﻿/*
Run this script to update the MET/CONNECT database from 3.1.0 to 3.2.0

You are recommended to back up your database before running this script

*/
SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS ON
GO
IF EXISTS (SELECT * FROM tempdb..sysobjects WHERE id=OBJECT_ID('tempdb..#tmpErrors')) DROP TABLE #tmpErrors
GO
CREATE TABLE #tmpErrors (Error int)
GO
SET XACT_ABORT ON
GO
SET TRANSACTION ISOLATION LEVEL SERIALIZABLE
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '2.3.0' )
BEGIN
	RAISERROR(N'*** Database script for version 2.3.0 is missing. ***', 20,-1) WITH LOG
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '3.0.0' )
BEGIN
	RAISERROR(N'*** Database script for version 3.0.0 is missing. ***', 20,-1) WITH LOG
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '3.1.0' )
BEGIN
	RAISERROR(N'*** Database script for version 3.1.0 is missing. ***', 20,-1) WITH LOG
END
GO

-- set database compatibility level to SQL Server 2012
DECLARE @comp NVARCHAR(max);
SET @comp = N'ALTER DATABASE [' + (SELECT DB_NAME()) + ']
SET COMPATIBILITY_LEVEL = 110 '
EXEC sp_executesql @comp
GO

-- TEMPORARY, remove for release
DELETE FROM [dbo].[Version] WHERE nVersionUID = '0B8889D5-59AF-4398-8235-86ABE6CFA3F3'
GO

-- No need to process if we have a 3.2.0 version record
IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE nVersionUID = '0B8889D5-59AF-4398-8235-86ABE6CFA3F3' )
BEGIN
	BEGIN TRANSACTION

	-- get the current collation and switch it to case-sensitive
	DECLARE @sql NVARCHAR(max);
	DECLARE @coll_cs NVARCHAR(100);
	SELECT @coll_cs = collation_name FROM sys.databases WHERE name = (SELECT DB_NAME());
	SELECT @coll_cs = REPLACE(@coll_cs, N'CI', N'CS');

	-->>MTM-86<<--
	-- the filter is applied via the inner join
	-- the WHERE clause was added to prevent SSMS warning that there is no WHERE clause
	UPDATE
		[dbo].[AvailableComboData]
	SET
		[cText] = t.[cKey]
	FROM
		[dbo].[AvailableComboData] acd
	INNER JOIN
		[dbo].[Translations] t
	ON
		acd.[cText] = t.[cKey]
	WHERE
		1 = 1


	-->>MTM-98<<--
	IF EXISTS( SELECT * FROM sysobjects WHERE type='P' AND name='InsertPoint' )
	BEGIN
		PRINT N'Dropping [dbo].[InsertPoint]'

		DROP PROCEDURE [dbo].[InsertPoint]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[InsertPoint]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[InsertPoint]'

		EXEC sp_executesql N'
		CREATE PROCEDURE [dbo].[InsertPoint]
			 @nPointUID [uniqueidentifier]
			,@nCallSheetResultUID uniqueidentifier
			,@nManualTemplateRowUID uniqueidentifier  = NULL
			,@nUUTUnitUID uniqueidentifier  = NULL
			,@nUUTFormatUID uniqueidentifier  = NULL
			,@nReferenceUnitUID uniqueidentifier  = NULL
			,@nReferenceFormatUID uniqueidentifier  = NULL
			,@nCardinalPointUnitUID uniqueidentifier  = NULL
			,@nCardinalPointFormatUID uniqueidentifier  = NULL
			,@nCorrectionUnitUID uniqueidentifier  = NULL
			,@nCorrectionFormatUID uniqueidentifier  = NULL
			,@nUUTRangeUnitUID uniqueidentifier  = NULL
			,@nUUTRangeFormatUID uniqueidentifier  = NULL
			,@nSystemAccuracyUnitUID uniqueidentifier  = NULL
			,@nSystemAccuracyFormatUID uniqueidentifier  = NULL
			,@nTemplateItemUID uniqueidentifier  = NULL
			,@nPointOrdinal int  = NULL
			,@tPointDateTime datetime  = NULL
			,@cPointLabel nvarchar(150)  = NULL
			,@cPointStatusFlags nvarchar(50)  = NULL
			,@cPointPassFailStatus nvarchar(50)  = NULL
			,@cFunctionSelectCode nvarchar(50)  = NULL
			,@nUUT float  = NULL
			,@nReference float  = NULL
			,@nCardinalPoint float  = NULL
			,@nCorrection float  = NULL
			,@cPointDescription nvarchar(300)  = NULL
			,@cRemarks nvarchar(300)  = NULL
			,@cOverrideRemarks nvarchar(300)  = NULL
			,@cDesignation nvarchar(10)  = NULL
			,@cTagId nvarchar(50)  = NULL
			,@nUUTRange float  = NULL
			,@nSetTime float  = NULL
			,@cCondition nvarchar(50)  = NULL
			,@nSystemAccuracy float  = NULL
			,@nClaim numeric(18, 0)  = NULL
			,@lAccredited int
			,@lPrinted int
			,@lUUTIsFixed int
			,@lOverride int
			,@lHeader int  = 0
			,@lActive int  = -1
			,@lDeleted int  = 0
			,@lApproved int  = 0
			,@lAdded int  = -1
			,@nAddFacilityUID uniqueidentifier  = ''AB9B7878-B72C-4A72-9273-47030571BE4C''
			,@nAddUserUID uniqueidentifier  = ''ABF8F215-1980-4E47-84DA-305699ECF5D5''
			,@nImportUID uniqueidentifier  = NULL
		AS
		BEGIN
			INSERT INTO [dbo].[Points] (
				 [nPointUID]
				,[nCallSheetResultUID]
				,[nManualTemplateRowUID]
				,[nUUTUnitUID]
				,[nUUTFormatUID]
				,[nReferenceUnitUID]
				,[nReferenceFormatUID]
				,[nCardinalPointUnitUID]
				,[nCardinalPointFormatUID]
				,[nCorrectionUnitUID]
				,[nCorrectionFormatUID]
				,[nUUTRangeUnitUID]
				,[nUUTRangeFormatUID]
				,[nSystemAccuracyUnitUID]
				,[nSystemAccuracyFormatUID]
				,[nTemplateItemUID]
				,[nPointOrdinal]
				,[tPointDateTime]
				,[cPointLabel]
				,[cPointStatusFlags]
				,[cPointPassFailStatus]
				,[cFunctionSelectCode]
				,[nUUT]
				,[nReference]
				,[nCardinalPoint]
				,[nCorrection]
				,[cPointDescription]
				,[cRemarks]
				,[cOverrideRemarks]
				,[cDesignation]
				,[cTagId]
				,[nUUTRange]
				,[nSetTime]
				,[cCondition]
				,[nSystemAccuracy]
				,[nClaim]
				,[lAccredited]
				,[lPrinted]
				,[lUUTIsFixed]
				,[lOverride]
				,[lHeader]
				,[lActive]
				,[lDeleted]
				,[lApproved]
				,[lAdded]
				,[nAddFacilityUID]
				,[nAddUserUID]
				,[nImportUID]
				,[tAddTime]
				,[nUpdateUserUID]
				,[nUpdateFacilityUID]
				,[tUpdateTime]
				,[tMobileTime]
			)
			VALUES (
				 @nPointUID
				,@nCallSheetResultUID
				,@nManualTemplateRowUID
				,@nUUTUnitUID
				,@nUUTFormatUID
				,@nReferenceUnitUID
				,@nReferenceFormatUID
				,@nCardinalPointUnitUID
				,@nCardinalPointFormatUID
				,@nCorrectionUnitUID
				,@nCorrectionFormatUID
				,@nUUTRangeUnitUID
				,@nUUTRangeFormatUID
				,@nSystemAccuracyUnitUID
				,@nSystemAccuracyFormatUID
				,@nTemplateItemUID
				,@nPointOrdinal
				,@tPointDateTime
				,@cPointLabel
				,@cPointStatusFlags
				,@cPointPassFailStatus
				,@cFunctionSelectCode
				,@nUUT
				,@nReference
				,@nCardinalPoint
				,@nCorrection
				,@cPointDescription
				,@cRemarks
				,@cOverrideRemarks
				,@cDesignation
				,@cTagId
				,@nUUTRange
				,@nSetTime
				,@cCondition
				,@nSystemAccuracy
				,@nClaim
				,@lAccredited
				,@lPrinted
				,@lUUTIsFixed
				,@lOverride
				,@lHeader
				,@lActive
				,@lDeleted
				,@lApproved
				,@lAdded
				,@nAddFacilityUID
				,@nAddUserUID
				,@nImportUID
				,GetUTCDate()
				,@nAddUserUID
				,@nAddFacilityUID
				,GetUTCDate()
				,GetUTCDate()
			)

			RETURN 1
		END
		'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF EXISTS( SELECT * FROM sysobjects WHERE type='P' AND name='InsertPointStatistic' )
		BEGIN
			PRINT N'Dropping [dbo].[InsertPointStatistic]'

			DROP PROCEDURE [dbo].[InsertPointStatistic]

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

	IF OBJECT_ID(N'[dbo].[InsertPointStatistic]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[splt_GetDatabaseInfo4]'

		EXEC sp_executesql N'
		CREATE PROCEDURE [dbo].[InsertPointStatistic]
			 @nPointStatisticUID [uniqueidentifier]
			,@nPointUID uniqueidentifier
			,@nMinimumUUTUnitUID uniqueidentifier  = NULL
			,@nMinimumUUTFormatUID uniqueidentifier  = NULL
			,@nMaximumUUTUnitUID uniqueidentifier  = NULL
			,@nMaximumUUTFormatUID uniqueidentifier  = NULL
			,@nMinimumReferenceUnitUID uniqueidentifier  = NULL
			,@nMinimumReferenceFormatUID uniqueidentifier  = NULL
			,@nMaximumReferenceUnitUID uniqueidentifier  = NULL
			,@nMaximumReferenceFormatUID uniqueidentifier  = NULL
			,@nUUTStandardDeviationUnitUID uniqueidentifier  = NULL
			,@nUUTStandardDeviationFormatUID uniqueidentifier  = NULL
			,@nUUTRawStandardDeviationUnitUID uniqueidentifier  = NULL
			,@nUUTRawStandardDeviationFormatUID uniqueidentifier  = NULL
			,@nReferenceStandardDeviationUnitUID uniqueidentifier  = NULL
			,@nReferenceStandardDeviationFormatUID uniqueidentifier  = NULL
			,@nReference2StandardDeviationUnitUID uniqueidentifier  = NULL
			,@nReference2StandardDeviationFormatUID uniqueidentifier  = NULL
			,@nReferenceRawStandardDeviationUnitUID uniqueidentifier  = NULL
			,@nReferenceRawStandardDeviationFormatUID uniqueidentifier  = NULL
			,@nReferenceRaw2StandardDeviationUnitUID uniqueidentifier  = NULL
			,@nReferenceRaw2StandardDeviationFormatUID uniqueidentifier  = NULL
			,@nSampleRateUnitUID uniqueidentifier  = NULL
			,@nSampleRateFormatUID uniqueidentifier  = NULL
			,@nMinimumUUT float  = NULL
			,@nMaximumUUT float  = NULL
			,@nMinimumReference float  = NULL
			,@nMaximumReference float  = NULL
			,@nUUTStandardDeviation float  = NULL
			,@nUUTRawStandardDeviation float  = NULL
			,@nReferenceStandardDeviation float  = NULL
			,@nReference2StandardDeviation float  = NULL
			,@nReferenceRawStandardDeviation float  = NULL
			,@nReferenceRaw2StandardDeviation float  = NULL
			,@nNumberOfSamplesReference int  = NULL
			,@nNumberOfSamplesUUT int  = 1
			,@nNumberOfSamplesDiscarded int  = 0
			,@nSampleRate float  = NULL
			,@nChiSquared float  = NULL
			,@lNoisy int
			,@lReliable int
			,@lActive int  = -1
			,@lDeleted int  = 0
			,@lApproved int  = 0
			,@lAdded int  = -1
			,@nAddFacilityUID uniqueidentifier  = ''AB9B7878-B72C-4A72-9273-47030571BE4C''
			,@nAddUserUID uniqueidentifier  = ''ABF8F215-1980-4E47-84DA-305699ECF5D5''
			,@nImportUID uniqueidentifier  = NULL
		AS
		BEGIN
			INSERT INTO [dbo].[PointStatistics] (
				 [nPointStatisticUID]
				,[nPointUID]
				,[nMinimumUUTUnitUID]
				,[nMinimumUUTFormatUID]
				,[nMaximumUUTUnitUID]
				,[nMaximumUUTFormatUID]
				,[nMinimumReferenceUnitUID]
				,[nMinimumReferenceFormatUID]
				,[nMaximumReferenceUnitUID]
				,[nMaximumReferenceFormatUID]
				,[nUUTStandardDeviationUnitUID]
				,[nUUTStandardDeviationFormatUID]
				,[nUUTRawStandardDeviationUnitUID]
				,[nUUTRawStandardDeviationFormatUID]
				,[nReferenceStandardDeviationUnitUID]
				,[nReferenceStandardDeviationFormatUID]
				,[nReference2StandardDeviationUnitUID]
				,[nReference2StandardDeviationFormatUID]
				,[nReferenceRawStandardDeviationUnitUID]
				,[nReferenceRawStandardDeviationFormatUID]
				,[nReferenceRaw2StandardDeviationUnitUID]
				,[nReferenceRaw2StandardDeviationFormatUID]
				,[nSampleRateUnitUID]
				,[nSampleRateFormatUID]
				,[nMinimumUUT]
				,[nMaximumUUT]
				,[nMinimumReference]
				,[nMaximumReference]
				,[nUUTStandardDeviation]
				,[nUUTRawStandardDeviation]
				,[nReferenceStandardDeviation]
				,[nReference2StandardDeviation]
				,[nReferenceRawStandardDeviation]
				,[nReferenceRaw2StandardDeviation]
				,[nNumberOfSamplesReference]
				,[nNumberOfSamplesUUT]
				,[nNumberOfSamplesDiscarded]
				,[nSampleRate]
				,[nChiSquared]
				,[lNoisy]
				,[lReliable]
				,[lActive]
				,[lDeleted]
				,[lApproved]
				,[lAdded]
				,[nAddFacilityUID]
				,[nAddUserUID]
				,[nImportUID]
				,[tAddTime]
				,[nUpdateUserUID]
				,[nUpdateFacilityUID]
				,[tUpdateTime]
				,[tMobileTime]
			)
			VALUES (
				 @nPointStatisticUID
				,@nPointUID
				,@nMinimumUUTUnitUID
				,@nMinimumUUTFormatUID
				,@nMaximumUUTUnitUID
				,@nMaximumUUTFormatUID
				,@nMinimumReferenceUnitUID
				,@nMinimumReferenceFormatUID
				,@nMaximumReferenceUnitUID
				,@nMaximumReferenceFormatUID
				,@nUUTStandardDeviationUnitUID
				,@nUUTStandardDeviationFormatUID
				,@nUUTRawStandardDeviationUnitUID
				,@nUUTRawStandardDeviationFormatUID
				,@nReferenceStandardDeviationUnitUID
				,@nReferenceStandardDeviationFormatUID
				,@nReference2StandardDeviationUnitUID
				,@nReference2StandardDeviationFormatUID
				,@nReferenceRawStandardDeviationUnitUID
				,@nReferenceRawStandardDeviationFormatUID
				,@nReferenceRaw2StandardDeviationUnitUID
				,@nReferenceRaw2StandardDeviationFormatUID
				,@nSampleRateUnitUID
				,@nSampleRateFormatUID
				,@nMinimumUUT
				,@nMaximumUUT
				,@nMinimumReference
				,@nMaximumReference
				,@nUUTStandardDeviation
				,@nUUTRawStandardDeviation
				,@nReferenceStandardDeviation
				,@nReference2StandardDeviation
				,@nReferenceRawStandardDeviation
				,@nReferenceRaw2StandardDeviation
				,@nNumberOfSamplesReference
				,@nNumberOfSamplesUUT
				,@nNumberOfSamplesDiscarded
				,@nSampleRate
				,@nChiSquared
				,@lNoisy
				,@lReliable
				,@lActive
				,@lDeleted
				,@lApproved
				,@lAdded
				,@nAddFacilityUID
				,@nAddUserUID
				,@nImportUID
				,GetUTCDate()
				,@nAddUserUID
				,@nAddFacilityUID
				,GetUTCDate()
				,GetUTCDate()
			)

			RETURN 1
		END
		'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF EXISTS( SELECT * FROM sysobjects WHERE type='P' AND name='InsertPointTolerance' )
		BEGIN
			PRINT N'Dropping [dbo].[InsertPointTolerance]'

			DROP PROCEDURE [dbo].[InsertPointTolerance]

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

	IF OBJECT_ID(N'[dbo].[InsertPointTolerance]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[InsertPointTolerance]'

		EXEC sp_executesql N'
		CREATE PROCEDURE [dbo].[InsertPointTolerance]
			 @nPointToleranceUID [uniqueidentifier]
			,@nPointUID uniqueidentifier
			,@nToleranceUnitUID uniqueidentifier  = NULL
			,@nToleranceFormatUID uniqueidentifier  = NULL
			,@nTolerancePositiveUnitUID uniqueidentifier  = NULL
			,@nTolerancePositiveFormatUID uniqueidentifier  = NULL
			,@nToleranceNegativeUnitUID uniqueidentifier  = NULL
			,@nToleranceNegativeFormatUID uniqueidentifier  = NULL
			,@nReferenceToleranceUnitUID uniqueidentifier  = NULL
			,@nReferenceToleranceFormatUID uniqueidentifier  = NULL
			,@nErrorUnitUID uniqueidentifier  = NULL
			,@nErrorFormatUID uniqueidentifier  = NULL
			,@nToleranceErrorUnitUID uniqueidentifier  = NULL
			,@nToleranceErrorFormatUID uniqueidentifier  = NULL
			,@nTolerance float  = NULL
			,@nTolerancePositive float  = NULL
			,@nToleranceNegative float  = NULL
			,@cToleranceReference nvarchar(50)  = NULL
			,@nReferenceTolerance float  = NULL
			,@nReadingErrorPercent float  = NULL
			,@nReadingErrorReferencePercent float  = NULL
			,@nFullScaleErrorPercent float  = NULL
			,@nFullScaleErrorReferencePercent float  = NULL
			,@nSetErrorPercent float  = NULL
			,@nSetFullScaleErrorPercent float  = NULL
			,@nToleranceErrorPercent float  = NULL
			,@nError float  = NULL
			,@nToleranceError float  = NULL
			,@lActive int  = -1
			,@lDeleted int  = 0
			,@lApproved int  = 0
			,@lAdded int  = -1
			,@nAddFacilityUID uniqueidentifier  = ''AB9B7878-B72C-4A72-9273-47030571BE4C''
			,@nAddUserUID uniqueidentifier  = ''ABF8F215-1980-4E47-84DA-305699ECF5D5''
			,@nImportUID uniqueidentifier  = NULL
		AS
		BEGIN
			INSERT INTO [dbo].[PointTolerances] (
				 [nPointToleranceUID]
				,[nPointUID]
				,[nToleranceUnitUID]
				,[nToleranceFormatUID]
				,[nTolerancePositiveUnitUID]
				,[nTolerancePositiveFormatUID]
				,[nToleranceNegativeUnitUID]
				,[nToleranceNegativeFormatUID]
				,[nReferenceToleranceUnitUID]
				,[nReferenceToleranceFormatUID]
				,[nErrorUnitUID]
				,[nErrorFormatUID]
				,[nToleranceErrorUnitUID]
				,[nToleranceErrorFormatUID]
				,[nTolerance]
				,[nTolerancePositive]
				,[nToleranceNegative]
				,[cToleranceReference]
				,[nReferenceTolerance]
				,[nReadingErrorPercent]
				,[nReadingErrorReferencePercent]
				,[nFullScaleErrorPercent]
				,[nFullScaleErrorReferencePercent]
				,[nSetErrorPercent]
				,[nSetFullScaleErrorPercent]
				,[nToleranceErrorPercent]
				,[nError]
				,[nToleranceError]
				,[lActive]
				,[lDeleted]
				,[lApproved]
				,[lAdded]
				,[nAddFacilityUID]
				,[nAddUserUID]
				,[nImportUID]
				,[tAddTime]
				,[nUpdateUserUID]
				,[nUpdateFacilityUID]
				,[tUpdateTime]
				,[tMobileTime]
			)
			VALUES (
				 @nPointToleranceUID
				,@nPointUID
				,@nToleranceUnitUID
				,@nToleranceFormatUID
				,@nTolerancePositiveUnitUID
				,@nTolerancePositiveFormatUID
				,@nToleranceNegativeUnitUID
				,@nToleranceNegativeFormatUID
				,@nReferenceToleranceUnitUID
				,@nReferenceToleranceFormatUID
				,@nErrorUnitUID
				,@nErrorFormatUID
				,@nToleranceErrorUnitUID
				,@nToleranceErrorFormatUID
				,@nTolerance
				,@nTolerancePositive
				,@nToleranceNegative
				,@cToleranceReference
				,@nReferenceTolerance
				,@nReadingErrorPercent
				,@nReadingErrorReferencePercent
				,@nFullScaleErrorPercent
				,@nFullScaleErrorReferencePercent
				,@nSetErrorPercent
				,@nSetFullScaleErrorPercent
				,@nToleranceErrorPercent
				,@nError
				,@nToleranceError
				,@lActive
				,@lDeleted
				,@lApproved
				,@lAdded
				,@nAddFacilityUID
				,@nAddUserUID
				,@nImportUID
				,GetUTCDate()
				,@nAddUserUID
				,@nAddFacilityUID
				,GetUTCDate()
				,GetUTCDate()
			)

			RETURN 1
		END
		'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF EXISTS( SELECT * FROM sysobjects WHERE type='P' AND name='InsertPointUncertainty' )
		BEGIN
			PRINT N'Dropping [dbo].[InsertPointUncertainty]'

			DROP PROCEDURE [dbo].[InsertPointUncertainty]

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

	IF OBJECT_ID(N'[dbo].[InsertPointUncertainty]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[InsertPointUncertainty]'

		EXEC sp_executesql N'
		CREATE PROCEDURE [dbo].[InsertPointUncertainty]
		     @nPointUncertaintyUID [uniqueidentifier]
			,@nPointUID uniqueidentifier
			,@nGuardBandLowerUnitUID uniqueidentifier  = NULL
			,@nGuardBandLowerFormatUID uniqueidentifier  = NULL
			,@nGuardBandUpperUnitUID uniqueidentifier  = NULL
			,@nGuardBandUpperFormatUID uniqueidentifier  = NULL
			,@nUncertaintyUnitUID uniqueidentifier  = NULL
			,@nUncertaintyFormatUID uniqueidentifier  = NULL
			,@nUncertaintyExpandedUnitUID uniqueidentifier  = NULL
			,@nUncertaintyExpandedFormatUID uniqueidentifier  = NULL
			,@nUncertaintyDominantUnitUID uniqueidentifier  = NULL
			,@nUncertaintyDominantFormatUID uniqueidentifier  = NULL
			,@nUncertaintyStandardUnitUID uniqueidentifier  = NULL
			,@nUncertaintyStandardFormatUID uniqueidentifier  = NULL
			,@nLowerLimitUnitUID uniqueidentifier  = NULL
			,@nLowerLimitFormatUID uniqueidentifier  = NULL
			,@nUpperLimitUnitUID uniqueidentifier  = NULL
			,@nUpperLimitFormatUID uniqueidentifier  = NULL
			,@nUncertaintyParameter1UnitUID uniqueidentifier  = NULL
			,@nUncertaintyParameter1FormatUID uniqueidentifier  = NULL
			,@nUncertaintyParameter2UnitUID uniqueidentifier  = NULL
			,@nUncertaintyParameter2FormatUID uniqueidentifier  = NULL
			,@nUncertaintyParameter3UnitUID uniqueidentifier  = NULL
			,@nUncertaintyParameter3FormatUID uniqueidentifier  = NULL
			,@nUncertaintyParameter4UnitUID uniqueidentifier  = NULL
			,@nUncertaintyParameter4FormatUID uniqueidentifier  = NULL
			,@nUncertaintyParameter5UnitUID uniqueidentifier  = NULL
			,@nUncertaintyParameter5FormatUID uniqueidentifier  = NULL
			,@nUncertaintyParameter6UnitUID uniqueidentifier  = NULL
			,@nUncertaintyParameter6FormatUID uniqueidentifier  = NULL
			,@nUncertaintyParameter7UnitUID uniqueidentifier  = NULL
			,@nUncertaintyParameter7FormatUID uniqueidentifier  = NULL
			,@nUncertaintyParameter8UnitUID uniqueidentifier  = NULL
			,@nUncertaintyParameter8FormatUID uniqueidentifier  = NULL
			,@nUncertaintyParameter9UnitUID uniqueidentifier  = NULL
			,@nUncertaintyParameter9FormatUID uniqueidentifier  = NULL
			,@nUncertaintyParameter10UnitUID uniqueidentifier  = NULL
			,@nUncertaintyParameter10FormatUID uniqueidentifier  = NULL
			,@nModifier1UnitUID uniqueidentifier  = NULL
			,@nModifier1FormatUID uniqueidentifier  = NULL
			,@nModifier2UnitUID uniqueidentifier  = NULL
			,@nModifier2FormatUID uniqueidentifier  = NULL
			,@nS1UnitUID uniqueidentifier  = NULL
			,@nS1FormatUID uniqueidentifier  = NULL
			,@nS2UnitUID uniqueidentifier  = NULL
			,@nS2FormatUID uniqueidentifier  = NULL
			,@cGuardBandMethod nvarchar(32)  = NULL
			,@nGuardBandLower float  = NULL
			,@nGuardBandUpper float  = NULL
			,@cUncertaintyMethod nvarchar(50)  = NULL
			,@nUncertainty float  = NULL
			,@nUncertaintyExpanded float  = NULL
			,@nUncertaintyDominant float  = NULL
			,@nUncertaintyStandard float  = NULL
			,@nLowerLimit float  = NULL
			,@nUpperLimit float  = NULL
			,@nCoverageFactor float  = NULL
			,@nSystemCoverageFactor float  = NULL
			,@nConfidenceLevel float  = NULL
			,@cStudentsT nvarchar(32)  = NULL
			,@nUncertaintyParameter1 float  = NULL
			,@nUncertaintyParameter2 float  = NULL
			,@nUncertaintyParameter3 float  = NULL
			,@nUncertaintyParameter4 float  = NULL
			,@nUncertaintyParameter5 float  = NULL
			,@nUncertaintyParameter6 float  = NULL
			,@nUncertaintyParameter7 float  = NULL
			,@nUncertaintyParameter8 float  = NULL
			,@nUncertaintyParameter9 float  = NULL
			,@nUncertaintyParameter10 float  = NULL
			,@cSensitivity1 nvarchar(32)  = NULL
			,@cSensitivity2 nvarchar(32)  = NULL
			,@cSensitivity3 nvarchar(32)  = NULL
			,@cSensitivity4 nvarchar(32)  = NULL
			,@cSensitivity5 nvarchar(32)  = NULL
			,@cSensitivity6 nvarchar(32)  = NULL
			,@cSensitivity7 nvarchar(32)  = NULL
			,@cSensitivity8 nvarchar(32)  = NULL
			,@cSensitivity9 nvarchar(32)  = NULL
			,@cSensitivity10 nvarchar(32)  = NULL
			,@cDegreesOfFreedom1 nvarchar(16)  = NULL
			,@cDegreesOfFreedom2 nvarchar(16)  = NULL
			,@cDegreesOfFreedom3 nvarchar(16)  = NULL
			,@cDegreesOfFreedom4 nvarchar(16)  = NULL
			,@cDegreesOfFreedom5 nvarchar(16)  = NULL
			,@cDegreesOfFreedom6 nvarchar(16)  = NULL
			,@cDegreesOfFreedom7 nvarchar(16)  = NULL
			,@cDegreesOfFreedom8 nvarchar(16)  = NULL
			,@cDegreesOfFreedom9 nvarchar(16)  = NULL
			,@cDegreesOfFreedom10 nvarchar(16)  = NULL
			,@nModifier1 float  = NULL
			,@nModifier2 float  = NULL
			,@nS1 float  = NULL
			,@nS2 float  = NULL
			,@cEquilibrationParameters nvarchar(50)  = NULL
			,@lStudentsT int
			,@lDominant int
			,@lWelchSatterthwaite int  = 0
			,@lActive int  = -1
			,@lDeleted int  = 0
			,@lApproved int  = 0
			,@lAdded int  = -1
			,@nAddFacilityUID uniqueidentifier  = ''AB9B7878-B72C-4A72-9273-47030571BE4C''
			,@nAddUserUID uniqueidentifier  = ''ABF8F215-1980-4E47-84DA-305699ECF5D5''
			,@nImportUID uniqueidentifier  = NULL
		AS
		BEGIN
		    INSERT INTO [dbo].[PointUncertainties] (
			 	 [nPointUncertaintyUID]
				,[nPointUID]
				,[nGuardBandLowerUnitUID]
				,[nGuardBandLowerFormatUID]
				,[nGuardBandUpperUnitUID]
				,[nGuardBandUpperFormatUID]
				,[nUncertaintyUnitUID]
				,[nUncertaintyFormatUID]
				,[nUncertaintyExpandedUnitUID]
				,[nUncertaintyExpandedFormatUID]
				,[nUncertaintyDominantUnitUID]
				,[nUncertaintyDominantFormatUID]
				,[nUncertaintyStandardUnitUID]
				,[nUncertaintyStandardFormatUID]
				,[nLowerLimitUnitUID]
				,[nLowerLimitFormatUID]
				,[nUpperLimitUnitUID]
				,[nUpperLimitFormatUID]
				,[nUncertaintyParameter1UnitUID]
				,[nUncertaintyParameter1FormatUID]
				,[nUncertaintyParameter2UnitUID]
				,[nUncertaintyParameter2FormatUID]
				,[nUncertaintyParameter3UnitUID]
				,[nUncertaintyParameter3FormatUID]
				,[nUncertaintyParameter4UnitUID]
				,[nUncertaintyParameter4FormatUID]
				,[nUncertaintyParameter5UnitUID]
				,[nUncertaintyParameter5FormatUID]
				,[nUncertaintyParameter6UnitUID]
				,[nUncertaintyParameter6FormatUID]
				,[nUncertaintyParameter7UnitUID]
				,[nUncertaintyParameter7FormatUID]
				,[nUncertaintyParameter8UnitUID]
				,[nUncertaintyParameter8FormatUID]
				,[nUncertaintyParameter9UnitUID]
				,[nUncertaintyParameter9FormatUID]
				,[nUncertaintyParameter10UnitUID]
				,[nUncertaintyParameter10FormatUID]
				,[nModifier1UnitUID]
				,[nModifier1FormatUID]
				,[nModifier2UnitUID]
				,[nModifier2FormatUID]
				,[nS1UnitUID]
				,[nS1FormatUID]
				,[nS2UnitUID]
				,[nS2FormatUID]
				,[cGuardBandMethod]
				,[nGuardBandLower]
				,[nGuardBandUpper]
				,[cUncertaintyMethod]
				,[nUncertainty]
				,[nUncertaintyExpanded]
				,[nUncertaintyDominant]
				,[nUncertaintyStandard]
				,[nLowerLimit]
				,[nUpperLimit]
				,[nCoverageFactor]
				,[nSystemCoverageFactor]
				,[nConfidenceLevel]
				,[cStudentsT]
				,[nUncertaintyParameter1]
				,[nUncertaintyParameter2]
				,[nUncertaintyParameter3]
				,[nUncertaintyParameter4]
				,[nUncertaintyParameter5]
				,[nUncertaintyParameter6]
				,[nUncertaintyParameter7]
				,[nUncertaintyParameter8]
				,[nUncertaintyParameter9]
				,[nUncertaintyParameter10]
				,[cSensitivity1]
				,[cSensitivity2]
				,[cSensitivity3]
				,[cSensitivity4]
				,[cSensitivity5]
				,[cSensitivity6]
				,[cSensitivity7]
				,[cSensitivity8]
				,[cSensitivity9]
				,[cSensitivity10]
				,[cDegreesOfFreedom1]
				,[cDegreesOfFreedom2]
				,[cDegreesOfFreedom3]
				,[cDegreesOfFreedom4]
				,[cDegreesOfFreedom5]
				,[cDegreesOfFreedom6]
				,[cDegreesOfFreedom7]
				,[cDegreesOfFreedom8]
				,[cDegreesOfFreedom9]
				,[cDegreesOfFreedom10]
				,[nModifier1]
				,[nModifier2]
				,[nS1]
				,[nS2]
				,[cEquilibrationParameters]
				,[lStudentsT]
				,[lDominant]
				,[lWelchSatterthwaite]
				,[lActive]
				,[lDeleted]
				,[lApproved]
				,[lAdded]
				,[nAddFacilityUID]
				,[nAddUserUID]
				,[nImportUID]
				,[tAddTime]
				,[nUpdateUserUID]
				,[nUpdateFacilityUID]
				,[tUpdateTime]
				,[tMobileTime]
			)
			VALUES (
		         @nPointUncertaintyUID
				,@nPointUID
				,@nGuardBandLowerUnitUID
				,@nGuardBandLowerFormatUID
				,@nGuardBandUpperUnitUID
				,@nGuardBandUpperFormatUID
				,@nUncertaintyUnitUID
				,@nUncertaintyFormatUID
				,@nUncertaintyExpandedUnitUID
				,@nUncertaintyExpandedFormatUID
				,@nUncertaintyDominantUnitUID
				,@nUncertaintyDominantFormatUID
				,@nUncertaintyStandardUnitUID
				,@nUncertaintyStandardFormatUID
				,@nLowerLimitUnitUID
				,@nLowerLimitFormatUID
				,@nUpperLimitUnitUID
				,@nUpperLimitFormatUID
				,@nUncertaintyParameter1UnitUID
				,@nUncertaintyParameter1FormatUID
				,@nUncertaintyParameter2UnitUID
				,@nUncertaintyParameter2FormatUID
				,@nUncertaintyParameter3UnitUID
				,@nUncertaintyParameter3FormatUID
				,@nUncertaintyParameter4UnitUID
				,@nUncertaintyParameter4FormatUID
				,@nUncertaintyParameter5UnitUID
				,@nUncertaintyParameter5FormatUID
				,@nUncertaintyParameter6UnitUID
				,@nUncertaintyParameter6FormatUID
				,@nUncertaintyParameter7UnitUID
				,@nUncertaintyParameter7FormatUID
				,@nUncertaintyParameter8UnitUID
				,@nUncertaintyParameter8FormatUID
				,@nUncertaintyParameter9UnitUID
				,@nUncertaintyParameter9FormatUID
				,@nUncertaintyParameter10UnitUID
				,@nUncertaintyParameter10FormatUID
				,@nModifier1UnitUID
				,@nModifier1FormatUID
				,@nModifier2UnitUID
				,@nModifier2FormatUID
				,@nS1UnitUID
				,@nS1FormatUID
				,@nS2UnitUID
				,@nS2FormatUID
				,@cGuardBandMethod
				,@nGuardBandLower
				,@nGuardBandUpper
				,@cUncertaintyMethod
				,@nUncertainty
				,@nUncertaintyExpanded
				,@nUncertaintyDominant
				,@nUncertaintyStandard
				,@nLowerLimit
				,@nUpperLimit
				,@nCoverageFactor
				,@nSystemCoverageFactor
				,@nConfidenceLevel
				,@cStudentsT
				,@nUncertaintyParameter1
				,@nUncertaintyParameter2
				,@nUncertaintyParameter3
				,@nUncertaintyParameter4
				,@nUncertaintyParameter5
				,@nUncertaintyParameter6
				,@nUncertaintyParameter7
				,@nUncertaintyParameter8
				,@nUncertaintyParameter9
				,@nUncertaintyParameter10
				,@cSensitivity1
				,@cSensitivity2
				,@cSensitivity3
				,@cSensitivity4
				,@cSensitivity5
				,@cSensitivity6
				,@cSensitivity7
				,@cSensitivity8
				,@cSensitivity9
				,@cSensitivity10
				,@cDegreesOfFreedom1
				,@cDegreesOfFreedom2
				,@cDegreesOfFreedom3
				,@cDegreesOfFreedom4
				,@cDegreesOfFreedom5
				,@cDegreesOfFreedom6
				,@cDegreesOfFreedom7
				,@cDegreesOfFreedom8
				,@cDegreesOfFreedom9
				,@cDegreesOfFreedom10
				,@nModifier1
				,@nModifier2
				,@nS1
				,@nS2
				,@cEquilibrationParameters
				,@lStudentsT
				,@lDominant
				,@lWelchSatterthwaite
				,@lActive
				,@lDeleted
				,@lApproved
				,@lAdded
				,@nAddFacilityUID
				,@nAddUserUID
				,@nImportUID
				,GetUTCDate()
				,@nAddUserUID
				,@nAddFacilityUID
				,GetUTCDate()
				,GetUTCDate()
			)

			RETURN 1
		END
		'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF EXISTS( SELECT * FROM sysobjects WHERE type='P' AND name='InsertPointExString' )
		BEGIN
			PRINT N'Dropping [dbo].[InsertPointExString]'

			DROP PROCEDURE [dbo].[InsertPointExString]

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

	IF OBJECT_ID(N'[dbo].[InsertPointExString]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[InsertPointExString]'

		EXEC sp_executesql N'
		CREATE PROCEDURE [dbo].[InsertPointExString]
			 @nPointExStringUID uniqueidentifier
			,@nPointUID uniqueidentifier
			,@cField001 nvarchar(255)  = NULL
			,@cField002 nvarchar(255)  = NULL
			,@cField003 nvarchar(255)  = NULL
			,@cField004 nvarchar(255)  = NULL
			,@cField005 nvarchar(255)  = NULL
			,@cField006 nvarchar(255)  = NULL
			,@cField007 nvarchar(255)  = NULL
			,@cField008 nvarchar(255)  = NULL
			,@cField009 nvarchar(255)  = NULL
			,@cField010 nvarchar(255)  = NULL
			,@cField011 nvarchar(255)  = NULL
			,@cField012 nvarchar(255)  = NULL
			,@cField013 nvarchar(255)  = NULL
			,@cField014 nvarchar(255)  = NULL
			,@cField015 nvarchar(255)  = NULL
			,@cField016 nvarchar(255)  = NULL
			,@cField017 nvarchar(255)  = NULL
			,@cField018 nvarchar(255)  = NULL
			,@cField019 nvarchar(255)  = NULL
			,@cField020 nvarchar(255)  = NULL
			,@cField021 nvarchar(255)  = NULL
			,@cField022 nvarchar(255)  = NULL
			,@cField023 nvarchar(255)  = NULL
			,@cField024 nvarchar(255)  = NULL
			,@cField025 nvarchar(255)  = NULL
			,@cField026 nvarchar(255)  = NULL
			,@cField027 nvarchar(255)  = NULL
			,@cField028 nvarchar(255)  = NULL
			,@cField029 nvarchar(255)  = NULL
			,@cField030 nvarchar(255)  = NULL
			,@cField031 nvarchar(255)  = NULL
			,@cField032 nvarchar(255)  = NULL
			,@cField033 nvarchar(255)  = NULL
			,@cField034 nvarchar(255)  = NULL
			,@cField035 nvarchar(255)  = NULL
			,@cField036 nvarchar(255)  = NULL
			,@cField037 nvarchar(255)  = NULL
			,@cField038 nvarchar(255)  = NULL
			,@cField039 nvarchar(255)  = NULL
			,@cField040 nvarchar(255)  = NULL
			,@cField041 nvarchar(255)  = NULL
			,@cField042 nvarchar(255)  = NULL
			,@cField043 nvarchar(255)  = NULL
			,@cField044 nvarchar(255)  = NULL
			,@cField045 nvarchar(255)  = NULL
			,@cField046 nvarchar(255)  = NULL
			,@cField047 nvarchar(255)  = NULL
			,@cField048 nvarchar(255)  = NULL
			,@cField049 nvarchar(255)  = NULL
			,@cField050 nvarchar(255)  = NULL
			,@cField051 nvarchar(255)  = NULL
			,@cField052 nvarchar(255)  = NULL
			,@cField053 nvarchar(255)  = NULL
			,@cField054 nvarchar(255)  = NULL
			,@cField055 nvarchar(255)  = NULL
			,@cField056 nvarchar(255)  = NULL
			,@cField057 nvarchar(255)  = NULL
			,@cField058 nvarchar(255)  = NULL
			,@cField059 nvarchar(255)  = NULL
			,@cField060 nvarchar(255)  = NULL
			,@lActive int  = -1
			,@lDeleted int  = 0
			,@lApproved int  = 0
			,@lAdded int  = -1
			,@nAddFacilityUID uniqueidentifier  = ''AB9B7878-B72C-4A72-9273-47030571BE4C''
			,@nAddUserUID uniqueidentifier  = ''ABF8F215-1980-4E47-84DA-305699ECF5D5''
			,@nImportUID uniqueidentifier  = NULL
		AS
		BEGIN
			INSERT INTO [dbo].[PointExStrings] (
				 [nPointExStringUID]
				,[nPointUID]
				,[cField001]
				,[cField002]
				,[cField003]
				,[cField004]
				,[cField005]
				,[cField006]
				,[cField007]
				,[cField008]
				,[cField009]
				,[cField010]
				,[cField011]
				,[cField012]
				,[cField013]
				,[cField014]
				,[cField015]
				,[cField016]
				,[cField017]
				,[cField018]
				,[cField019]
				,[cField020]
				,[cField021]
				,[cField022]
				,[cField023]
				,[cField024]
				,[cField025]
				,[cField026]
				,[cField027]
				,[cField028]
				,[cField029]
				,[cField030]
				,[cField031]
				,[cField032]
				,[cField033]
				,[cField034]
				,[cField035]
				,[cField036]
				,[cField037]
				,[cField038]
				,[cField039]
				,[cField040]
				,[cField041]
				,[cField042]
				,[cField043]
				,[cField044]
				,[cField045]
				,[cField046]
				,[cField047]
				,[cField048]
				,[cField049]
				,[cField050]
				,[cField051]
				,[cField052]
				,[cField053]
				,[cField054]
				,[cField055]
				,[cField056]
				,[cField057]
				,[cField058]
				,[cField059]
				,[cField060]
				,[lActive]
				,[lDeleted]
				,[lApproved]
				,[lAdded]
				,[nAddFacilityUID]
				,[nAddUserUID]
				,[nImportUID]
				,[tAddTime]
				,[nUpdateUserUID]
				,[nUpdateFacilityUID]
				,[tUpdateTime]
				,[tMobileTime]
			)
			VALUES (
				 @nPointExStringUID
				,@nPointUID
				,@cField001
				,@cField002
				,@cField003
				,@cField004
				,@cField005
				,@cField006
				,@cField007
				,@cField008
				,@cField009
				,@cField010
				,@cField011
				,@cField012
				,@cField013
				,@cField014
				,@cField015
				,@cField016
				,@cField017
				,@cField018
				,@cField019
				,@cField020
				,@cField021
				,@cField022
				,@cField023
				,@cField024
				,@cField025
				,@cField026
				,@cField027
				,@cField028
				,@cField029
				,@cField030
				,@cField031
				,@cField032
				,@cField033
				,@cField034
				,@cField035
				,@cField036
				,@cField037
				,@cField038
				,@cField039
				,@cField040
				,@cField041
				,@cField042
				,@cField043
				,@cField044
				,@cField045
				,@cField046
				,@cField047
				,@cField048
				,@cField049
				,@cField050
				,@cField051
				,@cField052
				,@cField053
				,@cField054
				,@cField055
				,@cField056
				,@cField057
				,@cField058
				,@cField059
				,@cField060
				,@lActive
				,@lDeleted
				,@lApproved
				,@lAdded
				,@nAddFacilityUID
				,@nAddUserUID
				,@nImportUID
				,GetUTCDate()
				,@nAddUserUID
				,@nAddFacilityUID
				,GetUTCDate()
				,GetUTCDate()
			)

			RETURN 1
		END
		'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF EXISTS( SELECT * FROM sysobjects WHERE type='P' AND name='InsertPointExLogical' )
		BEGIN
			PRINT N'Dropping [dbo].[InsertPointExLogical]'

			DROP PROCEDURE [dbo].[InsertPointExLogical]

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

	IF OBJECT_ID(N'[dbo].[InsertPointExLogical]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[InsertPointExLogical]'

		EXEC sp_executesql N'
		CREATE PROCEDURE [dbo].[InsertPointExLogical]
			 @nPointExLogicalUID [uniqueidentifier]
			,@nPointUID uniqueidentifier
			,@lField001 int  = NULL
			,@lField002 int  = NULL
			,@lField003 int  = NULL
			,@lField004 int  = NULL
			,@lField005 int  = NULL
			,@lField006 int  = NULL
			,@lField007 int  = NULL
			,@lField008 int  = NULL
			,@lField009 int  = NULL
			,@lField010 int  = NULL
			,@lField011 int  = NULL
			,@lField012 int  = NULL
			,@lField013 int  = NULL
			,@lField014 int  = NULL
			,@lField015 int  = NULL
			,@lField016 int  = NULL
			,@lField017 int  = NULL
			,@lField018 int  = NULL
			,@lField019 int  = NULL
			,@lField020 int  = NULL
			,@lField021 int  = NULL
			,@lField022 int  = NULL
			,@lField023 int  = NULL
			,@lField024 int  = NULL
			,@lField025 int  = NULL
			,@lField026 int  = NULL
			,@lField027 int  = NULL
			,@lField028 int  = NULL
			,@lField029 int  = NULL
			,@lField030 int  = NULL
			,@lField031 int  = NULL
			,@lField032 int  = NULL
			,@lField033 int  = NULL
			,@lField034 int  = NULL
			,@lField035 int  = NULL
			,@lField036 int  = NULL
			,@lField037 int  = NULL
			,@lField038 int  = NULL
			,@lField039 int  = NULL
			,@lField040 int  = NULL
			,@lField041 int  = NULL
			,@lField042 int  = NULL
			,@lField043 int  = NULL
			,@lField044 int  = NULL
			,@lField045 int  = NULL
			,@lField046 int  = NULL
			,@lField047 int  = NULL
			,@lField048 int  = NULL
			,@lField049 int  = NULL
			,@lField050 int  = NULL
			,@lField051 int  = NULL
			,@lField052 int  = NULL
			,@lField053 int  = NULL
			,@lField054 int  = NULL
			,@lField055 int  = NULL
			,@lField056 int  = NULL
			,@lField057 int  = NULL
			,@lField058 int  = NULL
			,@lField059 int  = NULL
			,@lField060 int  = NULL
			,@lActive int  = -1
			,@lDeleted int  = 0
			,@lApproved int  = 0
			,@lAdded int  = -1
			,@nAddFacilityUID uniqueidentifier  = ''AB9B7878-B72C-4A72-9273-47030571BE4C''
			,@nAddUserUID uniqueidentifier  = ''ABF8F215-1980-4E47-84DA-305699ECF5D5''
			,@nImportUID uniqueidentifier  = NULL
		AS
		BEGIN
			INSERT INTO [dbo].[PointExLogicals] (
				 [nPointExLogicalUID]
				,[nPointUID]
				,[lField001]
				,[lField002]
				,[lField003]
				,[lField004]
				,[lField005]
				,[lField006]
				,[lField007]
				,[lField008]
				,[lField009]
				,[lField010]
				,[lField011]
				,[lField012]
				,[lField013]
				,[lField014]
				,[lField015]
				,[lField016]
				,[lField017]
				,[lField018]
				,[lField019]
				,[lField020]
				,[lField021]
				,[lField022]
				,[lField023]
				,[lField024]
				,[lField025]
				,[lField026]
				,[lField027]
				,[lField028]
				,[lField029]
				,[lField030]
				,[lField031]
				,[lField032]
				,[lField033]
				,[lField034]
				,[lField035]
				,[lField036]
				,[lField037]
				,[lField038]
				,[lField039]
				,[lField040]
				,[lField041]
				,[lField042]
				,[lField043]
				,[lField044]
				,[lField045]
				,[lField046]
				,[lField047]
				,[lField048]
				,[lField049]
				,[lField050]
				,[lField051]
				,[lField052]
				,[lField053]
				,[lField054]
				,[lField055]
				,[lField056]
				,[lField057]
				,[lField058]
				,[lField059]
				,[lField060]
				,[lActive]
				,[lDeleted]
				,[lApproved]
				,[lAdded]
				,[nAddFacilityUID]
				,[nAddUserUID]
				,[nImportUID]
				,[tAddTime]
				,[nUpdateUserUID]
				,[nUpdateFacilityUID]
				,[tUpdateTime]
				,[tMobileTime]
			)
			VALUES (
		         @nPointExLogicalUID
				,@nPointUID
				,@lField001
				,@lField002
				,@lField003
				,@lField004
				,@lField005
				,@lField006
				,@lField007
				,@lField008
				,@lField009
				,@lField010
				,@lField011
				,@lField012
				,@lField013
				,@lField014
				,@lField015
				,@lField016
				,@lField017
				,@lField018
				,@lField019
				,@lField020
				,@lField021
				,@lField022
				,@lField023
				,@lField024
				,@lField025
				,@lField026
				,@lField027
				,@lField028
				,@lField029
				,@lField030
				,@lField031
				,@lField032
				,@lField033
				,@lField034
				,@lField035
				,@lField036
				,@lField037
				,@lField038
				,@lField039
				,@lField040
				,@lField041
				,@lField042
				,@lField043
				,@lField044
				,@lField045
				,@lField046
				,@lField047
				,@lField048
				,@lField049
				,@lField050
				,@lField051
				,@lField052
				,@lField053
				,@lField054
				,@lField055
				,@lField056
				,@lField057
				,@lField058
				,@lField059
				,@lField060
				,@lActive
				,@lDeleted
				,@lApproved
				,@lAdded
				,@nAddFacilityUID
				,@nAddUserUID
				,@nImportUID
				,GetUTCDate()
				,@nAddUserUID
				,@nAddFacilityUID
				,GetUTCDate()
				,GetUTCDate()
			)

			RETURN 1
		END
		'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF EXISTS( SELECT * FROM sysobjects WHERE type='P' AND name='InsertPointExNumeric' )
		BEGIN
			PRINT N'Dropping [dbo].[InsertPointExNumeric]'

			DROP PROCEDURE [dbo].[InsertPointExNumeric]

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

	IF OBJECT_ID(N'[dbo].[InsertPointExNumeric]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[InsertPointExNumeric]'

		EXEC sp_executesql N'
		CREATE PROCEDURE [dbo].[InsertPointExNumeric]
		     @nPointExNumericUID [uniqueidentifier]
			,@nPointUID uniqueidentifier
			,@nField001 float  = NULL
			,@nField001UnitUID uniqueidentifier  = NULL
			,@nField001FormatUID uniqueidentifier  = NULL
			,@nField002 float  = NULL
			,@nField002UnitUID uniqueidentifier  = NULL
			,@nField002FormatUID uniqueidentifier  = NULL
			,@nField003 float  = NULL
			,@nField003UnitUID uniqueidentifier  = NULL
			,@nField003FormatUID uniqueidentifier  = NULL
			,@nField004 float  = NULL
			,@nField004UnitUID uniqueidentifier  = NULL
			,@nField004FormatUID uniqueidentifier  = NULL
			,@nField005 float  = NULL
			,@nField005UnitUID uniqueidentifier  = NULL
			,@nField005FormatUID uniqueidentifier  = NULL
			,@nField006 float  = NULL
			,@nField006UnitUID uniqueidentifier  = NULL
			,@nField006FormatUID uniqueidentifier  = NULL
			,@nField007 float  = NULL
			,@nField007UnitUID uniqueidentifier  = NULL
			,@nField007FormatUID uniqueidentifier  = NULL
			,@nField008 float  = NULL
			,@nField008UnitUID uniqueidentifier  = NULL
			,@nField008FormatUID uniqueidentifier  = NULL
			,@nField009 float  = NULL
			,@nField009UnitUID uniqueidentifier  = NULL
			,@nField009FormatUID uniqueidentifier  = NULL
			,@nField010 float  = NULL
			,@nField010UnitUID uniqueidentifier  = NULL
			,@nField010FormatUID uniqueidentifier  = NULL
			,@nField011 float  = NULL
			,@nField011UnitUID uniqueidentifier  = NULL
			,@nField011FormatUID uniqueidentifier  = NULL
			,@nField012 float  = NULL
			,@nField012UnitUID uniqueidentifier  = NULL
			,@nField012FormatUID uniqueidentifier  = NULL
			,@nField013 float  = NULL
			,@nField013UnitUID uniqueidentifier  = NULL
			,@nField013FormatUID uniqueidentifier  = NULL
			,@nField014 float  = NULL
			,@nField014UnitUID uniqueidentifier  = NULL
			,@nField014FormatUID uniqueidentifier  = NULL
			,@nField015 float  = NULL
			,@nField015UnitUID uniqueidentifier  = NULL
			,@nField015FormatUID uniqueidentifier  = NULL
			,@nField016 float  = NULL
			,@nField016UnitUID uniqueidentifier  = NULL
			,@nField016FormatUID uniqueidentifier  = NULL
			,@nField017 float  = NULL
			,@nField017UnitUID uniqueidentifier  = NULL
			,@nField017FormatUID uniqueidentifier  = NULL
			,@nField018 float  = NULL
			,@nField018UnitUID uniqueidentifier  = NULL
			,@nField018FormatUID uniqueidentifier  = NULL
			,@nField019 float  = NULL
			,@nField019UnitUID uniqueidentifier  = NULL
			,@nField019FormatUID uniqueidentifier  = NULL
			,@nField020 float  = NULL
			,@nField020UnitUID uniqueidentifier  = NULL
			,@nField020FormatUID uniqueidentifier  = NULL
			,@nField021 float  = NULL
			,@nField021UnitUID uniqueidentifier  = NULL
			,@nField021FormatUID uniqueidentifier  = NULL
			,@nField022 float  = NULL
			,@nField022UnitUID uniqueidentifier  = NULL
			,@nField022FormatUID uniqueidentifier  = NULL
			,@nField023 float  = NULL
			,@nField023UnitUID uniqueidentifier  = NULL
			,@nField023FormatUID uniqueidentifier  = NULL
			,@nField024 float  = NULL
			,@nField024UnitUID uniqueidentifier  = NULL
			,@nField024FormatUID uniqueidentifier  = NULL
			,@nField025 float  = NULL
			,@nField025UnitUID uniqueidentifier  = NULL
			,@nField025FormatUID uniqueidentifier  = NULL
			,@nField026 float  = NULL
			,@nField026UnitUID uniqueidentifier  = NULL
			,@nField026FormatUID uniqueidentifier  = NULL
			,@nField027 float  = NULL
			,@nField027UnitUID uniqueidentifier  = NULL
			,@nField027FormatUID uniqueidentifier  = NULL
			,@nField028 float  = NULL
			,@nField028UnitUID uniqueidentifier  = NULL
			,@nField028FormatUID uniqueidentifier  = NULL
			,@nField029 float  = NULL
			,@nField029UnitUID uniqueidentifier  = NULL
			,@nField029FormatUID uniqueidentifier  = NULL
			,@nField030 float  = NULL
			,@nField030UnitUID uniqueidentifier  = NULL
			,@nField030FormatUID uniqueidentifier  = NULL
			,@nField031 float  = NULL
			,@nField031UnitUID uniqueidentifier  = NULL
			,@nField031FormatUID uniqueidentifier  = NULL
			,@nField032 float  = NULL
			,@nField032UnitUID uniqueidentifier  = NULL
			,@nField032FormatUID uniqueidentifier  = NULL
			,@nField033 float  = NULL
			,@nField033UnitUID uniqueidentifier  = NULL
			,@nField033FormatUID uniqueidentifier  = NULL
			,@nField034 float  = NULL
			,@nField034UnitUID uniqueidentifier  = NULL
			,@nField034FormatUID uniqueidentifier  = NULL
			,@nField035 float  = NULL
			,@nField035UnitUID uniqueidentifier  = NULL
			,@nField035FormatUID uniqueidentifier  = NULL
			,@nField036 float  = NULL
			,@nField036UnitUID uniqueidentifier  = NULL
			,@nField036FormatUID uniqueidentifier  = NULL
			,@nField037 float  = NULL
			,@nField037UnitUID uniqueidentifier  = NULL
			,@nField037FormatUID uniqueidentifier  = NULL
			,@nField038 float  = NULL
			,@nField038UnitUID uniqueidentifier  = NULL
			,@nField038FormatUID uniqueidentifier  = NULL
			,@nField039 float  = NULL
			,@nField039UnitUID uniqueidentifier  = NULL
			,@nField039FormatUID uniqueidentifier  = NULL
			,@nField040 float  = NULL
			,@nField040UnitUID uniqueidentifier  = NULL
			,@nField040FormatUID uniqueidentifier  = NULL
			,@nField041 float  = NULL
			,@nField041UnitUID uniqueidentifier  = NULL
			,@nField041FormatUID uniqueidentifier  = NULL
			,@nField042 float  = NULL
			,@nField042UnitUID uniqueidentifier  = NULL
			,@nField042FormatUID uniqueidentifier  = NULL
			,@nField043 float  = NULL
			,@nField043UnitUID uniqueidentifier  = NULL
			,@nField043FormatUID uniqueidentifier  = NULL
			,@nField044 float  = NULL
			,@nField044UnitUID uniqueidentifier  = NULL
			,@nField044FormatUID uniqueidentifier  = NULL
			,@nField045 float  = NULL
			,@nField045UnitUID uniqueidentifier  = NULL
			,@nField045FormatUID uniqueidentifier  = NULL
			,@nField046 float  = NULL
			,@nField046UnitUID uniqueidentifier  = NULL
			,@nField046FormatUID uniqueidentifier  = NULL
			,@nField047 float  = NULL
			,@nField047UnitUID uniqueidentifier  = NULL
			,@nField047FormatUID uniqueidentifier  = NULL
			,@nField048 float  = NULL
			,@nField048UnitUID uniqueidentifier  = NULL
			,@nField048FormatUID uniqueidentifier  = NULL
			,@nField049 float  = NULL
			,@nField049UnitUID uniqueidentifier  = NULL
			,@nField049FormatUID uniqueidentifier  = NULL
			,@nField050 float  = NULL
			,@nField050UnitUID uniqueidentifier  = NULL
			,@nField050FormatUID uniqueidentifier  = NULL
			,@nField051 float  = NULL
			,@nField051UnitUID uniqueidentifier  = NULL
			,@nField051FormatUID uniqueidentifier  = NULL
			,@nField052 float  = NULL
			,@nField052UnitUID uniqueidentifier  = NULL
			,@nField052FormatUID uniqueidentifier  = NULL
			,@nField053 float  = NULL
			,@nField053UnitUID uniqueidentifier  = NULL
			,@nField053FormatUID uniqueidentifier  = NULL
			,@nField054 float  = NULL
			,@nField054UnitUID uniqueidentifier  = NULL
			,@nField054FormatUID uniqueidentifier  = NULL
			,@nField055 float  = NULL
			,@nField055UnitUID uniqueidentifier  = NULL
			,@nField055FormatUID uniqueidentifier  = NULL
			,@nField056 float  = NULL
			,@nField056UnitUID uniqueidentifier  = NULL
			,@nField056FormatUID uniqueidentifier  = NULL
			,@nField057 float  = NULL
			,@nField057UnitUID uniqueidentifier  = NULL
			,@nField057FormatUID uniqueidentifier  = NULL
			,@nField058 float  = NULL
			,@nField058UnitUID uniqueidentifier  = NULL
			,@nField058FormatUID uniqueidentifier  = NULL
			,@nField059 float  = NULL
			,@nField059UnitUID uniqueidentifier  = NULL
			,@nField059FormatUID uniqueidentifier  = NULL
			,@nField060 float  = NULL
			,@nField060UnitUID uniqueidentifier  = NULL
			,@nField060FormatUID uniqueidentifier  = NULL
			,@lActive int  = -1
			,@lDeleted int  = 0
			,@lApproved int  = 0
			,@lAdded int  = -1
			,@nAddFacilityUID uniqueidentifier  = ''AB9B7878-B72C-4A72-9273-47030571BE4C''
			,@nAddUserUID uniqueidentifier  = ''ABF8F215-1980-4E47-84DA-305699ECF5D5''
			,@nImportUID uniqueidentifier  = NULL
		AS
		BEGIN
			INSERT INTO [dbo].[PointExNumerics] (
				 [nPointExNumericUID]
				,[nPointUID]
				,[nField001]
				,[nField001UnitUID]
				,[nField001FormatUID]
				,[nField002]
				,[nField002UnitUID]
				,[nField002FormatUID]
				,[nField003]
				,[nField003UnitUID]
				,[nField003FormatUID]
				,[nField004]
				,[nField004UnitUID]
				,[nField004FormatUID]
				,[nField005]
				,[nField005UnitUID]
				,[nField005FormatUID]
				,[nField006]
				,[nField006UnitUID]
				,[nField006FormatUID]
				,[nField007]
				,[nField007UnitUID]
				,[nField007FormatUID]
				,[nField008]
				,[nField008UnitUID]
				,[nField008FormatUID]
				,[nField009]
				,[nField009UnitUID]
				,[nField009FormatUID]
				,[nField010]
				,[nField010UnitUID]
				,[nField010FormatUID]
				,[nField011]
				,[nField011UnitUID]
				,[nField011FormatUID]
				,[nField012]
				,[nField012UnitUID]
				,[nField012FormatUID]
				,[nField013]
				,[nField013UnitUID]
				,[nField013FormatUID]
				,[nField014]
				,[nField014UnitUID]
				,[nField014FormatUID]
				,[nField015]
				,[nField015UnitUID]
				,[nField015FormatUID]
				,[nField016]
				,[nField016UnitUID]
				,[nField016FormatUID]
				,[nField017]
				,[nField017UnitUID]
				,[nField017FormatUID]
				,[nField018]
				,[nField018UnitUID]
				,[nField018FormatUID]
				,[nField019]
				,[nField019UnitUID]
				,[nField019FormatUID]
				,[nField020]
				,[nField020UnitUID]
				,[nField020FormatUID]
				,[nField021]
				,[nField021UnitUID]
				,[nField021FormatUID]
				,[nField022]
				,[nField022UnitUID]
				,[nField022FormatUID]
				,[nField023]
				,[nField023UnitUID]
				,[nField023FormatUID]
				,[nField024]
				,[nField024UnitUID]
				,[nField024FormatUID]
				,[nField025]
				,[nField025UnitUID]
				,[nField025FormatUID]
				,[nField026]
				,[nField026UnitUID]
				,[nField026FormatUID]
				,[nField027]
				,[nField027UnitUID]
				,[nField027FormatUID]
				,[nField028]
				,[nField028UnitUID]
				,[nField028FormatUID]
				,[nField029]
				,[nField029UnitUID]
				,[nField029FormatUID]
				,[nField030]
				,[nField030UnitUID]
				,[nField030FormatUID]
				,[nField031]
				,[nField031UnitUID]
				,[nField031FormatUID]
				,[nField032]
				,[nField032UnitUID]
				,[nField032FormatUID]
				,[nField033]
				,[nField033UnitUID]
				,[nField033FormatUID]
				,[nField034]
				,[nField034UnitUID]
				,[nField034FormatUID]
				,[nField035]
				,[nField035UnitUID]
				,[nField035FormatUID]
				,[nField036]
				,[nField036UnitUID]
				,[nField036FormatUID]
				,[nField037]
				,[nField037UnitUID]
				,[nField037FormatUID]
				,[nField038]
				,[nField038UnitUID]
				,[nField038FormatUID]
				,[nField039]
				,[nField039UnitUID]
				,[nField039FormatUID]
				,[nField040]
				,[nField040UnitUID]
				,[nField040FormatUID]
				,[nField041]
				,[nField041UnitUID]
				,[nField041FormatUID]
				,[nField042]
				,[nField042UnitUID]
				,[nField042FormatUID]
				,[nField043]
				,[nField043UnitUID]
				,[nField043FormatUID]
				,[nField044]
				,[nField044UnitUID]
				,[nField044FormatUID]
				,[nField045]
				,[nField045UnitUID]
				,[nField045FormatUID]
				,[nField046]
				,[nField046UnitUID]
				,[nField046FormatUID]
				,[nField047]
				,[nField047UnitUID]
				,[nField047FormatUID]
				,[nField048]
				,[nField048UnitUID]
				,[nField048FormatUID]
				,[nField049]
				,[nField049UnitUID]
				,[nField049FormatUID]
				,[nField050]
				,[nField050UnitUID]
				,[nField050FormatUID]
				,[nField051]
				,[nField051UnitUID]
				,[nField051FormatUID]
				,[nField052]
				,[nField052UnitUID]
				,[nField052FormatUID]
				,[nField053]
				,[nField053UnitUID]
				,[nField053FormatUID]
				,[nField054]
				,[nField054UnitUID]
				,[nField054FormatUID]
				,[nField055]
				,[nField055UnitUID]
				,[nField055FormatUID]
				,[nField056]
				,[nField056UnitUID]
				,[nField056FormatUID]
				,[nField057]
				,[nField057UnitUID]
				,[nField057FormatUID]
				,[nField058]
				,[nField058UnitUID]
				,[nField058FormatUID]
				,[nField059]
				,[nField059UnitUID]
				,[nField059FormatUID]
				,[nField060]
				,[nField060UnitUID]
				,[nField060FormatUID]
				,[lActive]
				,[lDeleted]
				,[lApproved]
				,[lAdded]
				,[nAddFacilityUID]
				,[nAddUserUID]
				,[nImportUID]
				,[tAddTime]
				,[nUpdateUserUID]
				,[nUpdateFacilityUID]
				,[tUpdateTime]
				,[tMobileTime]
			)
			VALUES (
				 @nPointExNumericUID
				,@nPointUID
				,@nField001
				,@nField001UnitUID
				,@nField001FormatUID
				,@nField002
				,@nField002UnitUID
				,@nField002FormatUID
				,@nField003
				,@nField003UnitUID
				,@nField003FormatUID
				,@nField004
				,@nField004UnitUID
				,@nField004FormatUID
				,@nField005
				,@nField005UnitUID
				,@nField005FormatUID
				,@nField006
				,@nField006UnitUID
				,@nField006FormatUID
				,@nField007
				,@nField007UnitUID
				,@nField007FormatUID
				,@nField008
				,@nField008UnitUID
				,@nField008FormatUID
				,@nField009
				,@nField009UnitUID
				,@nField009FormatUID
				,@nField010
				,@nField010UnitUID
				,@nField010FormatUID
				,@nField011
				,@nField011UnitUID
				,@nField011FormatUID
				,@nField012
				,@nField012UnitUID
				,@nField012FormatUID
				,@nField013
				,@nField013UnitUID
				,@nField013FormatUID
				,@nField014
				,@nField014UnitUID
				,@nField014FormatUID
				,@nField015
				,@nField015UnitUID
				,@nField015FormatUID
				,@nField016
				,@nField016UnitUID
				,@nField016FormatUID
				,@nField017
				,@nField017UnitUID
				,@nField017FormatUID
				,@nField018
				,@nField018UnitUID
				,@nField018FormatUID
				,@nField019
				,@nField019UnitUID
				,@nField019FormatUID
				,@nField020
				,@nField020UnitUID
				,@nField020FormatUID
				,@nField021
				,@nField021UnitUID
				,@nField021FormatUID
				,@nField022
				,@nField022UnitUID
				,@nField022FormatUID
				,@nField023
				,@nField023UnitUID
				,@nField023FormatUID
				,@nField024
				,@nField024UnitUID
				,@nField024FormatUID
				,@nField025
				,@nField025UnitUID
				,@nField025FormatUID
				,@nField026
				,@nField026UnitUID
				,@nField026FormatUID
				,@nField027
				,@nField027UnitUID
				,@nField027FormatUID
				,@nField028
				,@nField028UnitUID
				,@nField028FormatUID
				,@nField029
				,@nField029UnitUID
				,@nField029FormatUID
				,@nField030
				,@nField030UnitUID
				,@nField030FormatUID
				,@nField031
				,@nField031UnitUID
				,@nField031FormatUID
				,@nField032
				,@nField032UnitUID
				,@nField032FormatUID
				,@nField033
				,@nField033UnitUID
				,@nField033FormatUID
				,@nField034
				,@nField034UnitUID
				,@nField034FormatUID
				,@nField035
				,@nField035UnitUID
				,@nField035FormatUID
				,@nField036
				,@nField036UnitUID
				,@nField036FormatUID
				,@nField037
				,@nField037UnitUID
				,@nField037FormatUID
				,@nField038
				,@nField038UnitUID
				,@nField038FormatUID
				,@nField039
				,@nField039UnitUID
				,@nField039FormatUID
				,@nField040
				,@nField040UnitUID
				,@nField040FormatUID
				,@nField041
				,@nField041UnitUID
				,@nField041FormatUID
				,@nField042
				,@nField042UnitUID
				,@nField042FormatUID
				,@nField043
				,@nField043UnitUID
				,@nField043FormatUID
				,@nField044
				,@nField044UnitUID
				,@nField044FormatUID
				,@nField045
				,@nField045UnitUID
				,@nField045FormatUID
				,@nField046
				,@nField046UnitUID
				,@nField046FormatUID
				,@nField047
				,@nField047UnitUID
				,@nField047FormatUID
				,@nField048
				,@nField048UnitUID
				,@nField048FormatUID
				,@nField049
				,@nField049UnitUID
				,@nField049FormatUID
				,@nField050
				,@nField050UnitUID
				,@nField050FormatUID
				,@nField051
				,@nField051UnitUID
				,@nField051FormatUID
				,@nField052
				,@nField052UnitUID
				,@nField052FormatUID
				,@nField053
				,@nField053UnitUID
				,@nField053FormatUID
				,@nField054
				,@nField054UnitUID
				,@nField054FormatUID
				,@nField055
				,@nField055UnitUID
				,@nField055FormatUID
				,@nField056
				,@nField056UnitUID
				,@nField056FormatUID
				,@nField057
				,@nField057UnitUID
				,@nField057FormatUID
				,@nField058
				,@nField058UnitUID
				,@nField058FormatUID
				,@nField059
				,@nField059UnitUID
				,@nField059FormatUID
				,@nField060
				,@nField060UnitUID
				,@nField060FormatUID
				,@lActive
				,@lDeleted
				,@lApproved
				,@lAdded
				,@nAddFacilityUID
				,@nAddUserUID
				,@nImportUID
				,GetUTCDate()
				,@nAddUserUID
				,@nAddFacilityUID
				,GetUTCDate()
				,GetUTCDate()
			)

			RETURN 1
		END
		'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF EXISTS( SELECT * FROM sysobjects WHERE type='P' AND name='InsertPointReading' )
		BEGIN
			PRINT N'Dropping [dbo].[InsertPointReading]'

			DROP PROCEDURE [dbo].[InsertPointReading]

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

	IF OBJECT_ID(N'[dbo].[InsertPointReading]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[InsertPointReading]'

		EXEC sp_executesql N'
		CREATE PROCEDURE [dbo].[InsertPointReading]
			 @nPointReadingUID [uniqueidentifier]
			,@nPointUID uniqueidentifier
			,@nAssetUID uniqueidentifier
			,@nReadingUnitUID uniqueidentifier  = NULL
			,@nReadingFormatUID uniqueidentifier  = NULL
			,@tReadingDateTime datetime  = NULL
			,@nReadingOrdinal int  = NULL
			,@nReading float  = NULL
			,@cReadingUnit nvarchar(50)  = NULL
			,@cReadingLabel nvarchar(50)  = NULL
			,@cReadingType nvarchar(50)  = NULL
			,@lActive int  = -1
			,@lDeleted int  = 0
			,@lApproved int  = 0
			,@lAdded int  = -1
			,@nAddFacilityUID uniqueidentifier  = ''AB9B7878-B72C-4A72-9273-47030571BE4C''
			,@nAddUserUID uniqueidentifier  = ''ABF8F215-1980-4E47-84DA-305699ECF5D5''
			,@nImportUID uniqueidentifier  = NULL
		AS
		BEGIN
			INSERT INTO [dbo].[PointReadings] (
				 [nPointReadingUID]
				,[nPointUID]
				,[nAssetUID]
				,[nReadingUnitUID]
				,[nReadingFormatUID]
				,[tReadingDateTime]
				,[nReadingOrdinal]
				,[nReading]
				,[cReadingUnit]
				,[cReadingLabel]
				,[cReadingType]
				,[lActive]
				,[lDeleted]
				,[lApproved]
				,[lAdded]
				,[nAddFacilityUID]
				,[nAddUserUID]
				,[nImportUID]
				,[tAddTime]
				,[nUpdateUserUID]
				,[nUpdateFacilityUID]
				,[tUpdateTime]
				,[tMobileTime]
			)
			VALUES (
		         @nPointReadingUID
				,@nPointUID
				,@nAssetUID
				,@nReadingUnitUID
				,@nReadingFormatUID
				,@tReadingDateTime
				,@nReadingOrdinal
				,@nReading
				,@cReadingUnit
				,@cReadingLabel
				,@cReadingType
				,@lActive
				,@lDeleted
				,@lApproved
				,@lAdded
				,@nAddFacilityUID
				,@nAddUserUID
				,@nImportUID
				,GetUTCDate()
				,@nAddUserUID
				,@nAddFacilityUID
				,GetUTCDate()
				,GetUTCDate()
			)

			RETURN 1
		END
		'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END


	-- UCI data, context element & link: cFunctionName
	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '415070fd-cd58-4075-bf45-bd0db0baf30c')
	BEGIN
	    PRINT N'Adding UCI Data Item for cFunctionName'
	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('415070fd-cd58-4075-bf45-bd0db0baf30c', N'dbo.Validations', N'cFunctionName', N'Label', N'Function Name',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200420 22:45:58','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200420 22:45:58','20200420 22:45:58')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF (SELECT nUCIDataUID FROM [dbo].[ContextElements] WHERE nContextElementUID = '7ee8e48f-1160-433a-9f0b-fc1d38bf7fe8') IS NULL
	BEGIN
		PRINT N'Updating Context Element for cFunctionName'
		UPDATE [dbo].[ContextElements] SET [nUCIDataUID] = '415070fd-cd58-4075-bf45-bd0db0baf30c' WHERE nContextElementUID = '7ee8e48f-1160-433a-9f0b-fc1d38bf7fe8'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '35e99fac-899f-4131-923d-61f466bcd5a1')
	BEGIN
	    PRINT N'Adding Context Element Link for cFunctionName'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('35e99fac-899f-4131-923d-61f466bcd5a1','8C4489D3-5752-48D1-AFE3-37F6FD34415F','7ee8e48f-1160-433a-9f0b-fc1d38bf7fe8',N'AND',2,0,NULL,-1,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200420 22:45:58','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200420 22:45:58','20200420 22:45:58')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-- UCI data, context element & link: cCode
	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'ecd793fb-28d9-48d8-827e-939b69b8d90a')
	BEGIN
	    PRINT N'Adding UCI Data Item for cCode'
	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('ecd793fb-28d9-48d8-827e-939b69b8d90a', N'dbo.Validations', N'cCode', N'Label', N'Code',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200420 22:45:58','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200420 22:45:58','20200420 22:45:58')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	--   60a38bd7-3218-40ff-975d-61541f332d28    cCode  Code
	IF (SELECT nUCIDataUID FROM [dbo].[ContextElements] WHERE nContextElementUID = '60a38bd7-3218-40ff-975d-61541f332d28') IS NULL
	BEGIN
		PRINT N'Updating Context Element for cCode'
		UPDATE [dbo].[ContextElements] SET [nUCIDataUID] = 'ecd793fb-28d9-48d8-827e-939b69b8d90a' WHERE nContextElementUID = '60a38bd7-3218-40ff-975d-61541f332d28'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'a0339484-c522-49c4-a218-1cfc14137a38')
	BEGIN
	    PRINT N'Adding Context Element Link for cCode'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('a0339484-c522-49c4-a218-1cfc14137a38','8C4489D3-5752-48D1-AFE3-37F6FD34415F','60a38bd7-3218-40ff-975d-61541f332d28',N'AND',5,0,NULL,-1,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200420 22:45:58','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200420 22:45:58','20200420 22:45:58')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '85E160AF-EC63-401E-9A7E-A5D06B09ADEB')
	BEGIN
		UPDATE [dbo].[ContextElementLink] SET lActive = 0 WHERE nContextElementLinkUID = '85E160AF-EC63-401E-9A7E-A5D06B09ADEB'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '8C3F27BF-4B51-45F0-902B-9880D7F9B52B')
	BEGIN
		UPDATE [dbo].[ContextElementLink] SET lActive = 0 WHERE nContextElementLinkUID = '8C3F27BF-4B51-45F0-902B-9880D7F9B52B'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF (SELECT nUCIDataUID FROM [dbo].[ContextElements] WHERE nContextElementUID = 'C73466CE-3F63-4BAB-9B2F-641A8D638A4E') IS NULL
	BEGIN
		PRINT N'Updating Context Element for cFormName'
		UPDATE [dbo].[ContextElements] SET [nUCIDataUID] = '51CA98E5-3770-47A2-9C84-F3F74E6621E0' WHERE nContextElementUID = 'C73466CE-3F63-4BAB-9B2F-641A8D638A4E'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'dd6b68dc-d2a1-425f-869d-9b693f562003')
	BEGIN
	    PRINT N'Adding UCI Data Item for lActive'
	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('dd6b68dc-d2a1-425f-869d-9b693f562003', N'dbo.Validations', N'lActive', N'Label', N'Active',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200420 22:45:58','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200420 22:45:58','20200420 22:45:58')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

    IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '9fdecf63-31c4-4d92-a87c-95b18402376e')
	BEGIN
	    PRINT N'Adding Context Element for lActive'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('9fdecf63-31c4-4d92-a87c-95b18402376e','dd6b68dc-d2a1-425f-869d-9b693f562003',N'Field',N'lActive',N'Active',64,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200420 22:45:58','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200420 22:45:58','20200420 22:45:58')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '74fc311c-9722-4eaa-96c9-f43b7df2a668')
	BEGIN
	    PRINT N'Adding Context Element Link for lActive'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('74fc311c-9722-4eaa-96c9-f43b7df2a668','8C4489D3-5752-48D1-AFE3-37F6FD34415F','9fdecf63-31c4-4d92-a87c-95b18402376e',N'AND',4,0,NULL,-1,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200420 22:45:58','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200420 22:45:58','20200420 22:45:58')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	-- MTM-387
	IF EXISTS(SELECT * FROM [dbo].[SystemDefaults] WHERE [nSystemDefaultUID] = 'C2B053EE-C665-4060-A454-45674655AB2E')
	BEGIN
		UPDATE [dbo].[SystemDefaults] SET
			[cValue] = REPLACE([cValue], 'http://us.flukecal.com/', 'https://support.flukecal.com'),
			[tUpdateTime] = '20200508 14:49:38.510',
			[tMobileTime] = '20200508 14:49:38.510',
			[tSystemUpdateTime] = NULL
		WHERE [nSystemDefaultUID] = 'C2B053EE-C665-4060-A454-45674655AB2E'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-- MTM-509
	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 1159 AND [cLocale] = ''EN'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''Log Notes'' _COLL_ AND [cKey] = N''CallSheetLog'')
	BEGIN
		PRINT ''Updating translation entry: 1159 - EN''
		UPDATE
			[dbo].[Translations]
		SET
			[cKey] = N''CallSheetLog'',
			[mValue] = N''Log Notes'',
			[lActive] = -1,
			[tUpdateTime] = ''20200520 20:43:26'',
			[tMobileTime] = ''20200520 20:43:26''
		WHERE
			[nLineNumber] = 1159 AND [cLocale] = ''EN''
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 1261 AND [cLocale] = ''EN'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''Whitespace'' _COLL_ AND [cKey] = N''SHOW_WHITESPACE'')
	BEGIN
		PRINT ''Updating translation entry: 1261 - EN''
		UPDATE
			[dbo].[Translations]
		SET
			[cKey] = N''SHOW_WHITESPACE'',
			[mValue] = N''Whitespace'',
			[lActive] = -1,
			[tUpdateTime] = ''20200520 20:43:26'',
			[tMobileTime] = ''20200520 20:43:26''
		WHERE
			[nLineNumber] = 1261 AND [cLocale] = ''EN''
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 1264 AND [cLocale] = ''EN'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''Show Whitespace Characters'' _COLL_ AND [cKey] = N''SHOW_WHITESPACE_CHARS'')
	BEGIN
		PRINT ''Updating translation entry: 1264 - EN''
		UPDATE
			[dbo].[Translations]
		SET
			[cKey] = N''SHOW_WHITESPACE_CHARS'',
			[mValue] = N''Show Whitespace Characters'',
			[lActive] = -1,
			[tUpdateTime] = ''20200520 20:43:26'',
			[tMobileTime] = ''20200520 20:43:26''
		WHERE
			[nLineNumber] = 1264 AND [cLocale] = ''EN''
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 1265 AND [cLocale] = ''EN'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''Find Data Check'' _COLL_ AND [cKey] = N''FIND_DATA_CHECK'')
	BEGIN
		PRINT ''Updating translation entry: 1265 - EN''
		UPDATE
			[dbo].[Translations]
		SET
			[cKey] = N''FIND_DATA_CHECK'',
			[mValue] = N''Find Data Check'',
			[lActive] = -1,
			[tUpdateTime] = ''20200520 20:43:26'',
			[tMobileTime] = ''20200520 20:43:26''
		WHERE
			[nLineNumber] = 1265 AND [cLocale] = ''EN''
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 2531 AND [cLocale] = ''EN'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''Select To Insert'' _COLL_ AND [cKey] = N''MODEL_PROPS_INSERT'')
	BEGIN
		PRINT ''Updating translation entry: 2531 - EN''
		UPDATE
			[dbo].[Translations]
		SET
			[cKey] = N''MODEL_PROPS_INSERT'',
			[mValue] = N''Select To Insert'',
			[lActive] = -1,
			[tUpdateTime] = ''20200520 20:43:26'',
			[tMobileTime] = ''20200520 20:43:26''
		WHERE
			[nLineNumber] = 2531 AND [cLocale] = ''EN''
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 1265 AND [cLocale] = ''DE'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''Datencheck Suchen'' _COLL_ AND [cKey] = N''FIND_DATA_CHECK'')
	BEGIN
		PRINT ''Updating translation entry: 1265 - DE''
		UPDATE
			[dbo].[Translations]
		SET
			[cKey] = N''FIND_DATA_CHECK'',
			[mValue] = N''Datencheck Suchen'',
			[lActive] = -1,
			[tUpdateTime] = ''20200520 20:43:26'',
			[tMobileTime] = ''20200520 20:43:26''
		WHERE
			[nLineNumber] = 1265 AND [cLocale] = ''DE''
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 1159 AND [cLocale] = ''RU'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''#RU# Log Notes'' _COLL_ AND [cKey] = N''CallSheetLog'')
	BEGIN
		PRINT ''Updating translation entry: 1159 - RU''
		UPDATE
			[dbo].[Translations]
		SET
			[cKey] = N''CallSheetLog'',
			[mValue] = N''#RU# Log Notes'',
			[lActive] = -1,
			[tUpdateTime] = ''20200520 20:43:26'',
			[tMobileTime] = ''20200520 20:43:26''
		WHERE
			[nLineNumber] = 1159 AND [cLocale] = ''RU''
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 1261 AND [cLocale] = ''RU'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''#RU# Whitespace'' _COLL_ AND [cKey] = N''SHOW_WHITESPACE'')
	BEGIN
		PRINT ''Updating translation entry: 1261 - RU''
		UPDATE
			[dbo].[Translations]
		SET
			[cKey] = N''SHOW_WHITESPACE'',
			[mValue] = N''#RU# Whitespace'',
			[lActive] = -1,
			[tUpdateTime] = ''20200520 20:43:26'',
			[tMobileTime] = ''20200520 20:43:26''
		WHERE
			[nLineNumber] = 1261 AND [cLocale] = ''RU''
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 1264 AND [cLocale] = ''RU'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''#RU# Show Whitespace Characters'' _COLL_ AND [cKey] = N''SHOW_WHITESPACE_CHARS'')
	BEGIN
		PRINT ''Updating translation entry: 1264 - RU''
		UPDATE
			[dbo].[Translations]
		SET
			[cKey] = N''SHOW_WHITESPACE_CHARS'',
			[mValue] = N''#RU# Show Whitespace Characters'',
			[lActive] = -1,
			[tUpdateTime] = ''20200520 20:43:26'',
			[tMobileTime] = ''20200520 20:43:26''
		WHERE
			[nLineNumber] = 1264 AND [cLocale] = ''RU''
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 1265 AND [cLocale] = ''RU'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''#RU# Find Data Check'' _COLL_ AND [cKey] = N''FIND_DATA_CHECK'')
	BEGIN
		PRINT ''Updating translation entry: 1265 - RU''
		UPDATE
			[dbo].[Translations]
		SET
			[cKey] = N''FIND_DATA_CHECK'',
			[mValue] = N''#RU# Find Data Check'',
			[lActive] = -1,
			[tUpdateTime] = ''20200520 20:43:26'',
			[tMobileTime] = ''20200520 20:43:26''
		WHERE
			[nLineNumber] = 1265 AND [cLocale] = ''RU''
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 2531 AND [cLocale] = ''RU'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''#RU# Select To Insert'' _COLL_ AND [cKey] = N''MODEL_PROPS_INSERT'')
	BEGIN
		PRINT ''Updating translation entry: 2531 - RU''
		UPDATE
			[dbo].[Translations]
		SET
			[cKey] = N''MODEL_PROPS_INSERT'',
			[mValue] = N''#RU# Select To Insert'',
			[lActive] = -1,
			[tUpdateTime] = ''20200520 20:43:26'',
			[tMobileTime] = ''20200520 20:43:26''
		WHERE
			[nLineNumber] = 2531 AND [cLocale] = ''RU''
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 1159 AND [cLocale] = ''PT'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''#PT# Log Notes'' _COLL_ AND [cKey] = N''CallSheetLog'')
	BEGIN
		PRINT ''Updating translation entry: 1159 - PT''
		UPDATE
			[dbo].[Translations]
		SET
			[cKey] = N''CallSheetLog'',
			[mValue] = N''#PT# Log Notes'',
			[lActive] = -1,
			[tUpdateTime] = ''20200520 20:43:26'',
			[tMobileTime] = ''20200520 20:43:26''
		WHERE
			[nLineNumber] = 1159 AND [cLocale] = ''PT''
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '0E742995-0B08-4BDB-BD26-8F9DAA0743C8' )
	BEGIN
		PRINT 'Adding translation entry: 0E742995-0B08-4BDB-BD26-8F9DAA0743C8'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('0E742995-0B08-4BDB-BD26-8F9DAA0743C8',3187,N'EN',N'ManualTemplates',N'Manual Templates',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '19F4F9B4-2648-4B59-95A0-C60F60F9918B' )
	BEGIN
		PRINT 'Adding translation entry: 19F4F9B4-2648-4B59-95A0-C60F60F9918B'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('19F4F9B4-2648-4B59-95A0-C60F60F9918B',3187,N'DE',N'ManualTemplates',N'Eingabevorlagen',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '74FF3BED-3A87-438E-85CA-38F71C4228A8' )
	BEGIN
		PRINT 'Adding translation entry: 74FF3BED-3A87-438E-85CA-38F71C4228A8'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('74FF3BED-3A87-438E-85CA-38F71C4228A8',3187,N'RU',N'ManualTemplates',N'#RU# Manual Templates',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'F7E06540-7772-469F-959A-47F7F3F96D77' )
	BEGIN
		PRINT 'Adding translation entry: F7E06540-7772-469F-959A-47F7F3F96D77'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('F7E06540-7772-469F-959A-47F7F3F96D77',3187,N'PT',N'ManualTemplates',N'#PT# Manual Templates',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '2CC505D6-E1E6-4D4D-B09A-0860E6812883' )
	BEGIN
		PRINT 'Adding translation entry: 2CC505D6-E1E6-4D4D-B09A-0860E6812883'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('2CC505D6-E1E6-4D4D-B09A-0860E6812883',3187,N'ZH',N'ManualTemplates',N'#ZH# Manual Templates',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '59E70834-2867-4BC7-952A-E70BEDBAE783' )
	BEGIN
		PRINT 'Adding translation entry: 59E70834-2867-4BC7-952A-E70BEDBAE783'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('59E70834-2867-4BC7-952A-E70BEDBAE783',3187,N'JA',N'ManualTemplates',N'#JA# Manual Templates',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '9AC88DB1-AFE8-4778-BC97-34E586C0D7B9' )
	BEGIN
		PRINT 'Adding translation entry: 9AC88DB1-AFE8-4778-BC97-34E586C0D7B9'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('9AC88DB1-AFE8-4778-BC97-34E586C0D7B9',3187,N'FR',N'ManualTemplates',N'#FR# Manual Templates',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'E7D0FA9B-6330-4DB2-9245-5FE3CDDDB42F' )
	BEGIN
		PRINT 'Adding translation entry: E7D0FA9B-6330-4DB2-9245-5FE3CDDDB42F'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('E7D0FA9B-6330-4DB2-9245-5FE3CDDDB42F',3187,N'ES',N'ManualTemplates',N'#ES# Manual Templates',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '122D179D-AE81-462C-A801-80418486F564' )
	BEGIN
		PRINT 'Adding translation entry: 122D179D-AE81-462C-A801-80418486F564'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('122D179D-AE81-462C-A801-80418486F564',3187,N'IT',N'ManualTemplates',N'#IT# Manual Templates',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '8B487220-4410-42DE-9820-E1FEA268CF06' )
	BEGIN
		PRINT 'Adding translation entry: 8B487220-4410-42DE-9820-E1FEA268CF06'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('8B487220-4410-42DE-9820-E1FEA268CF06',3188,N'EN',N'ShipmentItems',N'Shipment Items',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'A29368E9-98B5-4C30-B386-3F37554ECEAE' )
	BEGIN
		PRINT 'Adding translation entry: A29368E9-98B5-4C30-B386-3F37554ECEAE'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('A29368E9-98B5-4C30-B386-3F37554ECEAE',3188,N'DE',N'ShipmentItems',N'Versandobjekte',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'F2E01FAD-E95F-4637-9DBF-040E30120B14' )
	BEGIN
		PRINT 'Adding translation entry: F2E01FAD-E95F-4637-9DBF-040E30120B14'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('F2E01FAD-E95F-4637-9DBF-040E30120B14',3188,N'RU',N'ShipmentItems',N'#RU# Shipment Items',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'A6738050-0608-48B8-8F0A-933C736C70F4' )
	BEGIN
		PRINT 'Adding translation entry: A6738050-0608-48B8-8F0A-933C736C70F4'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('A6738050-0608-48B8-8F0A-933C736C70F4',3188,N'PT',N'ShipmentItems',N'#PT# Shipment Items',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '963C6CD8-BF16-41B8-9CBE-3BB2D0B0B564' )
	BEGIN
		PRINT 'Adding translation entry: 963C6CD8-BF16-41B8-9CBE-3BB2D0B0B564'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('963C6CD8-BF16-41B8-9CBE-3BB2D0B0B564',3188,N'ZH',N'ShipmentItems',N'#ZH# Shipment Items',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'EE8DF2E9-9C2A-44A2-A5E1-0CD5FF7C0D6A' )
	BEGIN
		PRINT 'Adding translation entry: EE8DF2E9-9C2A-44A2-A5E1-0CD5FF7C0D6A'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('EE8DF2E9-9C2A-44A2-A5E1-0CD5FF7C0D6A',3188,N'JA',N'ShipmentItems',N'#JA# Shipment Items',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '4A8192F3-877A-4F64-939D-56B980A1AADB' )
	BEGIN
		PRINT 'Adding translation entry: 4A8192F3-877A-4F64-939D-56B980A1AADB'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('4A8192F3-877A-4F64-939D-56B980A1AADB',3188,N'FR',N'ShipmentItems',N'#FR# Shipment Items',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '6DBC246D-3D78-452A-A511-DB4473C5DC06' )
	BEGIN
		PRINT 'Adding translation entry: 6DBC246D-3D78-452A-A511-DB4473C5DC06'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('6DBC246D-3D78-452A-A511-DB4473C5DC06',3188,N'ES',N'ShipmentItems',N'#ES# Shipment Items',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'A5B0DDE5-0D7C-4F67-8B15-96D65E73EBDF' )
	BEGIN
		PRINT 'Adding translation entry: A5B0DDE5-0D7C-4F67-8B15-96D65E73EBDF'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('A5B0DDE5-0D7C-4F67-8B15-96D65E73EBDF',3188,N'IT',N'ShipmentItems',N'#IT# Shipment Items',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'EEFE2CE9-6B39-4FF8-A77E-7B2A58B9391D' )
	BEGIN
		PRINT 'Adding translation entry: EEFE2CE9-6B39-4FF8-A77E-7B2A58B9391D'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('EEFE2CE9-6B39-4FF8-A77E-7B2A58B9391D',3189,N'EN',N'TypeProcedureDefaults',N'Type Procedure Defaults',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '327831EC-4395-49D0-A691-EC9568725E48' )
	BEGIN
		PRINT 'Adding translation entry: 327831EC-4395-49D0-A691-EC9568725E48'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('327831EC-4395-49D0-A691-EC9568725E48',3189,N'DE',N'TypeProcedureDefaults',N'Typ-Prozedur-Voreinstellungen',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '550661F5-4BDC-4BAE-BEB8-0430994C3284' )
	BEGIN
		PRINT 'Adding translation entry: 550661F5-4BDC-4BAE-BEB8-0430994C3284'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('550661F5-4BDC-4BAE-BEB8-0430994C3284',3189,N'RU',N'TypeProcedureDefaults',N'#RU# Type Procedure Defaults',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'E7D53ECC-D3DA-451D-B329-A3C645D5D684' )
	BEGIN
		PRINT 'Adding translation entry: E7D53ECC-D3DA-451D-B329-A3C645D5D684'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('E7D53ECC-D3DA-451D-B329-A3C645D5D684',3189,N'PT',N'TypeProcedureDefaults',N'#PT# Type Procedure Defaults',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '259628A3-ABBD-4910-B38D-2E9035641E39' )
	BEGIN
		PRINT 'Adding translation entry: 259628A3-ABBD-4910-B38D-2E9035641E39'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('259628A3-ABBD-4910-B38D-2E9035641E39',3189,N'ZH',N'TypeProcedureDefaults',N'#ZH# Type Procedure Defaults',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '433C463F-E913-490C-AD60-30FCD6BB8E64' )
	BEGIN
		PRINT 'Adding translation entry: 433C463F-E913-490C-AD60-30FCD6BB8E64'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('433C463F-E913-490C-AD60-30FCD6BB8E64',3189,N'JA',N'TypeProcedureDefaults',N'#JA# Type Procedure Defaults',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '98E3052A-AB4C-4BD6-BDA2-FD2EA97D6AD5' )
	BEGIN
		PRINT 'Adding translation entry: 98E3052A-AB4C-4BD6-BDA2-FD2EA97D6AD5'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('98E3052A-AB4C-4BD6-BDA2-FD2EA97D6AD5',3189,N'FR',N'TypeProcedureDefaults',N'#FR# Type Procedure Defaults',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '8345C13C-E9DF-4837-B8AE-FB72A05E5547' )
	BEGIN
		PRINT 'Adding translation entry: 8345C13C-E9DF-4837-B8AE-FB72A05E5547'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('8345C13C-E9DF-4837-B8AE-FB72A05E5547',3189,N'ES',N'TypeProcedureDefaults',N'#ES# Type Procedure Defaults',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'C45E4B2F-D1C6-44CC-AADE-E05D41462655' )
	BEGIN
		PRINT 'Adding translation entry: C45E4B2F-D1C6-44CC-AADE-E05D41462655'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('C45E4B2F-D1C6-44CC-AADE-E05D41462655',3189,N'IT',N'TypeProcedureDefaults',N'#IT# Type Procedure Defaults',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '02B180B2-2BBA-4E15-A379-2004B8DE097D' )
	BEGIN
		PRINT 'Adding translation entry: 02B180B2-2BBA-4E15-A379-2004B8DE097D'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('02B180B2-2BBA-4E15-A379-2004B8DE097D',3190,N'EN',N'ProblemReports',N'Problem Reports',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'A7E3E0B0-169B-4194-B0C8-6E8CF4C09CF8' )
	BEGIN
		PRINT 'Adding translation entry: A7E3E0B0-169B-4194-B0C8-6E8CF4C09CF8'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('A7E3E0B0-169B-4194-B0C8-6E8CF4C09CF8',3190,N'DE',N'ProblemReports',N'Problemberichte',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'CCF44FD3-AA5D-46CD-93E9-E58A3220A44E' )
	BEGIN
		PRINT 'Adding translation entry: CCF44FD3-AA5D-46CD-93E9-E58A3220A44E'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('CCF44FD3-AA5D-46CD-93E9-E58A3220A44E',3190,N'RU',N'ProblemReports',N'#RU# Problem Reports',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '7F3C55BC-FA71-43F2-B029-F5BF51FB4E7F' )
	BEGIN
		PRINT 'Adding translation entry: 7F3C55BC-FA71-43F2-B029-F5BF51FB4E7F'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('7F3C55BC-FA71-43F2-B029-F5BF51FB4E7F',3190,N'PT',N'ProblemReports',N'#PT# Problem Reports',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '6F14DD98-A83A-432C-B234-71B79B15CC51' )
	BEGIN
		PRINT 'Adding translation entry: 6F14DD98-A83A-432C-B234-71B79B15CC51'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('6F14DD98-A83A-432C-B234-71B79B15CC51',3190,N'ZH',N'ProblemReports',N'#ZH# Problem Reports',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'E44C029A-B07C-4390-A92C-B741FEC9DEC5' )
	BEGIN
		PRINT 'Adding translation entry: E44C029A-B07C-4390-A92C-B741FEC9DEC5'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('E44C029A-B07C-4390-A92C-B741FEC9DEC5',3190,N'JA',N'ProblemReports',N'#JA# Problem Reports',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '78030556-77B6-4C5A-B750-4FE2565AD8FD' )
	BEGIN
		PRINT 'Adding translation entry: 78030556-77B6-4C5A-B750-4FE2565AD8FD'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('78030556-77B6-4C5A-B750-4FE2565AD8FD',3190,N'FR',N'ProblemReports',N'#FR# Problem Reports',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'D904379A-3421-4241-9730-773F17AEC434' )
	BEGIN
		PRINT 'Adding translation entry: D904379A-3421-4241-9730-773F17AEC434'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('D904379A-3421-4241-9730-773F17AEC434',3190,N'ES',N'ProblemReports',N'#ES# Problem Reports',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '7950C6A6-A465-4194-A832-0240B3F196E7' )
	BEGIN
		PRINT 'Adding translation entry: 7950C6A6-A465-4194-A832-0240B3F196E7'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('7950C6A6-A465-4194-A832-0240B3F196E7',3190,N'IT',N'ProblemReports',N'#IT# Problem Reports',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200520 20:50:01','20200520 20:50:01',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-- MTM-349
		SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 770 AND [cLocale] = ''IT'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''Immettere il codice di registrazione ricevuto nell\''''area sottostante, e selezionare “Salva” per registrare questa applicazione.'' _COLL_ AND [cKey] = N''ENTER_REGISTRATION_CODE_MESSAGE'')
	BEGIN
		PRINT ''Updating translation entry: 770 - IT''
		UPDATE
			[dbo].[Translations]
		SET
			[cKey] = N''ENTER_REGISTRATION_CODE_MESSAGE'',
			[mValue] = N''Immettere il codice di registrazione ricevuto nell\''''area sottostante, e selezionare “Salva” per registrare questa applicazione.'',
			[lActive] = -1,
			[tUpdateTime] = ''20200528 15:23:33'',
			[tMobileTime] = ''20200528 15:23:33''
		WHERE
			[nLineNumber] = 770 AND [cLocale] = ''IT''
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END


	-- MTM-829
	IF NOT EXISTS(SELECT * FROM [dbo].[Context] WHERE nContextUID = 'b601a92b-fbc4-450e-b3b8-57a7c2cc4f7a')
	BEGIN
	    PRINT N'Adding context for FindRunnableDataChecks'
	    INSERT INTO [dbo].[Context]([nContextUID],[cContext],[cMode],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('b601a92b-fbc4-450e-b3b8-57a7c2cc4f7a',N'FindRunnableDataChecks',N'System',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200611 21:03:58.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200611 21:03:58.000','20200611 21:03:58.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	-- link select element
	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '03c66187-cdc4-4b43-88b8-66e96598435d')
	BEGIN
	    PRINT N'Adding Context Element Link for SELECT clause'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('03c66187-cdc4-4b43-88b8-66e96598435d','b601a92b-fbc4-450e-b3b8-57a7c2cc4f7a','3B664A34-6F37-478D-85D2-83B7E94EA5E6',N'AND',1,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200611 21:03:58.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200611 21:03:58.000','20200611 21:03:58.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	-- WHERE clause
	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'c9d9a3f9-aa95-479a-995a-317296e1d8d9')
	BEGIN
	    PRINT N'Adding Context Element for WHERE clause'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],
	    [nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('c9d9a3f9-aa95-479a-995a-317296e1d8d9', NULL, N'Where', N'lActive <> 0 AND lDeleted = 0 AND cFormName = ''Runnable''', NULL, NULL, NULL, NULL, NULL, 1, NULL, -1, 0, 0, 0,
	    'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20160921 21:14:03.667', 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20160921 21:14:03.667', '20160921 21:14:03.667')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	-- link where element
	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '1b1b9f89-ffa8-48c8-8797-611d9c7645ac')
	BEGIN
	    PRINT N'Adding Context Element Link for WHERE clause'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('1b1b9f89-ffa8-48c8-8797-611d9c7645ac','b601a92b-fbc4-450e-b3b8-57a7c2cc4f7a','c9d9a3f9-aa95-479a-995a-317296e1d8d9',N'AND',1,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200611 21:03:58.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200611 21:03:58.000','20200611 21:03:58.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	-- link cFunctionName
	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '44995974-9f61-4ce2-9166-eabc1e9f4ff1')
	BEGIN
	    PRINT N'Adding Context Element Link for cFunctionName'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('44995974-9f61-4ce2-9166-eabc1e9f4ff1','b601a92b-fbc4-450e-b3b8-57a7c2cc4f7a','7EE8E48F-1160-433A-9F0B-FC1D38BF7FE8',N'AND',1,0,NULL,-1,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200611 21:03:58.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200611 21:03:58.000','20200611 21:03:58.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	-- link cCode
	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '0e736272-6261-4e23-a0fd-2303a7ae2281')
	BEGIN
	    PRINT N'Adding Context Element Link for cCode'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('0e736272-6261-4e23-a0fd-2303a7ae2281','b601a92b-fbc4-450e-b3b8-57a7c2cc4f7a','60A38BD7-3218-40FF-975D-61541F332D28',N'AND',1,0,NULL,-1,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200611 21:03:58.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200611 21:03:58.000','20200611 21:03:58.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-- MTM-781
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '5CA09182-8A42-4653-8074-1CCDAFE66590' )
	BEGIN
		PRINT 'Adding translation entry: 5CA09182-8A42-4653-8074-1CCDAFE66590'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('5CA09182-8A42-4653-8074-1CCDAFE66590',3191,N'EN',N'IMPORT_LOG_FILE_DOWNLOAD_TITLE',N'Import Log File',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'D32480C6-A2E9-4B75-AB97-7F29823BF726' )
	BEGIN
		PRINT 'Adding translation entry: D32480C6-A2E9-4B75-AB97-7F29823BF726'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('D32480C6-A2E9-4B75-AB97-7F29823BF726',3191,N'DE',N'IMPORT_LOG_FILE_DOWNLOAD_TITLE',N'#DE# Import Log File',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '5E8FE402-7010-4E55-804F-384C0F9B54BB' )
	BEGIN
		PRINT 'Adding translation entry: 5E8FE402-7010-4E55-804F-384C0F9B54BB'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('5E8FE402-7010-4E55-804F-384C0F9B54BB',3191,N'RU',N'IMPORT_LOG_FILE_DOWNLOAD_TITLE',N'#RU# Import Log File',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'D2B64002-3099-4542-9C2F-CF6128CC8D2F' )
	BEGIN
		PRINT 'Adding translation entry: D2B64002-3099-4542-9C2F-CF6128CC8D2F'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('D2B64002-3099-4542-9C2F-CF6128CC8D2F',3191,N'PT',N'IMPORT_LOG_FILE_DOWNLOAD_TITLE',N'#PT# Import Log File',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '1A8FC8FE-AA5B-4B76-991C-7D45C86BAC7A' )
	BEGIN
		PRINT 'Adding translation entry: 1A8FC8FE-AA5B-4B76-991C-7D45C86BAC7A'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('1A8FC8FE-AA5B-4B76-991C-7D45C86BAC7A',3191,N'ZH',N'IMPORT_LOG_FILE_DOWNLOAD_TITLE',N'#ZH# Import Log File',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'BB52BAC2-74DC-41A6-A8EA-27FE89093A3C' )
	BEGIN
		PRINT 'Adding translation entry: BB52BAC2-74DC-41A6-A8EA-27FE89093A3C'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('BB52BAC2-74DC-41A6-A8EA-27FE89093A3C',3191,N'JA',N'IMPORT_LOG_FILE_DOWNLOAD_TITLE',N'#JA# Import Log File',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '2B9BFCE6-60CC-45B4-AB5E-652FBAC95604' )
	BEGIN
		PRINT 'Adding translation entry: 2B9BFCE6-60CC-45B4-AB5E-652FBAC95604'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('2B9BFCE6-60CC-45B4-AB5E-652FBAC95604',3191,N'FR',N'IMPORT_LOG_FILE_DOWNLOAD_TITLE',N'#FR# Import Log File',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '2F67181B-2659-43EF-841C-AC4D3636C7EB' )
	BEGIN
		PRINT 'Adding translation entry: 2F67181B-2659-43EF-841C-AC4D3636C7EB'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('2F67181B-2659-43EF-841C-AC4D3636C7EB',3191,N'ES',N'IMPORT_LOG_FILE_DOWNLOAD_TITLE',N'#ES# Import Log File',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '08D1BA21-B692-413B-A8BE-A9A2D5A707EF' )
	BEGIN
		PRINT 'Adding translation entry: 08D1BA21-B692-413B-A8BE-A9A2D5A707EF'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('08D1BA21-B692-413B-A8BE-A9A2D5A707EF',3191,N'IT',N'IMPORT_LOG_FILE_DOWNLOAD_TITLE',N'#IT# Import Log File',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'F47BC758-BEA2-47B6-8A87-EF459C414F8B' )
	BEGIN
		PRINT 'Adding translation entry: F47BC758-BEA2-47B6-8A87-EF459C414F8B'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('F47BC758-BEA2-47B6-8A87-EF459C414F8B',3192,N'EN',N'IMPORT_LOG_FILE_DOWNLOAD_INITIATED',N'If the import log file did not open, check the download folder.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'C831E848-0A84-4333-8609-A0149D722D18' )
	BEGIN
		PRINT 'Adding translation entry: C831E848-0A84-4333-8609-A0149D722D18'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('C831E848-0A84-4333-8609-A0149D722D18',3192,N'DE',N'IMPORT_LOG_FILE_DOWNLOAD_INITIATED',N'#DE# If the import log file did not open, check the download folder.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'CA685D18-CD88-4519-A46B-1A22CD3A27BF' )
	BEGIN
		PRINT 'Adding translation entry: CA685D18-CD88-4519-A46B-1A22CD3A27BF'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('CA685D18-CD88-4519-A46B-1A22CD3A27BF',3192,N'RU',N'IMPORT_LOG_FILE_DOWNLOAD_INITIATED',N'#RU# If the import log file did not open, check the download folder.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '8425A726-92C1-42F9-AAA5-24FC97534D22' )
	BEGIN
		PRINT 'Adding translation entry: 8425A726-92C1-42F9-AAA5-24FC97534D22'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('8425A726-92C1-42F9-AAA5-24FC97534D22',3192,N'PT',N'IMPORT_LOG_FILE_DOWNLOAD_INITIATED',N'#PT# If the import log file did not open, check the download folder.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'D957811E-43CB-4C26-88DA-1E58FF80D24B' )
	BEGIN
		PRINT 'Adding translation entry: D957811E-43CB-4C26-88DA-1E58FF80D24B'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('D957811E-43CB-4C26-88DA-1E58FF80D24B',3192,N'ZH',N'IMPORT_LOG_FILE_DOWNLOAD_INITIATED',N'#ZH# If the import log file did not open, check the download folder.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '83DC8D53-EC61-4717-9D6F-04FED056943B' )
	BEGIN
		PRINT 'Adding translation entry: 83DC8D53-EC61-4717-9D6F-04FED056943B'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('83DC8D53-EC61-4717-9D6F-04FED056943B',3192,N'JA',N'IMPORT_LOG_FILE_DOWNLOAD_INITIATED',N'#JA# If the import log file did not open, check the download folder.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '3D94087E-F698-4BEB-88EA-313509E4B380' )
	BEGIN
		PRINT 'Adding translation entry: 3D94087E-F698-4BEB-88EA-313509E4B380'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('3D94087E-F698-4BEB-88EA-313509E4B380',3192,N'FR',N'IMPORT_LOG_FILE_DOWNLOAD_INITIATED',N'#FR# If the import log file did not open, check the download folder.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '8D373059-6D98-42D3-8848-CE6B12AD2D23' )
	BEGIN
		PRINT 'Adding translation entry: 8D373059-6D98-42D3-8848-CE6B12AD2D23'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('8D373059-6D98-42D3-8848-CE6B12AD2D23',3192,N'ES',N'IMPORT_LOG_FILE_DOWNLOAD_INITIATED',N'#ES# If the import log file did not open, check the download folder.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '28647A0D-9837-4BD0-B124-B625F5854284' )
	BEGIN
		PRINT 'Adding translation entry: 28647A0D-9837-4BD0-B124-B625F5854284'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('28647A0D-9837-4BD0-B124-B625F5854284',3192,N'IT',N'IMPORT_LOG_FILE_DOWNLOAD_INITIATED',N'#IT# If the import log file did not open, check the download folder.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '71164643-CCE6-4DE0-93BF-3C55F3618316' )
	BEGIN
		PRINT 'Adding translation entry: 71164643-CCE6-4DE0-93BF-3C55F3618316'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('71164643-CCE6-4DE0-93BF-3C55F3618316',3193,N'EN',N'DOWNLOAD_LOG_FILES',N'Download Log Files',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'E5B484D8-3D85-4975-AB66-80935A8F3C3B' )
	BEGIN
		PRINT 'Adding translation entry: E5B484D8-3D85-4975-AB66-80935A8F3C3B'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('E5B484D8-3D85-4975-AB66-80935A8F3C3B',3193,N'DE',N'DOWNLOAD_LOG_FILES',N'#DE# Download Log Files',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '72D9E790-0FB4-4C8C-AEA8-EF4B1474D16B' )
	BEGIN
		PRINT 'Adding translation entry: 72D9E790-0FB4-4C8C-AEA8-EF4B1474D16B'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('72D9E790-0FB4-4C8C-AEA8-EF4B1474D16B',3193,N'RU',N'DOWNLOAD_LOG_FILES',N'#RU# Download Log Files',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '0FB24A6C-E516-41D1-8390-05B9A1CE84CF' )
	BEGIN
		PRINT 'Adding translation entry: 0FB24A6C-E516-41D1-8390-05B9A1CE84CF'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('0FB24A6C-E516-41D1-8390-05B9A1CE84CF',3193,N'PT',N'DOWNLOAD_LOG_FILES',N'#PT# Download Log Files',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '9ADB10D5-5A92-4366-9D3E-5F9391E690C5' )
	BEGIN
		PRINT 'Adding translation entry: 9ADB10D5-5A92-4366-9D3E-5F9391E690C5'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('9ADB10D5-5A92-4366-9D3E-5F9391E690C5',3193,N'ZH',N'DOWNLOAD_LOG_FILES',N'#ZH# Download Log Files',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'A4C10A93-85E0-4378-BB3A-A652A026F1C6' )
	BEGIN
		PRINT 'Adding translation entry: A4C10A93-85E0-4378-BB3A-A652A026F1C6'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('A4C10A93-85E0-4378-BB3A-A652A026F1C6',3193,N'JA',N'DOWNLOAD_LOG_FILES',N'#JA# Download Log Files',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'D634EAA6-30FF-4BCA-894D-AC05828EEA3B' )
	BEGIN
		PRINT 'Adding translation entry: D634EAA6-30FF-4BCA-894D-AC05828EEA3B'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('D634EAA6-30FF-4BCA-894D-AC05828EEA3B',3193,N'FR',N'DOWNLOAD_LOG_FILES',N'#FR# Download Log Files',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '07259973-3E06-419E-8E4B-EABE532E5F48' )
	BEGIN
		PRINT 'Adding translation entry: 07259973-3E06-419E-8E4B-EABE532E5F48'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('07259973-3E06-419E-8E4B-EABE532E5F48',3193,N'ES',N'DOWNLOAD_LOG_FILES',N'#ES# Download Log Files',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '92060C0C-9BE3-4A1D-8D89-6F837DA82222' )
	BEGIN
		PRINT 'Adding translation entry: 92060C0C-9BE3-4A1D-8D89-6F837DA82222'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('92060C0C-9BE3-4A1D-8D89-6F837DA82222',3193,N'IT',N'DOWNLOAD_LOG_FILES',N'#IT# Download Log Files',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '520BEE71-5CDC-48DB-B020-B210075DA936' )
	BEGIN
		PRINT 'Adding translation entry: 520BEE71-5CDC-48DB-B020-B210075DA936'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('520BEE71-5CDC-48DB-B020-B210075DA936',3194,N'EN',N'DOWNLOAD_LOG_FILES_TOOLTIP',N'Archive and Download Log Files to send to Technical Support',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '291FF760-F3D7-4088-828A-21F9A8592F1F' )
	BEGIN
		PRINT 'Adding translation entry: 291FF760-F3D7-4088-828A-21F9A8592F1F'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('291FF760-F3D7-4088-828A-21F9A8592F1F',3194,N'DE',N'DOWNLOAD_LOG_FILES_TOOLTIP',N'#DE# Archive and Download Log Files to send to Technical Support',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'B44D3020-3FBA-4611-ABC2-FB7433926F31' )
	BEGIN
		PRINT 'Adding translation entry: B44D3020-3FBA-4611-ABC2-FB7433926F31'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('B44D3020-3FBA-4611-ABC2-FB7433926F31',3194,N'RU',N'DOWNLOAD_LOG_FILES_TOOLTIP',N'#RU# Archive and Download Log Files to send to Technical Support',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'ADF14C84-1668-4DE4-977D-0016FBCEDDB8' )
	BEGIN
		PRINT 'Adding translation entry: ADF14C84-1668-4DE4-977D-0016FBCEDDB8'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('ADF14C84-1668-4DE4-977D-0016FBCEDDB8',3194,N'PT',N'DOWNLOAD_LOG_FILES_TOOLTIP',N'#PT# Archive and Download Log Files to send to Technical Support',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'C6CA6562-C84A-4A47-A20B-2559CD7EB4BE' )
	BEGIN
		PRINT 'Adding translation entry: C6CA6562-C84A-4A47-A20B-2559CD7EB4BE'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('C6CA6562-C84A-4A47-A20B-2559CD7EB4BE',3194,N'ZH',N'DOWNLOAD_LOG_FILES_TOOLTIP',N'#ZH# Archive and Download Log Files to send to Technical Support',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '9B9B64B5-BFAE-45F5-9E7E-0DEF327AF373' )
	BEGIN
		PRINT 'Adding translation entry: 9B9B64B5-BFAE-45F5-9E7E-0DEF327AF373'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('9B9B64B5-BFAE-45F5-9E7E-0DEF327AF373',3194,N'JA',N'DOWNLOAD_LOG_FILES_TOOLTIP',N'#JA# Archive and Download Log Files to send to Technical Support',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'ED79C49D-A448-4830-866D-E9B5DD3DB826' )
	BEGIN
		PRINT 'Adding translation entry: ED79C49D-A448-4830-866D-E9B5DD3DB826'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('ED79C49D-A448-4830-866D-E9B5DD3DB826',3194,N'FR',N'DOWNLOAD_LOG_FILES_TOOLTIP',N'#FR# Archive and Download Log Files to send to Technical Support',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'EC7F4EF1-7533-4AC2-B7C5-44ABA70397E5' )
	BEGIN
		PRINT 'Adding translation entry: EC7F4EF1-7533-4AC2-B7C5-44ABA70397E5'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('EC7F4EF1-7533-4AC2-B7C5-44ABA70397E5',3194,N'ES',N'DOWNLOAD_LOG_FILES_TOOLTIP',N'#ES# Archive and Download Log Files to send to Technical Support',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '9840DBF8-CBC9-403F-8FA0-B3CE0DEBD5B4' )
	BEGIN
		PRINT 'Adding translation entry: 9840DBF8-CBC9-403F-8FA0-B3CE0DEBD5B4'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('9840DBF8-CBC9-403F-8FA0-B3CE0DEBD5B4',3194,N'IT',N'DOWNLOAD_LOG_FILES_TOOLTIP',N'#IT# Archive and Download Log Files to send to Technical Support',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '116FE60D-0A96-407F-A66F-08FA2FFD8F0C' )
	BEGIN
		PRINT 'Adding translation entry: 116FE60D-0A96-407F-A66F-08FA2FFD8F0C'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('116FE60D-0A96-407F-A66F-08FA2FFD8F0C',3195,N'EN',N'DOWNLOAD_LOG_FILES_SUCCESS',N'MET/TEAM log files have been archived and downloaded to your browser''s downloads folder.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '732CFAF9-41F7-48E2-A062-52309CE8B505' )
	BEGIN
		PRINT 'Adding translation entry: 732CFAF9-41F7-48E2-A062-52309CE8B505'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('732CFAF9-41F7-48E2-A062-52309CE8B505',3195,N'DE',N'DOWNLOAD_LOG_FILES_SUCCESS',N'#DE# MET/TEAM log files have been archived and downloaded to your browser''s downloads folder.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '2C6BAFFD-4B1F-4D84-A2E3-5F7807387AEA' )
	BEGIN
		PRINT 'Adding translation entry: 2C6BAFFD-4B1F-4D84-A2E3-5F7807387AEA'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('2C6BAFFD-4B1F-4D84-A2E3-5F7807387AEA',3195,N'RU',N'DOWNLOAD_LOG_FILES_SUCCESS',N'#RU# MET/TEAM log files have been archived and downloaded to your browser''s downloads folder.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'E5B8D5C1-B4F0-4DC0-A07A-C99DD3327AFE' )
	BEGIN
		PRINT 'Adding translation entry: E5B8D5C1-B4F0-4DC0-A07A-C99DD3327AFE'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('E5B8D5C1-B4F0-4DC0-A07A-C99DD3327AFE',3195,N'PT',N'DOWNLOAD_LOG_FILES_SUCCESS',N'#PT# MET/TEAM log files have been archived and downloaded to your browser''s downloads folder.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'D61C9C32-2051-4EB2-B5AF-6F8ED3D03E0B' )
	BEGIN
		PRINT 'Adding translation entry: D61C9C32-2051-4EB2-B5AF-6F8ED3D03E0B'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('D61C9C32-2051-4EB2-B5AF-6F8ED3D03E0B',3195,N'ZH',N'DOWNLOAD_LOG_FILES_SUCCESS',N'#ZH# MET/TEAM log files have been archived and downloaded to your browser''s downloads folder.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '6FBE59F4-795F-4457-99D3-CD335C3E650C' )
	BEGIN
		PRINT 'Adding translation entry: 6FBE59F4-795F-4457-99D3-CD335C3E650C'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('6FBE59F4-795F-4457-99D3-CD335C3E650C',3195,N'JA',N'DOWNLOAD_LOG_FILES_SUCCESS',N'#JA# MET/TEAM log files have been archived and downloaded to your browser''s downloads folder.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '22A7937A-0437-42E5-83F6-C582CB773957' )
	BEGIN
		PRINT 'Adding translation entry: 22A7937A-0437-42E5-83F6-C582CB773957'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('22A7937A-0437-42E5-83F6-C582CB773957',3195,N'FR',N'DOWNLOAD_LOG_FILES_SUCCESS',N'#FR# MET/TEAM log files have been archived and downloaded to your browser''s downloads folder.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'BE4316B7-3ECD-4C6C-92DF-4E15C6348C91' )
	BEGIN
		PRINT 'Adding translation entry: BE4316B7-3ECD-4C6C-92DF-4E15C6348C91'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('BE4316B7-3ECD-4C6C-92DF-4E15C6348C91',3195,N'ES',N'DOWNLOAD_LOG_FILES_SUCCESS',N'#ES# MET/TEAM log files have been archived and downloaded to your browser''s downloads folder.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'A1603F29-7F82-4E85-BDCB-68160AED0983' )
	BEGIN
		PRINT 'Adding translation entry: A1603F29-7F82-4E85-BDCB-68160AED0983'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('A1603F29-7F82-4E85-BDCB-68160AED0983',3195,N'IT',N'DOWNLOAD_LOG_FILES_SUCCESS',N'#IT# MET/TEAM log files have been archived and downloaded to your browser''s downloads folder.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '95DA5E56-CC10-49F3-ADDA-AEE8C622E1DE' )
	BEGIN
		PRINT 'Adding translation entry: 95DA5E56-CC10-49F3-ADDA-AEE8C622E1DE'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('95DA5E56-CC10-49F3-ADDA-AEE8C622E1DE',3196,N'EN',N'DOWNLOAD_LOG_FILES_FAILURE',N'There was a problem archiving and/or downloading the MET/TEAM log files.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '734440CA-944B-4EB8-A22E-55793CDB2816' )
	BEGIN
		PRINT 'Adding translation entry: 734440CA-944B-4EB8-A22E-55793CDB2816'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('734440CA-944B-4EB8-A22E-55793CDB2816',3196,N'DE',N'DOWNLOAD_LOG_FILES_FAILURE',N'#DE# There was a problem archiving and/or downloading the MET/TEAM log files.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '376E291F-0253-45F3-8CD7-62D058047EA1' )
	BEGIN
		PRINT 'Adding translation entry: 376E291F-0253-45F3-8CD7-62D058047EA1'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('376E291F-0253-45F3-8CD7-62D058047EA1',3196,N'RU',N'DOWNLOAD_LOG_FILES_FAILURE',N'#RU# There was a problem archiving and/or downloading the MET/TEAM log files.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'F9C19849-13F0-4FFD-BA34-4528EF4F0FC2' )
	BEGIN
		PRINT 'Adding translation entry: F9C19849-13F0-4FFD-BA34-4528EF4F0FC2'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('F9C19849-13F0-4FFD-BA34-4528EF4F0FC2',3196,N'PT',N'DOWNLOAD_LOG_FILES_FAILURE',N'#PT# There was a problem archiving and/or downloading the MET/TEAM log files.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'AC53DDF2-18AD-4BB3-B09F-7B395C0F0925' )
	BEGIN
		PRINT 'Adding translation entry: AC53DDF2-18AD-4BB3-B09F-7B395C0F0925'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('AC53DDF2-18AD-4BB3-B09F-7B395C0F0925',3196,N'ZH',N'DOWNLOAD_LOG_FILES_FAILURE',N'#ZH# There was a problem archiving and/or downloading the MET/TEAM log files.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '30BACCDE-1E3F-4E38-92CB-6FB81E5C5679' )
	BEGIN
		PRINT 'Adding translation entry: 30BACCDE-1E3F-4E38-92CB-6FB81E5C5679'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('30BACCDE-1E3F-4E38-92CB-6FB81E5C5679',3196,N'JA',N'DOWNLOAD_LOG_FILES_FAILURE',N'#JA# There was a problem archiving and/or downloading the MET/TEAM log files.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'DE3F0E0D-E0A8-4634-9FC5-446092A03ED1' )
	BEGIN
		PRINT 'Adding translation entry: DE3F0E0D-E0A8-4634-9FC5-446092A03ED1'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('DE3F0E0D-E0A8-4634-9FC5-446092A03ED1',3196,N'FR',N'DOWNLOAD_LOG_FILES_FAILURE',N'#FR# There was a problem archiving and/or downloading the MET/TEAM log files.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'EFA558E7-6185-498A-A454-83E1FB5FDAF0' )
	BEGIN
		PRINT 'Adding translation entry: EFA558E7-6185-498A-A454-83E1FB5FDAF0'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('EFA558E7-6185-498A-A454-83E1FB5FDAF0',3196,N'ES',N'DOWNLOAD_LOG_FILES_FAILURE',N'#ES# There was a problem archiving and/or downloading the MET/TEAM log files.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'F920E382-43D8-40BF-862E-8A55001B89E9' )
	BEGIN
		PRINT 'Adding translation entry: F920E382-43D8-40BF-862E-8A55001B89E9'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('F920E382-43D8-40BF-862E-8A55001B89E9',3196,N'IT',N'DOWNLOAD_LOG_FILES_FAILURE',N'#IT# There was a problem archiving and/or downloading the MET/TEAM log files.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '708DA115-A4B1-4C96-A653-39319396B9DC' )
	BEGIN
		PRINT 'Adding translation entry: 708DA115-A4B1-4C96-A653-39319396B9DC'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('708DA115-A4B1-4C96-A653-39319396B9DC',3197,N'EN',N'NO_LOG_FILES_TO_ARCHIVE_MSG',N'There are no log files to archive.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '7D6F63C9-41BB-46F6-BEAD-3813A53B53CB' )
	BEGIN
		PRINT 'Adding translation entry: 7D6F63C9-41BB-46F6-BEAD-3813A53B53CB'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('7D6F63C9-41BB-46F6-BEAD-3813A53B53CB',3197,N'DE',N'NO_LOG_FILES_TO_ARCHIVE_MSG',N'#DE# There are no log files to archive.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'CD1D4F86-ECC0-4522-B257-77B4F11A0656' )
	BEGIN
		PRINT 'Adding translation entry: CD1D4F86-ECC0-4522-B257-77B4F11A0656'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('CD1D4F86-ECC0-4522-B257-77B4F11A0656',3197,N'RU',N'NO_LOG_FILES_TO_ARCHIVE_MSG',N'#RU# There are no log files to archive.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'A86ACDAE-3AE9-4F84-9672-53EE3964EC08' )
	BEGIN
		PRINT 'Adding translation entry: A86ACDAE-3AE9-4F84-9672-53EE3964EC08'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('A86ACDAE-3AE9-4F84-9672-53EE3964EC08',3197,N'PT',N'NO_LOG_FILES_TO_ARCHIVE_MSG',N'#PT# There are no log files to archive.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '3AC2EB16-20B6-4D11-AA79-34923C44EDB5' )
	BEGIN
		PRINT 'Adding translation entry: 3AC2EB16-20B6-4D11-AA79-34923C44EDB5'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('3AC2EB16-20B6-4D11-AA79-34923C44EDB5',3197,N'ZH',N'NO_LOG_FILES_TO_ARCHIVE_MSG',N'#ZH# There are no log files to archive.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'DEFCE8B1-4A5E-4246-A6E3-626EEB03C7EC' )
	BEGIN
		PRINT 'Adding translation entry: DEFCE8B1-4A5E-4246-A6E3-626EEB03C7EC'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('DEFCE8B1-4A5E-4246-A6E3-626EEB03C7EC',3197,N'JA',N'NO_LOG_FILES_TO_ARCHIVE_MSG',N'#JA# There are no log files to archive.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '2B0FE03D-1537-4DB5-984E-0885245E6C95' )
	BEGIN
		PRINT 'Adding translation entry: 2B0FE03D-1537-4DB5-984E-0885245E6C95'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('2B0FE03D-1537-4DB5-984E-0885245E6C95',3197,N'FR',N'NO_LOG_FILES_TO_ARCHIVE_MSG',N'#FR# There are no log files to archive.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '131BB651-5116-4D00-B718-BA5CAEC96C6F' )
	BEGIN
		PRINT 'Adding translation entry: 131BB651-5116-4D00-B718-BA5CAEC96C6F'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('131BB651-5116-4D00-B718-BA5CAEC96C6F',3197,N'ES',N'NO_LOG_FILES_TO_ARCHIVE_MSG',N'#ES# There are no log files to archive.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '0134F735-9387-437A-BC0B-C01EA65BB2CD' )
	BEGIN
		PRINT 'Adding translation entry: 0134F735-9387-437A-BC0B-C01EA65BB2CD'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('0134F735-9387-437A-BC0B-C01EA65BB2CD',3197,N'IT',N'NO_LOG_FILES_TO_ARCHIVE_MSG',N'#IT# There are no log files to archive.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200615 16:11:40','20200615 16:11:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 3191 AND [cLocale] = ''DE'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''Import-Protokolldatei'' _COLL_ AND [cKey] = N''IMPORT_LOG_FILE_DOWNLOAD_TITLE'')
	BEGIN
		PRINT ''Updating translation entry: 3191 - DE''
		UPDATE
			[dbo].[Translations]
		SET
			[cKey] = N''IMPORT_LOG_FILE_DOWNLOAD_TITLE'',
			[mValue] = N''Import-Protokolldatei'',
			[lActive] = -1,
			[tUpdateTime] = ''20200615 16:57:13'',
			[tMobileTime] = ''20200615 16:57:13''
		WHERE
			[nLineNumber] = 3191 AND [cLocale] = ''DE''
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 3192 AND [cLocale] = ''DE'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''Falls die Import-Protokolldatei nicht angezeigt wird, sehen Sie in ihrem Download-Order nach.'' _COLL_ AND [cKey] = N''IMPORT_LOG_FILE_DOWNLOAD_INITIATED'')
	BEGIN
		PRINT ''Updating translation entry: 3192 - DE''
		UPDATE
			[dbo].[Translations]
		SET
			[cKey] = N''IMPORT_LOG_FILE_DOWNLOAD_INITIATED'',
			[mValue] = N''Falls die Import-Protokolldatei nicht angezeigt wird, sehen Sie in ihrem Download-Order nach.'',
			[lActive] = -1,
			[tUpdateTime] = ''20200615 16:57:13'',
			[tMobileTime] = ''20200615 16:57:13''
		WHERE
			[nLineNumber] = 3192 AND [cLocale] = ''DE''
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 3194 AND [cLocale] = ''DE'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''Protokolldateien komprimieren und sichern, für die Übermittlung zum Support'' _COLL_ AND [cKey] = N''DOWNLOAD_LOG_FILES_TOOLTIP'')
	BEGIN
		PRINT ''Updating translation entry: 3194 - DE''
		UPDATE
			[dbo].[Translations]
		SET
			[cKey] = N''DOWNLOAD_LOG_FILES_TOOLTIP'',
			[mValue] = N''Protokolldateien komprimieren und sichern, für die Übermittlung zum Support'',
			[lActive] = -1,
			[tUpdateTime] = ''20200615 16:57:13'',
			[tMobileTime] = ''20200615 16:57:13''
		WHERE
			[nLineNumber] = 3194 AND [cLocale] = ''DE''
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 3195 AND [cLocale] = ''EN'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''MET/TEAM log files have been archived and downloaded to your browser\''''s downloads folder.'' _COLL_ AND [cKey] = N''DOWNLOAD_LOG_FILES_SUCCESS'')
	BEGIN
		PRINT ''Updating translation entry: 3195 - EN''
		UPDATE
			[dbo].[Translations]
		SET
			[cKey] = N''DOWNLOAD_LOG_FILES_SUCCESS'',
			[mValue] = N''MET/TEAM log files have been archived and downloaded to your browser\''''s downloads folder.'',
			[lActive] = -1,
			[tUpdateTime] = ''20200615 20:43:35'',
			[tMobileTime] = ''20200615 20:43:35''
		WHERE
			[nLineNumber] = 3195 AND [cLocale] = ''EN''
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END


	-- MTM-709
	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '2B1BD7A7-68C5-4936-96C8-989188E12BF2')
	BEGIN
	    PRINT N'Adding UCI Data Item'

	    INSERT INTO [dbo].UCIData([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],
	    [nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('2B1BD7A7-68C5-4936-96C8-989188E12BF2', N'Validations', N'cFormName', N'ControlType', N'combo', -1, 0, 0, 0,
	    'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000', 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000', '20200616 15:15:15.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='809CB457-A12D-4BB5-BC7B-78A203C49327')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('809CB457-A12D-4BB5-BC7B-78A203C49327','Accreditations', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='59ABE988-EC84-437A-BEF0-30918E3A2741')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('59ABE988-EC84-437A-BEF0-30918E3A2741','Addresses', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='24ED2248-A5FF-43D7-BC98-6348911EBB28')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('24ED2248-A5FF-43D7-BC98-6348911EBB28','Alerts', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='7E422A87-B618-457E-9E35-9C0DABF4C7DD')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('7E422A87-B618-457E-9E35-9C0DABF4C7DD','Assets', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='530CB4B4-477E-4CB5-9061-0F1AFB05D97A')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('530CB4B4-477E-4CB5-9061-0F1AFB05D97A','AssetServices', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='11F22CF5-FA50-4876-85AC-31305A65721F')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('11F22CF5-FA50-4876-85AC-31305A65721F','CallSheetLog', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='5892F2CF-E9FD-43B3-B80B-AB83B8E825A0')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('5892F2CF-E9FD-43B3-B80B-AB83B8E825A0','CallSheets', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='24C3749A-B9BE-4155-B357-D76E0DFE23EF')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('24C3749A-B9BE-4155-B357-D76E0DFE23EF','Contacts', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='3175EE1B-B411-41A2-8FE7-DAA6BCBEE56B')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('3175EE1B-B411-41A2-8FE7-DAA6BCBEE56B','EstimateItems', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='C4EA2FF7-E8B2-49E1-B4B6-F55F60CA926D')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('C4EA2FF7-E8B2-49E1-B4B6-F55F60CA926D','Estimates', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='E1377FDE-B644-47FA-A324-8601420E3E34')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('E1377FDE-B644-47FA-A324-8601420E3E34','ExDef', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='1B5B2897-9A6B-4AD9-9FDD-120B0ECF9E7C')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('1B5B2897-9A6B-4AD9-9FDD-120B0ECF9E7C','Facilities', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='782A0598-CA4D-40A8-88CE-6534912AE86E')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('782A0598-CA4D-40A8-88CE-6534912AE86E','Files', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='D6463780-DED5-4904-8EC5-E01943152B55')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('D6463780-DED5-4904-8EC5-E01943152B55','Invoices', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='DECB7C96-2415-4DE3-A5ED-983D38178430')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('DECB7C96-2415-4DE3-A5ED-983D38178430','JobNumbers', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='301149F2-3167-45BD-BF41-94049B3D4B0D')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('301149F2-3167-45BD-BF41-94049B3D4B0D','Labor', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='3300BD7B-453E-483F-AC53-BC6DA1C77EE9')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('3300BD7B-453E-483F-AC53-BC6DA1C77EE9','ManualTemplates', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='A8BCF2B3-FE16-4391-852A-5544077EF51C')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('A8BCF2B3-FE16-4391-852A-5544077EF51C','Parts', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='6B95D68F-CBF3-4A62-94B2-B669260C2ABD')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('6B95D68F-CBF3-4A62-94B2-B669260C2ABD','Pricing', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='7617A838-C1E8-453D-A11F-E65E22007BB5')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('7617A838-C1E8-453D-A11F-E65E22007BB5','ProblemReports', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='00A1743B-899B-4D19-ABE6-6C5CE2E7351F')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('00A1743B-899B-4D19-ABE6-6C5CE2E7351F','Procedures', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='BA236367-4844-48DF-A7CB-65DB80BF78BD')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('BA236367-4844-48DF-A7CB-65DB80BF78BD','QuickNotes', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='7DD1DAF0-A67E-4CB6-A48F-66E247F2AAB6')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('7DD1DAF0-A67E-4CB6-A48F-66E247F2AAB6','Receiving', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='502D4483-8F22-4081-9160-E3A989703CFB')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('502D4483-8F22-4081-9160-E3A989703CFB','Returning', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='DD77D736-4FBE-4039-9968-D77D7412C0B0')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('DD77D736-4FBE-4039-9968-D77D7412C0B0','Runnable', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='97A3EC60-55D0-4E51-A4AC-6D730638C089')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('97A3EC60-55D0-4E51-A4AC-6D730638C089','SecurityGroups', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='325043DB-B246-41DC-A091-A280FB71437F')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('325043DB-B246-41DC-A091-A280FB71437F','ServiceTypes', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='66996CA5-4F97-4434-8A54-526455422E9C')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('66996CA5-4F97-4434-8A54-526455422E9C','ShipmentItems', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='1F33ACDE-3F4F-445E-BF54-C871C4500574')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('1F33ACDE-3F4F-445E-BF54-C871C4500574','Shipments', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='31496483-3952-4E7B-A469-640B11860048')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('31496483-3952-4E7B-A469-640B11860048','SystemDefaults', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='7BA58919-5C5F-42FC-BA53-DC06033A2357')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('7BA58919-5C5F-42FC-BA53-DC06033A2357','ToolAssignments', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='4A944B3D-24CC-49ED-9F35-00309826B6E8')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('4A944B3D-24CC-49ED-9F35-00309826B6E8','TypeProcedureDefaults', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='BF605FAA-F5D1-403F-8C6D-A57F305A7E75')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('BF605FAA-F5D1-403F-8C6D-A57F305A7E75','Types', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[AvailableComboData] WHERE [nAvailableComboDataUID] ='7C5FA58D-7906-4F9D-902C-A051A2F595D1')
	BEGIN
		PRINT N'Adding available combo data item'

		INSERT INTO [dbo].[AvailableComboData] ([nAvailableComboDataUID], [cText], [cItemData], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('7C5FA58D-7906-4F9D-902C-A051A2F595D1','Users', NULL, -1, 0, 0, 0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = 'C110D8CA-20DF-46E7-B124-A5B00273CB2D')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('C110D8CA-20DF-46E7-B124-A5B00273CB2D', '809CB457-A12D-4BB5-BC7B-78A203C49327', NULL, 'Default', 'Validations', 'cFormName', 0,  -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '633DE9FA-DB6E-4471-85C7-501D546FE395')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('633DE9FA-DB6E-4471-85C7-501D546FE395', '59ABE988-EC84-437A-BEF0-30918E3A2741', NULL, 'Default', 'Validations', 'cFormName', 1,  -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '011E72AA-E583-49B9-97BC-7816E0F3B453')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('011E72AA-E583-49B9-97BC-7816E0F3B453', '24ED2248-A5FF-43D7-BC98-6348911EBB28', NULL, 'Default', 'Validations', 'cFormName', 2,  -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = 'E473E6A2-3938-4A7C-9B4F-3071DCF1BA27')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('E473E6A2-3938-4A7C-9B4F-3071DCF1BA27', '7E422A87-B618-457E-9E35-9C0DABF4C7DD', NULL, 'Default', 'Validations', 'cFormName', 3,  -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '3F0D4827-9286-4635-9AB5-2EF17470F24B')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('3F0D4827-9286-4635-9AB5-2EF17470F24B', '530CB4B4-477E-4CB5-9061-0F1AFB05D97A', NULL, 'Default', 'Validations', 'cFormName', 4,  -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '350A14C8-63D3-405E-A0D8-8E1802620634')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('350A14C8-63D3-405E-A0D8-8E1802620634', '11F22CF5-FA50-4876-85AC-31305A65721F', NULL, 'Default', 'Validations', 'cFormName', 5,  -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '4569F421-ABEA-473F-B6E1-716520447F6C')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('4569F421-ABEA-473F-B6E1-716520447F6C', '5892F2CF-E9FD-43B3-B80B-AB83B8E825A0', NULL, 'Default', 'Validations', 'cFormName', 6,  -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '1A2F1E3C-AE38-468B-8C44-1654F8F187E0')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('1A2F1E3C-AE38-468B-8C44-1654F8F187E0', '24C3749A-B9BE-4155-B357-D76E0DFE23EF', NULL, 'Default', 'Validations', 'cFormName', 7,  -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '6EC6D0A9-1F2B-43D3-84D0-4760A527A360')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('6EC6D0A9-1F2B-43D3-84D0-4760A527A360', '3175EE1B-B411-41A2-8FE7-DAA6BCBEE56B', NULL, 'Default', 'Validations', 'cFormName', 8,  -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '0EC6A69A-CC6B-42D1-AF3A-734B433A1AE3')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('0EC6A69A-CC6B-42D1-AF3A-734B433A1AE3', 'C4EA2FF7-E8B2-49E1-B4B6-F55F60CA926D', NULL, 'Default', 'Validations', 'cFormName', 9,  -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = 'D0CF4CC7-9014-4774-B7E4-07C592C8FCEA')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('D0CF4CC7-9014-4774-B7E4-07C592C8FCEA', 'E1377FDE-B644-47FA-A324-8601420E3E34', NULL, 'Default', 'Validations', 'cFormName', 10, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = 'D0939FB4-3A57-44FC-9B81-F5E64EA2470E')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('D0939FB4-3A57-44FC-9B81-F5E64EA2470E', '1B5B2897-9A6B-4AD9-9FDD-120B0ECF9E7C', NULL, 'Default', 'Validations', 'cFormName', 11, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = 'CED78EF8-568A-48B6-8A70-529AED72EB4E')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('CED78EF8-568A-48B6-8A70-529AED72EB4E', '782A0598-CA4D-40A8-88CE-6534912AE86E', NULL, 'Default', 'Validations', 'cFormName', 12, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '6B97B136-8CF2-48A9-BFDB-8EC60139BC32')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('6B97B136-8CF2-48A9-BFDB-8EC60139BC32', 'D6463780-DED5-4904-8EC5-E01943152B55', NULL, 'Default', 'Validations', 'cFormName', 13, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '37B3BAE1-38D8-4B7D-ABAB-513F43C92D33')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('37B3BAE1-38D8-4B7D-ABAB-513F43C92D33', 'DECB7C96-2415-4DE3-A5ED-983D38178430', NULL, 'Default', 'Validations', 'cFormName', 14, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '9985D30A-0CC7-4A69-842A-6179F59F4B4E')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('9985D30A-0CC7-4A69-842A-6179F59F4B4E', '301149F2-3167-45BD-BF41-94049B3D4B0D', NULL, 'Default', 'Validations', 'cFormName', 15, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '676C9093-8675-4239-881D-D4856C64FD16')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('676C9093-8675-4239-881D-D4856C64FD16', '3300BD7B-453E-483F-AC53-BC6DA1C77EE9', NULL, 'Default', 'Validations', 'cFormName', 16, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '2FB3FEF2-6F40-47D0-9B6D-9A00F5436CEC')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('2FB3FEF2-6F40-47D0-9B6D-9A00F5436CEC', 'A8BCF2B3-FE16-4391-852A-5544077EF51C', NULL, 'Default', 'Validations', 'cFormName', 17, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = 'DA65C610-63EE-4DFC-AAA7-B86215B59553')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('DA65C610-63EE-4DFC-AAA7-B86215B59553', '6B95D68F-CBF3-4A62-94B2-B669260C2ABD', NULL, 'Default', 'Validations', 'cFormName', 18, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = 'ABC963D1-481B-4235-97F0-7E70AB40DB75')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('ABC963D1-481B-4235-97F0-7E70AB40DB75', '7617A838-C1E8-453D-A11F-E65E22007BB5', NULL, 'Default', 'Validations', 'cFormName', 19, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = 'D64C3218-1E97-45AA-AD6B-09AAE4FB179B')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('D64C3218-1E97-45AA-AD6B-09AAE4FB179B', '00A1743B-899B-4D19-ABE6-6C5CE2E7351F', NULL, 'Default', 'Validations', 'cFormName', 20, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '8F95A581-08C5-48E8-B1A9-658C52911A54')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('8F95A581-08C5-48E8-B1A9-658C52911A54', 'BA236367-4844-48DF-A7CB-65DB80BF78BD', NULL, 'Default', 'Validations', 'cFormName', 21, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = 'D877AB1F-049F-43CF-8A8B-EAD794E107E8')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('D877AB1F-049F-43CF-8A8B-EAD794E107E8', '7DD1DAF0-A67E-4CB6-A48F-66E247F2AAB6', NULL, 'Default', 'Validations', 'cFormName', 22, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '45D3CDC9-A4E8-4C1C-803B-9EAC14B8114B')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('45D3CDC9-A4E8-4C1C-803B-9EAC14B8114B', '502D4483-8F22-4081-9160-E3A989703CFB', NULL, 'Default', 'Validations', 'cFormName', 23, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '60E42E86-9982-45C0-968E-866F61AE07F1')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('60E42E86-9982-45C0-968E-866F61AE07F1', 'DD77D736-4FBE-4039-9968-D77D7412C0B0', NULL, 'Default', 'Validations', 'cFormName', 24, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '1AB38E31-22F6-4193-8F66-90FFA3825A38')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('1AB38E31-22F6-4193-8F66-90FFA3825A38', '97A3EC60-55D0-4E51-A4AC-6D730638C089', NULL, 'Default', 'Validations', 'cFormName', 25, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '5C96F9D3-169A-4681-9D34-C428639FFB69')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('5C96F9D3-169A-4681-9D34-C428639FFB69', '325043DB-B246-41DC-A091-A280FB71437F', NULL, 'Default', 'Validations', 'cFormName', 26, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '313EF616-F186-4DBA-B481-394C528CB4A5')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('313EF616-F186-4DBA-B481-394C528CB4A5', '66996CA5-4F97-4434-8A54-526455422E9C', NULL, 'Default', 'Validations', 'cFormName', 27, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '2446D6E7-0C07-47C8-B618-A43C35A03244')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('2446D6E7-0C07-47C8-B618-A43C35A03244', '1F33ACDE-3F4F-445E-BF54-C871C4500574', NULL, 'Default', 'Validations', 'cFormName', 28, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '80A3CAE1-9F67-43A8-84AA-901B99C2EA64')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('80A3CAE1-9F67-43A8-84AA-901B99C2EA64', '31496483-3952-4E7B-A469-640B11860048', NULL, 'Default', 'Validations', 'cFormName', 29, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '3B3ACA55-D4DE-472A-9D4D-A6D878BCD3A9')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('3B3ACA55-D4DE-472A-9D4D-A6D878BCD3A9', '7BA58919-5C5F-42FC-BA53-DC06033A2357', NULL, 'Default', 'Validations', 'cFormName', 30, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = 'AE71E3D2-4983-4845-8FF8-364BA4FC72A7')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('AE71E3D2-4983-4845-8FF8-364BA4FC72A7', '4A944B3D-24CC-49ED-9F35-00309826B6E8', NULL, 'Default', 'Validations', 'cFormName', 31, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = '47D8D2CC-E096-4C40-BC60-AC74C6FCEE4F')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('47D8D2CC-E096-4C40-BC60-AC74C6FCEE4F', 'BF605FAA-F5D1-403F-8C6D-A57F305A7E75', NULL, 'Default', 'Validations', 'cFormName', 32, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ComboData] WHERE [nComboDataUID] = 'F2745ACE-C7F7-4677-AC73-CBC6C9FF4744')
	BEGIN
		PRINT N'Adding combo data item'

		INSERT INTO [dbo].[ComboData]([nComboDataUID], [nAvailableComboDataUID], [nFacilityUID], [cAuthority], [cModel], [cField], [nOrder], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES('F2745ACE-C7F7-4677-AC73-CBC6C9FF4744', '7C5FA58D-7906-4F9D-902C-A051A2F595D1', NULL, 'Default', 'Validations', 'cFormName', 33, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20200616 15:15:15.000','20200616 15:15:15.000', NULL, NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-- MTM-1059
	IF EXISTS(SELECT * FROM sysobjects so JOIN syscolumns sc ON so.id = sc.id WHERE so.type = 'U' AND so.name = 'AssetFiles' AND sc.name = 'nAssetFileUID' AND sc.colstat <> 2)
	BEGIN
		PRINT N'Adding ROWGUIDCOL attribute to dbo.AssetFiles'

		ALTER TABLE [dbo].[AssetFiles] ALTER COLUMN [nAssetFileUID] Add ROWGUIDCOL

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-- MTM-1009
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'B06F8F35-8285-44C0-A1E1-2683C4CE6B48' )
	BEGIN
		PRINT 'Adding translation entry: B06F8F35-8285-44C0-A1E1-2683C4CE6B48'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('B06F8F35-8285-44C0-A1E1-2683C4CE6B48',3198,N'EN',N'TABLES_VIEWS',N'Tables / Views',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200619 17:17:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200619 17:17:40','20200619 17:17:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '707561C1-4B75-45B7-BCFC-1F00E7D6FB3C' )
	BEGIN
		PRINT 'Adding translation entry: 707561C1-4B75-45B7-BCFC-1F00E7D6FB3C'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('707561C1-4B75-45B7-BCFC-1F00E7D6FB3C',3198,N'DE',N'TABLES_VIEWS',N'Tabellen / Ansichten',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200619 17:17:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200619 17:17:40','20200619 17:17:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '68C1A8A3-166A-4B84-948C-F18C156F4DC0' )
	BEGIN
		PRINT 'Adding translation entry: 68C1A8A3-166A-4B84-948C-F18C156F4DC0'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('68C1A8A3-166A-4B84-948C-F18C156F4DC0',3198,N'RU',N'TABLES_VIEWS',N'#RU# Tables / Views',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200619 17:17:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200619 17:17:40','20200619 17:17:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '6A1F8048-F6B9-47F6-A195-BD05EF121F2D' )
	BEGIN
		PRINT 'Adding translation entry: 6A1F8048-F6B9-47F6-A195-BD05EF121F2D'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('6A1F8048-F6B9-47F6-A195-BD05EF121F2D',3198,N'PT',N'TABLES_VIEWS',N'#PT# Tables / Views',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200619 17:17:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200619 17:17:40','20200619 17:17:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '33CA1933-7606-4774-AF13-205D09C55F24' )
	BEGIN
		PRINT 'Adding translation entry: 33CA1933-7606-4774-AF13-205D09C55F24'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('33CA1933-7606-4774-AF13-205D09C55F24',3198,N'ZH',N'TABLES_VIEWS',N'#ZH# Tables / Views',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200619 17:17:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200619 17:17:40','20200619 17:17:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '18BA565D-AA99-4BB5-8E67-686A22A7C5C5' )
	BEGIN
		PRINT 'Adding translation entry: 18BA565D-AA99-4BB5-8E67-686A22A7C5C5'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('18BA565D-AA99-4BB5-8E67-686A22A7C5C5',3198,N'JA',N'TABLES_VIEWS',N'#JA# Tables / Views',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200619 17:17:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200619 17:17:40','20200619 17:17:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '7E2C426B-F229-4F19-AAA9-2AD9355519AC' )
	BEGIN
		PRINT 'Adding translation entry: 7E2C426B-F229-4F19-AAA9-2AD9355519AC'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('7E2C426B-F229-4F19-AAA9-2AD9355519AC',3198,N'FR',N'TABLES_VIEWS',N'#FR# Tables / Views',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200619 17:17:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200619 17:17:40','20200619 17:17:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'DEB6EE99-865C-4EE0-AFC0-4286C7B1A464' )
	BEGIN
		PRINT 'Adding translation entry: DEB6EE99-865C-4EE0-AFC0-4286C7B1A464'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('DEB6EE99-865C-4EE0-AFC0-4286C7B1A464',3198,N'ES',N'TABLES_VIEWS',N'#ES# Tables / Views',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200619 17:17:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200619 17:17:40','20200619 17:17:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'D14E05DE-5FEB-4B67-A2F5-17DFFABB77CF' )
	BEGIN
		PRINT 'Adding translation entry: D14E05DE-5FEB-4B67-A2F5-17DFFABB77CF'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('D14E05DE-5FEB-4B67-A2F5-17DFFABB77CF',3198,N'IT',N'TABLES_VIEWS',N'#IT# Tables / Views',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200619 17:17:40','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200619 17:17:40','20200619 17:17:40',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-- MTM-73 (new)
	IF EXISTS( SELECT * FROM sysobjects WHERE type='V' AND name='vw_WorkOrdersWithEx' )
	BEGIN
		PRINT N'Dropping [dbo].[vw_WorkOrdersWithEx]'

		DROP VIEW [dbo].[vw_WorkOrdersWithEx]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[vw_WorkOrdersWithEx]', 'V') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[vw_WorkOrdersWithEx]'

		EXEC sp_executesql N'
/******************************************************************************************
	vw_WorkOrdersWithEx
	(C) 2014-20 Fluke Calibration
-------------------------------------------------------------------------------------------
	CHANGE HISTORY
	05/13/2014	MM		Initial version
	07/22/2014	MM		Added nOwningLabUID
	03/11/2015	MM		Exclude inactive and deleted EX records
	04/09/2015	MM		Include all fields from CallSheets but nAssetUID and nFacilityUID
	12/08/2015  MM      Get latest work order location from CallSheetLog
	06/25/2020  MM      Coalesce nullable flags
*******************************************************************************************/
CREATE VIEW [dbo].[vw_WorkOrdersWithEx]
AS SELECT
	cs.[nCallSheetUID],
	cs.[nGroupUID],
	cs.[nTypeUID],
	cs.[nDepartmentUID],
	cs.[nWorkingFacilityUID],
	cs.[nOwningLabUID],
	cs.[nCategoryUID],
	cs.[nSubCategoryUID],
	cs.[nProcedureUID],
	cs.[nTypeProcedureDefaultUID],
	cs.[nAssignedTechUID],
	cs.[nTechnicianUID],
	cs.[nQCApprovedByUID],
	cs.[nReturnedByUID],
	cs.[nSubContractorUID],
	cs.[nJobNumberUID],
	cs.[nCalendarUID],
	cs.[nInvoiceUID],
	cs.[nCallSheetAttributeUID],
	cs.[nSubContHours],
	cs.[nSubContCost],
	cs.[nSubContLabCost],
	cs.[nCost],
	cs.[nAllocated],
	cs.[nAllocatedParts],
	cs.[cContactInfo],
	cs.[cInitialCondition],
	cs.[cServiceReason],
	cs.[cCallSheetType],
	cs.[cStickerType],
	cs.[cCallSheetStatus],
	cs.[cCallSheetNumber],
	cs.[cCertificationNumber],
	cs.[cInterval],
	cs.[cIntervalUOM],
	cs.[cTemperature],
	cs.[cTemperatureUOM],
	cs.[cHumidity],
	cs.[cHumidityUOM],
	cs.[cPressure],
	cs.[cPressureUOM],
	cs.[cLocation],
	cs.[cArea],
	cs.[cCertFormat],
	cs.[cWorkOrderResults],
	cs.[tOpenDate],
	cs.[tRequiredDate],
	cs.[tDelayDate],
	cs.[tMaintDate],
	cs.[tMaintNextDate],
	cs.[tQCApprovedDate],
	cs.[tClosedDate],
	cs.[tReturnedDate],
	cs.[nQuantity],
	cs.[nPriority],
	cs.[nTechnicianPriority],
	cs.[nRevision],
	COALESCE(cs.[lExpedite], 0) AS [lExpedite],
	COALESCE(cs.[lISOCert], 0) AS [lISOCert],
	COALESCE(cs.[lOnSite], 0) AS [lOnSite],
	COALESCE(cs.[lReturnNoMaint], 0) AS [lReturnNoMaint],
	COALESCE(cs.[lSubContracted], 0) AS [lSubContracted],
	COALESCE(cs.[lOOT], 0) AS [lOOT],
	COALESCE(cs.[lClosed], 0) AS [lClosed],
	COALESCE(cs.[lDelayed], 0) AS [lDelayed],
	COALESCE(cs.[lCancelled], 0) AS [lCancelled],
	cs.[mCallSheetNotes],
	cs.[mAccuracyNotes],
	cs.[mUncertaintyNotes],
	cs.[mSubContractorNotes],
	cs.[mOOTNotes],
	cs.[mStickerNotes],
	cs.[lActive],
	cs.[lDeleted],
	cs.[lApproved],
	cs.[lAdded],
	cs.[nAddFacilityUID],
	cs.[nAddUserUID],
	cs.[tAddTime],
	cs.[nUpdateFacilityUID],
	cs.[nUpdateUserUID],
	cs.[tUpdateTime],
	cs.[tMobileTime],
	cs.[tSystemUpdateTime],
	cs.[nImportUID],
	ass.nAssetUID AS [nAssetUID],
	ass.cID AS [cAssetID],
	ass.cBarcode AS [cAssetBarcode],
	ass.cModelNumber AS [cAssetModelNumber],
	ass.cSerialNumber AS [cAssetSerialNumber],
	ass.cDescription AS [cAssetDescription],
	ass.cPhysicalLocation AS [cAssetPhysicalLocation],
	ass.nQuantity AS [nAssetQuantity],
	ass.cPartNumber AS [cAssetPartNumber],
	ass.lActive AS [lAssetActive],
	ass.nFacilityUID AS [nFacilityUID],
	asspar.cID AS [cAssetParentID],
	asspar.cBarcode AS [cAssetParentBarcode],
	assfac.cFacilityName AS [cAssetManufacturerName],
	typ.cDescription AS [cCsTypeDescription],
	typ.cAuthority AS [cCsTypeAuthority],
	fac.cFacilityName AS [cCsCustomerName],
	fac.cFacilityNumber AS [cCsCustomerNumber],
	fac.cDistrict  AS [cCsCustomerRecallRule],
	dep.cFacilityName AS [cCsDepartmentName],
	dep.cFacilityNumber AS [cCsDepartmentNumber],
	wfc.cFacilityName AS [cCsWorkingFacilityName],
	wfc.cFacilityNumber AS [cCsWorkingFacilityNumber],
	ofc.cFacilityName AS [cCsOwningLabName],
	ofc.cFacilityNumber AS [cCsOwningLabNumber],
	cat.cDescription AS [cCsCategory],
	scat.cDescription AS [cCsSubCategory],
	pro.cProcedureName AS [cCsProcedureName],
	pro.cProcedureNumber AS [cCsProcedureNumber],
	pro.cAuthority AS [cCsProcedureAuthority],
	tpd.cInterval AS [cCsTpdInterval],
	tpd.cIntervalUOM AS [cCsTpdIntervalUOM],
	tpd.cMaintenanceType AS [cCsTpdMaintenanceType],
	tpd.nStandardTime AS [cCsTpdStandardTime],
	tpd.nStandardPrice AS [cCsTpdStandardPrice],
	ausr.cFirstName + '' '' + ausr.cLastName AS [cCsAssignedTechnician],
	usr.cFirstName + '' '' + usr.cLastName AS [cCsTechnician],
	QCusr.cFirstName + '' '' + QCusr.cLastName AS [cCsQCApprovedByUser],
	rusr.cFirstName + '' '' + rusr.cLastName AS [cCsReturnedByUser],
	sub.cFacilityName AS [cCsSubContractorName],
	sub.cFacilityNumber AS [cCsSubContractorNumber],
	COALESCE(job.[cJobOrderNumber],'''') AS [cCsJobOrderNumber],
	COALESCE(job.[lLevelOfEffort], 0) AS [lCsJobLevelOfEffort],
	inv.cInvoiceNo AS [cCsInvoiceNumber],
	inv.tInvoicedate AS [tCsInvoiceDate],
	csx.[cField1],
	csx.[cField2],
	csx.[cField3],
	csx.[cField4],
	csx.[cField5],
	csx.[cField6],
	csx.[cField7],
	csx.[cField8],
	csx.[cField9],
	csx.[cField10],
	csx.[cField11],
	csx.[cField12],
	csx.[cField13],
	csx.[cField14],
	csx.[cField15],
	csx.[cField16],
	csx.[cField17],
	csx.[cField18],
	csx.[cField19],
	csx.[cField20],
	csx.[cField21],
	csx.[cField22],
	csx.[cField23],
	csx.[cField24],
	csx.[cField25],
	csx.[cField26],
	csx.[tField1],
	csx.[tField2],
	csx.[tField3],
	csx.[tField4],
	csx.[tField5],
	csx.[tField6],
	csx.[tField7],
	csx.[tField8],
	csx.[tField9],
	csx.[tField10],
	csx.[nField1],
	csx.[nField2],
	csx.[nField3],
	csx.[nField4],
	csx.[nField5],
	csx.[nField6],
	csx.[nField7],
	csx.[nField8],
	csx.[nField9],
	csx.[nField10],
	csx.[nField11],
	csx.[nField12],
	csx.[nField13],
	csx.[nField14],
	csx.[nField15],
	csx.[nField16],
	csx.[nField17],
	csx.[nField18],
	csx.[nField19],
	csx.[nField20],
	csx.[nField21],
	csx.[nField22],
	csx.[nField23],
	csx.[nField24],
	csx.[nField25],
	csx.[nField26],
	csx.[nField27],
	csx.[nField28],
	csx.[nField29],
	csx.[nField30],
	csx.[nField31],
	csx.[nField32],
	csx.[nField33],
	csx.[nField34],
	csx.[nField35],
	COALESCE(csx.[lField1], 0) AS [lField1],
	COALESCE(csx.[lField2], 0) AS [lField2],
	COALESCE(csx.[lField3], 0) AS [lField3],
	COALESCE(csx.[lField4], 0) AS [lField4],
	COALESCE(csx.[lField5], 0) AS [lField5],
	COALESCE(csx.[lField6], 0) AS [lField6],
	COALESCE(csx.[lField7], 0) AS [lField7],
	COALESCE(csx.[lField8], 0) AS [lField8],
	COALESCE(csx.[lField9], 0) AS [lField9],
	COALESCE(csx.[lField10], 0) AS [lField10],
	csx.[mField1],
	csx.[mField2],
	csx.[mField3],
	csx.[lActive] AS [lCsxActive],
	cslog.[cLocation] AS [CurrentLocation]
FROM
CallSheets cs
	INNER JOIN Assets ass ON ass.nAssetUID = cs.nAssetUID
	INNER JOIN Types typ ON cs.nTypeUID = typ.nTypeUID
	INNER JOIN Facilities fac ON cs.nFacilityUID = fac.nFacilityUID
	LEFT JOIN Facilities dep ON cs.nDepartmentUID = dep.nFacilityUID
	LEFT JOIN Facilities wfc ON cs.nWorkingFacilityUID = wfc.nFacilityUID
	LEFT JOIN Facilities ofc ON cs.nOwningLabUID = ofc.nFacilityUID
	LEFT JOIN Category cat ON cs.nCategoryUID = cat.nCategoryUID
	LEFT JOIN SubCategory scat ON cs.nSubCategoryUID = scat.nSubCategoryUID
	LEFT JOIN Procedures pro ON cs.nProcedureUID = pro.nProcedureUID
	LEFT JOIN TypeProcedureDefaults tpd ON cs.nTypeProcedureDefaultUID = tpd.nTypeProcedureDefaultUID
	LEFT JOIN Users ausr ON cs.nAssignedTechUID = ausr.nUserUID
	LEFT JOIN Users usr ON cs.nTechnicianUID = usr.nUserUID
	LEFT JOIN Users QCusr ON cs.nQCApprovedByUID = QCusr.nUserUID
	LEFT JOIN Users rusr ON cs.nReturnedByUID = rusr.nUserUID
	LEFT JOIN Facilities sub ON cs.nSubContractorUID = sub.nFacilityUID
	LEFT JOIN JobNumbers job ON cs.nJobNumberUID = job.nJobNumberUID
	LEFT JOIN Invoices inv ON cs.nInvoiceUID = inv.nInvoiceUID
	LEFT JOIN Assets asspar ON ass.nParentUID = asspar.nAssetUID
	LEFT JOIN Facilities assfac ON ass.nManufacturerUID = assfac.nFacilityUID
	LEFT JOIN CallSheetEx csx ON cs.nCallSheetUID = csx.nCallSheetUID AND csx.lActive <> 0 AND csx.lDeleted = 0
OUTER APPLY (SELECT TOP 1 cLocation
				FROM [dbo].[CallSheetLog]
				WHERE CallSheetLog.nCallSheetUID = cs.[nCallSheetUID] AND CallSheetLog.lActive <> 0 AND CallSheetLog.lDeleted = 0
				ORDER BY tDate DESC) cslog
WHERE
	cs.lDeleted = 0	'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 3195 AND [cLocale] = ''DE'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''Protokolldateien wurden komprimiert und stehen im Download-Ordner bereit.'' _COLL_ AND [cKey] = N''DOWNLOAD_LOG_FILES_SUCCESS'')
	BEGIN
		PRINT ''Updating translation entry: 3195 - DE''
		UPDATE
			[dbo].[Translations]
		SET
			[cKey] = N''DOWNLOAD_LOG_FILES_SUCCESS'',
			[mValue] = N''Protokolldateien wurden komprimiert und stehen im Download-Ordner bereit.'',
			[lActive] = -1,
			[tUpdateTime] = ''20200702 22:48:55'',
			[tMobileTime] = ''20200702 22:48:55''
		WHERE
			[nLineNumber] = 3195 AND [cLocale] = ''DE''
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 3195 AND [cLocale] = ''RU'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''#RU# MET/TEAM log files have been archived and downloaded to your browser\''''s downloads folder.'' _COLL_ AND [cKey] = N''DOWNLOAD_LOG_FILES_SUCCESS'')
	BEGIN
		PRINT ''Updating translation entry: 3195 - RU''
		UPDATE
			[dbo].[Translations]
		SET
			[cKey] = N''DOWNLOAD_LOG_FILES_SUCCESS'',
			[mValue] = N''#RU# MET/TEAM log files have been archived and downloaded to your browser\''''s downloads folder.'',
			[lActive] = -1,
			[tUpdateTime] = ''20200702 22:48:55'',
			[tMobileTime] = ''20200702 22:48:55''
		WHERE
			[nLineNumber] = 3195 AND [cLocale] = ''RU''
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '74708249-AD07-46DE-A8AB-EC981F87671E' )
	BEGIN
		PRINT 'Adding translation entry: 74708249-AD07-46DE-A8AB-EC981F87671E'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('74708249-AD07-46DE-A8AB-EC981F87671E',3199,N'EN',N'FAILED_LOADING_CRYSTAL_REPORT_MSG',N'Failed to load Crystal Report. Report file was either not found or is not a valid report file.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200702 22:48:55','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200702 22:48:55','20200702 22:48:55',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'B611064D-5712-461C-ADC9-43D28FF393F6' )
	BEGIN
		PRINT 'Adding translation entry: B611064D-5712-461C-ADC9-43D28FF393F6'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('B611064D-5712-461C-ADC9-43D28FF393F6',3199,N'DE',N'FAILED_LOADING_CRYSTAL_REPORT_MSG',N'#DE# Failed to load Crystal Report. Report file was either not found or is not a valid report file.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200702 22:48:55','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200702 22:48:55','20200702 22:48:55',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '11CD3409-EFF1-4214-BAB1-981079B7A119' )
	BEGIN
		PRINT 'Adding translation entry: 11CD3409-EFF1-4214-BAB1-981079B7A119'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('11CD3409-EFF1-4214-BAB1-981079B7A119',3199,N'RU',N'FAILED_LOADING_CRYSTAL_REPORT_MSG',N'#RU# Failed to load Crystal Report. Report file was either not found or is not a valid report file.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200702 22:48:55','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200702 22:48:55','20200702 22:48:55',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'E788270F-F13D-490C-AD7D-38FBAB345DE5' )
	BEGIN
		PRINT 'Adding translation entry: E788270F-F13D-490C-AD7D-38FBAB345DE5'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('E788270F-F13D-490C-AD7D-38FBAB345DE5',3199,N'PT',N'FAILED_LOADING_CRYSTAL_REPORT_MSG',N'#PT# Failed to load Crystal Report. Report file was either not found or is not a valid report file.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200702 22:48:55','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200702 22:48:55','20200702 22:48:55',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '709C9643-42AE-45E6-A374-9FBA0B5A4AF9' )
	BEGIN
		PRINT 'Adding translation entry: 709C9643-42AE-45E6-A374-9FBA0B5A4AF9'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('709C9643-42AE-45E6-A374-9FBA0B5A4AF9',3199,N'ZH',N'FAILED_LOADING_CRYSTAL_REPORT_MSG',N'#ZH# Failed to load Crystal Report. Report file was either not found or is not a valid report file.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200702 22:48:55','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200702 22:48:55','20200702 22:48:55',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'B371425B-7761-4A50-92A6-12559BD5724C' )
	BEGIN
		PRINT 'Adding translation entry: B371425B-7761-4A50-92A6-12559BD5724C'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('B371425B-7761-4A50-92A6-12559BD5724C',3199,N'JA',N'FAILED_LOADING_CRYSTAL_REPORT_MSG',N'#JA# Failed to load Crystal Report. Report file was either not found or is not a valid report file.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200702 22:48:55','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200702 22:48:55','20200702 22:48:55',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'EEDF963E-CE41-4DB9-8484-08E2B06397B9' )
	BEGIN
		PRINT 'Adding translation entry: EEDF963E-CE41-4DB9-8484-08E2B06397B9'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('EEDF963E-CE41-4DB9-8484-08E2B06397B9',3199,N'FR',N'FAILED_LOADING_CRYSTAL_REPORT_MSG',N'#FR# Failed to load Crystal Report. Report file was either not found or is not a valid report file.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200702 22:48:55','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200702 22:48:55','20200702 22:48:55',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '8E6DCFCF-6A41-4B80-B04C-88170A695B04' )
	BEGIN
		PRINT 'Adding translation entry: 8E6DCFCF-6A41-4B80-B04C-88170A695B04'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('8E6DCFCF-6A41-4B80-B04C-88170A695B04',3199,N'ES',N'FAILED_LOADING_CRYSTAL_REPORT_MSG',N'#ES# Failed to load Crystal Report. Report file was either not found or is not a valid report file.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200702 22:48:55','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200702 22:48:55','20200702 22:48:55',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'D6F74EA2-4C31-4B8B-A294-547614D11424' )
	BEGIN
		PRINT 'Adding translation entry: D6F74EA2-4C31-4B8B-A294-547614D11424'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('D6F74EA2-4C31-4B8B-A294-547614D11424',3199,N'IT',N'FAILED_LOADING_CRYSTAL_REPORT_MSG',N'#IT# Failed to load Crystal Report. Report file was either not found or is not a valid report file.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200702 22:48:55','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200702 22:48:55','20200702 22:48:55',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 2186 AND [cLocale] = ''DE'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''Benutzungen'' _COLL_ AND [cKey] = N''Uses'')
	BEGIN
		PRINT ''Updating translation entry: 2186 - DE''
		UPDATE
			[dbo].[Translations]
		SET
			[cKey] = N''Uses'',
			[mValue] = N''Benutzungen'',
			[lActive] = -1,
			[tUpdateTime] = ''20200702 22:57:13'',
			[tMobileTime] = ''20200702 22:57:13''
		WHERE
			[nLineNumber] = 2186 AND [cLocale] = ''DE''
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 3199 AND [cLocale] = ''DE'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''Der Crystal Report konnte nicht geladen werden. Die Reportdatei ist beschädigt oder fehlt.'' _COLL_ AND [cKey] = N''FAILED_LOADING_CRYSTAL_REPORT_MSG'')
	BEGIN
		PRINT ''Updating translation entry: 3199 - DE''
		UPDATE
			[dbo].[Translations]
		SET
			[cKey] = N''FAILED_LOADING_CRYSTAL_REPORT_MSG'',
			[mValue] = N''Der Crystal Report konnte nicht geladen werden. Die Reportdatei ist beschädigt oder fehlt.'',
			[lActive] = -1,
			[tUpdateTime] = ''20200702 22:57:13'',
			[tMobileTime] = ''20200702 22:57:13''
		WHERE
			[nLineNumber] = 3199 AND [cLocale] = ''DE''
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END


	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 2297 AND [cLocale] = ''FR'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''Vos informations de demande d\''''enregistrement sont affichées ci-dessous. Vous devez envoyer ces informations à {0} pour obtenir une licence MET/TEAM.'' _COLL_ AND [cKey] = N''YOUR_REGISTRATION_REQUEST_INFORMATION_IS_DISPLAYED_BELOW_MSG'')
	BEGIN
		PRINT ''Updating translation entry: 2297 - FR''
		UPDATE
			[dbo].[Translations]
		SET
			[cKey] = N''YOUR_REGISTRATION_REQUEST_INFORMATION_IS_DISPLAYED_BELOW_MSG'',
			[mValue] = N''Vos informations de demande d\''''enregistrement sont affichées ci-dessous. Vous devez envoyer ces informations à {0} pour obtenir une licence MET/TEAM.'',
			[lActive] = -1,
			[tUpdateTime] = ''20200702 23:25:07'',
			[tMobileTime] = ''20200702 23:25:07''
		WHERE
			[nLineNumber] = 2297 AND [cLocale] = ''FR''
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[ManualTemplateRowTolerances]', 'U') IS NULL
	BEGIN
		PRINT N'Adding table [dbo].[ManualTemplateRowTolerances]'

		CREATE TABLE [dbo].[ManualTemplateRowTolerances](
			[nManualTemplateRowToleranceUID] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
			[nManualTemplateRowUID] [uniqueidentifier] NOT NULL,
			[nReadingErrorPercent] [float] NULL,
			[nFullScaleErrorPercent] [float] NULL,
			[nFloor] [float] NULL,
			[nInputMin] [float] NOT NULL,
			[nInputMax] [float] NOT NULL,
			[nOutputMin] [float] NULL,
			[nOutputMax] [float] NULL,
			[lIsTransducer] [int] NOT NULL,
			[lReadingErrorIsPpm] [int] NOT NULL,
			[lFullScaleErrorIsPpm] [int] NOT NULL,
			[lUseGreaterOfReadingFullScale] [int] NOT NULL,
			[lActive] [int] NOT NULL,
			[lDeleted] [int] NOT NULL,
			[lApproved] [int] NOT NULL,
			[lAdded] [int] NOT NULL,
			[nAddFacilityUID] [uniqueidentifier] NOT NULL,
			[nAddUserUID] [uniqueidentifier] NOT NULL,
			[tAddTime] [datetime] NOT NULL,
			[nUpdateFacilityUID] [uniqueidentifier] NOT NULL,
			[nUpdateUserUID] [uniqueidentifier] NOT NULL,
			[tUpdateTime] [datetime] NOT NULL,
			[tMobileTime] [datetime] NOT NULL,
			[tSystemUpdateTime] [datetime] NULL,
			[nImportUID] [uniqueidentifier] NULL,
		CONSTRAINT [PK_ManualTemplateRowTolerances] PRIMARY KEY NONCLUSTERED
		(
			[nManualTemplateRowToleranceUID] ASC
		)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
		) ON [PRIMARY]

		ALTER TABLE [dbo].[ManualTemplateRowTolerances] ADD CONSTRAINT [DF_ManualTemplateRowTolerances_lIsTransducer]  DEFAULT (0) FOR [lIsTransducer]

		ALTER TABLE [dbo].[ManualTemplateRowTolerances] ADD CONSTRAINT [DF_ManualTemplateRowTolerances_lReadingErrorIsPpm]  DEFAULT (0) FOR [lReadingErrorIsPpm]

		ALTER TABLE [dbo].[ManualTemplateRowTolerances] ADD CONSTRAINT [DF_ManualTemplateRowTolerances_lFullScaleErrorIsPpm]  DEFAULT (0) FOR [lFullScaleErrorIsPpm]

		ALTER TABLE [dbo].[ManualTemplateRowTolerances] ADD CONSTRAINT [DF_ManualTemplateRowTolerances_lUseGreaterOfReadingFullScale]  DEFAULT (0) FOR [lUseGreaterOfReadingFullScale]

		ALTER TABLE [dbo].[ManualTemplateRowTolerances] ADD CONSTRAINT [DF_ManualTemplateRowTolerances_lActive]  DEFAULT (-1) FOR [lActive]

		ALTER TABLE [dbo].[ManualTemplateRowTolerances] ADD CONSTRAINT [DF_ManualTemplateRowTolerances_lDeleted]  DEFAULT (0) FOR [lDeleted]

		ALTER TABLE [dbo].[ManualTemplateRowTolerances] ADD CONSTRAINT [DF_ManualTemplateRowTolerances_lApproved]  DEFAULT (0) FOR [lApproved]

		ALTER TABLE [dbo].[ManualTemplateRowTolerances] ADD CONSTRAINT [DF_ManualTemplateRowTolerances_lAdded]  DEFAULT (-1) FOR [lAdded]

		ALTER TABLE [dbo].[ManualTemplateRowTolerances] ADD CONSTRAINT [DF_ManualTemplateRowTolerances_nAddFacilityUID]  DEFAULT ('DBA97ADF-F868-459D-8343-DE1DF0FFB398') FOR [nAddFacilityUID]

		ALTER TABLE [dbo].[ManualTemplateRowTolerances] ADD CONSTRAINT [DF_ManualTemplateRowTolerances_nAddUserUID]  DEFAULT ('915F9722-3175-4E4D-A571-4A478E8E5172') FOR [nAddUserUID]

		ALTER TABLE [dbo].[ManualTemplateRowTolerances] ADD CONSTRAINT [DF_ManualTemplateRowTolerances_tAddTime]  DEFAULT (getutcdate()) FOR [tAddTime]

		ALTER TABLE [dbo].[ManualTemplateRowTolerances] ADD CONSTRAINT [DF_ManualTemplateRowTolerances_nUpdateFacilityUID]  DEFAULT ('DBA97ADF-F868-459D-8343-DE1DF0FFB398') FOR [nUpdateFacilityUID]

		ALTER TABLE [dbo].[ManualTemplateRowTolerances] ADD CONSTRAINT [DF_ManualTemplateRowTolerances_nUpdateUserUID]  DEFAULT ('915F9722-3175-4E4D-A571-4A478E8E5172') FOR [nUpdateUserUID]

		ALTER TABLE [dbo].[ManualTemplateRowTolerances] ADD CONSTRAINT [DF_ManualTemplateRowTolerances_tUpdateTime]  DEFAULT (getutcdate()) FOR [tUpdateTime]

		ALTER TABLE [dbo].[ManualTemplateRowTolerances] ADD CONSTRAINT [DF_ManualTemplateRowTolerances_tMobileTime]  DEFAULT (getutcdate()) FOR [tMobileTime]

		ALTER TABLE [dbo].[ManualTemplateRowTolerances] ADD CONSTRAINT [FK_ManualTemplateRowTolerances_ManualTemplateRows] FOREIGN KEY([nManualTemplateRowUID])
		REFERENCES [dbo].[ManualTemplateRows] ([nManualTemplateRowUID])


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=inactive; -1 or 1=active' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ManualTemplateRowTolerances', @level2type=N'COLUMN',@level2name=N'lActive'

		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=not deleted; -1 or 1=deleted' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ManualTemplateRowTolerances', @level2type=N'COLUMN',@level2name=N'lDeleted'

		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=not approved; -1 or 1=approved' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ManualTemplateRowTolerances', @level2type=N'COLUMN',@level2name=N'lApproved'

		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=not added; -1 or 1=added' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ManualTemplateRowTolerances', @level2type=N'COLUMN',@level2name=N'lAdded'

		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the server that added the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ManualTemplateRowTolerances', @level2type=N'COLUMN',@level2name=N'nAddFacilityUID'

		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the user that added the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ManualTemplateRowTolerances', @level2type=N'COLUMN',@level2name=N'nAddUserUID'

		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was added' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ManualTemplateRowTolerances', @level2type=N'COLUMN',@level2name=N'tAddTime'

		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the server that last updated the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ManualTemplateRowTolerances', @level2type=N'COLUMN',@level2name=N'nUpdateFacilityUID'

		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the last user to update the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ManualTemplateRowTolerances', @level2type=N'COLUMN',@level2name=N'nUpdateUserUID'

		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was last updated' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ManualTemplateRowTolerances', @level2type=N'COLUMN',@level2name=N'tUpdateTime'

		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was last updated for Mobile mode' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ManualTemplateRowTolerances', @level2type=N'COLUMN',@level2name=N'tMobileTime'

		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was last updated for the Warehouse' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ManualTemplateRowTolerances', @level2type=N'COLUMN',@level2name=N'tSystemUpdateTime'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END
IF OBJECT_ID(N'[dbo].[spl_ManualTemplateRowTolerances_RETRIEVE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_ManualTemplateRowTolerances_RETRIEVE]'
		DROP PROCEDURE [dbo].[spl_ManualTemplateRowTolerances_RETRIEVE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

IF OBJECT_ID(N'[dbo].[spl_ManualTemplateRowTolerances_RETRIEVE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_ManualTemplateRowTolerances_RETRIEVE]'

		EXEC sp_executesql N'		
/****************************************************************
	spl_ManualTemplateRowTolerances_RETRIEVE
	Retrieves a single record by ID from the ManualTemplateRowTolerances table
	(c) 2011-2020 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 9/15/2020 (R)
*****************************************************************/
	
CREATE PROCEDURE [dbo].[spl_ManualTemplateRowTolerances_RETRIEVE]
	
@nManualTemplateRowToleranceUID uniqueidentifier


AS
BEGIN

	SELECT
[nManualTemplateRowToleranceUID]
		,[nManualTemplateRowUID]
		,[nReadingErrorPercent]
		,[nFullScaleErrorPercent]
		,[nFloor]
		,[nInputMin]
		,[nInputMax]
		,[nOutputMin]
		,[nOutputMax]
		,[lIsTransducer]
		,[lReadingErrorIsPpm]
		,[lFullScaleErrorIsPpm]
		,[lUseGreaterOfReadingFullScale]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
		,[nImportUID]

	FROM
		[dbo].[ManualTemplateRowTolerances]
	WHERE
[nManualTemplateRowToleranceUID] = @nManualTemplateRowToleranceUID

	
	RETURN
		
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	
IF OBJECT_ID(N'[dbo].[spl_ManualTemplateRowTolerances_LIST]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_ManualTemplateRowTolerances_LIST]'
		DROP PROCEDURE [dbo].[spl_ManualTemplateRowTolerances_LIST]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

IF OBJECT_ID(N'[dbo].[spl_ManualTemplateRowTolerances_LIST]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_ManualTemplateRowTolerances_LIST]'

		EXEC sp_executesql N'		
/****************************************************************
	spl_ManualTemplateRowTolerances_LIST
	Retrieves all records from the ManualTemplateRowTolerances table
	Optionally includes inactive records
	(c) 2011-2020 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 9/15/2020 (L)
*****************************************************************/
	
CREATE PROCEDURE [dbo].[spl_ManualTemplateRowTolerances_LIST]
	
@includeInactive	INT	= 0

AS
BEGIN

	SELECT
[nManualTemplateRowToleranceUID]
		,[nManualTemplateRowUID]
		,[nReadingErrorPercent]
		,[nFullScaleErrorPercent]
		,[nFloor]
		,[nInputMin]
		,[nInputMax]
		,[nOutputMin]
		,[nOutputMax]
		,[lIsTransducer]
		,[lReadingErrorIsPpm]
		,[lFullScaleErrorIsPpm]
		,[lUseGreaterOfReadingFullScale]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
		,[nImportUID]

	FROM
		[dbo].[ManualTemplateRowTolerances]
	WHERE
		ABS(lActive) + @includeInactive > 0
		AND
		lDeleted = 0
	
	RETURN
		
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

IF OBJECT_ID(N'[dbo].[spl_ManualTemplateRowTolerances_INSERT]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_ManualTemplateRowTolerances_INSERT]'
		DROP PROCEDURE [dbo].[spl_ManualTemplateRowTolerances_INSERT]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

IF OBJECT_ID(N'[dbo].[spl_ManualTemplateRowTolerances_INSERT]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_ManualTemplateRowTolerances_INSERT]'
		
		EXEC sp_executesql N'	
/****************************************************************
	spl_ManualTemplateRowTolerances_INSERT
	Inserts a new record into the ManualTemplateRowTolerances table
	(c) 2011-2020 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 9/15/2020 (I)
*****************************************************************/
	
CREATE PROCEDURE [dbo].[spl_ManualTemplateRowTolerances_INSERT]
	
@nManualTemplateRowUID uniqueidentifier 
	,@nReadingErrorPercent float  = NULL 
	,@nFullScaleErrorPercent float  = NULL 
	,@nFloor float  = NULL 
	,@nInputMin float 
	,@nInputMax float 
	,@nOutputMin float  = NULL 
	,@nOutputMax float  = NULL 
	,@lIsTransducer int  = 0 
	,@lReadingErrorIsPpm int  = 0 
	,@lFullScaleErrorIsPpm int  = 0 
	,@lUseGreaterOfReadingFullScale int  = 0 
	,@lActive int  = -1 
	,@lDeleted int  = 0 
	,@lApproved int  = 0 
	,@lAdded int  = -1 
	,@nAddFacilityUID uniqueidentifier  = ''DBA97ADF-F868-459D-8343-DE1DF0FFB398'' 
	,@nAddUserUID uniqueidentifier  = ''915F9722-3175-4E4D-A571-4A478E8E5172'' 
	,@nImportUID uniqueidentifier  = NULL 

	,@nManualTemplateRowToleranceUID [uniqueidentifier] = NULL OUTPUT

AS
BEGIN

	DECLARE @ID [uniqueidentifier] = NEWID()

	INSERT INTO [dbo].[ManualTemplateRowTolerances] (
		[nManualTemplateRowToleranceUID]
,[nManualTemplateRowUID]
		,[nReadingErrorPercent]
		,[nFullScaleErrorPercent]
		,[nFloor]
		,[nInputMin]
		,[nInputMax]
		,[nOutputMin]
		,[nOutputMax]
		,[lIsTransducer]
		,[lReadingErrorIsPpm]
		,[lFullScaleErrorIsPpm]
		,[lUseGreaterOfReadingFullScale]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]

		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@ID
,@nManualTemplateRowUID
		,@nReadingErrorPercent
		,@nFullScaleErrorPercent
		,@nFloor
		,@nInputMin
		,@nInputMax
		,@nOutputMin
		,@nOutputMax
		,@lIsTransducer
		,@lReadingErrorIsPpm
		,@lFullScaleErrorIsPpm
		,@lUseGreaterOfReadingFullScale
		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@nImportUID

		,GetUTCDate()
		,@nAddUserUID
		,@nAddFacilityUID
		,GetUTCDate()
		,GetUTCDate()
	)

	-- Return the new GUID for the UID of this record to the caller
	SET @nManualTemplateRowToleranceUID = @ID

	-- Avoids warning in VS2010
	RETURN 1
		
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	
IF OBJECT_ID(N'[dbo].[spl_ManualTemplateRowTolerances_DELETE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_ManualTemplateRowTolerances_DELETE]'
		DROP PROCEDURE [dbo].[spl_ManualTemplateRowTolerances_DELETE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

IF OBJECT_ID(N'[dbo].[spl_ManualTemplateRowTolerances_DELETE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_ManualTemplateRowTolerances_DELETE]'

		EXEC sp_executesql N'	
/****************************************************************
	spl_ManualTemplateRowTolerances_DELETE
	Deletes a single record by ID from the ManualTemplateRowTolerances table
	(c) 2011-2020 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 9/15/2020 (D)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_ManualTemplateRowTolerances_DELETE]

	@nManualTemplateRowToleranceUID uniqueidentifier,
	@nUpdateUserUID 		[uniqueidentifier],
	@nUpdateFacilityUID		[uniqueidentifier],
	@retMsg					tinyint OUTPUT
	
AS
BEGIN

	DECLARE @recordID nvarchar(50)
	DECLARE @userID nvarchar(50)
	DECLARE @facilityUID nvarchar(50)
	DECLARE @now nvarchar(50)

	SELECT
		@recordID = CONVERT( nvarchar(50), @nManualTemplateRowToleranceUID ),
		@now = CONVERT( nvarchar(50), GetUTCDate() ),
		@userID = CONVERT( nvarchar(50), @nUpdateUserUID ),
		@facilityUID = CONVERT( nvarchar(50), @nUpdateFacilityUID ) 

	EXEC sp_CheckAndDelete
		1,							-- MarkDeleted
		''ManualTemplateRowTolerances'',		-- TableName
		@recordID,					-- PrimaryKeyValue
		1,							-- IsPrimaryKeyString
		'''',	-- TableExceptions
		1,							-- ExceptDeletions
		@facilityUID,				-- FacilityUID
		@userID,					-- UpdateUserUID
		@now,						-- UpdateTime
		@retMsg OUTPUT
	
	RETURN @retMsg
		
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END



IF OBJECT_ID(N'[dbo].[spl_ManualTemplateRowTolerances_UPDATE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_ManualTemplateRowTolerances_UPDATE]'
		DROP PROCEDURE [dbo].[spl_ManualTemplateRowTolerances_UPDATE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

IF OBJECT_ID(N'[dbo].[spl_ManualTemplateRowTolerances_UPDATE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_ManualTemplateRowTolerances_UPDATE]'

		EXEC sp_executesql N'		
/****************************************************************
	spl_ManualTemplateRowTolerances_UPDATE
	Updates a single record by ID in the ManualTemplateRowTolerances table
	(c) 2011-2020 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 9/15/2020 (U)
*****************************************************************/
	
CREATE PROCEDURE [dbo].[spl_ManualTemplateRowTolerances_UPDATE]
	
@nManualTemplateRowToleranceUID uniqueidentifier
	,@nManualTemplateRowUID uniqueidentifier
	,@nReadingErrorPercent float
	,@nFullScaleErrorPercent float
	,@nFloor float
	,@nInputMin float
	,@nInputMax float
	,@nOutputMin float
	,@nOutputMax float
	,@lIsTransducer int
	,@lReadingErrorIsPpm int
	,@lFullScaleErrorIsPpm int
	,@lUseGreaterOfReadingFullScale int
	,@lActive int
	,@lDeleted int
	,@lApproved int
	,@lAdded int
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@nImportUID uniqueidentifier


AS
BEGIN
	DECLARE @DateNow datetime = GetUTCDate();

	UPDATE [dbo].[ManualTemplateRowTolerances]
	SET
[nManualTemplateRowUID] = @nManualTemplateRowUID
		,[nReadingErrorPercent] = @nReadingErrorPercent
		,[nFullScaleErrorPercent] = @nFullScaleErrorPercent
		,[nFloor] = @nFloor
		,[nInputMin] = @nInputMin
		,[nInputMax] = @nInputMax
		,[nOutputMin] = @nOutputMin
		,[nOutputMax] = @nOutputMax
		,[lIsTransducer] = @lIsTransducer
		,[lReadingErrorIsPpm] = @lReadingErrorIsPpm
		,[lFullScaleErrorIsPpm] = @lFullScaleErrorIsPpm
		,[lUseGreaterOfReadingFullScale] = @lUseGreaterOfReadingFullScale
		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[nImportUID] = @nImportUID

		,[tUpdateTime] = @DateNow
		,[tMobileTime] = @DateNow
	WHERE
[nManualTemplateRowToleranceUID] = @nManualTemplateRowToleranceUID

	
	RETURN
		
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-- MTM-72
	IF (SELECT nUCIDataUID FROM [dbo].[ContextElements] WHERE nContextElementUID = '3BD41927-F687-44A9-BB2D-695115DAAB85') IS NULL
	BEGIN
		PRINT N'Updating Context Element for cAssignedLocation'
		UPDATE [dbo].[ContextElements] SET [nUCIDataUID] = '94719147-D567-4738-9A92-491B562C2392' WHERE nContextElementUID = '3BD41927-F687-44A9-BB2D-695115DAAB85'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF (SELECT nUCIDataUID FROM [dbo].[ContextElements] WHERE nContextElementUID = '9A9FA49D-2E90-4A73-A11E-03CFE9A17EAA') IS NULL
	BEGIN
		PRINT N'Updating Context Element for tReturnDate'
		UPDATE [dbo].[ContextElements] SET [nUCIDataUID] = '93E0003B-32B0-496C-93B1-08B290829A87' WHERE nContextElementUID = '9A9FA49D-2E90-4A73-A11E-03CFE9A17EAA'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF (SELECT nUCIDataUID FROM [dbo].[ContextElements] WHERE nContextElementUID = 'B75BC82E-0164-4EC0-90F3-8137F1AE5101') IS NULL
	BEGIN
		PRINT N'Updating Context Element for tExpectedReturnDate'
		UPDATE [dbo].[ContextElements] SET [nUCIDataUID] = '5A38C6A3-0B53-49C4-9C18-C84D4F0FBA32' WHERE nContextElementUID = 'B75BC82E-0164-4EC0-90F3-8137F1AE5101'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF (SELECT nUCIDataUID FROM [dbo].[ContextElements] WHERE nContextElementUID = '9059041C-7164-4E27-B189-02FEE3EADCD4') IS NULL
	BEGIN
		PRINT N'Updating Context Element for tLoanDate'
		UPDATE [dbo].[ContextElements] SET [nUCIDataUID] = 'E581699E-AB58-4856-A799-CC7A4C75D1AA' WHERE nContextElementUID = '9059041C-7164-4E27-B189-02FEE3EADCD4'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END



	-- MTM-555

	-- FillgrdAssetServices
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3EEDB767-1886-4936-910C-EB8A235D9C1B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3EEDB767-1886-4936-910C-EB8A235D9C1B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5505D6EC-DFC7-41C7-BE83-94A367D3B2A8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5505D6EC-DFC7-41C7-BE83-94A367D3B2A8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C411E777-89A5-4259-AA4C-B7D438E83A8F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C411E777-89A5-4259-AA4C-B7D438E83A8F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '11EF99C2-2BCF-4866-8F55-7BE24F618532' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '11EF99C2-2BCF-4866-8F55-7BE24F618532' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7E9CC5FD-C336-4D67-94DE-9AA61A9C1AAE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7E9CC5FD-C336-4D67-94DE-9AA61A9C1AAE' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2FA9D141-077C-4D8A-9CB8-88369FB4EB75' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2FA9D141-077C-4D8A-9CB8-88369FB4EB75' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdHistory
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7D702B34-3F5E-42CD-A024-A6A80C11972A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7D702B34-3F5E-42CD-A024-A6A80C11972A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '69AE3D6B-1D72-4FD9-B604-2794EA8EB441' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '69AE3D6B-1D72-4FD9-B604-2794EA8EB441' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0EBA3D6F-2707-4C15-A00A-5C09F35D53B3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0EBA3D6F-2707-4C15-A00A-5C09F35D53B3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '595308C8-11F4-425E-88D0-23F546A50DCB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '595308C8-11F4-425E-88D0-23F546A50DCB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'DD4F7781-3184-4271-A99B-CE7998495DB8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'DD4F7781-3184-4271-A99B-CE7998495DB8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '01488AA7-DF25-402C-8A38-E0B0CAD47C71' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '01488AA7-DF25-402C-8A38-E0B0CAD47C71' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1614CEDE-1324-44B7-B9FE-29616D0187FB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1614CEDE-1324-44B7-B9FE-29616D0187FB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5D23596D-DABB-4F18-9798-F9A37473611C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5D23596D-DABB-4F18-9798-F9A37473611C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1A1159D7-42FA-48E4-8532-99BEDE803561' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1A1159D7-42FA-48E4-8532-99BEDE803561' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdAssetFiles
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'DBBD6826-82FA-4A9F-ABE4-DC3AAC3B9CB7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'DBBD6826-82FA-4A9F-ABE4-DC3AAC3B9CB7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9636EB50-686D-49F2-B8A1-092F5BCDF012' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9636EB50-686D-49F2-B8A1-092F5BCDF012' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E7E44076-91CA-483C-A1D6-5369F9581808' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E7E44076-91CA-483C-A1D6-5369F9581808' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5EF2D39B-CB3F-44FE-B7CA-67B490328BA2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5EF2D39B-CB3F-44FE-B7CA-67B490328BA2' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdLogNotes
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9940B5D2-6772-4F19-89F7-9893016D8910' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9940B5D2-6772-4F19-89F7-9893016D8910' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '87469297-B118-473A-8DAF-D24A19FE398F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '87469297-B118-473A-8DAF-D24A19FE398F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D845C6E4-DEF5-4738-A25B-CEE05B91F493' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D845C6E4-DEF5-4738-A25B-CEE05B91F493' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2E9D3FB9-2C8B-430C-8AAC-7B514BC49721' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2E9D3FB9-2C8B-430C-8AAC-7B514BC49721' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '80745387-238F-413D-ADCB-9B6802C12A30' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '80745387-238F-413D-ADCB-9B6802C12A30' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4DD7BF40-8884-44B8-B253-33C67252FE35' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4DD7BF40-8884-44B8-B253-33C67252FE35' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F7EA8621-1A2B-41B6-9846-5148A2D6D4B1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F7EA8621-1A2B-41B6-9846-5148A2D6D4B1' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdHours
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9D4C0756-7D22-414B-8105-E432C6E28214' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9D4C0756-7D22-414B-8105-E432C6E28214' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7CE3C3BF-C207-4631-B1E6-937AB6A321CE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7CE3C3BF-C207-4631-B1E6-937AB6A321CE' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9D828A1B-1BE4-4B3D-9A96-8E10E315C6EF' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9D828A1B-1BE4-4B3D-9A96-8E10E315C6EF' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9E5F833A-3FE5-4C6F-A38A-BA30E08B788E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9E5F833A-3FE5-4C6F-A38A-BA30E08B788E' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdCSFiles
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '592057AE-D263-40AB-B6DF-08B56CB43539' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '592057AE-D263-40AB-B6DF-08B56CB43539' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BE799C0C-43C9-4267-B9A4-D2A5603D4687' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BE799C0C-43C9-4267-B9A4-D2A5603D4687' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '06614CF3-7E39-4A9F-9FCF-7FBCBA6DEF14' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '06614CF3-7E39-4A9F-9FCF-7FBCBA6DEF14' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'DF454DEF-C8B9-48EE-8791-3E3A7DE897C4' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'DF454DEF-C8B9-48EE-8791-3E3A7DE897C4' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8BFDC9C7-F474-4566-B574-72C1BD4AA939' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8BFDC9C7-F474-4566-B574-72C1BD4AA939' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AB8B4C9C-C045-45CA-B50D-6D1222CB71D0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AB8B4C9C-C045-45CA-B50D-6D1222CB71D0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E4854BEF-FA1B-494B-AD87-27A9E7403CD4' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E4854BEF-FA1B-494B-AD87-27A9E7403CD4' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8E5D4D47-5378-47B2-B118-F2D2C17F146A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8E5D4D47-5378-47B2-B118-F2D2C17F146A' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdStandards
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '49D3EEE6-1F00-4BE5-BCAB-6CFFC4DEDA85' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '49D3EEE6-1F00-4BE5-BCAB-6CFFC4DEDA85' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BBF70FF1-D519-4322-AFDA-D74B55C3BF6B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BBF70FF1-D519-4322-AFDA-D74B55C3BF6B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '914AD67D-DCE0-4A52-A5B9-45197E29541D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '914AD67D-DCE0-4A52-A5B9-45197E29541D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A6AC1A11-BA8E-4E4B-844F-43293D438AB7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A6AC1A11-BA8E-4E4B-844F-43293D438AB7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '80D35CEE-B2A4-4125-A31E-223B80C7D0BB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '80D35CEE-B2A4-4125-A31E-223B80C7D0BB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '787E218F-1192-4989-9475-0598191E5201' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '787E218F-1192-4989-9475-0598191E5201' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '12419FC8-42D9-4D6B-97C3-A51F3268AE87' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '12419FC8-42D9-4D6B-97C3-A51F3268AE87' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '89280B6B-3B70-43D7-8BA8-AACACFB44707' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '89280B6B-3B70-43D7-8BA8-AACACFB44707' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'DFB49FF7-8A37-495D-95AA-F2895875304E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'DFB49FF7-8A37-495D-95AA-F2895875304E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9132F8C3-29BE-4345-A461-FD995554E752' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9132F8C3-29BE-4345-A461-FD995554E752' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdNist
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '745A1238-B715-4598-90C8-7C77D4558AE8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '745A1238-B715-4598-90C8-7C77D4558AE8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '90756586-A506-45B0-9A6F-0318AFF14E4A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '90756586-A506-45B0-9A6F-0318AFF14E4A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '303F975F-47F8-4BB5-8D1A-C7FB133E2511' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '303F975F-47F8-4BB5-8D1A-C7FB133E2511' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'DA892C35-9DC8-4A8F-85C7-39CE945DCD8E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'DA892C35-9DC8-4A8F-85C7-39CE945DCD8E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3BCCD156-5CBD-4BBD-BD33-C059BD6835C2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3BCCD156-5CBD-4BBD-BD33-C059BD6835C2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '716440B8-EE31-40B5-A1B9-230800D54639' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '716440B8-EE31-40B5-A1B9-230800D54639' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AAA0F7DE-82CD-4F57-827E-6A71D6DF1EDF' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AAA0F7DE-82CD-4F57-827E-6A71D6DF1EDF' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '534D63F5-52CC-490D-965D-A498CE40986D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '534D63F5-52CC-490D-965D-A498CE40986D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '59E30F36-EAC9-4431-8EEC-2FB5582A133F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '59E30F36-EAC9-4431-8EEC-2FB5582A133F' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdParts
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E7C0E668-F2CB-4CA7-9482-F9A99B5F51A0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E7C0E668-F2CB-4CA7-9482-F9A99B5F51A0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '667317A6-624F-4AEB-A2AC-844622EDC281' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '667317A6-624F-4AEB-A2AC-844622EDC281' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F22A650A-007A-4A5A-9EC8-5C121D657428' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F22A650A-007A-4A5A-9EC8-5C121D657428' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BAF46F29-F43E-4D22-BE7C-310E0931C6D0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BAF46F29-F43E-4D22-BE7C-310E0931C6D0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1860442C-BDD2-417E-8805-D52DA126C31E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1860442C-BDD2-417E-8805-D52DA126C31E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4B3D396B-A3F3-4172-A101-4FD6004D0AC2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4B3D396B-A3F3-4172-A101-4FD6004D0AC2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CAF164C2-B10C-43EB-B675-F448A12CE256' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CAF164C2-B10C-43EB-B675-F448A12CE256' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '21B2A42C-734E-42AD-920D-C75419CC76BE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '21B2A42C-734E-42AD-920D-C75419CC76BE' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '597E6AB2-B7B9-4930-94E9-0F6511323B1F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '597E6AB2-B7B9-4930-94E9-0F6511323B1F' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdCallSheetResults
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '61CFB857-5406-4104-BD8F-FC8573A3E469' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '61CFB857-5406-4104-BD8F-FC8573A3E469' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '635EDE58-DE8B-4A77-8614-0FD10BA8ECCE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '635EDE58-DE8B-4A77-8614-0FD10BA8ECCE' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AE0D28C1-7CB0-4C42-AA93-F1BEAA461262' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AE0D28C1-7CB0-4C42-AA93-F1BEAA461262' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E8F3B11E-42EA-4BEC-848D-23FDF305945D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E8F3B11E-42EA-4BEC-848D-23FDF305945D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2F9F1ECF-6080-4952-A53E-BFAC472906BC' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2F9F1ECF-6080-4952-A53E-BFAC472906BC' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '76C8B1CD-B9D2-43AE-BF21-13F5B9CA6449' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '76C8B1CD-B9D2-43AE-BF21-13F5B9CA6449' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7C426AD9-E9C7-406C-84BA-56CFC064DA3A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7C426AD9-E9C7-406C-84BA-56CFC064DA3A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C6646F0A-3D37-4809-9F13-3E3AA6139B6B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C6646F0A-3D37-4809-9F13-3E3AA6139B6B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '101154F5-9BD0-4002-829C-E39E330B74B7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '101154F5-9BD0-4002-829C-E39E330B74B7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '730AF1DF-123A-4872-A6BC-412DD41B07E8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '730AF1DF-123A-4872-A6BC-412DD41B07E8' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- GetMETCAL_Results_MCRT
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '518A2044-D670-4E4D-BFED-3D5B02B7A499' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '518A2044-D670-4E4D-BFED-3D5B02B7A499' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F09E0318-87A1-4075-99CB-18F7E5117DA5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F09E0318-87A1-4075-99CB-18F7E5117DA5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '17D9A176-99F4-423C-A9B0-AE4093287492' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '17D9A176-99F4-423C-A9B0-AE4093287492' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '69E79E50-465A-4447-BB38-E56F005952A8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '69E79E50-465A-4447-BB38-E56F005952A8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '483FFE79-1522-43BD-963B-A5BFF2073251' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '483FFE79-1522-43BD-963B-A5BFF2073251' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6237F31E-776E-4254-9FB3-7C155F1AC7AA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6237F31E-776E-4254-9FB3-7C155F1AC7AA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AECB4CC3-79CA-4684-9655-61CE908CEDBF' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AECB4CC3-79CA-4684-9655-61CE908CEDBF' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A89F035C-D1C7-45F0-93A1-5456C377BB99' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A89F035C-D1C7-45F0-93A1-5456C377BB99' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F9F7A96E-2750-40DE-B63F-D23E5A30FFF8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F9F7A96E-2750-40DE-B63F-D23E5A30FFF8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '75F3D2F4-B4DC-4D65-B8A9-DB5B0A63A29A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '75F3D2F4-B4DC-4D65-B8A9-DB5B0A63A29A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C9377B94-EED8-402F-A0DD-84596EC5F259' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C9377B94-EED8-402F-A0DD-84596EC5F259' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- GetMETCAL_Results_Classic
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1EDEA22B-3881-4493-BC31-3A9FE90A3531' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1EDEA22B-3881-4493-BC31-3A9FE90A3531' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '06EBA131-C443-4C16-886F-CA7A99C663D2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '06EBA131-C443-4C16-886F-CA7A99C663D2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '77FF3172-822B-441B-87AC-E2073CE0C6B1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '77FF3172-822B-441B-87AC-E2073CE0C6B1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '69D52158-9A61-46B3-80C1-9B3E3D84D251' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '69D52158-9A61-46B3-80C1-9B3E3D84D251' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A49152D4-645D-43E3-BCBC-3D5BA34BE5A0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A49152D4-645D-43E3-BCBC-3D5BA34BE5A0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B2FBE2FA-BD62-474D-9400-D48DEE418310' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B2FBE2FA-BD62-474D-9400-D48DEE418310' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CA1A8136-6C80-4BC2-BF49-A2C7E0401380' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CA1A8136-6C80-4BC2-BF49-A2C7E0401380' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2AA2A7F1-B7B9-4A51-A25A-623D57951C3A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2AA2A7F1-B7B9-4A51-A25A-623D57951C3A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D671A92B-3D59-411F-98C0-0AD472BE78F0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D671A92B-3D59-411F-98C0-0AD472BE78F0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7B1D7B0E-C9A8-4F5F-89D2-9B2CA9D86A08' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7B1D7B0E-C9A8-4F5F-89D2-9B2CA9D86A08' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'FCA05CBF-4D2D-475F-A525-FD9829769966' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'FCA05CBF-4D2D-475F-A525-FD9829769966' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4D4DEDA5-39EB-4037-8618-C355B66832A4' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4D4DEDA5-39EB-4037-8618-C355B66832A4' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2F63CD61-2030-450A-AA3C-DD0685AB1D9A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2F63CD61-2030-450A-AA3C-DD0685AB1D9A' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- GetMETCAL_Results_MeasUncert
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '806CFB63-5FDD-47B2-94C1-72ABA9A29D45' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '806CFB63-5FDD-47B2-94C1-72ABA9A29D45' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B1B92A68-7918-488A-8EE2-F85C2BCC3E2C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B1B92A68-7918-488A-8EE2-F85C2BCC3E2C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '38887811-5A42-41DF-BE4E-5B6E7CADC153' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '38887811-5A42-41DF-BE4E-5B6E7CADC153' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '04488FA7-3483-43CF-9EA2-D08AEEEB0F6D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '04488FA7-3483-43CF-9EA2-D08AEEEB0F6D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5AF10345-A44F-4A9E-A1D6-3DC5687EFA74' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5AF10345-A44F-4A9E-A1D6-3DC5687EFA74' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2C178BB8-AFC3-4959-B0B9-5A01EADD6BAA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2C178BB8-AFC3-4959-B0B9-5A01EADD6BAA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'DBE7ABA8-C40C-4ED2-89AF-AE62803052B7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'DBE7ABA8-C40C-4ED2-89AF-AE62803052B7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E4FFA733-B157-49ED-91C7-6653A5D792C5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E4FFA733-B157-49ED-91C7-6653A5D792C5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AE3534E9-A4C8-4FB2-A3CB-0481B3DA8E6C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AE3534E9-A4C8-4FB2-A3CB-0481B3DA8E6C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '96F5E888-A359-4350-8F12-2C9FE630F4E6' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '96F5E888-A359-4350-8F12-2C9FE630F4E6' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- GetMETCAL_Results_ProcedureSteps
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '03D708EE-DF12-493D-A053-E2BF76A53DBA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '03D708EE-DF12-493D-A053-E2BF76A53DBA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F493632C-531E-403F-8C0D-D5D42EDB8C0D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F493632C-531E-403F-8C0D-D5D42EDB8C0D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4733466C-9AC2-4284-90BD-E7DFFD747135' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4733466C-9AC2-4284-90BD-E7DFFD747135' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'FA243CAC-B044-4B8A-B3A8-42A2CADD076D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'FA243CAC-B044-4B8A-B3A8-42A2CADD076D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3E9A1D0A-C6EC-4C08-BEA3-35F4D2633624' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3E9A1D0A-C6EC-4C08-BEA3-35F4D2633624' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A44CC67E-41E0-4A6B-BCC7-DAD1366E1D4A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A44CC67E-41E0-4A6B-BCC7-DAD1366E1D4A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0AE56B85-CB66-4A6F-AF8E-9D7C57E56775' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0AE56B85-CB66-4A6F-AF8E-9D7C57E56775' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '87300B38-36A6-49E9-818A-0F6EC33E7133' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '87300B38-36A6-49E9-818A-0F6EC33E7133' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4D2332D3-83C6-40A9-9119-1FE44DB9DDEA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4D2332D3-83C6-40A9-9119-1FE44DB9DDEA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'EB551782-60B8-4626-A976-6DD8AE10223D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'EB551782-60B8-4626-A976-6DD8AE10223D' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- GetCOMPASS_Results
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '00AF5FA7-8FC3-4F71-8233-C4A46CCCE3EB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '00AF5FA7-8FC3-4F71-8233-C4A46CCCE3EB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C621944E-E1DF-4F22-83DE-B06DF8365E4D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C621944E-E1DF-4F22-83DE-B06DF8365E4D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '67F63A9A-819E-4158-AC36-EBFCB25804C7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '67F63A9A-819E-4158-AC36-EBFCB25804C7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'DE5D8D79-C819-4217-AE8D-97204AFB595A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'DE5D8D79-C819-4217-AE8D-97204AFB595A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '22F2F2FC-3F82-421E-872A-E1612C6C2E79' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '22F2F2FC-3F82-421E-872A-E1612C6C2E79' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '779C96F9-9892-44C4-819A-600D31259F19' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '779C96F9-9892-44C4-819A-600D31259F19' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4FB9354D-C182-4BF5-AC07-616EBBB115A1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4FB9354D-C182-4BF5-AC07-616EBBB115A1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '64ED9987-7BBE-40BC-B151-96860601D3C9' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '64ED9987-7BBE-40BC-B151-96860601D3C9' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CB3FFFF9-EC32-4689-BA27-DE19CE834711' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CB3FFFF9-EC32-4689-BA27-DE19CE834711' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'DF305EEB-5EA7-4C57-A18F-A0C40AEA56BE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'DF305EEB-5EA7-4C57-A18F-A0C40AEA56BE' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '498DFB37-346C-4DBF-BD27-DA1727517318' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '498DFB37-346C-4DBF-BD27-DA1727517318' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E325FB72-0620-40EF-92B4-886301EBFC34' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E325FB72-0620-40EF-92B4-886301EBFC34' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '67750DB9-3EEE-49AB-9474-FE5F1C0FBA5D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '67750DB9-3EEE-49AB-9474-FE5F1C0FBA5D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F19587C2-4211-4DD0-BE74-797944B1A024' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F19587C2-4211-4DD0-BE74-797944B1A024' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1EE91F94-B79A-49CA-B9FC-14FF52DDF763' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1EE91F94-B79A-49CA-B9FC-14FF52DDF763' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '32E0E058-5E57-4D52-9266-F3F214895351' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '32E0E058-5E57-4D52-9266-F3F214895351' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2EE6973B-3196-4A1D-94F4-10C234210E6D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2EE6973B-3196-4A1D-94F4-10C234210E6D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '08A92409-4617-49E6-91EA-4FDA7B54BA73' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '08A92409-4617-49E6-91EA-4FDA7B54BA73' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '09B5DFB2-8E91-4B9E-98CB-185704B38F57' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '09B5DFB2-8E91-4B9E-98CB-185704B38F57' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BD650876-B634-4DC7-85A9-F3C83F2D3BC7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BD650876-B634-4DC7-85A9-F3C83F2D3BC7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '163483BF-EB51-48CC-8104-1C7ABBFD72C7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '163483BF-EB51-48CC-8104-1C7ABBFD72C7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'FD1AAF63-42DB-4579-8553-78DF6AA4EF0D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'FD1AAF63-42DB-4579-8553-78DF6AA4EF0D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2B4C18F1-3470-42EA-9FB6-7B15AD3D6EC1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2B4C18F1-3470-42EA-9FB6-7B15AD3D6EC1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '016FCB8F-7932-4616-8E99-3D6ADCA41488' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '016FCB8F-7932-4616-8E99-3D6ADCA41488' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CFB314AB-5678-40C5-B9E7-DF853BAFBFE5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CFB314AB-5678-40C5-B9E7-DF853BAFBFE5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4E853F78-25DC-4A65-B69C-1D7AF8812353' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4E853F78-25DC-4A65-B69C-1D7AF8812353' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C8C03EA5-6735-4393-8810-59D331732F36' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C8C03EA5-6735-4393-8810-59D331732F36' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A6847788-4F3C-4C59-BA89-93458547D0AB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A6847788-4F3C-4C59-BA89-93458547D0AB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '24E56F52-8111-478C-BCB2-334A12BBF4BB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '24E56F52-8111-478C-BCB2-334A12BBF4BB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2E37C143-ABF3-43CD-BE90-890A5B09329B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2E37C143-ABF3-43CD-BE90-890A5B09329B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E5D0BC7B-49E5-4F79-83E3-09D8C431BE3F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E5D0BC7B-49E5-4F79-83E3-09D8C431BE3F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5F70FD5B-59AE-4137-BF4A-3CD7EB1AA968' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5F70FD5B-59AE-4137-BF4A-3CD7EB1AA968' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5471DC65-471D-4C46-872B-621AAA369191' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5471DC65-471D-4C46-872B-621AAA369191' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E660D57A-018F-44DC-806A-9A07C8D8AE32' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E660D57A-018F-44DC-806A-9A07C8D8AE32' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3FE0F721-A27D-407F-A24D-B888B6071B6A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3FE0F721-A27D-407F-A24D-B888B6071B6A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '21FBF14C-8AFA-4BAD-9368-595A52BD5FA1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '21FBF14C-8AFA-4BAD-9368-595A52BD5FA1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7F17B24D-C64F-4F59-BDAF-6A7E33665547' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7F17B24D-C64F-4F59-BDAF-6A7E33665547' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1C4DCF9A-7720-4F86-A860-9A0CFA050CA3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1C4DCF9A-7720-4F86-A860-9A0CFA050CA3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '85B08B5E-099A-4CEE-AFEC-F5BC732F6FBE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '85B08B5E-099A-4CEE-AFEC-F5BC732F6FBE' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E4CC6C5E-A707-48D6-B9F9-373FCDCA2473' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E4CC6C5E-A707-48D6-B9F9-373FCDCA2473' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CA9D1B63-8825-40EB-A3B1-A7C802EDB429' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CA9D1B63-8825-40EB-A3B1-A7C802EDB429' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '22D6DB54-56DB-4C93-B8D1-AE8D26508859' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '22D6DB54-56DB-4C93-B8D1-AE8D26508859' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D4241D90-7A44-4D78-8F04-4236B5CFCAE1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D4241D90-7A44-4D78-8F04-4236B5CFCAE1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '343E5E99-AC3E-4F38-9747-5DE82CAF99D1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '343E5E99-AC3E-4F38-9747-5DE82CAF99D1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D26C7A35-CC86-4953-A7CA-530DABD9AB66' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D26C7A35-CC86-4953-A7CA-530DABD9AB66' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '824E0F69-E079-4D18-9C79-F58E4EEE157B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '824E0F69-E079-4D18-9C79-F58E4EEE157B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CE30C12A-6B50-481D-9281-4771DC052599' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CE30C12A-6B50-481D-9281-4771DC052599' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9E996957-47AB-48F6-9410-82D03AAEB482' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9E996957-47AB-48F6-9410-82D03AAEB482' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A5C6AF57-555E-4C35-B8E0-080433C1B043' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A5C6AF57-555E-4C35-B8E0-080433C1B043' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9FB644A5-F467-403B-BB74-4E36D5B71F6A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9FB644A5-F467-403B-BB74-4E36D5B71F6A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4F1D3655-D230-4A06-AA88-662557833251' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4F1D3655-D230-4A06-AA88-662557833251' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '525418A6-0765-4FCE-9E66-B6FF161B9E08' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '525418A6-0765-4FCE-9E66-B6FF161B9E08' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1494E03A-64BE-47BE-B348-9B0465AC2D31' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1494E03A-64BE-47BE-B348-9B0465AC2D31' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3134FC32-F859-426B-BE05-BAEADEAA9CBF' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3134FC32-F859-426B-BE05-BAEADEAA9CBF' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '534EC213-18F5-454D-ABEC-A5308FA60FF7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '534EC213-18F5-454D-ABEC-A5308FA60FF7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'FA81FFD2-73CE-4E24-874F-1520DDC5E903' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'FA81FFD2-73CE-4E24-874F-1520DDC5E903' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E34982FA-3F14-4BC2-807C-6ED60CE4B440' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E34982FA-3F14-4BC2-807C-6ED60CE4B440' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BC704B8D-C305-4006-A6EA-065EB8AD29E8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BC704B8D-C305-4006-A6EA-065EB8AD29E8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E090B0E1-0018-4F56-A9DB-36035F96F104' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E090B0E1-0018-4F56-A9DB-36035F96F104' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0317BD13-01CA-4286-83D4-ACF659F1F5BD' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0317BD13-01CA-4286-83D4-ACF659F1F5BD' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'DE9C7BD0-9EF3-487E-A02C-A9EA99A72C9E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'DE9C7BD0-9EF3-487E-A02C-A9EA99A72C9E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BE5A597F-9654-4DEC-8B82-596D262F5ADF' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BE5A597F-9654-4DEC-8B82-596D262F5ADF' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3298B436-FA99-48FF-A8F2-A40F90DAC16E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3298B436-FA99-48FF-A8F2-A40F90DAC16E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0D372153-F99E-4C77-BCDF-E691BB41F94D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0D372153-F99E-4C77-BCDF-E691BB41F94D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C8134C77-D34A-466B-90A3-3752597CF9CA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C8134C77-D34A-466B-90A3-3752597CF9CA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '898FDBA0-7116-4C04-8F6B-B21431104348' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '898FDBA0-7116-4C04-8F6B-B21431104348' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '85B22CA6-CA68-4602-A2EB-43B6A6E1F22F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '85B22CA6-CA68-4602-A2EB-43B6A6E1F22F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '595E2ACD-FAE9-43EA-8A00-5A5D4DAC628A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '595E2ACD-FAE9-43EA-8A00-5A5D4DAC628A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E36CF20F-D841-4A4D-A251-4BA9E8D15744' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E36CF20F-D841-4A4D-A251-4BA9E8D15744' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '07C14D97-BBB9-4CD1-B7C7-B770AE07A407' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '07C14D97-BBB9-4CD1-B7C7-B770AE07A407' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'FD16F6B0-A9E4-48AF-BDFD-5FCD517925F8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'FD16F6B0-A9E4-48AF-BDFD-5FCD517925F8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8593A2B0-CB44-4713-81C2-80B129578B20' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8593A2B0-CB44-4713-81C2-80B129578B20' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '722590A1-1A25-467E-8798-4C113F985A88' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '722590A1-1A25-467E-8798-4C113F985A88' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0F4F84B9-6A4C-4029-8586-AFB1524A3C45' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0F4F84B9-6A4C-4029-8586-AFB1524A3C45' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '76BA90EF-C77D-4424-A809-F56CE18BD274' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '76BA90EF-C77D-4424-A809-F56CE18BD274' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C4C02277-9CD1-44AF-85FE-18FE78B0D47D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C4C02277-9CD1-44AF-85FE-18FE78B0D47D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AC0518A8-E71D-4EA0-97D5-7E9440211E75' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AC0518A8-E71D-4EA0-97D5-7E9440211E75' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E67586B7-CA3F-4B0E-B332-FE5AB49DBCF7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E67586B7-CA3F-4B0E-B332-FE5AB49DBCF7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AA535DC7-8961-4696-8095-087C244DD24B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AA535DC7-8961-4696-8095-087C244DD24B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E22F62AA-06FA-4D64-93DB-5649643437B8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E22F62AA-06FA-4D64-93DB-5649643437B8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9CEB4B07-CA6B-478D-93C7-F41433AD1154' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9CEB4B07-CA6B-478D-93C7-F41433AD1154' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AD5E64A6-202D-47D4-BB93-89C7D9C79293' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AD5E64A6-202D-47D4-BB93-89C7D9C79293' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '321233DF-D6B3-4252-8EC4-7E21561270C5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '321233DF-D6B3-4252-8EC4-7E21561270C5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E9F7071F-1B2A-4814-9060-AAE93B8F2E45' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E9F7071F-1B2A-4814-9060-AAE93B8F2E45' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A84A9A67-53CA-4AE2-A685-421700F0DC05' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A84A9A67-53CA-4AE2-A685-421700F0DC05' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B0A0B81A-444F-49B2-82BB-1306DF5794DC' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B0A0B81A-444F-49B2-82BB-1306DF5794DC' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '746EDE0B-A365-42A8-AB32-8B66499D1D2C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '746EDE0B-A365-42A8-AB32-8B66499D1D2C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '76FFAEBF-29B6-412B-A693-58AF31437595' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '76FFAEBF-29B6-412B-A693-58AF31437595' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8359576F-0058-4F7F-99F1-C6B9D341FBD5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8359576F-0058-4F7F-99F1-C6B9D341FBD5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '161C714D-579C-457C-A297-46CDF0E69261' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '161C714D-579C-457C-A297-46CDF0E69261' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '428B689F-AFD5-4F4E-A216-76DE822DC613' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '428B689F-AFD5-4F4E-A216-76DE822DC613' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'EA2A97E1-9E30-40D2-9E85-ECA61D352EBC' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'EA2A97E1-9E30-40D2-9E85-ECA61D352EBC' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2BDEBE2C-2377-4EAA-ABAC-5D12BB43C0A3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2BDEBE2C-2377-4EAA-ABAC-5D12BB43C0A3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'EB5A7011-36D2-489B-9F7E-598444B89053' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'EB5A7011-36D2-489B-9F7E-598444B89053' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '763CF1C6-FE29-4A95-AB0F-2E611061211C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '763CF1C6-FE29-4A95-AB0F-2E611061211C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7950136C-B8B7-4D1A-BEBC-D4BFE677D972' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7950136C-B8B7-4D1A-BEBC-D4BFE677D972' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3996AB83-9006-4872-8DD5-862D6B0A34F7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3996AB83-9006-4872-8DD5-862D6B0A34F7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2070F3BF-C6C1-4897-B51F-387BFBCAA17A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2070F3BF-C6C1-4897-B51F-387BFBCAA17A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2D22FF7B-9AFA-43FC-A21E-A580B950E9F2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2D22FF7B-9AFA-43FC-A21E-A580B950E9F2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '507FF194-C064-412E-80EB-22C8065650F7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '507FF194-C064-412E-80EB-22C8065650F7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8E91FFA2-9427-4D77-AC2E-D4395DDF8343' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8E91FFA2-9427-4D77-AC2E-D4395DDF8343' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- GetMETCAL_Results_FullData
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D9D81E6E-9334-43A7-9E92-3B64D50BC9C7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D9D81E6E-9334-43A7-9E92-3B64D50BC9C7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CDD9DB12-C39E-4771-8391-F9623A4E1358' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CDD9DB12-C39E-4771-8391-F9623A4E1358' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5FF1702C-9A08-4201-AA25-0777E2F018B7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5FF1702C-9A08-4201-AA25-0777E2F018B7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '60E0F02A-36CC-457E-8F8E-3385E2BCED69' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '60E0F02A-36CC-457E-8F8E-3385E2BCED69' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4E47825D-180D-4C7A-AA48-52B8A5F132C3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4E47825D-180D-4C7A-AA48-52B8A5F132C3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '50648C60-A3F7-402C-94BE-3BD90A5F6100' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '50648C60-A3F7-402C-94BE-3BD90A5F6100' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AC7108EA-262D-4105-9834-FB0DC20A38AF' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AC7108EA-262D-4105-9834-FB0DC20A38AF' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '254D6C3A-E63B-4F83-A53F-8DC9512AEB12' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '254D6C3A-E63B-4F83-A53F-8DC9512AEB12' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5B4EF5A7-56CF-4722-9FEE-C623F5B04759' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5B4EF5A7-56CF-4722-9FEE-C623F5B04759' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '962F9D7F-2823-4D69-8551-A1C73DBE49B7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '962F9D7F-2823-4D69-8551-A1C73DBE49B7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '75694B44-4F06-48BC-B304-CDFCE4DFBA36' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '75694B44-4F06-48BC-B304-CDFCE4DFBA36' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '510279F0-99E8-479E-B62C-AD3816DAC8DD' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '510279F0-99E8-479E-B62C-AD3816DAC8DD' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AA35687C-438E-4D4D-85AA-61FB3AF08CF9' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AA35687C-438E-4D4D-85AA-61FB3AF08CF9' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '190056DB-135E-4D47-B7B2-3704589EE4FE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '190056DB-135E-4D47-B7B2-3704589EE4FE' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5A543FE0-90DD-4BE4-B91D-E3A0D72E5194' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5A543FE0-90DD-4BE4-B91D-E3A0D72E5194' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '282B07AD-8F94-4C36-8103-7C2EB2ED7216' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '282B07AD-8F94-4C36-8103-7C2EB2ED7216' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4C79D42E-BD1B-49D7-BEC6-005712691142' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4C79D42E-BD1B-49D7-BEC6-005712691142' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '04068053-6992-4443-9DB2-D702B79D293D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '04068053-6992-4443-9DB2-D702B79D293D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AE61551D-CF49-4E20-AC14-4AD8EFE69499' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AE61551D-CF49-4E20-AC14-4AD8EFE69499' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D0AB8DB0-4F90-439A-936F-3C452DDB3ECD' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D0AB8DB0-4F90-439A-936F-3C452DDB3ECD' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1DD83D5C-C1A5-44AA-8738-E96904AB44CE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1DD83D5C-C1A5-44AA-8738-E96904AB44CE' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2A94164E-C98A-49CA-A75E-6BE23BAC580D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2A94164E-C98A-49CA-A75E-6BE23BAC580D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C2138746-ED8A-4E1B-BED7-5B51414E26E1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C2138746-ED8A-4E1B-BED7-5B51414E26E1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8F78FE73-3190-4202-8972-1A1424F0C528' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8F78FE73-3190-4202-8972-1A1424F0C528' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1ED88ACA-D62D-4C33-9453-66521E485050' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1ED88ACA-D62D-4C33-9453-66521E485050' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '95B5AE39-3452-450C-A945-1BDA4BD9CBFF' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '95B5AE39-3452-450C-A945-1BDA4BD9CBFF' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B0B8D397-7DEF-44C0-989E-02C8046AD04E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B0B8D397-7DEF-44C0-989E-02C8046AD04E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8A46F7F1-42CA-424C-84E4-AB062688EA0B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8A46F7F1-42CA-424C-84E4-AB062688EA0B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'EFF26EC9-5B4F-43D5-A859-66B5A4A4D598' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'EFF26EC9-5B4F-43D5-A859-66B5A4A4D598' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8F94A249-2974-4392-B825-37B72DB611AE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8F94A249-2974-4392-B825-37B72DB611AE' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3FC77D07-672E-4690-9E45-702261B67BB7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3FC77D07-672E-4690-9E45-702261B67BB7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '37B8B441-A0F6-4BDE-9C7A-0D74D69B0324' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '37B8B441-A0F6-4BDE-9C7A-0D74D69B0324' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7D786D42-BFA3-4866-895D-10F353E1BECF' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7D786D42-BFA3-4866-895D-10F353E1BECF' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '26854290-5DC0-4DFF-93E7-1FF5907CA199' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '26854290-5DC0-4DFF-93E7-1FF5907CA199' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7AAE5D5D-CCBE-44DF-B63B-12BB10701060' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7AAE5D5D-CCBE-44DF-B63B-12BB10701060' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C6BB7233-55DA-4D20-A616-354B7AD65004' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C6BB7233-55DA-4D20-A616-354B7AD65004' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '13B7DF2A-B5EE-4E2F-879B-4CB3E6F29A74' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '13B7DF2A-B5EE-4E2F-879B-4CB3E6F29A74' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9C3BFC5D-91E6-4368-930E-2E67AFCCC617' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9C3BFC5D-91E6-4368-930E-2E67AFCCC617' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F6969FB2-4BC4-44EE-BC7E-AB99261FA3F2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F6969FB2-4BC4-44EE-BC7E-AB99261FA3F2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '29128B99-59EE-4EB1-8E25-C940FD71EF09' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '29128B99-59EE-4EB1-8E25-C940FD71EF09' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4E074224-BC00-4264-8BAD-74ACD6BE0216' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4E074224-BC00-4264-8BAD-74ACD6BE0216' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '24345532-2BCA-4842-AAE7-C02B328A5384' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '24345532-2BCA-4842-AAE7-C02B328A5384' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6219CC5C-123A-4223-8065-D4222706035F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6219CC5C-123A-4223-8065-D4222706035F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5CA5F559-C6BF-49F3-8E58-6966E34E625B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5CA5F559-C6BF-49F3-8E58-6966E34E625B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A471A90E-E91F-4521-873E-58E3151B3CEB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A471A90E-E91F-4521-873E-58E3151B3CEB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '98A832AC-0B36-4EAB-AAD9-428B8982C90D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '98A832AC-0B36-4EAB-AAD9-428B8982C90D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9682F8A8-57A4-4099-B6F0-B6A5CDE4CE76' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9682F8A8-57A4-4099-B6F0-B6A5CDE4CE76' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AF2DADA3-7A14-4B11-BC85-A457F84D43A6' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AF2DADA3-7A14-4B11-BC85-A457F84D43A6' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'DD9F670E-7080-4F74-8AB9-A584BCEE1831' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'DD9F670E-7080-4F74-8AB9-A584BCEE1831' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C5622338-3327-4DAB-8CA8-445E8D1D1AAC' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C5622338-3327-4DAB-8CA8-445E8D1D1AAC' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C4953ACD-CC81-4BF0-8E72-9C6BD62B8AE0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C4953ACD-CC81-4BF0-8E72-9C6BD62B8AE0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '140ECD00-58BE-4D4B-BB0C-5854346459D4' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '140ECD00-58BE-4D4B-BB0C-5854346459D4' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '75CA1C2A-002E-4986-8747-1D5871EF5410' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '75CA1C2A-002E-4986-8747-1D5871EF5410' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5BD78C06-C3AE-431F-AA01-3B07FDC7EE2C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5BD78C06-C3AE-431F-AA01-3B07FDC7EE2C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2449BE79-7C59-4025-B4B5-FCD7B75A5730' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2449BE79-7C59-4025-B4B5-FCD7B75A5730' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F01240DD-0F79-4A44-B4CD-99EE801C9284' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F01240DD-0F79-4A44-B4CD-99EE801C9284' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0C3D304E-1C40-4A1E-9CD9-490D52714A8D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0C3D304E-1C40-4A1E-9CD9-490D52714A8D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6E889568-7DB9-4DA1-89EF-2F08E0058E1F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6E889568-7DB9-4DA1-89EF-2F08E0058E1F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A7CC5791-85E5-4514-A156-086B5BC6F432' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A7CC5791-85E5-4514-A156-086B5BC6F432' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4BC32C93-7BA5-45BA-9811-0CE5165CB08B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4BC32C93-7BA5-45BA-9811-0CE5165CB08B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4947B941-5F08-45F9-8744-C34E2D289CC0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4947B941-5F08-45F9-8744-C34E2D289CC0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '15955813-1F56-423B-BD86-1E9FC545032D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '15955813-1F56-423B-BD86-1E9FC545032D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '389A0D41-642D-4484-8B4D-43F6E455D544' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '389A0D41-642D-4484-8B4D-43F6E455D544' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AED0E070-F7CC-472F-8303-C3A2A2BB6E59' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AED0E070-F7CC-472F-8303-C3A2A2BB6E59' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '52C84C8F-9B95-4455-867B-05FE5721DD4B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '52C84C8F-9B95-4455-867B-05FE5721DD4B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A414B58F-F8BB-44DB-AC16-C441D36DFA2E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A414B58F-F8BB-44DB-AC16-C441D36DFA2E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0D26B03C-A2EB-46A4-94D3-08AB82FB0B03' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0D26B03C-A2EB-46A4-94D3-08AB82FB0B03' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'FD674A44-1FBD-4D17-8561-8ADAF28C644C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'FD674A44-1FBD-4D17-8561-8ADAF28C644C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F57C407F-D2DD-4FCD-B4B7-D9355D4C2F15' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F57C407F-D2DD-4FCD-B4B7-D9355D4C2F15' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '99AA13D9-18D4-4B70-876E-C908AE5C3E95' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '99AA13D9-18D4-4B70-876E-C908AE5C3E95' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B0946A1F-F74B-4757-81E7-EB799BCEE8D6' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B0946A1F-F74B-4757-81E7-EB799BCEE8D6' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7D90600F-0438-4065-80B3-89402EDA4BF5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7D90600F-0438-4065-80B3-89402EDA4BF5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '861CA1B9-8D38-4546-ACD0-013F0DD29A67' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '861CA1B9-8D38-4546-ACD0-013F0DD29A67' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0DCB49A1-39BD-4A07-A7D7-06A707E5ABB9' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0DCB49A1-39BD-4A07-A7D7-06A707E5ABB9' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '74C70E58-BB4D-4D35-A857-E96E47A96FC7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '74C70E58-BB4D-4D35-A857-E96E47A96FC7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '322D2A2D-BFA6-4315-BECF-00CA8C0642CA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '322D2A2D-BFA6-4315-BECF-00CA8C0642CA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2BBC90A9-A3B8-400F-9B24-2DE9E4929501' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2BBC90A9-A3B8-400F-9B24-2DE9E4929501' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E91F133F-0A5B-49C8-B55F-C210EF2BAFD2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E91F133F-0A5B-49C8-B55F-C210EF2BAFD2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D1C9291F-66A4-4D47-B828-6BB69BB6CCD3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D1C9291F-66A4-4D47-B828-6BB69BB6CCD3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C1D57BD1-2D2B-4CBD-9123-D1EB16D8D612' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C1D57BD1-2D2B-4CBD-9123-D1EB16D8D612' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A8593E2A-424A-4B1D-95D3-B49AF75ADE72' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A8593E2A-424A-4B1D-95D3-B49AF75ADE72' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '111A38D1-0594-4825-8BB1-21E498C3CC37' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '111A38D1-0594-4825-8BB1-21E498C3CC37' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '56B30598-6146-43FA-8557-BFD544E6CE40' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '56B30598-6146-43FA-8557-BFD544E6CE40' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3D228773-4039-4325-B092-6CCF8544FDFF' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3D228773-4039-4325-B092-6CCF8544FDFF' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '25E23783-E6C6-42C9-AA99-164B13C74C16' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '25E23783-E6C6-42C9-AA99-164B13C74C16' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AD78D7FD-8794-46E4-A6C6-E0145AD31F85' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AD78D7FD-8794-46E4-A6C6-E0145AD31F85' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B29A51B8-449B-4DB3-8EA4-4F021A9C0C9E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B29A51B8-449B-4DB3-8EA4-4F021A9C0C9E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8C60F98E-DFB4-4CCD-955B-B2B5FFDE7481' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8C60F98E-DFB4-4CCD-955B-B2B5FFDE7481' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8E41DA13-15D5-4004-B0EE-663E6F2F8301' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8E41DA13-15D5-4004-B0EE-663E6F2F8301' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '49209668-EECB-4D57-9101-AF6AE505F2D6' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '49209668-EECB-4D57-9101-AF6AE505F2D6' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '868BA337-B16E-48DA-952E-D79038673850' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '868BA337-B16E-48DA-952E-D79038673850' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BED7C109-2CA5-4DA5-A464-912F78BF8F1C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BED7C109-2CA5-4DA5-A464-912F78BF8F1C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D38C62E8-28AE-4D25-8F43-CD701C8291D4' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D38C62E8-28AE-4D25-8F43-CD701C8291D4' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F5A59AAF-2ABB-4B32-899F-F26FB06B47D5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F5A59AAF-2ABB-4B32-899F-F26FB06B47D5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B472B73D-2A9A-4E25-AD3F-13A39ABA09A1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B472B73D-2A9A-4E25-AD3F-13A39ABA09A1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B1486289-226D-4F01-AFD8-10EB0B53C4C0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B1486289-226D-4F01-AFD8-10EB0B53C4C0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '93A2272A-33C9-42B3-B138-BDC08D229D6A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '93A2272A-33C9-42B3-B138-BDC08D229D6A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8E2CB814-5743-47A8-A1B3-2F87EB9E92F0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8E2CB814-5743-47A8-A1B3-2F87EB9E92F0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '267B5C96-45CF-4A93-878E-CBA52043736E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '267B5C96-45CF-4A93-878E-CBA52043736E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1D2DEBE9-665C-425A-BD03-A8251D949280' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1D2DEBE9-665C-425A-BD03-A8251D949280' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B5105647-B7DD-482E-A4B3-142EAC1C0551' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B5105647-B7DD-482E-A4B3-142EAC1C0551' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2E5E72D7-41C7-44A4-8860-24253A191A44' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2E5E72D7-41C7-44A4-8860-24253A191A44' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9C476678-E2C7-46B1-A905-2F679254CDA0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9C476678-E2C7-46B1-A905-2F679254CDA0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '16BA2565-015D-490D-9039-EEB4B22D9635' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '16BA2565-015D-490D-9039-EEB4B22D9635' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F211AF63-291F-4B77-82AA-3EC6F2FBD618' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F211AF63-291F-4B77-82AA-3EC6F2FBD618' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C9430CFF-CAD2-4CB6-B6A0-C694A0AA4BF1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C9430CFF-CAD2-4CB6-B6A0-C694A0AA4BF1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9A47D56F-76FB-4E33-8427-575845370FDC' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9A47D56F-76FB-4E33-8427-575845370FDC' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'DDAA50BC-BDD5-44D2-A01E-36F72046B6E7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'DDAA50BC-BDD5-44D2-A01E-36F72046B6E7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D7DECF5D-B496-49FD-B8CE-944AE1CC52FC' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D7DECF5D-B496-49FD-B8CE-944AE1CC52FC' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '46C6D0ED-BA86-4E1B-B498-DAC8439FCA81' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '46C6D0ED-BA86-4E1B-B498-DAC8439FCA81' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '26E17F41-DF40-49D1-A774-DEB6912E0934' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '26E17F41-DF40-49D1-A774-DEB6912E0934' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'FFF1EE74-908A-4E25-8262-1F979E3F688E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'FFF1EE74-908A-4E25-8262-1F979E3F688E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '46918C37-3A65-44D1-BC80-ACADB2D86115' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '46918C37-3A65-44D1-BC80-ACADB2D86115' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '531FE53C-62FB-4B1E-B2A1-C1BB5378545C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '531FE53C-62FB-4B1E-B2A1-C1BB5378545C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '51E833AE-94BD-4D77-9474-597E16C97765' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '51E833AE-94BD-4D77-9474-597E16C97765' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8297BAE8-B1B5-412D-BD56-F157B95C915D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8297BAE8-B1B5-412D-BD56-F157B95C915D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8DB98CD6-70ED-473C-BE51-BEA49BA9B88C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8DB98CD6-70ED-473C-BE51-BEA49BA9B88C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '99AD7E1D-D657-430C-ACEC-AF67F4776BBF' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '99AD7E1D-D657-430C-ACEC-AF67F4776BBF' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '802B4D90-85EA-4A0D-98C7-7F0680CF9246' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '802B4D90-85EA-4A0D-98C7-7F0680CF9246' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B82F8FF7-F3E2-4464-AAA2-0216CC7F2C71' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B82F8FF7-F3E2-4464-AAA2-0216CC7F2C71' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '89A2C106-A989-4787-934F-6FFA382AD2D1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '89A2C106-A989-4787-934F-6FFA382AD2D1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E2E45308-6B0E-4FCC-98CB-4828882B0FF9' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E2E45308-6B0E-4FCC-98CB-4828882B0FF9' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C70BD13D-DFB4-42AE-95F5-120E61F45361' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C70BD13D-DFB4-42AE-95F5-120E61F45361' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E534C39D-FE71-47E6-BEA5-9B1E42CE7CBB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E534C39D-FE71-47E6-BEA5-9B1E42CE7CBB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E44776A8-B7DA-4A3D-B9E0-A0C22213EB6D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E44776A8-B7DA-4A3D-B9E0-A0C22213EB6D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B8000B22-88FB-4F62-8CC3-2738223335EC' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B8000B22-88FB-4F62-8CC3-2738223335EC' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A24B0FC5-1E14-4668-B550-FB5EFAA68A67' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A24B0FC5-1E14-4668-B550-FB5EFAA68A67' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CC51257B-7DEE-4956-82FE-758794C16BBF' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CC51257B-7DEE-4956-82FE-758794C16BBF' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7D519161-1BBE-42BD-89BC-509CCAD075F1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7D519161-1BBE-42BD-89BC-509CCAD075F1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '388DD2F8-2CC6-45D1-ACAA-8AD1CA68A0E7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '388DD2F8-2CC6-45D1-ACAA-8AD1CA68A0E7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '650A0AFC-DE9C-4B54-9601-DB76C0FB9F68' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '650A0AFC-DE9C-4B54-9601-DB76C0FB9F68' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '96FD681D-21F0-46CF-8C73-1036F4C5F86C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '96FD681D-21F0-46CF-8C73-1036F4C5F86C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'EC476DF0-723F-443A-9772-6502DDBDB5EC' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'EC476DF0-723F-443A-9772-6502DDBDB5EC' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '86DEC6B2-3152-448E-B2DF-CDB3D9066B2E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '86DEC6B2-3152-448E-B2DF-CDB3D9066B2E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '933B7F6D-F36D-44A5-B988-C98CA195FB49' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '933B7F6D-F36D-44A5-B988-C98CA195FB49' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '16DBA1F9-9505-4E07-8F8F-18DC6C3736BA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '16DBA1F9-9505-4E07-8F8F-18DC6C3736BA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B858D2B2-B828-460C-AA23-758E02212160' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B858D2B2-B828-460C-AA23-758E02212160' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '371011FE-0237-4B7F-B36E-86F03365B65C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '371011FE-0237-4B7F-B36E-86F03365B65C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B588CEC7-DE73-4363-9132-D01C4A4451F0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B588CEC7-DE73-4363-9132-D01C4A4451F0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1EA39CD9-1A5F-451B-8723-56746C15B437' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1EA39CD9-1A5F-451B-8723-56746C15B437' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '63712679-FEF7-47FB-A2C9-7663F4F33169' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '63712679-FEF7-47FB-A2C9-7663F4F33169' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1632E3C8-652F-47B2-9D76-732383A7208C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1632E3C8-652F-47B2-9D76-732383A7208C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CA4BB71C-68E2-4518-A6C5-6A21F1A4DE40' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CA4BB71C-68E2-4518-A6C5-6A21F1A4DE40' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '64B26574-8A5A-4B04-A1BF-98AC15595CFC' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '64B26574-8A5A-4B04-A1BF-98AC15595CFC' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '569D5E64-4203-4B51-8D2A-2CF26EE16C2C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '569D5E64-4203-4B51-8D2A-2CF26EE16C2C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3A184EAE-4B09-4FE8-9853-656AA5F68745' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3A184EAE-4B09-4FE8-9853-656AA5F68745' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9DE7AF11-2D67-48D4-A4FB-7324C9EBC35C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9DE7AF11-2D67-48D4-A4FB-7324C9EBC35C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C0E5FD12-FCDE-4E13-A150-574B7D8A8C51' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C0E5FD12-FCDE-4E13-A150-574B7D8A8C51' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E4390A78-EC44-4004-BFD1-E5E0C03F8B62' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E4390A78-EC44-4004-BFD1-E5E0C03F8B62' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '53B00F5E-DD3F-45B6-B58E-F91F85F9402A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '53B00F5E-DD3F-45B6-B58E-F91F85F9402A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6181185B-0ADC-4888-931E-432506CFD5D6' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6181185B-0ADC-4888-931E-432506CFD5D6' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '440D9A04-61FE-4DD1-AA20-6894F63EBBE6' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '440D9A04-61FE-4DD1-AA20-6894F63EBBE6' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '81CFBE90-B446-4FB4-BBB3-0F1D108ACEAE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '81CFBE90-B446-4FB4-BBB3-0F1D108ACEAE' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4B869A56-996F-4D9B-B50D-57497FD179A1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4B869A56-996F-4D9B-B50D-57497FD179A1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '190E48BA-AE25-4830-A772-6FB83A4C08C2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '190E48BA-AE25-4830-A772-6FB83A4C08C2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8DC6FCB6-7183-44D6-B653-3610BD4F1B47' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8DC6FCB6-7183-44D6-B653-3610BD4F1B47' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6B616FCA-D76F-4D66-B435-3ACFABE35C86' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6B616FCA-D76F-4D66-B435-3ACFABE35C86' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'FED71CBC-457A-4360-BD7C-0865510823D4' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'FED71CBC-457A-4360-BD7C-0865510823D4' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F25CD342-1267-46DC-A4AC-CA2CD70491D5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F25CD342-1267-46DC-A4AC-CA2CD70491D5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5D685D12-F16D-4BF1-9141-4A2D43054975' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5D685D12-F16D-4BF1-9141-4A2D43054975' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0D70690E-E44C-4243-B4C3-E420FBC0E7B1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0D70690E-E44C-4243-B4C3-E420FBC0E7B1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '126BF340-2AA0-4E1F-8AE8-EBAB7E2FE214' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '126BF340-2AA0-4E1F-8AE8-EBAB7E2FE214' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '31ED2447-83E9-4C8D-B4B5-D3B5618AB838' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '31ED2447-83E9-4C8D-B4B5-D3B5618AB838' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BE56ABFC-9A6E-4499-96BB-0A1364AD4493' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BE56ABFC-9A6E-4499-96BB-0A1364AD4493' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '164EE08A-8A2F-477C-93DE-634CD94BDFA8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '164EE08A-8A2F-477C-93DE-634CD94BDFA8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7AD15C76-D2B9-488E-BC34-3D7E0850EA52' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7AD15C76-D2B9-488E-BC34-3D7E0850EA52' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '50E48D35-B12B-48E1-9335-1717B7466EF9' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '50E48D35-B12B-48E1-9335-1717B7466EF9' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'FEDB659F-75DB-4D45-A55B-AB7C24483978' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'FEDB659F-75DB-4D45-A55B-AB7C24483978' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6E7AD4B8-71BB-477F-B33B-3B98A39CE296' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6E7AD4B8-71BB-477F-B33B-3B98A39CE296' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'DF1C2AB7-F0B1-4061-A8B2-40B4CAC41899' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'DF1C2AB7-F0B1-4061-A8B2-40B4CAC41899' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '93707A5F-9921-4F63-9D9E-CC5BEA6828CB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '93707A5F-9921-4F63-9D9E-CC5BEA6828CB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7ED6BD24-C82B-4C87-AA3D-1678F8581C49' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7ED6BD24-C82B-4C87-AA3D-1678F8581C49' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'EBD0F341-5F01-4BA3-AF85-9E9079D89AF6' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'EBD0F341-5F01-4BA3-AF85-9E9079D89AF6' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '53D2DB1A-91C2-452A-B1BE-72BE4C4C734D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '53D2DB1A-91C2-452A-B1BE-72BE4C4C734D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'DED0D65B-7638-458C-A532-082CE32EA427' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'DED0D65B-7638-458C-A532-082CE32EA427' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A8F48CCB-F09C-4346-8F9E-7A1FE25024D5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A8F48CCB-F09C-4346-8F9E-7A1FE25024D5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '38128E7E-1815-45FE-B94E-00DCAFF964A8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '38128E7E-1815-45FE-B94E-00DCAFF964A8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3F888212-B0B1-43C7-B054-D481EDCCB4A3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3F888212-B0B1-43C7-B054-D481EDCCB4A3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7A73E09A-F28E-4867-9DDC-FD9B0FA8B40A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7A73E09A-F28E-4867-9DDC-FD9B0FA8B40A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D59FB10E-0193-44D1-98B2-39AD17CD131F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D59FB10E-0193-44D1-98B2-39AD17CD131F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A73F416E-3F1A-4F17-8C86-BEBCD4EA500C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A73F416E-3F1A-4F17-8C86-BEBCD4EA500C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C04A5588-6C0A-46C6-B8BD-988ACDAF77B3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C04A5588-6C0A-46C6-B8BD-988ACDAF77B3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '66A89091-5867-48B3-964A-73C1F531B39A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '66A89091-5867-48B3-964A-73C1F531B39A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '92C2E39D-F29B-471B-85DF-964719743B7E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '92C2E39D-F29B-471B-85DF-964719743B7E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0AB36207-F792-4B25-B44D-736B00F2BA79' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0AB36207-F792-4B25-B44D-736B00F2BA79' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '71958500-C08F-48DA-BCC0-5AC8BD95A133' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '71958500-C08F-48DA-BCC0-5AC8BD95A133' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3F1F4973-88B9-4C16-97EA-DC1AE3CB0818' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3F1F4973-88B9-4C16-97EA-DC1AE3CB0818' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '22CD9268-F3D1-4975-90CA-33767AB88911' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '22CD9268-F3D1-4975-90CA-33767AB88911' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '213D9184-90FB-48A6-AAEE-C4F812CE5CAC' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '213D9184-90FB-48A6-AAEE-C4F812CE5CAC' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AE702AF6-3896-478F-85A5-C9B0D6A6F5D8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AE702AF6-3896-478F-85A5-C9B0D6A6F5D8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8CAEE20C-4E25-430E-BD6A-99EF7D61B945' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8CAEE20C-4E25-430E-BD6A-99EF7D61B945' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8CC618E0-BA42-4C26-801C-96354A398DE9' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8CC618E0-BA42-4C26-801C-96354A398DE9' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0A52E95D-6478-428E-8E33-45B5567B13E3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0A52E95D-6478-428E-8E33-45B5567B13E3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8DB5E8C5-8F2F-47B5-B866-E7B36AFC4F40' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8DB5E8C5-8F2F-47B5-B866-E7B36AFC4F40' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F9C657AA-E4B3-45CD-A415-F42040BF3762' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F9C657AA-E4B3-45CD-A415-F42040BF3762' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '37DC7BDB-2A58-40C0-A16C-A397682B199F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '37DC7BDB-2A58-40C0-A16C-A397682B199F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C8887F14-6481-42B0-894E-EA01AFDF158E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C8887F14-6481-42B0-894E-EA01AFDF158E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1906A961-BF9F-4C72-AAEB-B71098A72F43' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1906A961-BF9F-4C72-AAEB-B71098A72F43' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'FEF71A29-3BD1-4C2A-9AE9-A869E869BDF0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'FEF71A29-3BD1-4C2A-9AE9-A869E869BDF0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0A29E85E-09D5-48CF-AA25-582A5A3DC223' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0A29E85E-09D5-48CF-AA25-582A5A3DC223' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F1A61252-0EE6-49A8-84F7-6390EA4B7A5A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F1A61252-0EE6-49A8-84F7-6390EA4B7A5A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8B0216A7-3D92-4911-9883-323C51351D7E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8B0216A7-3D92-4911-9883-323C51351D7E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1DAF1567-ACCE-4FC7-A913-F2C398845106' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1DAF1567-ACCE-4FC7-A913-F2C398845106' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A0CC2B64-5EAC-4BD1-A6AC-B3D016090A37' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A0CC2B64-5EAC-4BD1-A6AC-B3D016090A37' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BB475B7C-9A15-42D1-B5AB-557F403ADD23' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BB475B7C-9A15-42D1-B5AB-557F403ADD23' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'FEE089EC-2D2F-4BAB-98C6-36EE1311912D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'FEE089EC-2D2F-4BAB-98C6-36EE1311912D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2C7EE6F5-D8B5-4B42-B888-85EF30C75D46' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2C7EE6F5-D8B5-4B42-B888-85EF30C75D46' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BBC01F7C-B272-497F-A4BD-42714728C2CF' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BBC01F7C-B272-497F-A4BD-42714728C2CF' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '052369FC-11BF-473E-8BF4-31D581C7D7CA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '052369FC-11BF-473E-8BF4-31D581C7D7CA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2061E029-7859-48BF-A617-69139E8EB564' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2061E029-7859-48BF-A617-69139E8EB564' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '79A07C71-A7D9-4D22-8695-1B03AC47B70A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '79A07C71-A7D9-4D22-8695-1B03AC47B70A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1E4A6FDF-1C31-418F-9BDE-1CD1CFDBB072' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1E4A6FDF-1C31-418F-9BDE-1CD1CFDBB072' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'EF6F1A3F-374A-4518-A66D-CD3229DFF2A6' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'EF6F1A3F-374A-4518-A66D-CD3229DFF2A6' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0F00ACED-9657-410B-983C-E13F49E9B956' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0F00ACED-9657-410B-983C-E13F49E9B956' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3D7028AE-38F3-4109-AD35-F3EF2CC1AD7C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3D7028AE-38F3-4109-AD35-F3EF2CC1AD7C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '30EECC9F-C3E2-46C0-BB69-C173721C08F4' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '30EECC9F-C3E2-46C0-BB69-C173721C08F4' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D4659038-23B6-4225-A886-0355C167A4F0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D4659038-23B6-4225-A886-0355C167A4F0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C236155F-CA49-472F-B43B-D519CFB46187' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C236155F-CA49-472F-B43B-D519CFB46187' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '31D669F0-9262-4375-85C5-123D60672F66' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '31D669F0-9262-4375-85C5-123D60672F66' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9C31075A-5687-485D-B1B8-6497DBF04788' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9C31075A-5687-485D-B1B8-6497DBF04788' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '44E4FD41-475B-4A26-B94C-DC5424D08020' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '44E4FD41-475B-4A26-B94C-DC5424D08020' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1D792EF2-299D-496E-970E-226398DEE037' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1D792EF2-299D-496E-970E-226398DEE037' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7AD55E33-7E45-4488-98F6-FA260C50B034' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7AD55E33-7E45-4488-98F6-FA260C50B034' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '375CC5B0-24A1-4674-B3A6-616FF0035302' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '375CC5B0-24A1-4674-B3A6-616FF0035302' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8CFD0B46-E629-4950-A11F-25A5E1E4E76B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8CFD0B46-E629-4950-A11F-25A5E1E4E76B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'DE861408-7393-4E57-A7D3-5A4FA1C8A4C8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'DE861408-7393-4E57-A7D3-5A4FA1C8A4C8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4AFBB920-545F-4378-9A6A-5D5EE2AEFF0A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4AFBB920-545F-4378-9A6A-5D5EE2AEFF0A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '47E8DE36-D474-48DD-94D1-B555ECDF7942' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '47E8DE36-D474-48DD-94D1-B555ECDF7942' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '19CA4449-285B-478A-B545-EDA4C64B4751' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '19CA4449-285B-478A-B545-EDA4C64B4751' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D87CFBC1-EFAB-44F4-9476-4A446100EE6B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D87CFBC1-EFAB-44F4-9476-4A446100EE6B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F280F122-7F58-491D-9745-FA6B589FDA16' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F280F122-7F58-491D-9745-FA6B589FDA16' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E6FEDEC9-6D50-47D4-ACF1-991FEFF2773F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E6FEDEC9-6D50-47D4-ACF1-991FEFF2773F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9DD8C058-8506-49A3-9710-F4472F32025F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9DD8C058-8506-49A3-9710-F4472F32025F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5D10D973-3ABF-4783-BEAE-6AF650B4140F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5D10D973-3ABF-4783-BEAE-6AF650B4140F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4ADF025D-059A-401B-BF05-6068E5CD8C2E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4ADF025D-059A-401B-BF05-6068E5CD8C2E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '82F4B30A-4868-4D30-B90E-2488BBC3EDA9' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '82F4B30A-4868-4D30-B90E-2488BBC3EDA9' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3F85DD8F-CD0B-4E0E-A5F7-CD7E7FECABFC' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3F85DD8F-CD0B-4E0E-A5F7-CD7E7FECABFC' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7769011E-6F39-4C4E-B8F9-147633949018' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7769011E-6F39-4C4E-B8F9-147633949018' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '98AA85A1-220E-4CF2-BCFB-9C21E53F367A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '98AA85A1-220E-4CF2-BCFB-9C21E53F367A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'FB613C89-697E-4969-852A-D6B40CA39745' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'FB613C89-697E-4969-852A-D6B40CA39745' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F7ECD90B-E9DF-4AB9-BF90-79C1EA22ED29' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F7ECD90B-E9DF-4AB9-BF90-79C1EA22ED29' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B3B7F0BA-3BA0-41C5-A84A-34F4369342BD' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B3B7F0BA-3BA0-41C5-A84A-34F4369342BD' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'EAD54E39-3A2D-4F06-99D8-14F5F11F6868' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'EAD54E39-3A2D-4F06-99D8-14F5F11F6868' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '31AB6672-A74E-4251-9FF2-F50743F95B79' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '31AB6672-A74E-4251-9FF2-F50743F95B79' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B802F449-2ACA-456D-BE57-E9D5B457E8D2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B802F449-2ACA-456D-BE57-E9D5B457E8D2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F7603B15-3AD0-482E-A61F-7D119EE5F6A1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F7603B15-3AD0-482E-A61F-7D119EE5F6A1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1582D8B0-D2A4-4FE9-9485-65FECB4E9FC6' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1582D8B0-D2A4-4FE9-9485-65FECB4E9FC6' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9E5C998B-7EF9-44C1-87E3-E384AEC85230' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9E5C998B-7EF9-44C1-87E3-E384AEC85230' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E7A5FA8D-4BFE-4420-B714-85B2148EA565' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E7A5FA8D-4BFE-4420-B714-85B2148EA565' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '77101793-77D5-4AE9-AFFD-67CFC64CF689' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '77101793-77D5-4AE9-AFFD-67CFC64CF689' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5A5C59BA-0E02-4959-9473-A641BFB71EF2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5A5C59BA-0E02-4959-9473-A641BFB71EF2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8A52A7DA-5B7D-4223-BDE6-E29036D5A249' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8A52A7DA-5B7D-4223-BDE6-E29036D5A249' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D001DEFA-3DF0-4421-AA50-FB4087843E9A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D001DEFA-3DF0-4421-AA50-FB4087843E9A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '06EBC873-9299-441F-BFEE-696C83945370' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '06EBC873-9299-441F-BFEE-696C83945370' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7CB24E46-DE70-4966-8FFF-87023ECE3AC5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7CB24E46-DE70-4966-8FFF-87023ECE3AC5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9C2877B9-46A9-4C9A-BE4D-8AB186C0A350' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9C2877B9-46A9-4C9A-BE4D-8AB186C0A350' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B4C089A4-34F8-4D47-9690-44D9AF8958B8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B4C089A4-34F8-4D47-9690-44D9AF8958B8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E7C98041-4BCE-4FC1-97F1-D352D127E430' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E7C98041-4BCE-4FC1-97F1-D352D127E430' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '53A27380-07ED-4BCF-8620-9FF64E49DCA8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '53A27380-07ED-4BCF-8620-9FF64E49DCA8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0D9E418A-D499-4614-A8CB-97336651C109' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0D9E418A-D499-4614-A8CB-97336651C109' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B9867EF0-B8B7-44C6-8A49-7F7AA861D478' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B9867EF0-B8B7-44C6-8A49-7F7AA861D478' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1E11A2E6-429B-4DDB-BF45-5FBF4E5686A8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1E11A2E6-429B-4DDB-BF45-5FBF4E5686A8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5710ECCF-7EAC-4AC1-9321-307BF8029D15' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5710ECCF-7EAC-4AC1-9321-307BF8029D15' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '68944DCB-A037-4CAC-B517-0E90A342AF5D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '68944DCB-A037-4CAC-B517-0E90A342AF5D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '93AD2709-5EB2-4807-86E9-DAE90DD500F5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '93AD2709-5EB2-4807-86E9-DAE90DD500F5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7028B238-280B-4B0B-BD5A-7AB77C223263' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7028B238-280B-4B0B-BD5A-7AB77C223263' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D90DC865-774A-4133-AEC2-368195E3B5D9' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D90DC865-774A-4133-AEC2-368195E3B5D9' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '965FAF06-722B-4464-BBE0-AE42FAC9B815' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '965FAF06-722B-4464-BBE0-AE42FAC9B815' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D7D994A9-D9B0-4691-B7F2-06D85EF733BC' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D7D994A9-D9B0-4691-B7F2-06D85EF733BC' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '35BBAB0E-44DD-4892-939D-DC4CB13F01B5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '35BBAB0E-44DD-4892-939D-DC4CB13F01B5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BBF945C0-DE6B-41AD-9A44-BFDB558BD1CE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BBF945C0-DE6B-41AD-9A44-BFDB558BD1CE' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2F712198-EB81-4628-A2F6-56F6DC0894C6' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2F712198-EB81-4628-A2F6-56F6DC0894C6' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '85366C7E-0ACB-44F3-9C6E-ACA8C7948ADE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '85366C7E-0ACB-44F3-9C6E-ACA8C7948ADE' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F164E1EB-6F68-4197-B399-17E88F134510' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F164E1EB-6F68-4197-B399-17E88F134510' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '64E63FF0-FCE8-40A3-8FE1-23BAE27DD731' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '64E63FF0-FCE8-40A3-8FE1-23BAE27DD731' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A4F64E98-29BA-454A-B101-B39AD8D7488E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A4F64E98-29BA-454A-B101-B39AD8D7488E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F298CDC0-1BA8-41D3-B75C-E03007C616EE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F298CDC0-1BA8-41D3-B75C-E03007C616EE' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '427474F3-323B-44B0-AECD-B3C4E7DB39B7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '427474F3-323B-44B0-AECD-B3C4E7DB39B7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1DF357DD-C8DC-4DEA-9EEB-522C52957DEF' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1DF357DD-C8DC-4DEA-9EEB-522C52957DEF' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'EEF50481-1050-4A53-9668-7207010AC4F7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'EEF50481-1050-4A53-9668-7207010AC4F7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '24D5BD5A-D213-4815-9804-BB755A01FD2B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '24D5BD5A-D213-4815-9804-BB755A01FD2B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '89D1A200-67C5-4773-8298-67C73C76954B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '89D1A200-67C5-4773-8298-67C73C76954B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '868838C9-0548-45D8-8FD2-C04D7214A30D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '868838C9-0548-45D8-8FD2-C04D7214A30D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '17693D83-2839-47B0-AB2A-59B5F477FB98' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '17693D83-2839-47B0-AB2A-59B5F477FB98' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C949BBA2-1AE9-4D11-A8E6-079D36E9777D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C949BBA2-1AE9-4D11-A8E6-079D36E9777D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '71F7E1B9-3222-44BB-87A0-52BC693A6DAE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '71F7E1B9-3222-44BB-87A0-52BC693A6DAE' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '16780E65-25FA-4E38-9438-CE57EE5BACC7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '16780E65-25FA-4E38-9438-CE57EE5BACC7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '03CF4507-A652-4C84-9CAD-1C582FE96E99' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '03CF4507-A652-4C84-9CAD-1C582FE96E99' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F26C9B5F-A51A-4490-B7F3-5E2AA73DB416' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F26C9B5F-A51A-4490-B7F3-5E2AA73DB416' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '31A482D8-1C55-4B39-BFC0-0CCAD4B367A8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '31A482D8-1C55-4B39-BFC0-0CCAD4B367A8' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- GetPointReadings
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C08882F3-6A0D-4F77-8853-B0294773D4C2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C08882F3-6A0D-4F77-8853-B0294773D4C2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'FBB048C1-A6BB-4589-BEF7-F62F7A88CF90' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'FBB048C1-A6BB-4589-BEF7-F62F7A88CF90' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5EF30B0D-796C-4595-99B3-1D10868EEB2B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5EF30B0D-796C-4595-99B3-1D10868EEB2B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C9B09263-DF3F-4E2B-857E-80EC7AF5F506' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C9B09263-DF3F-4E2B-857E-80EC7AF5F506' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '214593FD-91C8-461F-A670-2A95B2122CB3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '214593FD-91C8-461F-A670-2A95B2122CB3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1BF2ED24-58AF-4181-8811-B0C7432EAE50' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1BF2ED24-58AF-4181-8811-B0C7432EAE50' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AA237045-955E-4BE5-BB73-F8F93A5D22F7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AA237045-955E-4BE5-BB73-F8F93A5D22F7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A8A1C45A-15CB-489C-B4E6-BD04C00C4047' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A8A1C45A-15CB-489C-B4E6-BD04C00C4047' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdShipmentItems
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AC532B70-87B0-4334-9E46-B5F0620A2983' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AC532B70-87B0-4334-9E46-B5F0620A2983' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '03297A23-DFF6-4846-A2AA-B9086868DCAE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '03297A23-DFF6-4846-A2AA-B9086868DCAE' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '923200C2-1CBF-4F11-9EBF-D033DFBE9240' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '923200C2-1CBF-4F11-9EBF-D033DFBE9240' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '660A181A-5FF4-4031-B215-357B4B9D3A03' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '660A181A-5FF4-4031-B215-357B4B9D3A03' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '63C8C81A-7199-4944-AA2E-20001F134DE9' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '63C8C81A-7199-4944-AA2E-20001F134DE9' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '95BA6FB8-5192-451E-B29D-8C4F5465A0CE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '95BA6FB8-5192-451E-B29D-8C4F5465A0CE' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5994EFFE-BD6D-4378-B5EE-F7541EBEEDC8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5994EFFE-BD6D-4378-B5EE-F7541EBEEDC8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '76C265FB-12E4-4615-AD4A-F9FF7C0F749F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '76C265FB-12E4-4615-AD4A-F9FF7C0F749F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '66E6C1A4-5F61-4AE6-8BD4-88EBBC86404B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '66E6C1A4-5F61-4AE6-8BD4-88EBBC86404B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2AF2A948-A107-40C1-95F8-8CA93F32E693' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2AF2A948-A107-40C1-95F8-8CA93F32E693' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '84A182C2-C47B-4DA2-BCBE-A87DB2247689' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '84A182C2-C47B-4DA2-BCBE-A87DB2247689' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '09D3061A-9508-4C0A-ADD7-AC537B758E3E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '09D3061A-9508-4C0A-ADD7-AC537B758E3E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '168BDD8E-2834-4D42-8949-538023673297' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '168BDD8E-2834-4D42-8949-538023673297' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AB1B8A34-15DF-4FAA-9F3A-CFFDDFBE28B0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AB1B8A34-15DF-4FAA-9F3A-CFFDDFBE28B0' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdAssignments
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'ED1E8245-AD46-41A0-B6FD-2682C0DC85B1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'ED1E8245-AD46-41A0-B6FD-2682C0DC85B1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '446CACCF-18C4-43EA-BBC6-306B02ABB708' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '446CACCF-18C4-43EA-BBC6-306B02ABB708' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9B49AE07-755F-4753-8470-FA1CB7468B72' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9B49AE07-755F-4753-8470-FA1CB7468B72' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9FADA583-6962-4024-9C16-531DF9A7A2B4' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9FADA583-6962-4024-9C16-531DF9A7A2B4' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6A784072-368D-4FF6-92A4-4C169991FD5C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6A784072-368D-4FF6-92A4-4C169991FD5C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A181ED99-4498-46D2-B2E0-00808393049C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A181ED99-4498-46D2-B2E0-00808393049C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '96B701CB-E7EE-42F8-9753-673F2580CE6F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '96B701CB-E7EE-42F8-9753-673F2580CE6F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '08947956-5558-4442-A72A-F4B8D596C47C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '08947956-5558-4442-A72A-F4B8D596C47C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A7A77B26-35CE-4EFA-A1CF-383FC64D156A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A7A77B26-35CE-4EFA-A1CF-383FC64D156A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '75BCFC6A-40EE-4C7B-B27F-4CB507CCB563' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '75BCFC6A-40EE-4C7B-B27F-4CB507CCB563' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '85643918-6971-4F0F-8A70-38455C88E49A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '85643918-6971-4F0F-8A70-38455C88E49A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '12455B94-E4DB-4F20-A7C9-F38719321FB5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '12455B94-E4DB-4F20-A7C9-F38719321FB5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3691DDFF-9146-4C8B-B4EA-BA223C5CFFC4' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3691DDFF-9146-4C8B-B4EA-BA223C5CFFC4' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'EC4F56D4-1825-43D1-BEFE-B686F205DCCD' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'EC4F56D4-1825-43D1-BEFE-B686F205DCCD' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6935C380-95D6-4294-8DC3-D3C8E1073B2A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6935C380-95D6-4294-8DC3-D3C8E1073B2A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '58D70E79-6EC5-4AF5-BBE7-51DFD753DDCB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '58D70E79-6EC5-4AF5-BBE7-51DFD753DDCB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8E0AE68C-72D9-4123-8687-D3E93873E931' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8E0AE68C-72D9-4123-8687-D3E93873E931' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E464AC8F-D05D-45E6-87FC-09B3E104F815' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E464AC8F-D05D-45E6-87FC-09B3E104F815' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '58CEBE2B-0F20-4CED-B385-5534DD9E2808' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '58CEBE2B-0F20-4CED-B385-5534DD9E2808' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdToolAssignmentFiles
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2049ACD1-17E2-4FC5-8A71-9315A54BFEDE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2049ACD1-17E2-4FC5-8A71-9315A54BFEDE' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B5FABA4B-AA81-4127-B4C4-61C41A7D4BF4' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B5FABA4B-AA81-4127-B4C4-61C41A7D4BF4' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1F1D3487-EF91-4592-A8A0-9E08226B3135' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1F1D3487-EF91-4592-A8A0-9E08226B3135' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '69D10561-32F7-4D27-BC49-3D12A03C8E21' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '69D10561-32F7-4D27-BC49-3D12A03C8E21' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdLabor
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0020E997-2898-419A-9AF9-667C52EB0476' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0020E997-2898-419A-9AF9-667C52EB0476' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '226C7063-440A-431E-AC36-A56CB539838E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '226C7063-440A-431E-AC36-A56CB539838E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5D54FD1F-77C0-4E1B-9E78-8631D4E212B7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5D54FD1F-77C0-4E1B-9E78-8631D4E212B7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '04267129-2902-4B2F-93CE-355E38220C02' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '04267129-2902-4B2F-93CE-355E38220C02' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '39A1FF96-631E-460E-97E8-A380DA22F749' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '39A1FF96-631E-460E-97E8-A380DA22F749' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillTechCallsheets
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2F6BC50C-42DF-4448-8F50-BE9B696268FB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2F6BC50C-42DF-4448-8F50-BE9B696268FB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A9663A38-CAED-4DCF-A12E-AD0F88E92B08' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A9663A38-CAED-4DCF-A12E-AD0F88E92B08' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A48D95C0-FF39-4B4F-A0D2-E2B7E37BA654' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A48D95C0-FF39-4B4F-A0D2-E2B7E37BA654' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AAB8BB9C-3FF2-4701-8FBB-9F3587F11345' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AAB8BB9C-3FF2-4701-8FBB-9F3587F11345' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '617FD103-6FA9-4C51-B1A0-9DD56BA38CBB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '617FD103-6FA9-4C51-B1A0-9DD56BA38CBB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'FD594BCC-7972-46FE-BCB7-3EF38897C12C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'FD594BCC-7972-46FE-BCB7-3EF38897C12C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '686147B2-4782-42B3-8156-58507135E5C5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '686147B2-4782-42B3-8156-58507135E5C5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '50C2AEF2-4C43-44DB-A5AA-B0AEF0765FF5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '50C2AEF2-4C43-44DB-A5AA-B0AEF0765FF5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E942F24D-4CFB-45D9-BB81-A3EB1BAC7D62' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E942F24D-4CFB-45D9-BB81-A3EB1BAC7D62' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A96189CE-9E55-4FFB-817D-597CD55369B0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A96189CE-9E55-4FFB-817D-597CD55369B0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '625B9E8D-DB52-4E3D-9BBF-3E4BB8BE03C8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '625B9E8D-DB52-4E3D-9BBF-3E4BB8BE03C8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '210C7FB1-7159-42F2-A58C-57D6ED5C0AFB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '210C7FB1-7159-42F2-A58C-57D6ED5C0AFB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D4A79365-2BB9-4158-A2DF-B1A67F3C6FE6' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D4A79365-2BB9-4158-A2DF-B1A67F3C6FE6' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9B5CD4DE-D826-4186-BF75-06821705D2EA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9B5CD4DE-D826-4186-BF75-06821705D2EA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B2CFE669-F144-46C0-AC94-8F332FF220BA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B2CFE669-F144-46C0-AC94-8F332FF220BA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A322F76F-F333-407B-B3F8-A348E5298A74' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A322F76F-F333-407B-B3F8-A348E5298A74' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2D001B89-C47B-4A4D-80FB-591DE7A48262' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2D001B89-C47B-4A4D-80FB-591DE7A48262' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A512C2D0-A078-417E-89DC-DC22C3311A10' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A512C2D0-A078-417E-89DC-DC22C3311A10' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '94E828FC-EC34-4124-8EC3-14AC051799C1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '94E828FC-EC34-4124-8EC3-14AC051799C1' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdProcedures
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '42856452-AF72-443C-BAA9-ADDB4876AD67' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '42856452-AF72-443C-BAA9-ADDB4876AD67' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4B5DDB46-8ABB-4EB5-A286-7E09E49388ED' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4B5DDB46-8ABB-4EB5-A286-7E09E49388ED' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '819AA2BE-2862-4CEA-B28F-E0E2E5DB2FB2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '819AA2BE-2862-4CEA-B28F-E0E2E5DB2FB2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CB1ECFED-3B04-44EE-B189-4D56480F2465' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CB1ECFED-3B04-44EE-B189-4D56480F2465' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8886A662-9E76-4A25-945E-21598011464D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8886A662-9E76-4A25-945E-21598011464D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3609140D-CD45-454E-8022-4C991BB64A27' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3609140D-CD45-454E-8022-4C991BB64A27' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4356F1DD-FEBA-47CF-AF61-9DEC74324598' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4356F1DD-FEBA-47CF-AF61-9DEC74324598' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AF8D5B7B-5B8E-43AC-BD83-797C0D69A5D9' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AF8D5B7B-5B8E-43AC-BD83-797C0D69A5D9' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6E29AF1C-6939-44AB-AE4B-05AD3CE16C18' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6E29AF1C-6939-44AB-AE4B-05AD3CE16C18' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AE47CC44-7853-4C6A-967D-A3D5A6F55382' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AE47CC44-7853-4C6A-967D-A3D5A6F55382' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '29D86D63-5361-4185-A664-32ACB89E9558' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '29D86D63-5361-4185-A664-32ACB89E9558' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5D0001E4-305C-4049-9302-E1638FD5E22F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5D0001E4-305C-4049-9302-E1638FD5E22F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3FC25E44-8EBA-489D-8EC5-7CEC152D346C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3FC25E44-8EBA-489D-8EC5-7CEC152D346C' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdTypeFiles
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B68604B8-84D7-48E0-A3F7-11691FEDCAFA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B68604B8-84D7-48E0-A3F7-11691FEDCAFA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A97797BD-D4A3-40A8-AD11-FAF3C33A44E0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A97797BD-D4A3-40A8-AD11-FAF3C33A44E0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1B3BD9E0-6E7F-41A2-880F-B2C8DF73F2C4' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1B3BD9E0-6E7F-41A2-880F-B2C8DF73F2C4' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E11B2D84-3486-455C-B71C-80293CCA690E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E11B2D84-3486-455C-B71C-80293CCA690E' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdDefaultStandards
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1C4F3520-63A0-465A-9C51-3F983A13FA22' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1C4F3520-63A0-465A-9C51-3F983A13FA22' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CCA6341D-CA20-428B-B254-9A06E1EE923C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CCA6341D-CA20-428B-B254-9A06E1EE923C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '516C0470-94FB-47E7-99E3-BEB327258147' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '516C0470-94FB-47E7-99E3-BEB327258147' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9573962E-3072-4A1E-9E52-1222B0171A5F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9573962E-3072-4A1E-9E52-1222B0171A5F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '339B7F42-6358-4EBD-81B6-282BE6103692' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '339B7F42-6358-4EBD-81B6-282BE6103692' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D7751133-7C55-4D93-B5BE-34E53C83B050' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D7751133-7C55-4D93-B5BE-34E53C83B050' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'EDA65925-1C29-4702-89A5-C9E47966E618' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'EDA65925-1C29-4702-89A5-C9E47966E618' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AC1549E4-5D9C-4BE5-AA28-CA5827596FEB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AC1549E4-5D9C-4BE5-AA28-CA5827596FEB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CB0CC965-7790-4050-97F6-BE9BA3C9CB9A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CB0CC965-7790-4050-97F6-BE9BA3C9CB9A' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdProcedureParts
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BEE574C0-11FE-4BD1-99DE-5165132980AE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BEE574C0-11FE-4BD1-99DE-5165132980AE' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6F79D550-0CA6-495E-82B7-14CE6B5752D5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6F79D550-0CA6-495E-82B7-14CE6B5752D5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A5602EE6-95BE-4EA6-95BA-7ECEC73E9907' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A5602EE6-95BE-4EA6-95BA-7ECEC73E9907' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5C40518A-4607-41A5-A664-6DD0D24A3E3D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5C40518A-4607-41A5-A664-6DD0D24A3E3D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '47AE7B00-BD25-4E9F-B4BA-7B1F05305CB5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '47AE7B00-BD25-4E9F-B4BA-7B1F05305CB5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '45EA3E0A-4603-4A34-B798-90F81C47BF03' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '45EA3E0A-4603-4A34-B798-90F81C47BF03' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5964BECD-4016-4E86-BAC0-25BBD08009DF' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5964BECD-4016-4E86-BAC0-25BBD08009DF' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2E8947AA-A8D1-40D5-A71A-A52F1AFA2B14' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2E8947AA-A8D1-40D5-A71A-A52F1AFA2B14' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdReferencedTypes
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '15200A4D-E328-4B6D-AD73-3076B8AE0FA2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '15200A4D-E328-4B6D-AD73-3076B8AE0FA2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B599E760-689C-41F2-B466-6E168E159599' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B599E760-689C-41F2-B466-6E168E159599' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4379665F-3755-45D0-A033-6B3CE49EE58A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4379665F-3755-45D0-A033-6B3CE49EE58A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '33AEFAFE-A954-4A6D-94BA-A77AAD3930DF' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '33AEFAFE-A954-4A6D-94BA-A77AAD3930DF' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A5506796-C8BC-4BF2-91CC-B8552E2AB74F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A5506796-C8BC-4BF2-91CC-B8552E2AB74F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '244257C5-E96C-4AA0-8C15-621BAF6F14CD' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '244257C5-E96C-4AA0-8C15-621BAF6F14CD' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '007396A3-AEDA-40FC-BE3B-074DBF7A76AE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '007396A3-AEDA-40FC-BE3B-074DBF7A76AE' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8FA4E0C8-1409-40A9-81A7-C0C3706057ED' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8FA4E0C8-1409-40A9-81A7-C0C3706057ED' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7D9F27E7-A353-42CA-8DE2-DBFA874F8193' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7D9F27E7-A353-42CA-8DE2-DBFA874F8193' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdProcedureFiles
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0DE9C3D0-2EA9-4FD0-9A27-0182C8017A9D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0DE9C3D0-2EA9-4FD0-9A27-0182C8017A9D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '22DD2B4B-2730-45B5-8411-9FE761F8DAF3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '22DD2B4B-2730-45B5-8411-9FE761F8DAF3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C14C58AB-24AB-44A8-BFE8-48E45F83F568' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C14C58AB-24AB-44A8-BFE8-48E45F83F568' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '95513B87-B112-4756-B66D-D182ACC23DF9' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '95513B87-B112-4756-B66D-D182ACC23DF9' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdChildren
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CC2F0EC5-1296-481D-A62A-0C09089572B7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CC2F0EC5-1296-481D-A62A-0C09089572B7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A1C42B3C-47BD-4183-9DE5-15465945C61E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A1C42B3C-47BD-4183-9DE5-15465945C61E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5D68610E-0BA8-4399-994C-CDE41F0CC4FE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5D68610E-0BA8-4399-994C-CDE41F0CC4FE' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C3A7A8BE-47A9-4E7B-8185-6E4B4A59093B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C3A7A8BE-47A9-4E7B-8185-6E4B4A59093B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8AD2D9D7-0520-4016-8A67-1200AD434CF0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8AD2D9D7-0520-4016-8A67-1200AD434CF0' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdAddresses
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B36D7B42-2C45-4D3F-91E2-897A6C3991D6' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B36D7B42-2C45-4D3F-91E2-897A6C3991D6' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'EF7951C8-D397-4DAB-8C1F-FE234D1EABD3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'EF7951C8-D397-4DAB-8C1F-FE234D1EABD3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A043B3B0-8329-43E0-B93F-82B9C345D06E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A043B3B0-8329-43E0-B93F-82B9C345D06E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5664AEBF-FD80-4A19-A211-ED21EA5457EA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5664AEBF-FD80-4A19-A211-ED21EA5457EA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F63A0210-3331-4041-AC1C-E8322AB1E713' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F63A0210-3331-4041-AC1C-E8322AB1E713' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4DCE84E8-CC0B-48D4-974F-A895788D07B6' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4DCE84E8-CC0B-48D4-974F-A895788D07B6' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8CA41165-F557-4CE4-B346-1B7EBBA24D8C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8CA41165-F557-4CE4-B346-1B7EBBA24D8C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'DF5BA8A6-E81B-4B8B-9485-28ADD2177421' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'DF5BA8A6-E81B-4B8B-9485-28ADD2177421' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B177004A-434F-4390-A6F2-8FEA8622A12A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B177004A-434F-4390-A6F2-8FEA8622A12A' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdContacts
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CF3A96BD-CDBA-44D9-BD2C-6B159F359745' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CF3A96BD-CDBA-44D9-BD2C-6B159F359745' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3512688C-4768-41FA-B893-6DB810C6AC8A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3512688C-4768-41FA-B893-6DB810C6AC8A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E54FE95A-7383-4543-A7EB-56CCA6913682' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E54FE95A-7383-4543-A7EB-56CCA6913682' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '01B10D9A-5D19-45D2-8807-DFAA93131B97' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '01B10D9A-5D19-45D2-8807-DFAA93131B97' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6728587C-69B0-4BDE-BB8D-7EFE661D7482' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6728587C-69B0-4BDE-BB8D-7EFE661D7482' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '150173FC-751C-4C0F-A4E1-A65CAC2910FC' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '150173FC-751C-4C0F-A4E1-A65CAC2910FC' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C17F714D-C7C3-4069-B98B-8642D0C9F6AC' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C17F714D-C7C3-4069-B98B-8642D0C9F6AC' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '949AC206-ECCD-4639-A4D8-E494BA08116A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '949AC206-ECCD-4639-A4D8-E494BA08116A' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdFacilityFiles
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0962624E-F3E7-48BF-AB2E-CC208CCB6878' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0962624E-F3E7-48BF-AB2E-CC208CCB6878' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'FD777DC5-873B-4567-ADC6-1B0B554FE035' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'FD777DC5-873B-4567-ADC6-1B0B554FE035' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '67475DCF-C5D0-4B75-8D7D-CB2C93092D35' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '67475DCF-C5D0-4B75-8D7D-CB2C93092D35' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BA4CD91F-0CF1-482B-B31F-BB5C8137A42D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BA4CD91F-0CF1-482B-B31F-BB5C8137A42D' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdJobnumbers
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '168468C0-42A7-47C3-8010-C57F8EB6C47A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '168468C0-42A7-47C3-8010-C57F8EB6C47A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '056CCB35-B1E2-4A2D-B439-6960CD869D97' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '056CCB35-B1E2-4A2D-B439-6960CD869D97' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CEBD4C8D-1478-4E2C-A2FC-C7322759D007' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CEBD4C8D-1478-4E2C-A2FC-C7322759D007' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '19B05FCF-C110-456D-B717-9E37A0C39E31' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '19B05FCF-C110-456D-B717-9E37A0C39E31' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '02B28053-E10D-4421-8028-615871B9C2B0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '02B28053-E10D-4421-8028-615871B9C2B0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7EFE9EE7-66E2-40FA-94C2-72353357235A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7EFE9EE7-66E2-40FA-94C2-72353357235A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9D135558-74EB-4F25-9E29-962B5D5C5DC8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9D135558-74EB-4F25-9E29-962B5D5C5DC8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6BEA13A6-F075-4104-8FAF-4F3523138FFE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6BEA13A6-F075-4104-8FAF-4F3523138FFE' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdFacilities
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1C6C6170-1C1A-460B-9AE0-9ED8605B5F1F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1C6C6170-1C1A-460B-9AE0-9ED8605B5F1F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C110A415-278E-4E1E-B1F9-ED2AEC324EE2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C110A415-278E-4E1E-B1F9-ED2AEC324EE2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3E89625E-06F7-4030-A909-F95C38BE3069' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3E89625E-06F7-4030-A909-F95C38BE3069' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B9D219DD-B842-4101-8839-6739F09CF5DC' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B9D219DD-B842-4101-8839-6739F09CF5DC' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E03CA531-A785-4292-9804-B389831CB825' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E03CA531-A785-4292-9804-B389831CB825' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdPartFiles
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6DCB5823-F223-48EC-BF6B-C26DD0BB2410' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6DCB5823-F223-48EC-BF6B-C26DD0BB2410' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E638F184-DF90-4747-B9E5-872C335C14A0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E638F184-DF90-4747-B9E5-872C335C14A0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '43E62431-4140-4733-906B-648346F04D25' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '43E62431-4140-4733-906B-648346F04D25' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '31F01022-F876-4D2A-9DFD-1245A62349A5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '31F01022-F876-4D2A-9DFD-1245A62349A5' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- DupsWIP-Band0
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '90F1104B-9AC9-43AA-9C35-B37A05588802' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '90F1104B-9AC9-43AA-9C35-B37A05588802' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '31D6840F-5A57-4293-B82D-1F21C1895CD9' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '31D6840F-5A57-4293-B82D-1F21C1895CD9' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BF0E330B-EED5-47DF-A489-48AD49B2051A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BF0E330B-EED5-47DF-A489-48AD49B2051A' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- DelWIP-Band0
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1C8D16B5-D7D1-4C81-9F59-FDC921CD5A86' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1C8D16B5-D7D1-4C81-9F59-FDC921CD5A86' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4CD481D8-2FD6-4F7D-BA26-88F0BACD9B36' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4CD481D8-2FD6-4F7D-BA26-88F0BACD9B36' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9DE54667-00FD-42C7-811D-5F671B619DF4' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9DE54667-00FD-42C7-811D-5F671B619DF4' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FindDataToolLog
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'ECB903E8-9ED1-4EF8-B235-3C320C4DA9E0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'ECB903E8-9ED1-4EF8-B235-3C320C4DA9E0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D0FDFDBB-B12E-45AF-A75C-F456A869C0D2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D0FDFDBB-B12E-45AF-A75C-F456A869C0D2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D66A4D38-C961-4D41-873F-CBA75DD1A2F6' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D66A4D38-C961-4D41-873F-CBA75DD1A2F6' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- CallSheetTypes
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'ECAC326E-2AFF-4D56-838A-E40E6B6AE6AD' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'ECAC326E-2AFF-4D56-838A-E40E6B6AE6AD' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D346E6E4-8C20-4023-BC01-8EA58578AE07' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D346E6E4-8C20-4023-BC01-8EA58578AE07' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdWIP-Band0
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'EE0126B3-A437-4048-BD23-EAB2954EEF65' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'EE0126B3-A437-4048-BD23-EAB2954EEF65' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E1AECBE8-4191-4489-AC23-561D5D87EE6F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E1AECBE8-4191-4489-AC23-561D5D87EE6F' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdCompleted-Band0
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '34B8C899-339A-423A-9869-59B82882CAFA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '34B8C899-339A-423A-9869-59B82882CAFA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7F0D9492-B613-4B6A-B89B-08A5B921E180' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7F0D9492-B613-4B6A-B89B-08A5B921E180' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4DFE09FF-BEA2-4721-9E6F-B520210E8F4C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4DFE09FF-BEA2-4721-9E6F-B520210E8F4C' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdInvoiceItems
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '547A5CE5-CA89-4CA1-80EF-3EC053299FDB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '547A5CE5-CA89-4CA1-80EF-3EC053299FDB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5D15FFD5-0381-4A13-B41A-25CB45402932' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5D15FFD5-0381-4A13-B41A-25CB45402932' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '779B3488-F1CD-44D4-B007-E824195ACD2A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '779B3488-F1CD-44D4-B007-E824195ACD2A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9D1C4812-9C1F-4794-8907-3F958C654752' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9D1C4812-9C1F-4794-8907-3F958C654752' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0746EC15-F33C-4D6D-A70E-965E0B60E7F3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0746EC15-F33C-4D6D-A70E-965E0B60E7F3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '60193EBF-9C3E-45F5-A1CE-BF93F48B7634' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '60193EBF-9C3E-45F5-A1CE-BF93F48B7634' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '886487DA-2C0C-4653-817F-9C8FDED57B0A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '886487DA-2C0C-4653-817F-9C8FDED57B0A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F126F82C-9F08-4C99-B1E9-C5EBBD7A93A7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F126F82C-9F08-4C99-B1E9-C5EBBD7A93A7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '52BFEDEC-B2FB-4AF2-871D-372D443F46E1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '52BFEDEC-B2FB-4AF2-871D-372D443F46E1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1F45B537-E3AB-4C19-BF8E-EBDE8D5CAE2E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1F45B537-E3AB-4C19-BF8E-EBDE8D5CAE2E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '18414773-B374-40E8-BA44-3133D73B82BE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '18414773-B374-40E8-BA44-3133D73B82BE' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '450C1B2F-0A26-4EEF-92BC-8F2B480E0AA5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '450C1B2F-0A26-4EEF-92BC-8F2B480E0AA5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '51DA6F2D-AA65-4EB2-9986-0B71FDAE465B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '51DA6F2D-AA65-4EB2-9986-0B71FDAE465B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B93E00A6-E57D-41DC-8F8C-EB3A4E67061A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B93E00A6-E57D-41DC-8F8C-EB3A4E67061A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'DCF1E3EF-C655-40DF-99C3-82A86E3A227D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'DCF1E3EF-C655-40DF-99C3-82A86E3A227D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '398E47F7-32C9-4B87-ADEC-A1D0A6A95FAA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '398E47F7-32C9-4B87-ADEC-A1D0A6A95FAA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D901723F-7EC3-4C98-8049-586C20822DDA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D901723F-7EC3-4C98-8049-586C20822DDA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '81119966-264C-4E53-B072-BD82C65D4E76' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '81119966-264C-4E53-B072-BD82C65D4E76' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4DDE6475-F43C-45B7-8C1C-46E010BF5896' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4DDE6475-F43C-45B7-8C1C-46E010BF5896' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0F685664-2ED4-41E5-8004-34BDBD7CEDC5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0F685664-2ED4-41E5-8004-34BDBD7CEDC5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '71297194-4DCD-4B31-8DAF-E20CB61770DF' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '71297194-4DCD-4B31-8DAF-E20CB61770DF' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6364695E-890D-4CFC-8E2E-9D024C718B39' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6364695E-890D-4CFC-8E2E-9D024C718B39' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F8714A4D-0902-4CA3-8FF0-FE6CB89EDC2F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F8714A4D-0902-4CA3-8FF0-FE6CB89EDC2F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5E0504BD-59CB-4974-975E-EA0B49512B2E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5E0504BD-59CB-4974-975E-EA0B49512B2E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '589D8528-DD65-4C89-9B07-8BCF57649478' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '589D8528-DD65-4C89-9B07-8BCF57649478' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0278C9F9-D7A5-4A25-8F39-4F52704B80D4' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0278C9F9-D7A5-4A25-8F39-4F52704B80D4' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '26C6D473-80F5-4ADB-B827-FF6A738B0188' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '26C6D473-80F5-4ADB-B827-FF6A738B0188' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D53B42C6-4BDA-42D2-B477-F61EB8DDCA77' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D53B42C6-4BDA-42D2-B477-F61EB8DDCA77' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '58E84E22-2C06-45E8-9390-C4C2DD647B5E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '58E84E22-2C06-45E8-9390-C4C2DD647B5E' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdInvoiceItemDetails
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '09CBAC24-1A0A-4380-AF26-3AA209866597' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '09CBAC24-1A0A-4380-AF26-3AA209866597' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '02AAEEE1-9E7E-463F-9F2C-3385622D55D1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '02AAEEE1-9E7E-463F-9F2C-3385622D55D1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0FB78C49-67F8-4882-97D9-CDAA459EBFC5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0FB78C49-67F8-4882-97D9-CDAA459EBFC5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C5A55E9B-A975-4E08-A66A-B95DE02200E2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C5A55E9B-A975-4E08-A66A-B95DE02200E2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1A2560D9-A7C1-45D0-93BF-17E7BBB8DB9C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1A2560D9-A7C1-45D0-93BF-17E7BBB8DB9C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '517A7B58-3C82-453C-82EE-55FE1B1ABE61' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '517A7B58-3C82-453C-82EE-55FE1B1ABE61' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E443228C-1EEC-486D-855B-48DBC17BC927' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E443228C-1EEC-486D-855B-48DBC17BC927' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'ECDA53EC-5115-4E7D-821B-C11B9413EA9A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'ECDA53EC-5115-4E7D-821B-C11B9413EA9A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '800722AE-A16E-4B17-9784-512FF95688F3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '800722AE-A16E-4B17-9784-512FF95688F3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '05735F4D-A943-4B4C-9F81-09A6D0BF842E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '05735F4D-A943-4B4C-9F81-09A6D0BF842E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '10D29B52-127F-4C94-A68A-5E52C8F2524D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '10D29B52-127F-4C94-A68A-5E52C8F2524D' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdPRFiles
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E8CD347E-F123-4240-8FA4-0A0B851D86BD' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E8CD347E-F123-4240-8FA4-0A0B851D86BD' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '414BD946-7886-44AB-8495-F0E02172D45D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '414BD946-7886-44AB-8495-F0E02172D45D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '03514A3A-640E-4341-B504-511253670712' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '03514A3A-640E-4341-B504-511253670712' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A486DF31-9A1A-42DC-8235-4CCBEF365AB2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A486DF31-9A1A-42DC-8235-4CCBEF365AB2' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillTechCallsheets
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2F6BC50C-42DF-4448-8F50-BE9B696268FB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2F6BC50C-42DF-4448-8F50-BE9B696268FB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A9663A38-CAED-4DCF-A12E-AD0F88E92B08' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A9663A38-CAED-4DCF-A12E-AD0F88E92B08' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A48D95C0-FF39-4B4F-A0D2-E2B7E37BA654' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A48D95C0-FF39-4B4F-A0D2-E2B7E37BA654' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AAB8BB9C-3FF2-4701-8FBB-9F3587F11345' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AAB8BB9C-3FF2-4701-8FBB-9F3587F11345' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '617FD103-6FA9-4C51-B1A0-9DD56BA38CBB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '617FD103-6FA9-4C51-B1A0-9DD56BA38CBB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'FD594BCC-7972-46FE-BCB7-3EF38897C12C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'FD594BCC-7972-46FE-BCB7-3EF38897C12C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '686147B2-4782-42B3-8156-58507135E5C5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '686147B2-4782-42B3-8156-58507135E5C5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '50C2AEF2-4C43-44DB-A5AA-B0AEF0765FF5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '50C2AEF2-4C43-44DB-A5AA-B0AEF0765FF5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E942F24D-4CFB-45D9-BB81-A3EB1BAC7D62' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E942F24D-4CFB-45D9-BB81-A3EB1BAC7D62' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A96189CE-9E55-4FFB-817D-597CD55369B0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A96189CE-9E55-4FFB-817D-597CD55369B0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '625B9E8D-DB52-4E3D-9BBF-3E4BB8BE03C8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '625B9E8D-DB52-4E3D-9BBF-3E4BB8BE03C8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '210C7FB1-7159-42F2-A58C-57D6ED5C0AFB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '210C7FB1-7159-42F2-A58C-57D6ED5C0AFB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D4A79365-2BB9-4158-A2DF-B1A67F3C6FE6' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D4A79365-2BB9-4158-A2DF-B1A67F3C6FE6' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9B5CD4DE-D826-4186-BF75-06821705D2EA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9B5CD4DE-D826-4186-BF75-06821705D2EA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B2CFE669-F144-46C0-AC94-8F332FF220BA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B2CFE669-F144-46C0-AC94-8F332FF220BA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A322F76F-F333-407B-B3F8-A348E5298A74' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A322F76F-F333-407B-B3F8-A348E5298A74' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2D001B89-C47B-4A4D-80FB-591DE7A48262' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2D001B89-C47B-4A4D-80FB-591DE7A48262' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A512C2D0-A078-417E-89DC-DC22C3311A10' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A512C2D0-A078-417E-89DC-DC22C3311A10' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '94E828FC-EC34-4124-8EC3-14AC051799C1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '94E828FC-EC34-4124-8EC3-14AC051799C1' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdTechs
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AABE8D1C-A539-41B4-A3E0-79E45E26EC4A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AABE8D1C-A539-41B4-A3E0-79E45E26EC4A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B2BDB65C-407D-430C-89AB-2D9D69082D06' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B2BDB65C-407D-430C-89AB-2D9D69082D06' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7171124A-3EC9-4599-9AAD-90B3A6CE83CD' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7171124A-3EC9-4599-9AAD-90B3A6CE83CD' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '60481C74-CFAD-4A2E-840D-C61268210D45' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '60481C74-CFAD-4A2E-840D-C61268210D45' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdEstimateItems
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F907195D-CFA9-46E8-9E7D-122A69D3185C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F907195D-CFA9-46E8-9E7D-122A69D3185C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D9E92562-EB63-4196-8420-4AC3C461ABB8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D9E92562-EB63-4196-8420-4AC3C461ABB8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '07F52D26-0F11-4D35-B317-7CAA43D1CE73' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '07F52D26-0F11-4D35-B317-7CAA43D1CE73' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '134B8A7D-8C93-45F3-87D8-2F0AADBC9813' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '134B8A7D-8C93-45F3-87D8-2F0AADBC9813' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B145417E-5C3A-4386-B3EF-707EF17E7363' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B145417E-5C3A-4386-B3EF-707EF17E7363' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3247092F-DD1D-43F2-962B-FED35E7B8230' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3247092F-DD1D-43F2-962B-FED35E7B8230' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '85453D0D-7956-4E31-B4DE-9B996D09D7F3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '85453D0D-7956-4E31-B4DE-9B996D09D7F3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8ECB3927-0D8F-41B3-95D8-BCA5EEDB45D4' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8ECB3927-0D8F-41B3-95D8-BCA5EEDB45D4' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '815C3E3D-4C3A-4B85-8ADC-2FD815664027' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '815C3E3D-4C3A-4B85-8ADC-2FD815664027' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'ABF0C036-CB15-4C68-A144-137A8973497D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'ABF0C036-CB15-4C68-A144-137A8973497D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '48CEFA67-D4F3-4B1E-921A-563CB4779834' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '48CEFA67-D4F3-4B1E-921A-563CB4779834' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BF4B5033-FE12-46AF-8DA3-5F6A61E64165' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BF4B5033-FE12-46AF-8DA3-5F6A61E64165' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1DF35075-295E-4C0E-BF29-0DF137E7EBC5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1DF35075-295E-4C0E-BF29-0DF137E7EBC5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B70AFD9D-2D73-49CD-BBAA-E49E8E034263' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B70AFD9D-2D73-49CD-BBAA-E49E8E034263' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillGrdCalendarTasks
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3A3C289C-B9B1-410C-A8A1-D4B110829E05' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3A3C289C-B9B1-410C-A8A1-D4B110829E05' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CAF87338-FB78-43E0-829A-8074CD6F72D8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CAF87338-FB78-43E0-829A-8074CD6F72D8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '99D1F2F5-8580-4559-B1BB-CFEB04E0E718' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '99D1F2F5-8580-4559-B1BB-CFEB04E0E718' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdServicesDue-Band0
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '12F67A75-A0AD-464B-99C1-45671DBCDBD6' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '12F67A75-A0AD-464B-99C1-45671DBCDBD6' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CA7A1658-832B-41F3-B659-A97444FAF799' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CA7A1658-832B-41F3-B659-A97444FAF799' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8A25E060-6150-4D70-BDE0-FB4F12DB9719' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8A25E060-6150-4D70-BDE0-FB4F12DB9719' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillGrdRecallCustomers
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9CC6AB60-D1F4-4EBF-AF7A-099704C6B2F3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9CC6AB60-D1F4-4EBF-AF7A-099704C6B2F3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6DE075A4-FE3E-443C-A98B-4CFA2EE87E37' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6DE075A4-FE3E-443C-A98B-4CFA2EE87E37' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '17932AD6-383E-4E39-B958-20AD440FD110' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '17932AD6-383E-4E39-B958-20AD440FD110' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '155AAD07-24D0-41BA-B6DD-19EEEB46DF31' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '155AAD07-24D0-41BA-B6DD-19EEEB46DF31' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4A1E1E91-4705-4B50-B491-70B0FEB6C21B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4A1E1E91-4705-4B50-B491-70B0FEB6C21B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '15ECB7F7-4CF3-4CFB-B7A6-4CC17ABCC3B0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '15ECB7F7-4CF3-4CFB-B7A6-4CC17ABCC3B0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D090651B-2BA7-4012-B5BF-C6D4AA5B6FF1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D090651B-2BA7-4012-B5BF-C6D4AA5B6FF1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A08C5C11-F5E3-429E-B5FB-F5A0312F3017' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A08C5C11-F5E3-429E-B5FB-F5A0312F3017' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0574B38E-5DA1-44A8-AE7C-C02CFB07E6B3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0574B38E-5DA1-44A8-AE7C-C02CFB07E6B3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1E517341-6EAE-4145-BBA2-8ABF7463EEE3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1E517341-6EAE-4145-BBA2-8ABF7463EEE3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '405A18A3-563E-4CCD-B382-714FEA09D675' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '405A18A3-563E-4CCD-B382-714FEA09D675' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '34AC0C9F-DDC2-43AF-963C-08B14A500332' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '34AC0C9F-DDC2-43AF-963C-08B14A500332' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdRecipients-Band0
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '62F88322-9C21-44A9-B4A1-DE3C1389097B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '62F88322-9C21-44A9-B4A1-DE3C1389097B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0452A07E-42C2-4307-9963-0535A732F0F8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0452A07E-42C2-4307-9963-0535A732F0F8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '74A03BEB-0702-4D35-B8D2-C84B138572DA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '74A03BEB-0702-4D35-B8D2-C84B138572DA' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdAlertEvents
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5A0BADEE-BBD3-4B00-AD8C-7565417DE3DD' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5A0BADEE-BBD3-4B00-AD8C-7565417DE3DD' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5B92C0B9-C856-43ED-886F-480431012B4C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5B92C0B9-C856-43ED-886F-480431012B4C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '850D174D-A516-4B02-9C1D-13411B43B5B6' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '850D174D-A516-4B02-9C1D-13411B43B5B6' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F2E7DFEB-4EBC-4F85-9269-BE81642113AA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F2E7DFEB-4EBC-4F85-9269-BE81642113AA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2FBE67E2-AFCD-41FA-BBE6-AD16C46AC8E7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2FBE67E2-AFCD-41FA-BBE6-AD16C46AC8E7' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdAlertContacts
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D0250A01-DD49-4F06-A8C1-6C5416F113C4' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D0250A01-DD49-4F06-A8C1-6C5416F113C4' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '54AD98CC-B5CC-4CE9-AEBD-7F7EFF76801C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '54AD98CC-B5CC-4CE9-AEBD-7F7EFF76801C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E7AC39AE-F492-472A-B166-C4F6271BB91D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E7AC39AE-F492-472A-B166-C4F6271BB91D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B4B4D515-09C9-410B-98DE-A0FE24D38156' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B4B4D515-09C9-410B-98DE-A0FE24D38156' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- 	FillGrdFacilityContactLink
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3CC1F20A-DF4C-4554-B82C-999B58F0BB17' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3CC1F20A-DF4C-4554-B82C-999B58F0BB17' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B2701998-5C54-4DC7-91B2-E40A6078AFF6' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B2701998-5C54-4DC7-91B2-E40A6078AFF6' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'ADCAB305-A3D7-484F-9D3C-461555C87BB7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'ADCAB305-A3D7-484F-9D3C-461555C87BB7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '76AF81CE-C519-4290-B382-FF4F34A531A1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '76AF81CE-C519-4290-B382-FF4F34A531A1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '03DF6425-F992-484E-ACD5-79AF51F375F8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '03DF6425-F992-484E-ACD5-79AF51F375F8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5DD59F4D-51FE-4AF9-B321-9156A1D420F3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5DD59F4D-51FE-4AF9-B321-9156A1D420F3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F1857155-BA31-45F7-B484-84531E4698F7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F1857155-BA31-45F7-B484-84531E4698F7' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdUserLabs
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5647A8B6-412A-48AE-B7A7-53093B6741F8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5647A8B6-412A-48AE-B7A7-53093B6741F8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3A88BB65-968F-4E10-AA34-C45C5127DD59' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3A88BB65-968F-4E10-AA34-C45C5127DD59' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E945F58B-9222-465C-BB2A-0AE02756D284' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E945F58B-9222-465C-BB2A-0AE02756D284' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A5E326F8-9809-4EA4-9B97-89F8CB3B64A7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A5E326F8-9809-4EA4-9B97-89F8CB3B64A7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '734B3251-088C-497D-AF4F-7F9C430BA820' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '734B3251-088C-497D-AF4F-7F9C430BA820' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- fillGrdDataCheckSQL
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '850880E2-4946-4CF1-A6EC-161653FBA224' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '850880E2-4946-4CF1-A6EC-161653FBA224' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7538E759-AF8A-418B-A664-795411A597AA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7538E759-AF8A-418B-A664-795411A597AA' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdAlertParameters
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D25EF20D-405D-4CFB-A205-CFB46E6F872F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D25EF20D-405D-4CFB-A205-CFB46E6F872F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E756F2A4-4A12-48C4-80A6-B65DA0D51D20' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E756F2A4-4A12-48C4-80A6-B65DA0D51D20' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '55B0A513-74E3-4273-9C92-7E3618071423' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '55B0A513-74E3-4273-9C92-7E3618071423' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillGrdAlerts
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '77CC37D8-654D-45A4-8580-D0481F2EF71A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '77CC37D8-654D-45A4-8580-D0481F2EF71A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2D5F1924-E66E-4FB7-AD40-037DD320EA57' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2D5F1924-E66E-4FB7-AD40-037DD320EA57' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CFD25C35-1B43-481F-B330-9AE1909DE4D2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CFD25C35-1B43-481F-B330-9AE1909DE4D2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '61A49B16-60BF-4FBE-B80D-512013A8977C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '61A49B16-60BF-4FBE-B80D-512013A8977C' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdAssignmentsNew
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '45A7BDA0-6DC1-4413-9C95-284811AE3F9D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '45A7BDA0-6DC1-4413-9C95-284811AE3F9D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '33DD7885-11F1-4203-94C2-859DFF9860E5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '33DD7885-11F1-4203-94C2-859DFF9860E5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'ED06B6C2-D6BC-4282-AB0C-FDE51E052D55' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'ED06B6C2-D6BC-4282-AB0C-FDE51E052D55' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '787C4519-4665-42B8-914D-8660B3BCBFF6' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '787C4519-4665-42B8-914D-8660B3BCBFF6' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3A55D3FA-7835-4597-A630-47CFD240BF6D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3A55D3FA-7835-4597-A630-47CFD240BF6D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '319276E7-E644-4CBB-A49C-95C48ABF25E9' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '319276E7-E644-4CBB-A49C-95C48ABF25E9' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3C88BF7E-A135-4BD1-A9C6-510A3442C563' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3C88BF7E-A135-4BD1-A9C6-510A3442C563' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0E9558BC-43A2-4E7A-9BC5-722DCC018BC7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0E9558BC-43A2-4E7A-9BC5-722DCC018BC7' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdAttributes
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '601C4B27-3803-421F-9698-45E578A2B2F2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '601C4B27-3803-421F-9698-45E578A2B2F2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '41223546-EFB3-4B30-B0D9-02E68EB7F97D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '41223546-EFB3-4B30-B0D9-02E68EB7F97D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '72F75B6E-91F7-4477-AD28-C149C7D8B72F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '72F75B6E-91F7-4477-AD28-C149C7D8B72F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BA4D4211-BD3C-478A-A386-5F6D9A4754A9' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BA4D4211-BD3C-478A-A386-5F6D9A4754A9' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6BF803D5-5F4A-47EE-B0D2-2247ECDC13AC' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6BF803D5-5F4A-47EE-B0D2-2247ECDC13AC' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '00CE50A5-D2E1-4007-A3B5-2A79E434DFE6' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '00CE50A5-D2E1-4007-A3B5-2A79E434DFE6' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4D6D9411-2939-4C39-8A85-401C3FD8C775' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4D6D9411-2939-4C39-8A85-401C3FD8C775' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '353604DA-AE48-4462-BCAF-2F30F2BD7487' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '353604DA-AE48-4462-BCAF-2F30F2BD7487' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D48A05C2-38D9-4390-8B4B-EE3B3F04F2BD' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D48A05C2-38D9-4390-8B4B-EE3B3F04F2BD' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4D461ACE-D062-41A7-ABB6-579146C6770A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4D461ACE-D062-41A7-ABB6-579146C6770A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4C0EDED5-0839-43F5-8D7D-1E97A38397D5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4C0EDED5-0839-43F5-8D7D-1E97A38397D5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '568F29E5-D5BE-483D-8464-BA7D25966CB4' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '568F29E5-D5BE-483D-8464-BA7D25966CB4' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2E5F420B-2B1B-43B1-A855-FB6754C68CE4' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2E5F420B-2B1B-43B1-A855-FB6754C68CE4' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdBatchCertPrint
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5901CACE-07B7-4133-A1C6-ACFCB4C76DCB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5901CACE-07B7-4133-A1C6-ACFCB4C76DCB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9B5D9D9A-A39C-4539-A0D9-8F4B5696CA0E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9B5D9D9A-A39C-4539-A0D9-8F4B5696CA0E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CE5083DA-9387-4AF9-A7A7-383E8C43C354' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CE5083DA-9387-4AF9-A7A7-383E8C43C354' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '99C238B5-8415-45C1-9322-C31A03ECD17C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '99C238B5-8415-45C1-9322-C31A03ECD17C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '518C17F0-4037-4F8B-AC57-B2F3136F8C8E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '518C17F0-4037-4F8B-AC57-B2F3136F8C8E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '160F3A87-3DB0-491A-A688-6DD764291A78' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '160F3A87-3DB0-491A-A688-6DD764291A78' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B0E624ED-04F9-4E0F-9AF3-0A3D267FC8A7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B0E624ED-04F9-4E0F-9AF3-0A3D267FC8A7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B43D1EBA-7FA0-4708-8BEB-930D224C5F60' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B43D1EBA-7FA0-4708-8BEB-930D224C5F60' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C9F2B836-AE23-48BC-B6EC-823E8EAA6197' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C9F2B836-AE23-48BC-B6EC-823E8EAA6197' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6A07AB0A-D7A7-4D85-B207-B6089DBAC9AD' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6A07AB0A-D7A7-4D85-B207-B6089DBAC9AD' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '28710CCE-A6C8-4051-B280-94495E67EFF2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '28710CCE-A6C8-4051-B280-94495E67EFF2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AA595F62-4F77-4549-805A-670ACC4A0E6E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AA595F62-4F77-4549-805A-670ACC4A0E6E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1A3F24CB-9DF3-4D39-876F-5517FA5F4CAF' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1A3F24CB-9DF3-4D39-876F-5517FA5F4CAF' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'EE53A74E-E30B-47F0-A627-0245C911E567' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'EE53A74E-E30B-47F0-A627-0245C911E567' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9A3DF1EC-A46C-4102-9550-9118DD36BF4B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9A3DF1EC-A46C-4102-9550-9118DD36BF4B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '68F209F1-8AB4-4A26-B018-EB587D470A60' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '68F209F1-8AB4-4A26-B018-EB587D470A60' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '027FBA34-6808-42D8-B34B-CDCEF023CAEE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '027FBA34-6808-42D8-B34B-CDCEF023CAEE' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D3763C0E-4841-440E-BC50-73924827420B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D3763C0E-4841-440E-BC50-73924827420B' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdBillCallSheets
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '56F5CD3C-FB63-47F7-BDD9-EF449F78DA27' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '56F5CD3C-FB63-47F7-BDD9-EF449F78DA27' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '763DD2F5-E943-459D-A6EE-0634101F2C07' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '763DD2F5-E943-459D-A6EE-0634101F2C07' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0C1B1231-6F9D-458D-A599-78CBB2DBE948' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0C1B1231-6F9D-458D-A599-78CBB2DBE948' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2F92D94D-114F-4671-B55F-52A5A9F68672' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2F92D94D-114F-4671-B55F-52A5A9F68672' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BDFA20FD-2146-47DF-9072-9A07F74340F8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BDFA20FD-2146-47DF-9072-9A07F74340F8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '73A8991C-503D-4437-AA00-94B41753428E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '73A8991C-503D-4437-AA00-94B41753428E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0E95A53B-6E65-4514-AB20-C0714000FC3F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0E95A53B-6E65-4514-AB20-C0714000FC3F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AAB1D95D-8FD5-475B-8F5C-928C5258425C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AAB1D95D-8FD5-475B-8F5C-928C5258425C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B944D1C9-8E40-4065-B367-9931877D3D1E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B944D1C9-8E40-4065-B367-9931877D3D1E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '00CD1D36-A4C9-4AA4-924F-6C6BC02C86A9' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '00CD1D36-A4C9-4AA4-924F-6C6BC02C86A9' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C3BE10D2-28DD-489A-A1E2-7C157FF013BB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C3BE10D2-28DD-489A-A1E2-7C157FF013BB' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdBilledParts
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F109CC84-DF87-42F1-9230-8EAB8419E0E5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F109CC84-DF87-42F1-9230-8EAB8419E0E5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'EA31BBD5-7751-4B87-AF4C-AFE53DCD83CA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'EA31BBD5-7751-4B87-AF4C-AFE53DCD83CA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E1D21AD8-06E2-4322-88ED-26D7DE64E0B5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E1D21AD8-06E2-4322-88ED-26D7DE64E0B5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8C35B9EE-26A0-41B0-AE5D-4EAB40AA86C3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8C35B9EE-26A0-41B0-AE5D-4EAB40AA86C3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7704E50D-7483-470A-9742-40B0E065080A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7704E50D-7483-470A-9742-40B0E065080A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D303C2AE-015F-4D70-96E7-CF0CEFDCE006' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D303C2AE-015F-4D70-96E7-CF0CEFDCE006' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdBillParts
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A6BBBAD6-0E8D-41E4-9C09-64EE0FA10195' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A6BBBAD6-0E8D-41E4-9C09-64EE0FA10195' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '703C88FD-5DFF-47E8-8AF7-ACAFDE098EDB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '703C88FD-5DFF-47E8-8AF7-ACAFDE098EDB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7E57CEF3-EF31-43C3-A331-F0187490DB67' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7E57CEF3-EF31-43C3-A331-F0187490DB67' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '627A0A56-85E7-40EA-BB1A-E1516293B155' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '627A0A56-85E7-40EA-BB1A-E1516293B155' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5CD77916-D9BC-4929-96B3-20087820B4AD' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5CD77916-D9BC-4929-96B3-20087820B4AD' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'FE0C817F-AD78-4422-8310-1E116F084CFE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'FE0C817F-AD78-4422-8310-1E116F084CFE' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '650FB259-5297-451F-970C-69FE4B389F50' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '650FB259-5297-451F-970C-69FE4B389F50' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdBulkChangeAssets
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3AE603CC-B384-47C9-BAF7-9B7059637559' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3AE603CC-B384-47C9-BAF7-9B7059637559' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '044F0E19-1F55-4699-B45D-64A40513BB49' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '044F0E19-1F55-4699-B45D-64A40513BB49' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D59E9D5C-8377-4DA4-8BB2-880122F815BE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D59E9D5C-8377-4DA4-8BB2-880122F815BE' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '009CA650-D2B6-49AC-AEA9-399D069EC972' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '009CA650-D2B6-49AC-AEA9-399D069EC972' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AA9A20BA-40C0-447C-9564-072C19FBE6EE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AA9A20BA-40C0-447C-9564-072C19FBE6EE' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F9D2ED16-23DD-49A2-B489-08AA66FBDE95' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F9D2ED16-23DD-49A2-B489-08AA66FBDE95' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '30EAEB2F-1966-497C-9C97-C79557416AC3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '30EAEB2F-1966-497C-9C97-C79557416AC3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'FAE0E175-BE29-43A0-9713-BEE06BC55508' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'FAE0E175-BE29-43A0-9713-BEE06BC55508' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdBulkChangeFields
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9D4C7E8F-9835-41CD-ABBA-6EFCF9E885F3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9D4C7E8F-9835-41CD-ABBA-6EFCF9E885F3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BF6081AD-17FF-4D94-B2FF-7CA388FC0456' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BF6081AD-17FF-4D94-B2FF-7CA388FC0456' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AD269C9E-032C-4E5B-889A-1DE908B80943' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AD269C9E-032C-4E5B-889A-1DE908B80943' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B9C52E88-077E-4DB5-988F-12EDBDE36BBD' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B9C52E88-077E-4DB5-988F-12EDBDE36BBD' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1788DBA2-76FA-4AD6-8459-EC1B7A701500' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1788DBA2-76FA-4AD6-8459-EC1B7A701500' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '039DDBEB-9E24-4439-98A0-CC491B2BF4CA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '039DDBEB-9E24-4439-98A0-CC491B2BF4CA' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdCallSheetBatch
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '490C044C-6D61-4871-AE47-D699A5E52FC5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '490C044C-6D61-4871-AE47-D699A5E52FC5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '15D6C9AC-834B-46CA-887D-88358C4BEABF' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '15D6C9AC-834B-46CA-887D-88358C4BEABF' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C07CB8AE-8B6A-4233-A287-31200E9B5C42' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C07CB8AE-8B6A-4233-A287-31200E9B5C42' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '60299784-6AA8-4869-9B89-E871C5E206CC' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '60299784-6AA8-4869-9B89-E871C5E206CC' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1F2AB7DF-81BC-4F15-B9E9-F47117D171F5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1F2AB7DF-81BC-4F15-B9E9-F47117D171F5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '713A8BE6-BECD-45B1-83D3-D430BD016692' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '713A8BE6-BECD-45B1-83D3-D430BD016692' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CCCFFC32-540E-4A1A-B818-9697DF6CEE0E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CCCFFC32-540E-4A1A-B818-9697DF6CEE0E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0E184C8E-BD44-4222-93DD-133F46281AB3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0E184C8E-BD44-4222-93DD-133F46281AB3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7298B811-FFF4-4193-BDBA-57081D27AD60' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7298B811-FFF4-4193-BDBA-57081D27AD60' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C5207A7B-4A96-4B02-9FC7-DE57E4F03BB4' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C5207A7B-4A96-4B02-9FC7-DE57E4F03BB4' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdCallSheets
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '19EE9E2B-3A2B-4B06-919D-AFCC0EA6AEF2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '19EE9E2B-3A2B-4B06-919D-AFCC0EA6AEF2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '88FA6064-34B2-42A0-8797-449D9474E0EB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '88FA6064-34B2-42A0-8797-449D9474E0EB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9DEA7503-BE2F-4BBF-9C4A-806ECBCA157B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9DEA7503-BE2F-4BBF-9C4A-806ECBCA157B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'EF872F80-5627-4377-ACF9-06689C854075' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'EF872F80-5627-4377-ACF9-06689C854075' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0EDEE66D-79F2-4F1D-9E37-1076F0AA2488' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0EDEE66D-79F2-4F1D-9E37-1076F0AA2488' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '22C748B9-FA8A-472B-AD1E-3056D792DF52' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '22C748B9-FA8A-472B-AD1E-3056D792DF52' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3E98EC1E-D1CA-4D47-B92C-F8B802B293F0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3E98EC1E-D1CA-4D47-B92C-F8B802B293F0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B382CA9E-CE9A-4E1E-973F-1875337DF08E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B382CA9E-CE9A-4E1E-973F-1875337DF08E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BE455B6E-C8BD-445A-9D2D-A3CD3FC341BE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BE455B6E-C8BD-445A-9D2D-A3CD3FC341BE' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D9904AE1-A9E3-4F96-B80E-09DA9D4968A3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D9904AE1-A9E3-4F96-B80E-09DA9D4968A3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1D492E6D-BFA9-490D-920B-7896E238F919' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1D492E6D-BFA9-490D-920B-7896E238F919' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5972A5CB-77BC-4825-884A-2AABC3F3F9DA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5972A5CB-77BC-4825-884A-2AABC3F3F9DA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '53D1FB5F-A124-44A8-A8D1-B2AEA99813E5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '53D1FB5F-A124-44A8-A8D1-B2AEA99813E5' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdCompleted-Band1
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B09663D5-D6AE-4E3C-A6AC-30C832E77E77' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B09663D5-D6AE-4E3C-A6AC-30C832E77E77' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '659D645D-C32E-4772-9465-AA1E52299661' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '659D645D-C32E-4772-9465-AA1E52299661' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B9233B27-2584-46AA-9D2B-1A285B004F81' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B9233B27-2584-46AA-9D2B-1A285B004F81' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '44D227A8-5FDD-4708-86D1-C5954B874A01' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '44D227A8-5FDD-4708-86D1-C5954B874A01' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CA67E2E9-F284-43F6-8F76-649A60C85D8E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CA67E2E9-F284-43F6-8F76-649A60C85D8E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A94A806B-BD1E-4EB7-A3A7-2553A4023548' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A94A806B-BD1E-4EB7-A3A7-2553A4023548' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6B4C5967-4FA9-4731-89C3-E4DC953DB293' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6B4C5967-4FA9-4731-89C3-E4DC953DB293' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E281827B-D9E8-4F77-B713-BAE3802FBD7D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E281827B-D9E8-4F77-B713-BAE3802FBD7D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D712E695-AC88-4CAE-92D9-794647580783' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D712E695-AC88-4CAE-92D9-794647580783' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '04ADF3FA-D542-4739-AB92-67A9721A78B9' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '04ADF3FA-D542-4739-AB92-67A9721A78B9' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C2D3C1DC-F6DD-464C-BA1B-945D52D3BC20' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C2D3C1DC-F6DD-464C-BA1B-945D52D3BC20' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0F920A16-6A5F-4D08-8FDE-78E326D5C560' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0F920A16-6A5F-4D08-8FDE-78E326D5C560' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '31B35763-28B4-47EE-BEBD-65012A6E6AD4' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '31B35763-28B4-47EE-BEBD-65012A6E6AD4' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E9460D9C-B302-4FD8-8004-5E46F28D6942' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E9460D9C-B302-4FD8-8004-5E46F28D6942' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '63796116-37DA-4944-B487-6657C0331F6F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '63796116-37DA-4944-B487-6657C0331F6F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '23E8D6E7-4D63-40B9-8B12-593F91297DD8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '23E8D6E7-4D63-40B9-8B12-593F91297DD8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '02D482E5-7A2C-4667-9728-7E784C48EFC9' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '02D482E5-7A2C-4667-9728-7E784C48EFC9' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C64CB8E2-F206-4B88-BDC8-B9D774C9D277' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C64CB8E2-F206-4B88-BDC8-B9D774C9D277' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6EA96E51-9C6C-410D-94AD-59C472AD0C0C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6EA96E51-9C6C-410D-94AD-59C472AD0C0C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '731BDD03-1D76-4839-BEAC-AAF70ED660B2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '731BDD03-1D76-4839-BEAC-AAF70ED660B2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '142F739F-CC72-4512-955C-DAC90E3B9D2B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '142F739F-CC72-4512-955C-DAC90E3B9D2B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AD518CC5-6429-4163-8A28-BD3C5B3B8DD1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AD518CC5-6429-4163-8A28-BD3C5B3B8DD1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3714BD9A-3CFE-4E38-B517-5071A86F2230' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3714BD9A-3CFE-4E38-B517-5071A86F2230' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '16B6DDAB-38EC-4223-BE66-9F09218671E1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '16B6DDAB-38EC-4223-BE66-9F09218671E1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2227C47C-ABE7-431F-8DBA-5284783DC1E2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2227C47C-ABE7-431F-8DBA-5284783DC1E2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C1AF7DB7-AD34-4BA6-AF2C-6A81585FB4A6' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C1AF7DB7-AD34-4BA6-AF2C-6A81585FB4A6' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3ED75454-17F7-41B4-B91D-6D95B041D9B9' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3ED75454-17F7-41B4-B91D-6D95B041D9B9' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'DDA3B98E-EA4D-4AC1-B217-BC0F256E1451' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'DDA3B98E-EA4D-4AC1-B217-BC0F256E1451' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B080B302-504C-4571-959E-FF60C586883B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B080B302-504C-4571-959E-FF60C586883B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8C9757A3-4BA1-47AE-A9FD-BDB5CAED6D9E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8C9757A3-4BA1-47AE-A9FD-BDB5CAED6D9E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1FECE821-E2D4-4ED2-B8E3-C6A9F09F4FC0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1FECE821-E2D4-4ED2-B8E3-C6A9F09F4FC0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '074DB194-B8EB-4877-B2C2-DD0AC563E016' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '074DB194-B8EB-4877-B2C2-DD0AC563E016' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E31FC2A7-4542-42AC-90CB-B2496F8AE658' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E31FC2A7-4542-42AC-90CB-B2496F8AE658' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1F7D450E-FBE2-419C-963A-C9693E3125BB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1F7D450E-FBE2-419C-963A-C9693E3125BB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F4942EC2-CACE-445C-AA62-D32FF6E7BEB7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F4942EC2-CACE-445C-AA62-D32FF6E7BEB7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '485F8830-2348-49F3-9240-11454968B767' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '485F8830-2348-49F3-9240-11454968B767' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdCSFilesCustomerPortal
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3D9BC2B5-6D80-4C78-8CA6-2F3F2791C32D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3D9BC2B5-6D80-4C78-8CA6-2F3F2791C32D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BCAEF34D-2FA7-4677-A4ED-89D82853BEA4' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BCAEF34D-2FA7-4677-A4ED-89D82853BEA4' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'ADB93369-1FC2-471C-B732-97B53E135ED6' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'ADB93369-1FC2-471C-B732-97B53E135ED6' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdEmailContacts
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'EBD7E427-7A8A-4122-9AD7-FA8D2B35517E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'EBD7E427-7A8A-4122-9AD7-FA8D2B35517E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '80481F34-0396-47EF-B11D-7A0DDA3C1D80' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '80481F34-0396-47EF-B11D-7A0DDA3C1D80' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '25492DD0-14C5-4C36-BE15-90F3DB9EA684' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '25492DD0-14C5-4C36-BE15-90F3DB9EA684' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F89B9DF5-B308-4530-807D-BC6073529B4E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F89B9DF5-B308-4530-807D-BC6073529B4E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7928D804-8AB1-4414-A605-0849FC6EB00F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7928D804-8AB1-4414-A605-0849FC6EB00F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3321C035-D763-468A-AB44-0B2C5AFB0F3C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3321C035-D763-468A-AB44-0B2C5AFB0F3C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4235DA50-92D2-4D37-AC5E-9AD1712423F8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4235DA50-92D2-4D37-AC5E-9AD1712423F8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '320B0B1D-CDC2-4B4E-8538-71B7FE2AD636' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '320B0B1D-CDC2-4B4E-8538-71B7FE2AD636' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'DAE766BB-AA4E-484C-A92A-14DEDD3FD6BD' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'DAE766BB-AA4E-484C-A92A-14DEDD3FD6BD' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'DAE8F6C8-96E3-4CE8-9C78-A4B94055BAFE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'DAE8F6C8-96E3-4CE8-9C78-A4B94055BAFE' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D27CA7C2-CE91-4CD8-AC92-712F848AF812' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D27CA7C2-CE91-4CD8-AC92-712F848AF812' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdForecast-Band0
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4D6C786D-8FD2-403D-A6B0-4C8D3C80C710' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4D6C786D-8FD2-403D-A6B0-4C8D3C80C710' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '08057C73-A188-4AF5-B6FF-D643B8972006' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '08057C73-A188-4AF5-B6FF-D643B8972006' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0488B06D-878E-4926-AB8B-06697D23FA12' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0488B06D-878E-4926-AB8B-06697D23FA12' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6640073F-BEEA-4193-9EE0-FF542E8BA046' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6640073F-BEEA-4193-9EE0-FF542E8BA046' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BCA5E915-025C-4DD7-9CFA-607083D6A7AC' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BCA5E915-025C-4DD7-9CFA-607083D6A7AC' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdForecast-Band1
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A320A33C-3152-4471-9282-E9BC10683881' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A320A33C-3152-4471-9282-E9BC10683881' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6C9E8F88-38E1-4452-9C4F-192DA286CEDA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6C9E8F88-38E1-4452-9C4F-192DA286CEDA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5DFB001D-EF74-40C6-BF84-DB231AE8751E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5DFB001D-EF74-40C6-BF84-DB231AE8751E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E6E93FF8-9C29-4AC9-9ACD-03608CB3752A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E6E93FF8-9C29-4AC9-9ACD-03608CB3752A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0D64BBE2-D154-42F6-B7A7-1F0C35AE3FD3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0D64BBE2-D154-42F6-B7A7-1F0C35AE3FD3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '68959F73-57F1-42E2-9EBB-0457879A2667' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '68959F73-57F1-42E2-9EBB-0457879A2667' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A99DA9C6-F779-4F35-98E7-7690AB066F12' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A99DA9C6-F779-4F35-98E7-7690AB066F12' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '50CA8864-8F17-4307-8934-B8EB3F078B40' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '50CA8864-8F17-4307-8934-B8EB3F078B40' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D6D06AB5-E75F-4B14-B8AC-2C3D687B97E8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D6D06AB5-E75F-4B14-B8AC-2C3D687B97E8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '19558138-3007-40DE-9930-D0E93640DD4F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '19558138-3007-40DE-9930-D0E93640DD4F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '67440433-5E36-4506-B533-AB44DF4CED29' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '67440433-5E36-4506-B533-AB44DF4CED29' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F69F09E9-FE85-4D56-A087-EADB2E1C98E2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F69F09E9-FE85-4D56-A087-EADB2E1C98E2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BF02DFF7-72AE-4A35-A0AF-614410D19E88' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BF02DFF7-72AE-4A35-A0AF-614410D19E88' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '13B3E31F-447A-4431-B828-3C14CA910D18' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '13B3E31F-447A-4431-B828-3C14CA910D18' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '32C53C46-069A-4A77-AA0A-A44C707B12E3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '32C53C46-069A-4A77-AA0A-A44C707B12E3' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- 	FillgrdHoursCustomerPortal
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '44847A67-EBFD-4A5D-9B0A-93FCD4710B49' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '44847A67-EBFD-4A5D-9B0A-93FCD4710B49' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8D00540E-EF8F-4799-A563-801651E9CFB2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8D00540E-EF8F-4799-A563-801651E9CFB2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0CE06DB0-025D-481C-8427-372E436B1561' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0CE06DB0-025D-481C-8427-372E436B1561' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6BC1B7FB-79E8-4425-9CCE-81334F339E1C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6BC1B7FB-79E8-4425-9CCE-81334F339E1C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CC6FF800-E5F0-4FD7-B8E8-C072157284B3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CC6FF800-E5F0-4FD7-B8E8-C072157284B3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1C6B76FB-DF9C-4D25-A6CE-1023E28B0E4F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1C6B76FB-DF9C-4D25-A6CE-1023E28B0E4F' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdImportDefaults
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F7E84901-46E6-43EB-B912-7C4B92F7C808' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F7E84901-46E6-43EB-B912-7C4B92F7C808' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6259C4BF-3B43-4C33-90A5-5ADCE9F444FC' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6259C4BF-3B43-4C33-90A5-5ADCE9F444FC' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2CC52DAD-C243-4B6D-AA46-53DCEF8FF4C2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2CC52DAD-C243-4B6D-AA46-53DCEF8FF4C2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8DA7B8DD-EB28-464E-8B92-B6881D434664' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8DA7B8DD-EB28-464E-8B92-B6881D434664' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdInvoiceItemsD
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '156416C3-E58F-4B89-81A7-EB318FB1E71B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '156416C3-E58F-4B89-81A7-EB318FB1E71B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B0B65A68-BA56-48C3-AA29-DBA89676D702' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B0B65A68-BA56-48C3-AA29-DBA89676D702' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D2391764-3E46-4DE5-B2EF-A294BDED5E87' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D2391764-3E46-4DE5-B2EF-A294BDED5E87' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'DE2D1F97-6709-4ED5-90EE-44270F9EB6BC' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'DE2D1F97-6709-4ED5-90EE-44270F9EB6BC' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F685969F-1D84-44A5-B73B-510E1BA5E8AA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F685969F-1D84-44A5-B73B-510E1BA5E8AA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8B6880A8-D8D7-4E60-B4DB-E86F9A21D251' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8B6880A8-D8D7-4E60-B4DB-E86F9A21D251' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BB0FC3B7-F0BC-4DC5-B02A-3F8EB82507DF' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BB0FC3B7-F0BC-4DC5-B02A-3F8EB82507DF' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E2F68656-27F4-4B0A-84FB-B08BC516FDE5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E2F68656-27F4-4B0A-84FB-B08BC516FDE5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6F3C6D1A-EC83-4744-A9B6-9827CECACED7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6F3C6D1A-EC83-4744-A9B6-9827CECACED7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9CA19429-D997-4FE4-92A6-A1B6D0CF0262' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9CA19429-D997-4FE4-92A6-A1B6D0CF0262' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B97821ED-8F84-441B-914D-DFA1B86EADBF' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B97821ED-8F84-441B-914D-DFA1B86EADBF' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '23F54C8B-909B-47ED-9EF2-C2E83B240FC0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '23F54C8B-909B-47ED-9EF2-C2E83B240FC0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '69FB3F64-4D70-4A7B-8540-2DE8EEF7D732' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '69FB3F64-4D70-4A7B-8540-2DE8EEF7D732' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8FAB23CE-8827-4057-A238-DA72028C195E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8FAB23CE-8827-4057-A238-DA72028C195E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '466D26F0-A3FA-48B3-AF20-7C2DD8EA6EA0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '466D26F0-A3FA-48B3-AF20-7C2DD8EA6EA0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B9832E55-F038-48D2-8413-ADDBE9564FA8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B9832E55-F038-48D2-8413-ADDBE9564FA8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D31BD1E5-80B7-4E66-B1C8-5B4D4C6A4A48' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D31BD1E5-80B7-4E66-B1C8-5B4D4C6A4A48' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9CC9B357-FCFD-42D9-B311-5DA1D8B7F674' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9CC9B357-FCFD-42D9-B311-5DA1D8B7F674' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'FFB24888-C5C7-4BCF-9709-571302BAC534' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'FFB24888-C5C7-4BCF-9709-571302BAC534' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '20DB3E8E-F930-425F-8C14-CE81C6D0A47A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '20DB3E8E-F930-425F-8C14-CE81C6D0A47A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '57761483-F92B-4927-9C87-4D868E7FA907' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '57761483-F92B-4927-9C87-4D868E7FA907' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '783D42C3-D538-4821-BB83-E0A51642D612' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '783D42C3-D538-4821-BB83-E0A51642D612' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F8490EC9-FF08-4B89-B59D-4D2432B05007' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F8490EC9-FF08-4B89-B59D-4D2432B05007' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '56F5E437-DD7E-40F4-B66D-96AC92975F55' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '56F5E437-DD7E-40F4-B66D-96AC92975F55' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3CE410B4-A3DE-47C5-AB2E-AC71A1267322' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3CE410B4-A3DE-47C5-AB2E-AC71A1267322' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '130A726B-5C78-4C2D-873D-603249C5E264' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '130A726B-5C78-4C2D-873D-603249C5E264' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A83D6F74-87AA-48FA-91CD-9F71725FCDA0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A83D6F74-87AA-48FA-91CD-9F71725FCDA0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5D584F85-ED18-4F9E-A648-6D112CA05E7C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5D584F85-ED18-4F9E-A648-6D112CA05E7C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0E7E1A84-C750-4D96-BD8E-6F18AF905A3B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0E7E1A84-C750-4D96-BD8E-6F18AF905A3B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '380A6C14-07CD-4A7D-827C-459F635536AA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '380A6C14-07CD-4A7D-827C-459F635536AA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '660A7191-FEF0-492B-B853-02310004225A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '660A7191-FEF0-492B-B853-02310004225A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '173F3D57-0EB8-4FE8-B1B1-0D6F642870AD' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '173F3D57-0EB8-4FE8-B1B1-0D6F642870AD' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C25A69A6-0EA3-4F34-ABC5-F347EDAB1C5E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C25A69A6-0EA3-4F34-ABC5-F347EDAB1C5E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E4F9FAA0-5B3B-4E2E-91C6-849D0E1FD158' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E4F9FAA0-5B3B-4E2E-91C6-849D0E1FD158' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'EFEC8FB1-32FF-41C5-B0A3-F11A60A6B119' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'EFEC8FB1-32FF-41C5-B0A3-F11A60A6B119' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C5CAB66A-5063-482F-9192-4C0849E5D641' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C5CAB66A-5063-482F-9192-4C0849E5D641' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '35FEBA4B-4593-450B-940B-2D9862988190' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '35FEBA4B-4593-450B-940B-2D9862988190' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AF1646F0-4CD5-4689-AD52-4C824D8B21AD' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AF1646F0-4CD5-4689-AD52-4C824D8B21AD' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C1999E56-EBA1-4DBB-A711-6F696A1F91FB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C1999E56-EBA1-4DBB-A711-6F696A1F91FB' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdJobNumberFiles
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '948552E8-50A8-44B8-940C-41BC1EAAADA0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '948552E8-50A8-44B8-940C-41BC1EAAADA0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '70FEE515-68A7-47F2-B704-F94C0B194C1F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '70FEE515-68A7-47F2-B704-F94C0B194C1F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'DA30C55B-F7A0-462A-B2D5-167FDC06EFCF' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'DA30C55B-F7A0-462A-B2D5-167FDC06EFCF' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '75D350E3-4712-40E1-B6AC-EE2B6FB219AA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '75D350E3-4712-40E1-B6AC-EE2B6FB219AA' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdLabProductivity
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8D7D7873-52F1-4FFA-A993-95184A9E88A3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8D7D7873-52F1-4FFA-A993-95184A9E88A3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7E2C8159-ADCC-4005-96E3-BEB90B44C47C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7E2C8159-ADCC-4005-96E3-BEB90B44C47C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '15336C56-6FE3-47B0-A1E7-1E7AC440B10A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '15336C56-6FE3-47B0-A1E7-1E7AC440B10A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '19CBAD28-3A6F-4FB9-858B-E124A0D9D30C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '19CBAD28-3A6F-4FB9-858B-E124A0D9D30C' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdLabs
	-- FillgrdProjectJobNumbers
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6633F819-BA2D-497C-BBD6-D8A4E6272A82' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6633F819-BA2D-497C-BBD6-D8A4E6272A82' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '08F1F616-991C-43BD-868F-FBAA81CE49F9' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '08F1F616-991C-43BD-868F-FBAA81CE49F9' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillGrdRecallCustomerPortal
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '62167867-9DFC-4E5D-89E6-05B6FBEAB483' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '62167867-9DFC-4E5D-89E6-05B6FBEAB483' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5BE305CF-4733-41ED-A804-3CB94E43A278' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5BE305CF-4733-41ED-A804-3CB94E43A278' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '472CDC79-7C6E-44E5-A29F-734E45834E8D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '472CDC79-7C6E-44E5-A29F-734E45834E8D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '749D8C60-C164-47DC-A976-0598D414FA5B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '749D8C60-C164-47DC-A976-0598D414FA5B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8AA27C51-FC3F-40ED-9342-A8C31229FEBB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8AA27C51-FC3F-40ED-9342-A8C31229FEBB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'EA54B242-A54A-40A8-B247-A5E54E03CEEB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'EA54B242-A54A-40A8-B247-A5E54E03CEEB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8C595D9D-1976-45C7-ABD7-7FFAC608C51F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8C595D9D-1976-45C7-ABD7-7FFAC608C51F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C3927E8E-2FC7-4B58-A7B9-7084D8B53427' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C3927E8E-2FC7-4B58-A7B9-7084D8B53427' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5FB302BB-4011-4133-8870-2D9BB511D369' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5FB302BB-4011-4133-8870-2D9BB511D369' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C4E515D0-5895-4CF4-8709-CD06E17EEE82' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C4E515D0-5895-4CF4-8709-CD06E17EEE82' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4A8856F1-2E24-4797-B9F0-AF4D68FD9E61' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4A8856F1-2E24-4797-B9F0-AF4D68FD9E61' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F851985C-3D9F-4949-9D42-0DC2AFFEDB74' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F851985C-3D9F-4949-9D42-0DC2AFFEDB74' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillGrdReceiving
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D4FB8F7A-6839-4D2D-A162-BDE486D39055' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D4FB8F7A-6839-4D2D-A162-BDE486D39055' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '52D75E9D-B493-45A5-A68E-4CBEC8FB0B8A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '52D75E9D-B493-45A5-A68E-4CBEC8FB0B8A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F5ADC6B3-24F6-41F8-A6C1-44448119FE7C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F5ADC6B3-24F6-41F8-A6C1-44448119FE7C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B3AAD2A1-0881-4A49-B8F9-3B6D7967E945' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B3AAD2A1-0881-4A49-B8F9-3B6D7967E945' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '46ACC443-E2B0-4CFF-A49D-777B9B8319BB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '46ACC443-E2B0-4CFF-A49D-777B9B8319BB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BE10E227-4B95-436A-BB2E-D66178A9AFFC' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BE10E227-4B95-436A-BB2E-D66178A9AFFC' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C234022C-4B12-4513-9DF5-6ED64EE4D750' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C234022C-4B12-4513-9DF5-6ED64EE4D750' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3F73FE74-A129-4C32-B76C-E7153E4C47CC' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3F73FE74-A129-4C32-B76C-E7153E4C47CC' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BB71668C-203C-4C16-B0BB-471872CF8E8D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BB71668C-203C-4C16-B0BB-471872CF8E8D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CA569ABD-C655-402A-93FA-F82E2BC7AA30' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CA569ABD-C655-402A-93FA-F82E2BC7AA30' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4556CC44-2ADE-4CA3-AB03-F12B751682E1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4556CC44-2ADE-4CA3-AB03-F12B751682E1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '24B4D47F-6391-45C7-A2F9-B81F59B7E954' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '24B4D47F-6391-45C7-A2F9-B81F59B7E954' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '14A5C80C-B1F2-440F-A7DB-0D4576354138' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '14A5C80C-B1F2-440F-A7DB-0D4576354138' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E951745C-A62D-40F5-8CF5-8F775B16A38C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E951745C-A62D-40F5-8CF5-8F775B16A38C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BC68F5C4-11E1-4DFC-9152-F836EC1E7968' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BC68F5C4-11E1-4DFC-9152-F836EC1E7968' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '29DF4E7A-2B0D-40FB-B04A-FDA1E8F8FE61' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '29DF4E7A-2B0D-40FB-B04A-FDA1E8F8FE61' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BDBAEA3C-D91B-493E-B8DE-3F1C803265CE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BDBAEA3C-D91B-493E-B8DE-3F1C803265CE' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'EC79C718-BFCB-4C7C-9D42-095EFF3CF83C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'EC79C718-BFCB-4C7C-9D42-095EFF3CF83C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '95966B17-6EAB-4615-8C03-F1E99FE7382E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '95966B17-6EAB-4615-8C03-F1E99FE7382E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '01D749AD-D8DE-4EF7-9050-90EF705E7207' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '01D749AD-D8DE-4EF7-9050-90EF705E7207' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9F6CD445-7A65-42CC-A513-374E58E0C926' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9F6CD445-7A65-42CC-A513-374E58E0C926' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C86BF653-C09E-4F23-B616-C9D5B86C8284' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C86BF653-C09E-4F23-B616-C9D5B86C8284' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdRecipients-Band1
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D1412FFB-7A5E-4616-BF29-7EA815B130B3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D1412FFB-7A5E-4616-BF29-7EA815B130B3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A17A3E8E-3BA3-4AFC-A711-DB2AD29BBFB1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A17A3E8E-3BA3-4AFC-A711-DB2AD29BBFB1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1C70622D-9E19-4C34-9CDF-2A1C7E111079' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1C70622D-9E19-4C34-9CDF-2A1C7E111079' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'FD5BEE2D-29B0-428C-86B6-171666923BAF' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'FD5BEE2D-29B0-428C-86B6-171666923BAF' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5FE8E767-2119-4954-8C84-8E0C047CDCAE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5FE8E767-2119-4954-8C84-8E0C047CDCAE' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CEC4CF70-DF7A-42A7-A565-DDC7FAEC2D43' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CEC4CF70-DF7A-42A7-A565-DDC7FAEC2D43' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'EF277CE4-9741-47B1-AE29-76B82FD247C2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'EF277CE4-9741-47B1-AE29-76B82FD247C2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C894F0D0-9E4C-44E3-9243-6038042EE72E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C894F0D0-9E4C-44E3-9243-6038042EE72E' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdServicesDue-Band1
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D3F545D8-A159-4E07-88CA-CBA3AA74DEF7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D3F545D8-A159-4E07-88CA-CBA3AA74DEF7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0019E12B-F0EE-4AF8-AEA5-911358132383' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0019E12B-F0EE-4AF8-AEA5-911358132383' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'EF09E0F4-414D-41D8-B35B-EF6785BC47C2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'EF09E0F4-414D-41D8-B35B-EF6785BC47C2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D6CB026F-0FD4-4545-B39F-E947BC7C42A5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D6CB026F-0FD4-4545-B39F-E947BC7C42A5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '459D3CD5-538E-4D94-BADB-5A136DC1D8C1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '459D3CD5-538E-4D94-BADB-5A136DC1D8C1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '183FAED0-422C-43BF-8577-432C4932A30B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '183FAED0-422C-43BF-8577-432C4932A30B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E283DF3D-093F-4E8C-B014-0D11F9AB4474' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E283DF3D-093F-4E8C-B014-0D11F9AB4474' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '392A8E80-0EC8-41E2-AF35-BE930D4988BA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '392A8E80-0EC8-41E2-AF35-BE930D4988BA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'FFA0FAE4-9D2C-4379-8206-4502291BD425' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'FFA0FAE4-9D2C-4379-8206-4502291BD425' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6C3A1F09-FF87-4A9A-82CF-A46BCBD2DD0E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6C3A1F09-FF87-4A9A-82CF-A46BCBD2DD0E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5533C257-0F5F-49A4-B597-A68A2DC35EFB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5533C257-0F5F-49A4-B597-A68A2DC35EFB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C090ABD5-6851-4FAC-8F42-D996A1092B64' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C090ABD5-6851-4FAC-8F42-D996A1092B64' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8D0FC26C-B78F-44BB-9B7A-2EF690BD221B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8D0FC26C-B78F-44BB-9B7A-2EF690BD221B' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdTechProd-Band0
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '99DB07EF-E092-444D-AF60-B9B4B43E3F3F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '99DB07EF-E092-444D-AF60-B9B4B43E3F3F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '90E7E3C8-0F27-4F94-B80E-9D08089D4AE2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '90E7E3C8-0F27-4F94-B80E-9D08089D4AE2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A0870CF2-D850-469F-B2B3-BA460F4D5573' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A0870CF2-D850-469F-B2B3-BA460F4D5573' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdTechProd-Band1
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BA4E79DC-A076-4257-843F-B9E8DD8AA959' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BA4E79DC-A076-4257-843F-B9E8DD8AA959' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B424A409-9FAE-4A3B-96C7-1E33A88431BB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B424A409-9FAE-4A3B-96C7-1E33A88431BB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '40A69A3C-ECF1-4D45-80BC-FE9EFBD8585A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '40A69A3C-ECF1-4D45-80BC-FE9EFBD8585A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A7AC069A-C527-4A20-84DD-F924443A4CF0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A7AC069A-C527-4A20-84DD-F924443A4CF0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CB66BB83-2943-4E04-A621-4AB53AF365E9' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CB66BB83-2943-4E04-A621-4AB53AF365E9' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '68A07E3C-4202-4D87-9983-4E9E4A31EB80' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '68A07E3C-4202-4D87-9983-4E9E4A31EB80' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6E4712F5-B86C-4631-A857-9C2B7937D5C8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6E4712F5-B86C-4631-A857-9C2B7937D5C8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '758F794A-EED4-46DC-AFE2-00097DEF6FB6' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '758F794A-EED4-46DC-AFE2-00097DEF6FB6' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BEBC8158-7CA1-4E73-A147-05D68B853636' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BEBC8158-7CA1-4E73-A147-05D68B853636' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8A9434F7-5009-4850-8296-C0BBD64BA771' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8A9434F7-5009-4850-8296-C0BBD64BA771' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdTemplateItems
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'EDF9300C-F338-4695-9A3A-B68735D3ABB2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'EDF9300C-F338-4695-9A3A-B68735D3ABB2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9D96FE53-B9D9-48BA-B7B0-34FCF540A71B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9D96FE53-B9D9-48BA-B7B0-34FCF540A71B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4F4D346E-1557-4E6F-97EE-AF7723A81AE1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4F4D346E-1557-4E6F-97EE-AF7723A81AE1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E7C56897-38D2-4497-A842-868BD44BF622' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E7C56897-38D2-4497-A842-868BD44BF622' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BE97A580-8FD4-4AE3-8FF1-4DD40268DA74' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BE97A580-8FD4-4AE3-8FF1-4DD40268DA74' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '377C169C-E643-4D92-8307-1526BB4B4FF8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '377C169C-E643-4D92-8307-1526BB4B4FF8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AB6B7355-4E2F-4DF8-B64E-3AC4466B013A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AB6B7355-4E2F-4DF8-B64E-3AC4466B013A' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillGrdValidationsActive
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2968CC75-C5B3-4E6F-B33B-7374895F91F4' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2968CC75-C5B3-4E6F-B33B-7374895F91F4' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BC7528D4-143D-46B4-94AC-2E42281608BF' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BC7528D4-143D-46B4-94AC-2E42281608BF' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AB310E6F-95B1-4636-BC99-A8DE7C6AF04C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AB310E6F-95B1-4636-BC99-A8DE7C6AF04C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'FF55F7B6-CCF5-4436-8518-BB47E12D1433' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'FF55F7B6-CCF5-4436-8518-BB47E12D1433' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '95858C82-3DA8-4C7F-AD34-44FD792F90A9' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '95858C82-3DA8-4C7F-AD34-44FD792F90A9' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillGrdValidationsAll
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'EF181300-6F56-4218-9333-DC9F12B69D28' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'EF181300-6F56-4218-9333-DC9F12B69D28' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '674DDC85-0AA8-4C59-8A33-E6D6775BAF80' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '674DDC85-0AA8-4C59-8A33-E6D6775BAF80' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0A7ACA67-D6DF-45E2-AAEC-2B942BD0F318' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0A7ACA67-D6DF-45E2-AAEC-2B942BD0F318' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '174117FB-2470-4DE0-A9F9-62972995976F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '174117FB-2470-4DE0-A9F9-62972995976F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'FEB14192-FD90-463D-AFB9-69867E4AF34D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'FEB14192-FD90-463D-AFB9-69867E4AF34D' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillgrdWIP-Band1
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C60EDBDA-7076-4EC1-9F12-BCFAA377E567' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C60EDBDA-7076-4EC1-9F12-BCFAA377E567' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2FB32049-751A-40EE-984A-8B810CB6FBC3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2FB32049-751A-40EE-984A-8B810CB6FBC3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '82570FC1-F689-4D90-AC5E-58FE9105586C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '82570FC1-F689-4D90-AC5E-58FE9105586C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B6D7830A-8794-4287-8E65-FD307DAE4903' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B6D7830A-8794-4287-8E65-FD307DAE4903' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '78CFF918-A414-42E3-B445-7320279C59D4' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '78CFF918-A414-42E3-B445-7320279C59D4' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C9E59CC6-5290-4225-90A3-C4DEEFF0DE5B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C9E59CC6-5290-4225-90A3-C4DEEFF0DE5B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BD08EF2F-FC61-40F9-BC1F-C9B8A36651A8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BD08EF2F-FC61-40F9-BC1F-C9B8A36651A8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D94B2214-6BA8-4AD8-9DB2-B08207E4162B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D94B2214-6BA8-4AD8-9DB2-B08207E4162B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'DDE54487-4A1C-4899-A0A6-05DA2A87DDD2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'DDE54487-4A1C-4899-A0A6-05DA2A87DDD2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3BA14FFE-4AFD-4AF6-BF90-5290F760FA13' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3BA14FFE-4AFD-4AF6-BF90-5290F760FA13' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '66187F69-43C0-42EA-ACF2-D8C6C664827A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '66187F69-43C0-42EA-ACF2-D8C6C664827A' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- AuditHistory-Band0
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '916D5938-AC5A-428C-9490-AB86F7C4364E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '916D5938-AC5A-428C-9490-AB86F7C4364E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8EEE07CD-0351-4F8F-834E-CEA437532EDC' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8EEE07CD-0351-4F8F-834E-CEA437532EDC' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E91577D7-8DF7-4934-B53E-084FC5B8ABBB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E91577D7-8DF7-4934-B53E-084FC5B8ABBB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'ABCFFC44-DED9-4757-8255-C32DFA684B17' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'ABCFFC44-DED9-4757-8255-C32DFA684B17' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6229F7BA-B945-462D-987C-C49C6836A938' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6229F7BA-B945-462D-987C-C49C6836A938' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7F432F7E-C7D8-43FB-A34B-C1F871D803AA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7F432F7E-C7D8-43FB-A34B-C1F871D803AA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D7E4965B-95CF-4F5B-BAA3-82C8719CD224' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D7E4965B-95CF-4F5B-BAA3-82C8719CD224' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- AuditHistory-Band1
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'FE27BD6D-B2AD-4727-B399-6E68186F5BA3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'FE27BD6D-B2AD-4727-B399-6E68186F5BA3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8B032985-07DF-4D84-85A3-B020373D188D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8B032985-07DF-4D84-85A3-B020373D188D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C559B081-4865-4C30-BF17-D5AAF1BAAEF0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C559B081-4865-4C30-BF17-D5AAF1BAAEF0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5A6D2FE2-24C0-4A84-B86F-C8612A4BBA46' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5A6D2FE2-24C0-4A84-B86F-C8612A4BBA46' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5C5229BB-0429-49F1-9D29-562A3EAA0AC1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5C5229BB-0429-49F1-9D29-562A3EAA0AC1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '336357E6-C66F-473D-A2F9-5CD38A8B4EF3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '336357E6-C66F-473D-A2F9-5CD38A8B4EF3' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- BuildAssetDetail
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7DDA8E12-A8A2-40DC-AA7A-7AC6F9247C63' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7DDA8E12-A8A2-40DC-AA7A-7AC6F9247C63' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AE1E8C94-04A8-46CC-BD5C-F211A524D3BA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AE1E8C94-04A8-46CC-BD5C-F211A524D3BA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C814AC6F-9965-43CC-BDF9-D6319859CEA7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C814AC6F-9965-43CC-BDF9-D6319859CEA7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A45D437E-F272-4B48-AD9D-621E969D69D0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A45D437E-F272-4B48-AD9D-621E969D69D0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'FF06E4DC-72A7-4906-984D-4E2C602C8CC9' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'FF06E4DC-72A7-4906-984D-4E2C602C8CC9' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8949A47E-1F00-47D1-9F64-F9732C094988' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8949A47E-1F00-47D1-9F64-F9732C094988' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E7A3FA44-BA7E-419B-A801-7542ADC80E0E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E7A3FA44-BA7E-419B-A801-7542ADC80E0E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '27AA4C2C-A882-4954-BBBB-8CA7B3B39007' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '27AA4C2C-A882-4954-BBBB-8CA7B3B39007' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E61EEAD3-D8A4-4FB2-9299-C36961F7B36D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E61EEAD3-D8A4-4FB2-9299-C36961F7B36D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '60D2DD6B-3B1D-4A79-A06F-0AE2EF311265' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '60D2DD6B-3B1D-4A79-A06F-0AE2EF311265' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '28E0EC1F-9F4B-42E9-81F5-38E0F7A40D17' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '28E0EC1F-9F4B-42E9-81F5-38E0F7A40D17' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E7690418-0751-4FF0-9D01-80EE54DFAC0C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E7690418-0751-4FF0-9D01-80EE54DFAC0C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'DB83BAD0-583E-4A90-9FEF-2FD2AA7C6053' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'DB83BAD0-583E-4A90-9FEF-2FD2AA7C6053' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4AF17512-60DC-48BE-A2FF-6BD005369078' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4AF17512-60DC-48BE-A2FF-6BD005369078' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '17C50C16-2A27-4B78-BAFB-AF2FC189DDF9' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '17C50C16-2A27-4B78-BAFB-AF2FC189DDF9' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- BuildCallSheets
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3FC4121C-1ED7-4F17-B7D5-210C5D6D5684' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3FC4121C-1ED7-4F17-B7D5-210C5D6D5684' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8F912FB5-52AC-4C4F-8F77-9A9CD6BFC858' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8F912FB5-52AC-4C4F-8F77-9A9CD6BFC858' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'EE2ECA00-FFD3-4DD6-A286-1FF5BDDCAE49' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'EE2ECA00-FFD3-4DD6-A286-1FF5BDDCAE49' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '068B25E3-4D1B-40D2-A8D3-9A8884C36C2C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '068B25E3-4D1B-40D2-A8D3-9A8884C36C2C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F669E920-C6ED-42F6-BBA7-F5D06536C489' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F669E920-C6ED-42F6-BBA7-F5D06536C489' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '043D757C-EF83-48AA-B129-67531379EB0C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '043D757C-EF83-48AA-B129-67531379EB0C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '879051FA-9F3A-4FDE-9B0A-6D6E4E91A8BB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '879051FA-9F3A-4FDE-9B0A-6D6E4E91A8BB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7E68B74A-676E-47C1-A3B6-2EFD7888F3A0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7E68B74A-676E-47C1-A3B6-2EFD7888F3A0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1A96B3AE-7283-4628-8E5E-EDAC4D7B93E1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1A96B3AE-7283-4628-8E5E-EDAC4D7B93E1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '97DA34E7-0FA2-4C01-9789-ED37FC4C7826' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '97DA34E7-0FA2-4C01-9789-ED37FC4C7826' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A86D1490-9C8F-4127-AA62-C9607D150CFC' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A86D1490-9C8F-4127-AA62-C9607D150CFC' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2CB1B9A7-45AD-4EEB-B1DE-EF2E6441E647' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2CB1B9A7-45AD-4EEB-B1DE-EF2E6441E647' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '101297F3-C095-4306-92C6-3C60C583B61D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '101297F3-C095-4306-92C6-3C60C583B61D' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- BuildEmailReport
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2BCD6C65-4E30-44BF-93F4-8433A6F497D0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2BCD6C65-4E30-44BF-93F4-8433A6F497D0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6F03A98C-F1F4-4B5E-BDE9-DCDEFDA2CA6E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6F03A98C-F1F4-4B5E-BDE9-DCDEFDA2CA6E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CCF1CD5B-5CAE-477C-9326-372EC0C064B7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CCF1CD5B-5CAE-477C-9326-372EC0C064B7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '400CC7AE-F01B-47D1-A3DF-0AB7B8C187FA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '400CC7AE-F01B-47D1-A3DF-0AB7B8C187FA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AA0D3010-457C-42B8-A58A-6F0D6EA0E667' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AA0D3010-457C-42B8-A58A-6F0D6EA0E667' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7B5BF226-5DAF-47C5-A558-9D0EE6D8C4BE' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7B5BF226-5DAF-47C5-A558-9D0EE6D8C4BE' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0CD91DD1-94C1-4EBA-B2F1-40C21768FE86' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0CD91DD1-94C1-4EBA-B2F1-40C21768FE86' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BA6A4D08-5428-4948-BAB8-16F6B202DEA5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BA6A4D08-5428-4948-BAB8-16F6B202DEA5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CE526852-EE03-4B2A-A632-60A2C9260B0C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CE526852-EE03-4B2A-A632-60A2C9260B0C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C765A96A-7CBA-4899-888A-5E5952ABB2DC' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C765A96A-7CBA-4899-888A-5E5952ABB2DC' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- BuildEmailSummary
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A3CC43D8-7ADF-4763-9AC3-F69F6A2C559A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A3CC43D8-7ADF-4763-9AC3-F69F6A2C559A' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- BuildEmailSummaryPastDue
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B9917345-4B96-41CB-B656-23D3232D588C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B9917345-4B96-41CB-B656-23D3232D588C' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- BuildPackingList
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'EA9ED27E-2A1B-4133-A889-D4A7D554917B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'EA9ED27E-2A1B-4133-A889-D4A7D554917B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'DCB3EFEE-5F20-430D-BD80-0D9400E98B57' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'DCB3EFEE-5F20-430D-BD80-0D9400E98B57' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3C79B0B1-598D-431C-B7AC-D6DC69F71AD7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3C79B0B1-598D-431C-B7AC-D6DC69F71AD7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'FA1EFBCF-D07F-4C9E-A5AF-9F2153794424' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'FA1EFBCF-D07F-4C9E-A5AF-9F2153794424' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '76727520-A79C-4FF2-BCFA-0A6774B48A38' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '76727520-A79C-4FF2-BCFA-0A6774B48A38' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C94FEE4E-325A-4183-B611-1590D7612EAD' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C94FEE4E-325A-4183-B611-1590D7612EAD' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C3AA04F9-40FC-4BAC-AD5D-765BD4141319' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C3AA04F9-40FC-4BAC-AD5D-765BD4141319' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3537B02C-E031-494B-BB50-9D525321C22C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3537B02C-E031-494B-BB50-9D525321C22C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '09C89679-0367-4376-9026-9C07F905A816' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '09C89679-0367-4376-9026-9C07F905A816' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '04169035-2EFD-4BB9-BFF5-EB59A5FD1E45' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '04169035-2EFD-4BB9-BFF5-EB59A5FD1E45' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A133A5F7-15AA-4114-8955-82FC213A8500' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A133A5F7-15AA-4114-8955-82FC213A8500' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '94CA5EA0-6AB1-421F-8671-919FA634D6C2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '94CA5EA0-6AB1-421F-8671-919FA634D6C2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'FE49855B-FE0C-4639-BB56-65B5564026F8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'FE49855B-FE0C-4639-BB56-65B5564026F8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E5F4FFCD-0A77-49E1-85C0-AFA69879163C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E5F4FFCD-0A77-49E1-85C0-AFA69879163C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'DC9F3BA4-33ED-448D-AF4B-F22630EFA08F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'DC9F3BA4-33ED-448D-AF4B-F22630EFA08F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '369F5807-2F36-451C-B500-1511621C045B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '369F5807-2F36-451C-B500-1511621C045B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '158CBF34-BB9C-4EA5-9E0F-2C3103313725' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '158CBF34-BB9C-4EA5-9E0F-2C3103313725' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8DE3F42E-55BE-4BE3-886D-59109E5B1DEB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8DE3F42E-55BE-4BE3-886D-59109E5B1DEB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AC8AC450-8805-4D2C-9E89-72B27281B97F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AC8AC450-8805-4D2C-9E89-72B27281B97F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B9A49976-C83F-43CA-9913-47CA951D4E09' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B9A49976-C83F-43CA-9913-47CA951D4E09' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5E29F985-2566-45EF-A8E4-4A259993AB96' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5E29F985-2566-45EF-A8E4-4A259993AB96' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A9F7A5DC-6503-4540-8871-B6A9FEE16BC4' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A9F7A5DC-6503-4540-8871-B6A9FEE16BC4' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9F2FD708-1A39-40F7-BAF1-CC8BEB6C4089' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9F2FD708-1A39-40F7-BAF1-CC8BEB6C4089' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D9A54090-ACF0-471A-A7A7-408E5F84C3BA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D9A54090-ACF0-471A-A7A7-408E5F84C3BA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4AFC19F5-41FE-45A6-BFBC-1EEF85EA7342' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4AFC19F5-41FE-45A6-BFBC-1EEF85EA7342' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F04F441C-6664-413B-92DB-05A54E3107FB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F04F441C-6664-413B-92DB-05A54E3107FB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '73B10D5D-C218-4E9E-B9D7-8B89D8A3D3C0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '73B10D5D-C218-4E9E-B9D7-8B89D8A3D3C0' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- BuildTempAsset
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '105A5492-2083-4DC5-AFBB-D90BF58F2805' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '105A5492-2083-4DC5-AFBB-D90BF58F2805' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5BC0C24E-7311-4244-B07A-BC7D05CD2665' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5BC0C24E-7311-4244-B07A-BC7D05CD2665' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F1B75B6A-26E3-48B6-AF88-9ABFCC83D0EA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F1B75B6A-26E3-48B6-AF88-9ABFCC83D0EA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '74ED821A-573A-468F-BE8E-03BECD430C74' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '74ED821A-573A-468F-BE8E-03BECD430C74' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5EBDB445-2112-46C3-9382-A855001C6B5F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5EBDB445-2112-46C3-9382-A855001C6B5F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8155D4E2-4AD8-4B42-9AC2-2387C8C36B06' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8155D4E2-4AD8-4B42-9AC2-2387C8C36B06' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '91A0FC08-7AFA-410C-812F-5DE6CC42B6A9' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '91A0FC08-7AFA-410C-812F-5DE6CC42B6A9' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7D0E5EC2-1B61-4AEE-862A-B5FED0A51C49' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7D0E5EC2-1B61-4AEE-862A-B5FED0A51C49' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'DE6E03DD-292B-4770-BA58-BD71B81188D8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'DE6E03DD-292B-4770-BA58-BD71B81188D8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '90DE8342-1371-4937-B902-368A60B8384C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '90DE8342-1371-4937-B902-368A60B8384C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7CD9D1E7-1497-4BF4-B76C-F0F2B281F8C7' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7CD9D1E7-1497-4BF4-B76C-F0F2B281F8C7' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A2F43CF3-6D60-4D63-ADD3-2632D7DFD622' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A2F43CF3-6D60-4D63-ADD3-2632D7DFD622' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C82EBBEE-3C6E-41F7-BF8D-89EFD47DCDED' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C82EBBEE-3C6E-41F7-BF8D-89EFD47DCDED' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1D510843-CB7E-4C31-88D2-30CFD90B7CBA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1D510843-CB7E-4C31-88D2-30CFD90B7CBA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '48217B31-90F3-4BD9-BC11-F344BB8A05FC' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '48217B31-90F3-4BD9-BC11-F344BB8A05FC' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '78CB9E01-A3FE-4273-A17F-A3C7A82ED640' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '78CB9E01-A3FE-4273-A17F-A3C7A82ED640' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CFBC320A-D178-41FD-B9E7-049B2B014997' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CFBC320A-D178-41FD-B9E7-049B2B014997' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '686EA28C-C70F-46BC-9A83-8A2CB9EEB70A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '686EA28C-C70F-46BC-9A83-8A2CB9EEB70A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F84B82B2-CCAC-4A11-9BC5-5529D9B701AB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F84B82B2-CCAC-4A11-9BC5-5529D9B701AB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9D6A8B90-2A87-4DAF-97E8-A3EC34BD2F45' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9D6A8B90-2A87-4DAF-97E8-A3EC34BD2F45' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CBD5441A-C33F-468F-BE10-E456F85A48B5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CBD5441A-C33F-468F-BE10-E456F85A48B5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '69C3682C-AA72-4350-AD2D-9FE07B26A4E3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '69C3682C-AA72-4350-AD2D-9FE07B26A4E3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F53652C9-478B-44A0-82D1-6E0487A7D705' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F53652C9-478B-44A0-82D1-6E0487A7D705' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- BulkChangeFieldsAssets
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BE7FA23F-AA70-49B4-972D-1F1838041460' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BE7FA23F-AA70-49B4-972D-1F1838041460' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7FDFA6B2-825A-4DB9-8E0F-CCB0E71E46FF' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7FDFA6B2-825A-4DB9-8E0F-CCB0E71E46FF' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0ABE2CA8-C270-4DFE-B066-41CAB06997CD' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0ABE2CA8-C270-4DFE-B066-41CAB06997CD' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8D169782-53A7-4B11-AA01-97E5FBE0E193' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8D169782-53A7-4B11-AA01-97E5FBE0E193' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B5E71DCE-E77B-4C03-82FD-2EB821A2CE12' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B5E71DCE-E77B-4C03-82FD-2EB821A2CE12' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6229EA69-7208-484F-9D31-8791BDAC904D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6229EA69-7208-484F-9D31-8791BDAC904D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'FE21C032-B192-4CC4-BD53-6D50C3A1175A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'FE21C032-B192-4CC4-BD53-6D50C3A1175A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E43CA392-EFCE-4C4F-B915-F9AC89E9150B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E43CA392-EFCE-4C4F-B915-F9AC89E9150B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2321DD07-76BF-4A2C-AA58-A5DD0C4DA0C1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2321DD07-76BF-4A2C-AA58-A5DD0C4DA0C1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B5B989BD-C5E2-4E76-B3CB-90D3E828DC05' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B5B989BD-C5E2-4E76-B3CB-90D3E828DC05' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B9DC8D2D-CA3F-486A-9CA7-52D6D81FCD82' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B9DC8D2D-CA3F-486A-9CA7-52D6D81FCD82' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7DE8ACDC-EE20-4E3A-9B68-9B1A0A614FFB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7DE8ACDC-EE20-4E3A-9B68-9B1A0A614FFB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'EF9A7ACE-FEFE-4A52-93E2-E9E420043A98' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'EF9A7ACE-FEFE-4A52-93E2-E9E420043A98' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3F1106C3-AA27-4594-8F75-BDE869BA581C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3F1106C3-AA27-4594-8F75-BDE869BA581C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4F0258D3-613D-4571-A49A-344E77F27162' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4F0258D3-613D-4571-A49A-344E77F27162' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '75A55F92-3FCE-4B56-8D16-246688D43865' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '75A55F92-3FCE-4B56-8D16-246688D43865' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '03411513-3B22-4C80-8BDF-B0C7FE5A530A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '03411513-3B22-4C80-8BDF-B0C7FE5A530A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3094B893-30AE-427F-B15E-BB1807F720B1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '3094B893-30AE-427F-B15E-BB1807F720B1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F6F7E432-019A-47B8-BEE1-CF7399E4B500' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F6F7E432-019A-47B8-BEE1-CF7399E4B500' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8BD26E6B-14FB-42E1-8511-3C8C6378D420' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8BD26E6B-14FB-42E1-8511-3C8C6378D420' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B64D2713-B197-44EC-869B-39ECDE830ED5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B64D2713-B197-44EC-869B-39ECDE830ED5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AFB4F0EA-4509-4D6E-8C31-9235F2C77362' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AFB4F0EA-4509-4D6E-8C31-9235F2C77362' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '80BB8B2F-9413-4F18-99DB-E44C0AE987F9' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '80BB8B2F-9413-4F18-99DB-E44C0AE987F9' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1D30996A-13F3-4EE9-811E-81F495665492' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1D30996A-13F3-4EE9-811E-81F495665492' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F34C621A-A0AA-4A88-B0E6-E0F9EC8FCF72' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F34C621A-A0AA-4A88-B0E6-E0F9EC8FCF72' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '85D16950-6503-4E05-B7CA-48D860248452' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '85D16950-6503-4E05-B7CA-48D860248452' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B6CA4974-EFD9-413D-8884-F0D942212880' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B6CA4974-EFD9-413D-8884-F0D942212880' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F66358EF-DD10-42FA-A13C-943C0AC18A83' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F66358EF-DD10-42FA-A13C-943C0AC18A83' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C873FBBE-D978-4705-A719-F83BB66F4CA9' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C873FBBE-D978-4705-A719-F83BB66F4CA9' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '900AD96B-06D5-45ED-A5B6-F87646AA0CF4' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '900AD96B-06D5-45ED-A5B6-F87646AA0CF4' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9852F101-65C8-4C7E-B71A-6C1F5CB5ABDF' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9852F101-65C8-4C7E-B71A-6C1F5CB5ABDF' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5D74A1F2-9FC0-43A5-BD75-F7D4B7D51480' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5D74A1F2-9FC0-43A5-BD75-F7D4B7D51480' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6176DCD9-94F0-4C0A-B814-14FDE1289129' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6176DCD9-94F0-4C0A-B814-14FDE1289129' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '950DC536-4611-4D28-8930-C7C898FCDD3C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '950DC536-4611-4D28-8930-C7C898FCDD3C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '58049E35-4035-46C3-823D-7191AD5F89A3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '58049E35-4035-46C3-823D-7191AD5F89A3' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7D45038F-2386-43CA-B8AA-98E11B41CA83' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7D45038F-2386-43CA-B8AA-98E11B41CA83' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D5A5E805-412A-4841-AE03-7D9F3BF67D62' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D5A5E805-412A-4841-AE03-7D9F3BF67D62' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CD8F2F2A-2C6D-4EF7-A403-9F9F9F58AE01' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CD8F2F2A-2C6D-4EF7-A403-9F9F9F58AE01' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D8763716-9B6C-4FA4-9015-27BE2D2511ED' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D8763716-9B6C-4FA4-9015-27BE2D2511ED' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0F51DA27-9E1C-41C8-A968-C398661DE7E9' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0F51DA27-9E1C-41C8-A968-C398661DE7E9' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B4508A50-E093-475D-8621-B16619C57B97' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B4508A50-E093-475D-8621-B16619C57B97' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '02582BDD-1781-40E6-9329-101CB771D416' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '02582BDD-1781-40E6-9329-101CB771D416' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F1FB9B8E-042E-444B-96DA-0D2066360729' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F1FB9B8E-042E-444B-96DA-0D2066360729' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '33719AD1-0B85-4E42-9DA7-44A9094BD47B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '33719AD1-0B85-4E42-9DA7-44A9094BD47B' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '51AF278F-6133-40B3-B037-C667781A3195' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '51AF278F-6133-40B3-B037-C667781A3195' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- CallSheetTypes
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'ECAC326E-2AFF-4D56-838A-E40E6B6AE6AD' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'ECAC326E-2AFF-4D56-838A-E40E6B6AE6AD' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D346E6E4-8C20-4023-BC01-8EA58578AE07' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D346E6E4-8C20-4023-BC01-8EA58578AE07' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- DelWIP-Band0
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1C8D16B5-D7D1-4C81-9F59-FDC921CD5A86' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1C8D16B5-D7D1-4C81-9F59-FDC921CD5A86' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4CD481D8-2FD6-4F7D-BA26-88F0BACD9B36' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4CD481D8-2FD6-4F7D-BA26-88F0BACD9B36' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9DE54667-00FD-42C7-811D-5F671B619DF4' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9DE54667-00FD-42C7-811D-5F671B619DF4' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- DupsSelection-Band0
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '83AEC485-8ED7-4E1C-8F62-5381ABC39523' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '83AEC485-8ED7-4E1C-8F62-5381ABC39523' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AD7B39B3-CBBA-4BB1-97DF-E01A038226FC' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AD7B39B3-CBBA-4BB1-97DF-E01A038226FC' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '05710EE3-B394-412B-A927-6F3459293F76' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '05710EE3-B394-412B-A927-6F3459293F76' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C281298D-19BD-4F70-8FF6-68B10E98D060' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'C281298D-19BD-4F70-8FF6-68B10E98D060' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F0F83A2D-FA05-4F40-8749-FA7594A28693' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F0F83A2D-FA05-4F40-8749-FA7594A28693' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- DupsSelection-Band1
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '36743914-1780-451B-8C91-4DC87AFF5DBF' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '36743914-1780-451B-8C91-4DC87AFF5DBF' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '86093693-86CF-497D-ACA0-086D9E28FC1F' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '86093693-86CF-497D-ACA0-086D9E28FC1F' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '855F475F-C93F-4052-8A58-1F53EEC04142' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '855F475F-C93F-4052-8A58-1F53EEC04142' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- DupsWIP-Band0
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '90F1104B-9AC9-43AA-9C35-B37A05588802' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '90F1104B-9AC9-43AA-9C35-B37A05588802' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '31D6840F-5A57-4293-B82D-1F21C1895CD9' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '31D6840F-5A57-4293-B82D-1F21C1895CD9' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'BF0E330B-EED5-47DF-A489-48AD49B2051A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'BF0E330B-EED5-47DF-A489-48AD49B2051A' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- DupsWIP-Band1
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '230310E5-3DB0-48BB-B90E-1481E1337624' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '230310E5-3DB0-48BB-B90E-1481E1337624' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '69819CEB-06DB-4A2F-990B-C0D8B05F53D5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '69819CEB-06DB-4A2F-990B-C0D8B05F53D5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '8718AFF6-CECD-47D9-9F8E-9072E76D1E72' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '8718AFF6-CECD-47D9-9F8E-9072E76D1E72' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '600212D9-5B3A-40F6-ABEA-FA398C5F0E57' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '600212D9-5B3A-40F6-ABEA-FA398C5F0E57' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '47A442EE-4BFE-4158-ABC3-7D869DB6CBCF' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '47A442EE-4BFE-4158-ABC3-7D869DB6CBCF' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D6AC567B-8DC0-4E1B-92B2-5E8F3A46E5D2' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D6AC567B-8DC0-4E1B-92B2-5E8F3A46E5D2' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2E3F9E76-42C1-495C-AEA6-55B0FD950D67' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2E3F9E76-42C1-495C-AEA6-55B0FD950D67' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '54AC297C-ECD2-473F-B7A5-C8D3A250655C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '54AC297C-ECD2-473F-B7A5-C8D3A250655C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '676C4819-79C1-472E-9E58-6B7F6D8CB2AB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '676C4819-79C1-472E-9E58-6B7F6D8CB2AB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '163D8622-9790-4B06-842F-2AA615B9FC33' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '163D8622-9790-4B06-842F-2AA615B9FC33' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E574C370-5736-49A6-B868-EE2B43ABE8A8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E574C370-5736-49A6-B868-EE2B43ABE8A8' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- Escalation summary
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '456B5A56-CD4C-4230-A057-400D29E2C505' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '456B5A56-CD4C-4230-A057-400D29E2C505' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillAssetLog
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '6C79524F-6E53-4146-BDA3-2075D75C12A1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '6C79524F-6E53-4146-BDA3-2075D75C12A1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F8DF38AE-FF80-4E7F-8951-568DA72E1CE1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F8DF38AE-FF80-4E7F-8951-568DA72E1CE1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F8F4F44E-CC3D-4420-9D22-AC58026B6A83' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'F8F4F44E-CC3D-4420-9D22-AC58026B6A83' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '4A96F798-D4EA-4FA0-AAEC-8664BFE52852' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '4A96F798-D4EA-4FA0-AAEC-8664BFE52852' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9D657BE3-03C5-48FE-8D02-B7AF25FFB6E9' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9D657BE3-03C5-48FE-8D02-B7AF25FFB6E9' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '651042E3-661F-47BE-8E01-E6C0646B4E28' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '651042E3-661F-47BE-8E01-E6C0646B4E28' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '13E39001-EB61-43F8-99FB-8301438EAC8E' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '13E39001-EB61-43F8-99FB-8301438EAC8E' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0C5A426F-792E-4A8E-AB5D-60F795005558' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0C5A426F-792E-4A8E-AB5D-60F795005558' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '22D0A86F-53A0-4106-8528-52A70C83B9D1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '22D0A86F-53A0-4106-8528-52A70C83B9D1' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '7DFAD012-0708-4BC8-9D09-C49D023E6AD0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '7DFAD012-0708-4BC8-9D09-C49D023E6AD0' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- FillTechCallsheets
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2F6BC50C-42DF-4448-8F50-BE9B696268FB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2F6BC50C-42DF-4448-8F50-BE9B696268FB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A9663A38-CAED-4DCF-A12E-AD0F88E92B08' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A9663A38-CAED-4DCF-A12E-AD0F88E92B08' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A48D95C0-FF39-4B4F-A0D2-E2B7E37BA654' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A48D95C0-FF39-4B4F-A0D2-E2B7E37BA654' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AAB8BB9C-3FF2-4701-8FBB-9F3587F11345' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AAB8BB9C-3FF2-4701-8FBB-9F3587F11345' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '617FD103-6FA9-4C51-B1A0-9DD56BA38CBB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '617FD103-6FA9-4C51-B1A0-9DD56BA38CBB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'FD594BCC-7972-46FE-BCB7-3EF38897C12C' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'FD594BCC-7972-46FE-BCB7-3EF38897C12C' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '686147B2-4782-42B3-8156-58507135E5C5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '686147B2-4782-42B3-8156-58507135E5C5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '50C2AEF2-4C43-44DB-A5AA-B0AEF0765FF5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '50C2AEF2-4C43-44DB-A5AA-B0AEF0765FF5' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E942F24D-4CFB-45D9-BB81-A3EB1BAC7D62' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E942F24D-4CFB-45D9-BB81-A3EB1BAC7D62' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A96189CE-9E55-4FFB-817D-597CD55369B0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A96189CE-9E55-4FFB-817D-597CD55369B0' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '625B9E8D-DB52-4E3D-9BBF-3E4BB8BE03C8' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '625B9E8D-DB52-4E3D-9BBF-3E4BB8BE03C8' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '210C7FB1-7159-42F2-A58C-57D6ED5C0AFB' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '210C7FB1-7159-42F2-A58C-57D6ED5C0AFB' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D4A79365-2BB9-4158-A2DF-B1A67F3C6FE6' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D4A79365-2BB9-4158-A2DF-B1A67F3C6FE6' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9B5CD4DE-D826-4186-BF75-06821705D2EA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9B5CD4DE-D826-4186-BF75-06821705D2EA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B2CFE669-F144-46C0-AC94-8F332FF220BA' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B2CFE669-F144-46C0-AC94-8F332FF220BA' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A322F76F-F333-407B-B3F8-A348E5298A74' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A322F76F-F333-407B-B3F8-A348E5298A74' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2D001B89-C47B-4A4D-80FB-591DE7A48262' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '2D001B89-C47B-4A4D-80FB-591DE7A48262' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A512C2D0-A078-417E-89DC-DC22C3311A10' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A512C2D0-A078-417E-89DC-DC22C3311A10' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '94E828FC-EC34-4124-8EC3-14AC051799C1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '94E828FC-EC34-4124-8EC3-14AC051799C1' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- GetCAPO_MasterCallSheet
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'CB5C2D3B-C5EA-4140-826C-D88C774DED0B' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'CB5C2D3B-C5EA-4140-826C-D88C774DED0B' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- GetEscalationContacts
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'D262033C-F9AF-46F9-AE35-3DFF0F78B2BD' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'D262033C-F9AF-46F9-AE35-3DFF0F78B2BD' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- xTrackGetAssets
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'E8CFCA13-CE7C-4BEF-B6B0-38C0437C728D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'E8CFCA13-CE7C-4BEF-B6B0-38C0437C728D' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- 	xTrackGetCallSheets
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '704F2C65-BBF9-47FC-88EC-3936432B97FD' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '704F2C65-BBF9-47FC-88EC-3936432B97FD' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- xTrackGetFiles
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0520CAF0-B6DF-47A0-A027-CE413E0360D3' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '0520CAF0-B6DF-47A0-A027-CE413E0360D3' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- xTrackGetIPAssets
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '1C7BD480-70B9-4BFF-A50D-2AC1240E5A3A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '1C7BD480-70B9-4BFF-A50D-2AC1240E5A3A' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '669A0583-685F-4BC6-88C9-8F499147C293' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '669A0583-685F-4BC6-88C9-8F499147C293' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '146C0590-6A7D-40DA-BEE2-FDA403CCED2D' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '146C0590-6A7D-40DA-BEE2-FDA403CCED2D' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'B4F022C5-54B4-4A8C-B836-05BB38928C5A' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'B4F022C5-54B4-4A8C-B836-05BB38928C5A' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- xTrackGetIPCallSheets
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'AC758E0D-6DEC-49A5-8BF8-FBAEAA2A3315' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'AC758E0D-6DEC-49A5-8BF8-FBAEAA2A3315' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5CB29E78-92B7-4A85-9F12-5A463CECF861' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '5CB29E78-92B7-4A85-9F12-5A463CECF861' END
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'A0DF75F6-B8EC-4E2A-878A-710F2C198D04' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'A0DF75F6-B8EC-4E2A-878A-710F2C198D04' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- xTrackGetParts
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'DB736D6B-B9A5-4DB2-88D5-ED790BE1C7F1' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = 'DB736D6B-B9A5-4DB2-88D5-ED790BE1C7F1' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- xTrackGetReadings
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '286CD292-5EA0-4B37-8821-795E69FB32D5' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '286CD292-5EA0-4B37-8821-795E69FB32D5' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- xTrackGetStandards
	IF EXISTS (SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '9EA5FD7C-BBE3-4BDB-9C5A-CC3C0B5793E0' AND [lDefault] = 0) BEGIN UPDATE [dbo].[ContextElementLink] SET [lDefault] = -1 WHERE [nContextElementLinkUID] = '9EA5FD7C-BBE3-4BDB-9C5A-CC3C0B5793E0' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	IF OBJECT_ID(N'[dbo].[vw_AssetsWithEx]', 'V') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[vw_AssetsWithEx]'

		DROP VIEW [dbo].[vw_AssetsWithEx]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[vw_AssetsWithEx]', 'V') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[vw_AssetsWithEx]'

		EXEC sp_executesql N'
/********************************************************************
		vw_AssetsWithEx
		(C) 2013-20 Fluke Calibration
	-----------------------------------------------------------------
		CHANGE HISTORY
		10/21/2013	MM	Initial version (from vw_Assets)
		07/21/2014	MM	Fixed casts and quoted identifiers
		03/11/2015	MM	Exclude inactive and deleted EX records
		07/14/2015	MM	Formatting updated
		01/06/2016  MM  Added AssetServices.tMaintDate
		07/27/2020  MM  Join AssetServices - may appear to yield dups
	*****************************************************************/
	CREATE VIEW [dbo].[vw_AssetsWithEx]
	AS
	SELECT
		ass.[nAssetUID],
		ass.[nFacilityUID],
		ass.[nDepartmentUID],
		ass.[nTypeUID],
		ass.[nManufacturerUID],
		ass.[nCategoryUID],
		ass.[nSubCategoryUID],
		ass.[nInventoryByUID],
		ass.[nParentUID],
		ass.[nMaintenanceFacUID],
		ass.[nAssignedFacUID],
		ass.[nAuthorizedFacUID],
		ass.[cBarcode],
		ass.[cID],
		ass.[cSerialNumber],
		ass.[cModelNumber],
		ass.[cPartNumber],
		ass.[cStockNumber],
		ass.[cStatus],
		ass.[cDisposition],
		ass.[cAssignedGroup],
		ass.[cClass],
		ass.[cGroup],
		ass.[cFamily],
		ass.[cStandardType],
		ass.[cDescription],
		ass.[cPhysicalLocation],
		ass.[cWeightUOM],
		ass.[cWeight],
		ass.[cDimension],
		vas.[cServiceName] AS [cNextMaintType],
		vas.[cInterval],
		vas.[cIntervalUOM],
		ass.[nReplacementCost],
		ass.[nItemCost],
		ass.[tInventoryDate],
		ass.[tInServiceDate],
		ass.[tStatusDate],
		ass.[tPurchaseDate],
		vas.[tNextMaintDate],
		ass.[tAssignedGroupDate],
		ass.[tWarrantyDate],
		ass.[mWarrantyInfo],
		ass.[mAccuracy],
		ass.[mUncertaintyNotes],
		ass.[mNotes],
		ass.[lStandard],
		ass.[lRecallMaintenanceType],
		ass.[lInAbeyance],
		ass.[nAbeyanceInterval],
		ass.[nUseCount],
		ass.[nQuantity],
		ass.[lOnSite],
		ass.[lNonTracked],
		ass.[lActive],
		ass.[lDeleted],
		ass.[lApproved],
		ass.[lAdded],
		ass.[nAddFacilityUID],
		ass.[nAddUserUID],
		ass.[tAddTime],
		ass.[nUpdateFacilityUID],
		ass.[nUpdateUserUID],
		ass.[tUpdateTime],
		ass.[tMobileTime],
		ass.[tSystemUpdateTime],
		''None'' AS [cShipmentStatus],
		fac.[cFacilityName] AS [cFacilityName],
		fac.[cFacilityNumber] AS [cFacilityNumber],
		dep.[cFacilityName] AS [cDepartment],
		dep.[cFacilityNumber] AS [cDepartmentNumber],
		man.[cFacilityName] AS [cManufacturer],
		cat.[cDescription] AS [cCategory],
		scat.[cDescription] AS [cSubCategory],
		usr.[cFirstName] + '' '' + usr.[cLastName] AS [cInventoryBy],
		par.[cBarcode] AS [cParentBarcode],
		par.[cID] AS [cParentID],
		mfac.[cFacilityName] AS [cMaintenanceFacName],
		mfac.[cFacilityNumber] AS [cMaintenanceFacNumber],
		asfac.[cFacilityName] AS [cAssignedFacName],
		asfac.[cFacilityNumber] AS [cAssignedFacNumber],
		aufac.[cFacilityName] AS [cAuthorizedFacName],
		aufac.[cFacilityNumber] AS [cAuthorizedFacNumber],
		CAST (ass.[mWarrantyInfo] AS NTEXT) AS [mWarrantyInfoText],
		CAST (ass.[mAccuracy] AS NTEXT) AS [mAccuracyText],
		CAST (ass.[mUncertaintyNotes] AS NTEXT) AS [mUncertaintyNotesText],
		CAST (ass.[mNotes] AS NTEXT) AS [mNotesText],
		ty.[nTyItemCost],
		ty.[nTyReplacementCost],
		ty.[cTyModelNumber],
		ty.[cTyDescription],
		ty.[cTyPartNumber],
		ty.[cTyStockNumber],
		ty.[cTyAuthority],
		ty.[cTyClass],
		ty.[cTyFamily],
		ty.[cTyWeight],
		ty.[cTyWeightUOM],
		ty.[cTyDimension],
		ty.[cTyArea],
		ty.[mTyAccuracy],
		ty.[mTyUncertaintyNotes],
		ty.[mTyReceivingNotes],
		ty.[mTyNotes],
		ty.[lTyActive],
		ty.[lTyDeleted],
		ex.[cField1],
		ex.[cField2],
		ex.[cField3],
		ex.[cField4],
		ex.[cField5],
		ex.[cField6],
		ex.[cField7],
		ex.[cField8],
		ex.[cField9],
		ex.[cField10],
		ex.[cField11],
		ex.[cField12],
		ex.[cField13],
		ex.[cField14],
		ex.[cField15],
		ex.[cField16],
		ex.[cField17],
		ex.[cField18],
		ex.[cField19],
		ex.[cField20],
		ex.[cField21],
		ex.[cField22],
		ex.[cField23],
		ex.[cField24],
		ex.[cField25],
		ex.[cField26],
		ex.[cField27],
		ex.[cField28],
		ex.[cField29],
		ex.[cField30],
		ex.[cField31],
		ex.[cField32],
		ex.[cField33],
		ex.[cField34],
		ex.[cField35],
		ex.[tField1],
		ex.[tField2],
		ex.[tField3],
		ex.[tField4],
		ex.[tField5],
		ex.[tField6],
		ex.[tField7],
		ex.[tField8],
		ex.[tField9],
		ex.[tField10],
		ex.[nField1],
		ex.[nField2],
		ex.[nField3],
		ex.[nField4],
		ex.[nField5],
		ex.[nField6],
		ex.[nField7],
		ex.[nField8],
		ex.[nField9],
		ex.[nField10],
		ex.[lField1],
		ex.[lField2],
		ex.[lField3],
		ex.[lField4],
		ex.[lField5],
		ex.[lField6],
		ex.[lField7],
		ex.[lField8],
		ex.[lField9],
		ex.[lField10],
		ex.[mField1],
		ex.[mField2],
		ex.[lActive] AS [lExActive],
		ex.[lDeleted] AS [lExDeleted],
		vas.[tMaintDate]
	FROM
		Assets ass
	LEFT JOIN AssetEx ex ON ass.nAssetUID = ex.nAssetUID AND ex.lActive <> 0 AND ex.lDeleted = 0
	LEFT JOIN Facilities AS fac ON ass.nFacilityUID = fac.nFacilityUID
	LEFT JOIN vw_Types AS ty ON ass.nTypeUID = ty.nTyTypeUID
	LEFT JOIN Facilities AS man ON ass.nManufacturerUID = man.nFacilityUID
	LEFT JOIN Category AS cat ON ass.nCategoryUID = cat.nCategoryUID
	LEFT JOIN SubCategory AS scat ON ass.nSubCategoryUID = scat.nSubCategoryUID
	LEFT JOIN Users AS usr ON ass.nInventoryByUID = usr.nUserUID
	LEFT JOIN Assets AS par ON ass.nParentUID = par.nAssetUID
	LEFT JOIN Facilities AS mfac ON ass.nMaintenanceFacUID = mfac.nFacilityUID
	LEFT JOIN Facilities AS asfac ON ass.nAssignedFacUID = asfac.nFacilityUID
	LEFT JOIN Facilities AS aufac ON ass.nAuthorizedFacUID = aufac.nFacilityUID
	LEFT JOIN Facilities AS dep ON ass.nDepartmentUID = dep.nFacilityUID
	LEFT JOIN vw_AssetsWithServices vas ON ass.nAssetUID = vas.nAssetUID AND vas.ASV_lActive <> 0 AND vas.ST_lActive <> 0 AND vas.lRecalled <> 0
'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[udf_GetUCIGridByContext]') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GetUCIGridByContext]'

		DROP FUNCTION [dbo].[udf_GetUCIGridByContext]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[udf_GetUCIGridByContext]') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GetUCIGridByContext]'

		EXEC sp_executesql N'
/**************************************************************************************************************************
	udf_GetUCIGridByContext

	(C) 2011-2020 Fluke Calibration
---------------------------------------------------------------------------------------------------------------------------
	CHANGE HISTORY
     7/29/2011  --    Initially created
	10/12/2011	JP    Added checks for lDeleted and lActive on all tables
	12/15/2011	JP    Updated logic to use dbo.udf_UCIData_GetLabel (changed signature of this function)
	12/20/2011	JP    Updated 2 parameter names to: @cLabType, @cMode
	03/01/2012	EW    Added > ORDER BY cel.nOrder < to fix issue in some grids
	06/29/2012	EW    Changed declaration of cValue from varchar(7000) to nvarchar(max), matching ContextElemets schema.
	06/29/2012	EW    Changed declaration of ohther varchar opjects to nnvarchar matching existing schema.
	07/31/2012  MM    Include nUCIDataUID, to spot missing links to UCI Data when running as query
	11/15/2013  MM    Now includes ExDef in place of UCI Data, for extended data fields
	08/06/2015  MM    Added support for FieldList element
	09/10/2015  MM    Fixed missing ORDER BY context element value
	04/01/2016  MM    Changes for GUIDs
	07/30/2020  MM    Added parameters user uid and all columns to get configured / all columns
***************************************************************************************************************************/
CREATE FUNCTION [dbo].[udf_GetUCIGridByContext] (
		@cContext NVARCHAR(500)
		,@nCustomerUID [UNIQUEIDENTIFIER]
		,@nLabUID [UNIQUEIDENTIFIER]
		,@cLabType NVARCHAR(50)
		,@cMode NVARCHAR(50)
		,@nUserUID [UNIQUEIDENTIFIER]
		,@AllColumns INT = 0
       )
RETURNS @UCIGrid TABLE (
--ContextElement
	nContextElementUID [UNIQUEIDENTIFIER],
	cProperty NVARCHAR(50),
	cValue NVARCHAR(MAX),
	cDefaultLabel NVARCHAR(50),
	nWidth INT,
	cForm NVARCHAR(50),
	cControl NVARCHAR(50),
	cFormat NVARCHAR(50),
	nStyle INT,
	nTextAlign INT,
	nUCIDataUID [UNIQUEIDENTIFIER],
--Context
	nContextUID [UNIQUEIDENTIFIER],
	cContext NVARCHAR(50),
	cMode NVARCHAR(50),
--ContextElementLink
	nContextElementLinkUID [UNIQUEIDENTIFIER],
	cOperator NVARCHAR(50),
	nOrder INT,
	lHidden INT,
	nActivation INT,
	lDefault INT
       )
AS
    BEGIN

		DECLARE @SqlStatement nVARCHAR(MAX);
		DECLARE @SqlFields nVARCHAR(MAX);
		DECLARE @SqlSelect nVARCHAR(MAX);
		DECLARE @SqlWhere nVARCHAR(MAX);
		DECLARE @SqlOrder nVARCHAR(MAX);
		DECLARE @cForm nVARCHAR(500);
		DECLARE @SchemaName nVARCHAR(500) = '''';
		DECLARE @SqlFieldListCount INT = 0;
		DECLARE @n INT = 1;

		-- get FIELDS
		SELECT  @SqlFields = COALESCE(@SqlFields + '', '', '''') + ce.cValue + '' AS ''
				+ QUOTENAME( COALESCE(dbo.udf_UCIData_GetLabel(ce.nUCIDataUID,@nCustomerUID,@nLabUID,@cLabType,@cMode,ce.cControl), ce.cDefaultLabel))
		FROM    dbo.ContextElements AS ce
				JOIN dbo.ContextElementLink AS cel ON ce.nContextElementUID = cel.nContextElementUID
				JOIN dbo.Context AS c ON cel.nContextUID = c.nContextUID
		WHERE   c.cContext = @cContext
				AND ce.cProperty = ''Field''
				AND ce.lDeleted = 0
				AND ce.lActive <> 0
				AND c.lDeleted = 0
				AND c.lActive <> 0
				AND cel.lDeleted = 0
				AND cel.lActive <> 0
				AND
				(
					@AllColumns <> 0
					OR
					cel.lDefault <> 0
					OR
					cel.nContextElementUID IN (SELECT nContextElementUID FROM UserPreferences WHERE nUserUID = @nUserUID AND cContext = @cContext AND lActive <> 0 AND lDeleted = 0)
                )
		ORDER BY cel.nOrder;

		-- get field list (if any)
		SELECT TOP 1
				@SqlFieldListCount = CAST(ce.cValue AS INT)
		FROM    dbo.ContextElements AS ce
				JOIN dbo.ContextElementLink AS cel ON ce.nContextElementUID = cel.nContextElementUID
				JOIN dbo.Context AS c ON cel.nContextUID = c.nContextUID
		WHERE   c.cContext = @cContext
				AND ce.cProperty = ''FieldList''
				AND ce.lDeleted = 0
				AND ce.lActive <> 0
				AND c.lDeleted = 0
				AND c.lActive <> 0
				AND cel.lDeleted = 0
				AND cel.lActive <> 0
				AND
				(
					@AllColumns <> 0
					OR
					cel.lDefault <> 0
					OR
					cel.nContextElementUID IN (SELECT nContextElementUID FROM UserPreferences WHERE nUserUID = @nUserUID AND cContext = @cContext AND lActive <> 0 AND lDeleted = 0)
                );
		-- make the actual field list from the count
		WHILE(@n <= @SqlFieldListCount)
		BEGIN
			SELECT @SqlFields = @SqlFields + '', cValue'' + CAST(@n AS nVARCHAR);
			SELECT @n = @n + 1;
		END

		--get WHERE clause
		SELECT TOP 1
				@SqlWhere = ce.cValue
		FROM    dbo.ContextElements AS ce
				JOIN dbo.ContextElementLink AS cel ON ce.nContextElementUID = cel.nContextElementUID
				JOIN dbo.Context AS c ON cel.nContextUID = c.nContextUID
		WHERE   c.cContext = @cContext
				AND ce.cProperty = ''Where''
				AND ce.lDeleted = 0
				AND ce.lActive <> 0
				AND c.lDeleted = 0
				AND c.lActive <> 0
				AND cel.lDeleted = 0
				AND cel.lActive <> 0;
		--get SELECT statement
		SELECT TOP 1
				@SqlSelect = ce.cValue
		FROM    dbo.ContextElements AS ce
				JOIN dbo.ContextElementLink AS cel ON ce.nContextElementUID = cel.nContextElementUID
				JOIN dbo.Context AS c ON cel.nContextUID = c.nContextUID
		WHERE   c.cContext = @cContext
				AND ce.cProperty = ''Select''
				AND ce.lDeleted = 0
				AND ce.lActive <> 0
				AND c.lDeleted = 0
				AND c.lActive <> 0
				AND cel.lDeleted = 0
				AND cel.lActive <> 0;

		--get ORDER BY statement
		SELECT TOP 1
				@SqlOrder = ce.cValue
		FROM    dbo.ContextElements AS ce
				JOIN dbo.ContextElementLink AS cel ON ce.nContextElementUID = cel.nContextElementUID
				JOIN dbo.Context AS c ON cel.nContextUID = c.nContextUID
		WHERE   c.cContext = @cContext
				AND ce.cProperty = ''Order''
				AND ce.lDeleted = 0
				AND ce.lActive <> 0
				AND c.lDeleted = 0
				AND c.lActive <> 0
				AND cel.lDeleted = 0
				AND cel.lActive <> 0;

		SET @SqlStatement = REPLACE(REPLACE(REPLACE(@SqlSelect, ''strFields'',
													@SqlFields), ''strWhere'',
											COALESCE('' WHERE '' + @SqlWhere, '''')),
									''strOrder'', COALESCE('' ORDER BY '' + @SqlOrder, ''''))


		INSERT  INTO @UCIGrid
				( cValue )
		VALUES  ( @SqlStatement )


		INSERT  INTO @UCIGrid
				(
		--ContextElement
				  nContextElementUID,
				  cProperty,
				  cValue,
				  cDefaultLabel,
				  nWidth,
				  cForm,
				  cControl,
				  cFormat,
				  nStyle,
				  nTextAlign,
				  nUCIDataUID,
		--Context
				  nContextUID,
				  cContext,
				  cMode,
		--ContextElementLink
				  nContextElementLinkUID,
				  cOperator,
				  nOrder,
				  lHidden,
				  nActivation,
				  lDefault
				)
				SELECT
		--ContextElement
						ce.nContextElementUID,
						ce.cProperty,
						ce.cValue,
					    COALESCE(dbo.udf_UCIData_GetLabel(ce.nUCIDataUID,@nCustomerUID,@nLabUID,@cLabType,@cMode,ce.cControl), ce.cDefaultLabel),
						ce.nWidth,
						ce.cForm,
						ce.cControl,
						ce.cFormat,
						ce.nStyle,
						ce.nTextAlign,
						ce.nUCIDataUID,
		--Context
						c.nContextUID,
						c.cContext,
						c.cMode,
		--ContextElementLink
						cel.nContextElementLinkUID,
						cel.cOperator,
						cel.nOrder,
						cel.lHidden,
						cel.nActivation,
						cel.lDefault
				FROM    dbo.ContextElements AS ce
						JOIN dbo.ContextElementLink AS cel ON ce.nContextElementUID = cel.nContextElementUID
						JOIN dbo.Context AS c ON cel.nContextUID = c.nContextUID
				WHERE   ce.cProperty = ''Field''
						AND c.cContext = @cContext
						AND ce.lDeleted = 0
						AND ce.lActive <> 0
						AND c.lDeleted = 0
						AND c.lActive <> 0
						AND cel.lDeleted = 0
						AND cel.lActive <> 0
						AND
						(
							@AllColumns <> 0
							OR
							cel.lDefault <> 0
							OR
							cel.nContextElementUID IN (SELECT nContextElementUID FROM UserPreferences WHERE nUserUID = @nUserUID AND cContext = @cContext AND lActive <> 0 AND lDeleted = 0)
		                )
				ORDER BY cel.nOrder;
          RETURN
    END;
'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '5CC79B7E-AC76-4CCA-9B30-4DD36FD2DE8A')
	BEGIN
		IF (SELECT cValue FROM [dbo].[ContextElements] WHERE nContextElementUID = '5CC79B7E-AC76-4CCA-9B30-4DD36FD2DE8A') <> 'SELECT DISTINCT strFields, ass.nAssetUID AS [UID] FROM vw_AssetsWithEx ass strWhere strOrder'
		BEGIN
			PRINT N'Updating Context Element for FindAsset - cValue'
			UPDATE [dbo].[ContextElements] SET [cValue] = 'SELECT DISTINCT strFields, ass.nAssetUID AS [UID] FROM vw_AssetsWithEx ass strWhere strOrder' WHERE nContextElementUID = '5CC79B7E-AC76-4CCA-9B30-4DD36FD2DE8A'

		    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'A9A58B93-C0F1-40BD-8F44-04A01E307312' )
	BEGIN
		PRINT 'Adding translation entry: A9A58B93-C0F1-40BD-8F44-04A01E307312'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('A9A58B93-C0F1-40BD-8F44-04A01E307312',3200,N'EN',N'MUST_SELECT_AT_LEAST_ONE_DAY',N'At least one day must be selected.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','20200817 18:36:11',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '6D288A5F-0F8D-4741-BECF-0E1F9442C770' )
	BEGIN
		PRINT 'Adding translation entry: 6D288A5F-0F8D-4741-BECF-0E1F9442C770'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('6D288A5F-0F8D-4741-BECF-0E1F9442C770',3200,N'DE',N'MUST_SELECT_AT_LEAST_ONE_DAY',N'Mindestens ein Wochentag muss gewählt werden.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','20200817 18:36:11',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '566BADE8-BAFE-43C9-AA50-20A248D26111' )
	BEGIN
		PRINT 'Adding translation entry: 566BADE8-BAFE-43C9-AA50-20A248D26111'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('566BADE8-BAFE-43C9-AA50-20A248D26111',3200,N'RU',N'MUST_SELECT_AT_LEAST_ONE_DAY',N'#RU# At least one day must be selected.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','20200817 18:36:11',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '550B5310-C80C-44A5-B774-C78CD0819FD6' )
	BEGIN
		PRINT 'Adding translation entry: 550B5310-C80C-44A5-B774-C78CD0819FD6'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('550B5310-C80C-44A5-B774-C78CD0819FD6',3200,N'PT',N'MUST_SELECT_AT_LEAST_ONE_DAY',N'#PT# At least one day must be selected.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','20200817 18:36:11',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'C9203221-268D-4352-99E8-0C067D215836' )
	BEGIN
		PRINT 'Adding translation entry: C9203221-268D-4352-99E8-0C067D215836'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('C9203221-268D-4352-99E8-0C067D215836',3200,N'ZH',N'MUST_SELECT_AT_LEAST_ONE_DAY',N'#ZH# At least one day must be selected.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','20200817 18:36:11',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'F24D4933-4B80-4BE7-9904-168DA89513C2' )
	BEGIN
		PRINT 'Adding translation entry: F24D4933-4B80-4BE7-9904-168DA89513C2'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('F24D4933-4B80-4BE7-9904-168DA89513C2',3200,N'JA',N'MUST_SELECT_AT_LEAST_ONE_DAY',N'#JA# At least one day must be selected.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','20200817 18:36:11',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'A79E5044-F62F-4310-AF32-F28538DA66BB' )
	BEGIN
		PRINT 'Adding translation entry: A79E5044-F62F-4310-AF32-F28538DA66BB'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('A79E5044-F62F-4310-AF32-F28538DA66BB',3200,N'FR',N'MUST_SELECT_AT_LEAST_ONE_DAY',N'#FR# At least one day must be selected.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','20200817 18:36:11',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'D6ABDD9C-DAEA-47DC-A40D-EF00D7D54129' )
	BEGIN
		PRINT 'Adding translation entry: D6ABDD9C-DAEA-47DC-A40D-EF00D7D54129'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('D6ABDD9C-DAEA-47DC-A40D-EF00D7D54129',3200,N'ES',N'MUST_SELECT_AT_LEAST_ONE_DAY',N'#ES# At least one day must be selected.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','20200817 18:36:11',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'D3963128-C912-44A7-AC4E-5571B604C85D' )
	BEGIN
		PRINT 'Adding translation entry: D3963128-C912-44A7-AC4E-5571B604C85D'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('D3963128-C912-44A7-AC4E-5571B604C85D',3200,N'IT',N'MUST_SELECT_AT_LEAST_ONE_DAY',N'#IT# At least one day must be selected.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','20200817 18:36:11',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'E6828614-B3DF-43E9-BCDF-B2CB09CE6671' )
	BEGIN
		PRINT 'Adding translation entry: E6828614-B3DF-43E9-BCDF-B2CB09CE6671'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('E6828614-B3DF-43E9-BCDF-B2CB09CE6671',3201,N'EN',N'FAILED_TO_RESERVE_LICENSE_MSG',N'Failed to reserve a license for this login. Check license availability and try again.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','20200817 18:36:11',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'DE73175B-C885-4CDC-8AED-0DC72C4E95D4' )
	BEGIN
		PRINT 'Adding translation entry: DE73175B-C885-4CDC-8AED-0DC72C4E95D4'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('DE73175B-C885-4CDC-8AED-0DC72C4E95D4',3201,N'DE',N'FAILED_TO_RESERVE_LICENSE_MSG',N'Lizenz konnte nicht reserviert werden, bitte Verfügbarkeit prüfen.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','20200817 18:36:11',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '231342EC-3D3D-4B41-8D8F-C3EC67D1D78F' )
	BEGIN
		PRINT 'Adding translation entry: 231342EC-3D3D-4B41-8D8F-C3EC67D1D78F'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('231342EC-3D3D-4B41-8D8F-C3EC67D1D78F',3201,N'RU',N'FAILED_TO_RESERVE_LICENSE_MSG',N'#RU# Failed to reserve a license for this login. Check license availability and try again.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','20200817 18:36:11',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'F15A8691-FB00-4676-B514-A172D29BD760' )
	BEGIN
		PRINT 'Adding translation entry: F15A8691-FB00-4676-B514-A172D29BD760'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('F15A8691-FB00-4676-B514-A172D29BD760',3201,N'PT',N'FAILED_TO_RESERVE_LICENSE_MSG',N'#PT# Failed to reserve a license for this login. Check license availability and try again.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','20200817 18:36:11',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '6FBFFD14-16AC-4E26-B476-4F443F8E47C1' )
	BEGIN
		PRINT 'Adding translation entry: 6FBFFD14-16AC-4E26-B476-4F443F8E47C1'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('6FBFFD14-16AC-4E26-B476-4F443F8E47C1',3201,N'ZH',N'FAILED_TO_RESERVE_LICENSE_MSG',N'#ZH# Failed to reserve a license for this login. Check license availability and try again.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','20200817 18:36:11',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '75599D4E-00B9-43C1-9B5D-1DBCD740437B' )
	BEGIN
		PRINT 'Adding translation entry: 75599D4E-00B9-43C1-9B5D-1DBCD740437B'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('75599D4E-00B9-43C1-9B5D-1DBCD740437B',3201,N'JA',N'FAILED_TO_RESERVE_LICENSE_MSG',N'#JA# Failed to reserve a license for this login. Check license availability and try again.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','20200817 18:36:11',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '5B3B5135-3D62-43AC-9ABC-8F4DEE0BD602' )
	BEGIN
		PRINT 'Adding translation entry: 5B3B5135-3D62-43AC-9ABC-8F4DEE0BD602'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('5B3B5135-3D62-43AC-9ABC-8F4DEE0BD602',3201,N'FR',N'FAILED_TO_RESERVE_LICENSE_MSG',N'#FR# Failed to reserve a license for this login. Check license availability and try again.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','20200817 18:36:11',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'EE19DE41-AB4B-4FA9-B25B-E865A22B936B' )
	BEGIN
		PRINT 'Adding translation entry: EE19DE41-AB4B-4FA9-B25B-E865A22B936B'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('EE19DE41-AB4B-4FA9-B25B-E865A22B936B',3201,N'ES',N'FAILED_TO_RESERVE_LICENSE_MSG',N'#ES# Failed to reserve a license for this login. Check license availability and try again.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','20200817 18:36:11',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'A71E46A6-F29B-4478-B332-591E73AEB126' )
	BEGIN
		PRINT 'Adding translation entry: A71E46A6-F29B-4478-B332-591E73AEB126'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('A71E46A6-F29B-4478-B332-591E73AEB126',3201,N'IT',N'FAILED_TO_RESERVE_LICENSE_MSG',N'#IT# Failed to reserve a license for this login. Check license availability and try again.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','20200817 18:36:11',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '7619BBA9-944E-4566-9AB7-45A685BF9B94' )
	BEGIN
		PRINT 'Adding translation entry: 7619BBA9-944E-4566-9AB7-45A685BF9B94'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('7619BBA9-944E-4566-9AB7-45A685BF9B94',3202,N'EN',N'WORKSTATION_NAME_MISSING_MSG',N'Workstation name is missing. This must be provided when logging in from MET/CAL.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','20200817 18:36:11',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '91404ACE-BAEF-4624-92E5-1E8268189706' )
	BEGIN
		PRINT 'Adding translation entry: 91404ACE-BAEF-4624-92E5-1E8268189706'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('91404ACE-BAEF-4624-92E5-1E8268189706',3202,N'DE',N'WORKSTATION_NAME_MISSING_MSG',N'Beim Einloggen von MET/CAL muss der Arbeitsstationsname angegeben werden.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','20200817 18:36:11',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '86B798EC-F7B7-47AE-9DC0-AA67DAFB0229' )
	BEGIN
		PRINT 'Adding translation entry: 86B798EC-F7B7-47AE-9DC0-AA67DAFB0229'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('86B798EC-F7B7-47AE-9DC0-AA67DAFB0229',3202,N'RU',N'WORKSTATION_NAME_MISSING_MSG',N'#RU# Workstation name is missing. This must be provided when logging in from MET/CAL.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','20200817 18:36:11',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '517E08C8-18BE-4D25-AA0E-F40975270DF1' )
	BEGIN
		PRINT 'Adding translation entry: 517E08C8-18BE-4D25-AA0E-F40975270DF1'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('517E08C8-18BE-4D25-AA0E-F40975270DF1',3202,N'PT',N'WORKSTATION_NAME_MISSING_MSG',N'#PT# Workstation name is missing. This must be provided when logging in from MET/CAL.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','20200817 18:36:11',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '84D2AE53-DECF-4098-A608-77445D9172ED' )
	BEGIN
		PRINT 'Adding translation entry: 84D2AE53-DECF-4098-A608-77445D9172ED'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('84D2AE53-DECF-4098-A608-77445D9172ED',3202,N'ZH',N'WORKSTATION_NAME_MISSING_MSG',N'#ZH# Workstation name is missing. This must be provided when logging in from MET/CAL.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','20200817 18:36:11',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '33E05047-31B9-4985-A2E3-862BAB09A152' )
	BEGIN
		PRINT 'Adding translation entry: 33E05047-31B9-4985-A2E3-862BAB09A152'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('33E05047-31B9-4985-A2E3-862BAB09A152',3202,N'JA',N'WORKSTATION_NAME_MISSING_MSG',N'#JA# Workstation name is missing. This must be provided when logging in from MET/CAL.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','20200817 18:36:11',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '644B0377-98E2-46BE-83ED-C8744FAE2D6F' )
	BEGIN
		PRINT 'Adding translation entry: 644B0377-98E2-46BE-83ED-C8744FAE2D6F'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('644B0377-98E2-46BE-83ED-C8744FAE2D6F',3202,N'FR',N'WORKSTATION_NAME_MISSING_MSG',N'#FR# Workstation name is missing. This must be provided when logging in from MET/CAL.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','20200817 18:36:11',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'CB41A7D9-4E57-43AA-AF1E-704D623A243E' )
	BEGIN
		PRINT 'Adding translation entry: CB41A7D9-4E57-43AA-AF1E-704D623A243E'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('CB41A7D9-4E57-43AA-AF1E-704D623A243E',3202,N'ES',N'WORKSTATION_NAME_MISSING_MSG',N'#ES# Workstation name is missing. This must be provided when logging in from MET/CAL.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','20200817 18:36:11',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '90936288-48B1-4586-B7A3-A2B360F1E83F' )
	BEGIN
		PRINT 'Adding translation entry: 90936288-48B1-4586-B7A3-A2B360F1E83F'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('90936288-48B1-4586-B7A3-A2B360F1E83F',3202,N'IT',N'WORKSTATION_NAME_MISSING_MSG',N'#IT# Workstation name is missing. This must be provided when logging in from MET/CAL.',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200817 18:36:11','20200817 18:36:11',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '1D21C582-8125-4A1A-935F-1848B1BDA27A' )
	BEGIN
		PRINT 'Adding translation entry: 1D21C582-8125-4A1A-935F-1848B1BDA27A'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('1D21C582-8125-4A1A-935F-1848B1BDA27A',3203,N'EN',N'FACILITY_RECALL_REPORT',N'Facility Recall Report',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '5939D248-5A10-4605-8A6A-E4A17DCC99EE' )
	BEGIN
		PRINT 'Adding translation entry: 5939D248-5A10-4605-8A6A-E4A17DCC99EE'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('5939D248-5A10-4605-8A6A-E4A17DCC99EE',3203,N'DE',N'FACILITY_RECALL_REPORT',N'#DE# Facility Recall Report',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '7C38F58A-767F-450B-A1A6-A50E0C4BF361' )
	BEGIN
		PRINT 'Adding translation entry: 7C38F58A-767F-450B-A1A6-A50E0C4BF361'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('7C38F58A-767F-450B-A1A6-A50E0C4BF361',3203,N'RU',N'FACILITY_RECALL_REPORT',N'#RU# Facility Recall Report',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '8A8BA2F9-38AA-4F9C-8302-BB05A189F1D3' )
	BEGIN
		PRINT 'Adding translation entry: 8A8BA2F9-38AA-4F9C-8302-BB05A189F1D3'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('8A8BA2F9-38AA-4F9C-8302-BB05A189F1D3',3203,N'PT',N'FACILITY_RECALL_REPORT',N'#PT# Facility Recall Report',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '701F24EC-FA78-4C09-8069-7749A09B8C13' )
	BEGIN
		PRINT 'Adding translation entry: 701F24EC-FA78-4C09-8069-7749A09B8C13'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('701F24EC-FA78-4C09-8069-7749A09B8C13',3203,N'ZH',N'FACILITY_RECALL_REPORT',N'#ZH# Facility Recall Report',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '18987C60-E7FA-4330-8602-3521C34DBD99' )
	BEGIN
		PRINT 'Adding translation entry: 18987C60-E7FA-4330-8602-3521C34DBD99'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('18987C60-E7FA-4330-8602-3521C34DBD99',3203,N'JA',N'FACILITY_RECALL_REPORT',N'#JA# Facility Recall Report',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '895C9C02-F254-411E-8012-3982D328F3BF' )
	BEGIN
		PRINT 'Adding translation entry: 895C9C02-F254-411E-8012-3982D328F3BF'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('895C9C02-F254-411E-8012-3982D328F3BF',3203,N'FR',N'FACILITY_RECALL_REPORT',N'#FR# Facility Recall Report',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'B13F54E2-40E3-4510-B56B-AAB63DBA2F2A' )
	BEGIN
		PRINT 'Adding translation entry: B13F54E2-40E3-4510-B56B-AAB63DBA2F2A'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('B13F54E2-40E3-4510-B56B-AAB63DBA2F2A',3203,N'ES',N'FACILITY_RECALL_REPORT',N'#ES# Facility Recall Report',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'CF42AE95-2B73-4F55-83ED-71E1DA04ACC5' )
	BEGIN
		PRINT 'Adding translation entry: CF42AE95-2B73-4F55-83ED-71E1DA04ACC5'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('CF42AE95-2B73-4F55-83ED-71E1DA04ACC5',3203,N'IT',N'FACILITY_RECALL_REPORT',N'#IT# Facility Recall Report',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '95A8B77C-38CB-402A-874E-921A4083438A' )
	BEGIN
		PRINT 'Adding translation entry: 95A8B77C-38CB-402A-874E-921A4083438A'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('95A8B77C-38CB-402A-874E-921A4083438A',3204,N'EN',N'FACILITY_RECALL_REPORT_FOR_MANAGER',N'Facility Recall Report for Manager',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '586A8F74-7A42-4AE2-A0F8-4D40D60A55A1' )
	BEGIN
		PRINT 'Adding translation entry: 586A8F74-7A42-4AE2-A0F8-4D40D60A55A1'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('586A8F74-7A42-4AE2-A0F8-4D40D60A55A1',3204,N'DE',N'FACILITY_RECALL_REPORT_FOR_MANAGER',N'#DE# Facility Recall Report for Manager',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'AC53BFB3-40F5-404D-9AD3-7F3F1F463C93' )
	BEGIN
		PRINT 'Adding translation entry: AC53BFB3-40F5-404D-9AD3-7F3F1F463C93'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('AC53BFB3-40F5-404D-9AD3-7F3F1F463C93',3204,N'RU',N'FACILITY_RECALL_REPORT_FOR_MANAGER',N'#RU# Facility Recall Report for Manager',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '9E28CDD9-B2A0-4809-8629-578ADE36201C' )
	BEGIN
		PRINT 'Adding translation entry: 9E28CDD9-B2A0-4809-8629-578ADE36201C'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('9E28CDD9-B2A0-4809-8629-578ADE36201C',3204,N'PT',N'FACILITY_RECALL_REPORT_FOR_MANAGER',N'#PT# Facility Recall Report for Manager',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '32D3773B-985B-49BE-9479-591E45A00092' )
	BEGIN
		PRINT 'Adding translation entry: 32D3773B-985B-49BE-9479-591E45A00092'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('32D3773B-985B-49BE-9479-591E45A00092',3204,N'ZH',N'FACILITY_RECALL_REPORT_FOR_MANAGER',N'#ZH# Facility Recall Report for Manager',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '9FB64792-E459-4C84-9813-B9B96535F1DC' )
	BEGIN
		PRINT 'Adding translation entry: 9FB64792-E459-4C84-9813-B9B96535F1DC'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('9FB64792-E459-4C84-9813-B9B96535F1DC',3204,N'JA',N'FACILITY_RECALL_REPORT_FOR_MANAGER',N'#JA# Facility Recall Report for Manager',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '5CEABEC4-4E2E-42B6-B34E-D24F801C9EBD' )
	BEGIN
		PRINT 'Adding translation entry: 5CEABEC4-4E2E-42B6-B34E-D24F801C9EBD'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('5CEABEC4-4E2E-42B6-B34E-D24F801C9EBD',3204,N'FR',N'FACILITY_RECALL_REPORT_FOR_MANAGER',N'#FR# Facility Recall Report for Manager',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '8FBA2D8B-338A-411F-8C7B-B121B439B275' )
	BEGIN
		PRINT 'Adding translation entry: 8FBA2D8B-338A-411F-8C7B-B121B439B275'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('8FBA2D8B-338A-411F-8C7B-B121B439B275',3204,N'ES',N'FACILITY_RECALL_REPORT_FOR_MANAGER',N'#ES# Facility Recall Report for Manager',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '3379E2F2-26FF-4CD7-B23C-C5B91924CFC8' )
	BEGIN
		PRINT 'Adding translation entry: 3379E2F2-26FF-4CD7-B23C-C5B91924CFC8'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('3379E2F2-26FF-4CD7-B23C-C5B91924CFC8',3204,N'IT',N'FACILITY_RECALL_REPORT_FOR_MANAGER',N'#IT# Facility Recall Report for Manager',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '236DC746-B389-4BBF-B259-FC95E2997CF7' )
	BEGIN
		PRINT 'Adding translation entry: 236DC746-B389-4BBF-B259-FC95E2997CF7'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('236DC746-B389-4BBF-B259-FC95E2997CF7',3205,N'EN',N'FACILITY_DELINQUENT_REPORT',N'Facility Delinquent Report',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '539B3935-73C9-4642-996C-80584DD46288' )
	BEGIN
		PRINT 'Adding translation entry: 539B3935-73C9-4642-996C-80584DD46288'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('539B3935-73C9-4642-996C-80584DD46288',3205,N'DE',N'FACILITY_DELINQUENT_REPORT',N'#DE# Facility Delinquent Report',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'EC410AEC-5B39-480B-B2EE-197624C236B0' )
	BEGIN
		PRINT 'Adding translation entry: EC410AEC-5B39-480B-B2EE-197624C236B0'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('EC410AEC-5B39-480B-B2EE-197624C236B0',3205,N'RU',N'FACILITY_DELINQUENT_REPORT',N'#RU# Facility Delinquent Report',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'B84826F3-CD25-41BE-8DDE-1EE14B8700E4' )
	BEGIN
		PRINT 'Adding translation entry: B84826F3-CD25-41BE-8DDE-1EE14B8700E4'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('B84826F3-CD25-41BE-8DDE-1EE14B8700E4',3205,N'PT',N'FACILITY_DELINQUENT_REPORT',N'#PT# Facility Delinquent Report',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '5894F2D1-4214-4E3E-A3D7-DC5176D84201' )
	BEGIN
		PRINT 'Adding translation entry: 5894F2D1-4214-4E3E-A3D7-DC5176D84201'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('5894F2D1-4214-4E3E-A3D7-DC5176D84201',3205,N'ZH',N'FACILITY_DELINQUENT_REPORT',N'#ZH# Facility Delinquent Report',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '4167D393-F5D1-4D2C-A558-08B0FC33D852' )
	BEGIN
		PRINT 'Adding translation entry: 4167D393-F5D1-4D2C-A558-08B0FC33D852'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('4167D393-F5D1-4D2C-A558-08B0FC33D852',3205,N'JA',N'FACILITY_DELINQUENT_REPORT',N'#JA# Facility Delinquent Report',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'ADB3C6D9-D773-4436-AADD-D57E7CD6D3C8' )
	BEGIN
		PRINT 'Adding translation entry: ADB3C6D9-D773-4436-AADD-D57E7CD6D3C8'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('ADB3C6D9-D773-4436-AADD-D57E7CD6D3C8',3205,N'FR',N'FACILITY_DELINQUENT_REPORT',N'#FR# Facility Delinquent Report',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '268964F9-871D-4B44-BF92-D614D96D853F' )
	BEGIN
		PRINT 'Adding translation entry: 268964F9-871D-4B44-BF92-D614D96D853F'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('268964F9-871D-4B44-BF92-D614D96D853F',3205,N'ES',N'FACILITY_DELINQUENT_REPORT',N'#ES# Facility Delinquent Report',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '907728AA-B809-4668-958E-525711BC5F54' )
	BEGIN
		PRINT 'Adding translation entry: 907728AA-B809-4668-958E-525711BC5F54'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('907728AA-B809-4668-958E-525711BC5F54',3205,N'IT',N'FACILITY_DELINQUENT_REPORT',N'#IT# Facility Delinquent Report',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '1F6C3708-F112-408A-BD24-D8A62DDEAFA9' )
	BEGIN
		PRINT 'Adding translation entry: 1F6C3708-F112-408A-BD24-D8A62DDEAFA9'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('1F6C3708-F112-408A-BD24-D8A62DDEAFA9',3206,N'EN',N'TOOL_ASSIGNMENT_RECALL',N'Tool Assignment Recall',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '813D44C3-9DF7-4717-9E37-D21FCA63BFBF' )
	BEGIN
		PRINT 'Adding translation entry: 813D44C3-9DF7-4717-9E37-D21FCA63BFBF'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('813D44C3-9DF7-4717-9E37-D21FCA63BFBF',3206,N'DE',N'TOOL_ASSIGNMENT_RECALL',N'#DE# Tool Assignment Recall',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '82E630AD-AAEF-4D5A-B5E5-FAD0DB967C9F' )
	BEGIN
		PRINT 'Adding translation entry: 82E630AD-AAEF-4D5A-B5E5-FAD0DB967C9F'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('82E630AD-AAEF-4D5A-B5E5-FAD0DB967C9F',3206,N'RU',N'TOOL_ASSIGNMENT_RECALL',N'#RU# Tool Assignment Recall',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '856CB4C3-A90A-4C0D-93F3-401F94C77AFB' )
	BEGIN
		PRINT 'Adding translation entry: 856CB4C3-A90A-4C0D-93F3-401F94C77AFB'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('856CB4C3-A90A-4C0D-93F3-401F94C77AFB',3206,N'PT',N'TOOL_ASSIGNMENT_RECALL',N'#PT# Tool Assignment Recall',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'E1129E94-30AB-4DD6-B8D6-438FD2A0E909' )
	BEGIN
		PRINT 'Adding translation entry: E1129E94-30AB-4DD6-B8D6-438FD2A0E909'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('E1129E94-30AB-4DD6-B8D6-438FD2A0E909',3206,N'ZH',N'TOOL_ASSIGNMENT_RECALL',N'#ZH# Tool Assignment Recall',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'EB3556BA-0D22-4244-9150-0E30D5023836' )
	BEGIN
		PRINT 'Adding translation entry: EB3556BA-0D22-4244-9150-0E30D5023836'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('EB3556BA-0D22-4244-9150-0E30D5023836',3206,N'JA',N'TOOL_ASSIGNMENT_RECALL',N'#JA# Tool Assignment Recall',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '9CE2460E-5F33-47A4-8640-2B195303379D' )
	BEGIN
		PRINT 'Adding translation entry: 9CE2460E-5F33-47A4-8640-2B195303379D'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('9CE2460E-5F33-47A4-8640-2B195303379D',3206,N'FR',N'TOOL_ASSIGNMENT_RECALL',N'#FR# Tool Assignment Recall',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '78AEE0C3-C3D3-4AE3-B683-B396D654EB1D' )
	BEGIN
		PRINT 'Adding translation entry: 78AEE0C3-C3D3-4AE3-B683-B396D654EB1D'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('78AEE0C3-C3D3-4AE3-B683-B396D654EB1D',3206,N'ES',N'TOOL_ASSIGNMENT_RECALL',N'#ES# Tool Assignment Recall',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '0E295CBC-2A9A-4B88-8D3F-784D3CFDD368' )
	BEGIN
		PRINT 'Adding translation entry: 0E295CBC-2A9A-4B88-8D3F-784D3CFDD368'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('0E295CBC-2A9A-4B88-8D3F-784D3CFDD368',3206,N'IT',N'TOOL_ASSIGNMENT_RECALL',N'#IT# Tool Assignment Recall',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '8EC6FD53-6A79-4B6F-B1FA-48B417CBED31' )
	BEGIN
		PRINT 'Adding translation entry: 8EC6FD53-6A79-4B6F-B1FA-48B417CBED31'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('8EC6FD53-6A79-4B6F-B1FA-48B417CBED31',3207,N'EN',N'MANAGER_TOOL_ASSIGNMENT_RECALL',N'Tool Assignment Recall for Manager',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'BD889105-DC27-4333-9EC0-EA24C59CB0C4' )
	BEGIN
		PRINT 'Adding translation entry: BD889105-DC27-4333-9EC0-EA24C59CB0C4'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('BD889105-DC27-4333-9EC0-EA24C59CB0C4',3207,N'DE',N'MANAGER_TOOL_ASSIGNMENT_RECALL',N'#DE# Tool Assignment Recall for Manager',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '1B4819AA-EEEA-411B-B7A1-B4EC27E30BFA' )
	BEGIN
		PRINT 'Adding translation entry: 1B4819AA-EEEA-411B-B7A1-B4EC27E30BFA'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('1B4819AA-EEEA-411B-B7A1-B4EC27E30BFA',3207,N'RU',N'MANAGER_TOOL_ASSIGNMENT_RECALL',N'#RU# Tool Assignment Recall for Manager',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '2732D329-C8F5-4E7F-9DB4-D42AAF0747EF' )
	BEGIN
		PRINT 'Adding translation entry: 2732D329-C8F5-4E7F-9DB4-D42AAF0747EF'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('2732D329-C8F5-4E7F-9DB4-D42AAF0747EF',3207,N'PT',N'MANAGER_TOOL_ASSIGNMENT_RECALL',N'#PT# Tool Assignment Recall for Manager',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '9C1553C4-9C15-4118-928E-978C9ECE0907' )
	BEGIN
		PRINT 'Adding translation entry: 9C1553C4-9C15-4118-928E-978C9ECE0907'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('9C1553C4-9C15-4118-928E-978C9ECE0907',3207,N'ZH',N'MANAGER_TOOL_ASSIGNMENT_RECALL',N'#ZH# Tool Assignment Recall for Manager',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '0373F326-A75B-4F20-982F-3399F396A7AE' )
	BEGIN
		PRINT 'Adding translation entry: 0373F326-A75B-4F20-982F-3399F396A7AE'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('0373F326-A75B-4F20-982F-3399F396A7AE',3207,N'JA',N'MANAGER_TOOL_ASSIGNMENT_RECALL',N'#JA# Tool Assignment Recall for Manager',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '2F9987D7-55AC-4CD3-9790-60D7E5FA9129' )
	BEGIN
		PRINT 'Adding translation entry: 2F9987D7-55AC-4CD3-9790-60D7E5FA9129'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('2F9987D7-55AC-4CD3-9790-60D7E5FA9129',3207,N'FR',N'MANAGER_TOOL_ASSIGNMENT_RECALL',N'#FR# Tool Assignment Recall for Manager',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '350485C9-6930-4A11-878A-6D0B6E121027' )
	BEGIN
		PRINT 'Adding translation entry: 350485C9-6930-4A11-878A-6D0B6E121027'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('350485C9-6930-4A11-878A-6D0B6E121027',3207,N'ES',N'MANAGER_TOOL_ASSIGNMENT_RECALL',N'#ES# Tool Assignment Recall for Manager',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'A78866FF-91FD-4323-8193-83DEDEF01AFE' )
	BEGIN
		PRINT 'Adding translation entry: A78866FF-91FD-4323-8193-83DEDEF01AFE'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('A78866FF-91FD-4323-8193-83DEDEF01AFE',3207,N'IT',N'MANAGER_TOOL_ASSIGNMENT_RECALL',N'#IT# Tool Assignment Recall for Manager',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '94CD998D-EFF6-471A-A101-19064DBD8B6D' )
	BEGIN
		PRINT 'Adding translation entry: 94CD998D-EFF6-471A-A101-19064DBD8B6D'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('94CD998D-EFF6-471A-A101-19064DBD8B6D',3208,N'EN',N'FOLLOWING_ITEMS_DUE',N'{0} you have the following items due:',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '1AD16C9B-5AEC-4050-85BA-CCE4C8265AED' )
	BEGIN
		PRINT 'Adding translation entry: 1AD16C9B-5AEC-4050-85BA-CCE4C8265AED'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('1AD16C9B-5AEC-4050-85BA-CCE4C8265AED',3208,N'DE',N'FOLLOWING_ITEMS_DUE',N'#DE# {0} you have the following items due:',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '6CD764E4-B061-4818-97C3-F450756151B0' )
	BEGIN
		PRINT 'Adding translation entry: 6CD764E4-B061-4818-97C3-F450756151B0'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('6CD764E4-B061-4818-97C3-F450756151B0',3208,N'RU',N'FOLLOWING_ITEMS_DUE',N'#RU# {0} you have the following items due:',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'CAA6F502-19B4-4752-9729-CB9E3B2C825C' )
	BEGIN
		PRINT 'Adding translation entry: CAA6F502-19B4-4752-9729-CB9E3B2C825C'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('CAA6F502-19B4-4752-9729-CB9E3B2C825C',3208,N'PT',N'FOLLOWING_ITEMS_DUE',N'#PT# {0} you have the following items due:',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '1FB2CA54-4D00-49C6-B936-B36B9E69C7ED' )
	BEGIN
		PRINT 'Adding translation entry: 1FB2CA54-4D00-49C6-B936-B36B9E69C7ED'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('1FB2CA54-4D00-49C6-B936-B36B9E69C7ED',3208,N'ZH',N'FOLLOWING_ITEMS_DUE',N'#ZH# {0} you have the following items due:',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '7430BED4-9C2B-4354-99E9-3B0498903B5D' )
	BEGIN
		PRINT 'Adding translation entry: 7430BED4-9C2B-4354-99E9-3B0498903B5D'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('7430BED4-9C2B-4354-99E9-3B0498903B5D',3208,N'JA',N'FOLLOWING_ITEMS_DUE',N'#JA# {0} you have the following items due:',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '34571D02-1F1B-47DF-B730-1DA7F4DBE9EB' )
	BEGIN
		PRINT 'Adding translation entry: 34571D02-1F1B-47DF-B730-1DA7F4DBE9EB'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('34571D02-1F1B-47DF-B730-1DA7F4DBE9EB',3208,N'FR',N'FOLLOWING_ITEMS_DUE',N'#FR# {0} you have the following items due:',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'E7556ED8-0F16-48A0-9D2E-90DC2AB1A4A0' )
	BEGIN
		PRINT 'Adding translation entry: E7556ED8-0F16-48A0-9D2E-90DC2AB1A4A0'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('E7556ED8-0F16-48A0-9D2E-90DC2AB1A4A0',3208,N'ES',N'FOLLOWING_ITEMS_DUE',N'#ES# {0} you have the following items due:',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '8F5EF8B5-CC10-4F4F-B163-F64EC74CDE88' )
	BEGIN
		PRINT 'Adding translation entry: 8F5EF8B5-CC10-4F4F-B163-F64EC74CDE88'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('8F5EF8B5-CC10-4F4F-B163-F64EC74CDE88',3208,N'IT',N'FOLLOWING_ITEMS_DUE',N'#IT# {0} you have the following items due:',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '2A7B29E8-9272-460B-89A2-6556598BFD9B' )
	BEGIN
		PRINT 'Adding translation entry: 2A7B29E8-9272-460B-89A2-6556598BFD9B'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('2A7B29E8-9272-460B-89A2-6556598BFD9B',3209,N'EN',N'RECALL_REPORT_FOR',N'Recall report for {0}',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '4982D230-C3A3-45CB-8FAF-85D2AA33E261' )
	BEGIN
		PRINT 'Adding translation entry: 4982D230-C3A3-45CB-8FAF-85D2AA33E261'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('4982D230-C3A3-45CB-8FAF-85D2AA33E261',3209,N'DE',N'RECALL_REPORT_FOR',N'#DE# Recall report for {0}',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '44FC4F67-52D3-439C-B764-CDD1306A029E' )
	BEGIN
		PRINT 'Adding translation entry: 44FC4F67-52D3-439C-B764-CDD1306A029E'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('44FC4F67-52D3-439C-B764-CDD1306A029E',3209,N'RU',N'RECALL_REPORT_FOR',N'#RU# Recall report for {0}',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '5B0B2272-DAC3-4C84-A213-614DF2308C08' )
	BEGIN
		PRINT 'Adding translation entry: 5B0B2272-DAC3-4C84-A213-614DF2308C08'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('5B0B2272-DAC3-4C84-A213-614DF2308C08',3209,N'PT',N'RECALL_REPORT_FOR',N'#PT# Recall report for {0}',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '08C91CE8-9B23-4E46-B771-39C0B5924773' )
	BEGIN
		PRINT 'Adding translation entry: 08C91CE8-9B23-4E46-B771-39C0B5924773'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('08C91CE8-9B23-4E46-B771-39C0B5924773',3209,N'ZH',N'RECALL_REPORT_FOR',N'#ZH# Recall report for {0}',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '53A30D06-0A6B-4F7C-A0E9-85F6A57FB9D3' )
	BEGIN
		PRINT 'Adding translation entry: 53A30D06-0A6B-4F7C-A0E9-85F6A57FB9D3'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('53A30D06-0A6B-4F7C-A0E9-85F6A57FB9D3',3209,N'JA',N'RECALL_REPORT_FOR',N'#JA# Recall report for {0}',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'A23A2A83-6473-43AB-960E-982E746B6BC0' )
	BEGIN
		PRINT 'Adding translation entry: A23A2A83-6473-43AB-960E-982E746B6BC0'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('A23A2A83-6473-43AB-960E-982E746B6BC0',3209,N'FR',N'RECALL_REPORT_FOR',N'#FR# Recall report for {0}',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '5B481643-B916-46CD-A9BE-75FCDCB8793F' )
	BEGIN
		PRINT 'Adding translation entry: 5B481643-B916-46CD-A9BE-75FCDCB8793F'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('5B481643-B916-46CD-A9BE-75FCDCB8793F',3209,N'ES',N'RECALL_REPORT_FOR',N'#ES# Recall report for {0}',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'DBC06AD2-B711-4189-B43A-813B0B31B6BC' )
	BEGIN
		PRINT 'Adding translation entry: DBC06AD2-B711-4189-B43A-813B0B31B6BC'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('DBC06AD2-B711-4189-B43A-813B0B31B6BC',3209,N'IT',N'RECALL_REPORT_FOR',N'#IT# Recall report for {0}',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '3544CED8-3F87-4C15-852C-D8B13D8DEB18' )
	BEGIN
		PRINT 'Adding translation entry: 3544CED8-3F87-4C15-852C-D8B13D8DEB18'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('3544CED8-3F87-4C15-852C-D8B13D8DEB18',3210,N'EN',N'FACILITY_RECALL_REPORT_FOR',N'Facility recall report for {0}',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'A51E246B-C9B2-4E4E-AF2D-EEC851AE069C' )
	BEGIN
		PRINT 'Adding translation entry: A51E246B-C9B2-4E4E-AF2D-EEC851AE069C'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('A51E246B-C9B2-4E4E-AF2D-EEC851AE069C',3210,N'DE',N'FACILITY_RECALL_REPORT_FOR',N'#DE# Facility recall report for {0}',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '43ABA126-FCCE-4F0A-875F-A607A7A1737F' )
	BEGIN
		PRINT 'Adding translation entry: 43ABA126-FCCE-4F0A-875F-A607A7A1737F'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('43ABA126-FCCE-4F0A-875F-A607A7A1737F',3210,N'RU',N'FACILITY_RECALL_REPORT_FOR',N'#RU# Facility recall report for {0}',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '3783E7B9-FE11-413D-8A03-D126B43322DE' )
	BEGIN
		PRINT 'Adding translation entry: 3783E7B9-FE11-413D-8A03-D126B43322DE'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('3783E7B9-FE11-413D-8A03-D126B43322DE',3210,N'PT',N'FACILITY_RECALL_REPORT_FOR',N'#PT# Facility recall report for {0}',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'E83D875E-3B8E-4AEB-946D-0217A08A25C1' )
	BEGIN
		PRINT 'Adding translation entry: E83D875E-3B8E-4AEB-946D-0217A08A25C1'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('E83D875E-3B8E-4AEB-946D-0217A08A25C1',3210,N'ZH',N'FACILITY_RECALL_REPORT_FOR',N'#ZH# Facility recall report for {0}',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '3570E620-A798-4B06-89BF-E1670F65FF22' )
	BEGIN
		PRINT 'Adding translation entry: 3570E620-A798-4B06-89BF-E1670F65FF22'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('3570E620-A798-4B06-89BF-E1670F65FF22',3210,N'JA',N'FACILITY_RECALL_REPORT_FOR',N'#JA# Facility recall report for {0}',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '5B407895-58DE-4E14-87F2-ED66F17C1DEA' )
	BEGIN
		PRINT 'Adding translation entry: 5B407895-58DE-4E14-87F2-ED66F17C1DEA'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('5B407895-58DE-4E14-87F2-ED66F17C1DEA',3210,N'FR',N'FACILITY_RECALL_REPORT_FOR',N'#FR# Facility recall report for {0}',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '12DEB4E6-B6F6-4B4F-AD3C-6974EDD8782F' )
	BEGIN
		PRINT 'Adding translation entry: 12DEB4E6-B6F6-4B4F-AD3C-6974EDD8782F'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('12DEB4E6-B6F6-4B4F-AD3C-6974EDD8782F',3210,N'ES',N'FACILITY_RECALL_REPORT_FOR',N'#ES# Facility recall report for {0}',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'C666ED9E-DAEB-4BB5-8919-768A38A4BD1B' )
	BEGIN
		PRINT 'Adding translation entry: C666ED9E-DAEB-4BB5-8919-768A38A4BD1B'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('C666ED9E-DAEB-4BB5-8919-768A38A4BD1B',3210,N'IT',N'FACILITY_RECALL_REPORT_FOR',N'#IT# Facility recall report for {0}',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200828 17:24:39','20200828 17:24:39',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	-- MTM-53
	IF OBJECT_ID(N'[dbo].[IsAssetRelated]') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[IsAssetRelated]'

		DROP FUNCTION [dbo].[IsAssetRelated]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[IsAssetRelated]') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[IsAssetRelated]'

		EXEC sp_executesql N'
/******************************************************************************************************
	@AssetID - 		UID of Reference Asset record
	@TestAssetID - 	UID of Asset record tested for relationship
	@ActiveOnly - 	If 0 both active and inactive Assets are evaluated
				If <> 0 then only active assets are evaluated
		NOTE: When <> 0 an inactive record breaks the chain and causes
			active records beyond it to not be "related".  E.g. if the
			parent is inactive, the Grandparent would no be considered "related".
	Return value
		If = 0 then @TestAssetID is not related
		If > 0 then @TestAssetID is a parent and the value is the
			levels it is above the @AssetID. (1 = parent, 2 = grandparent, 3 = great grandparent ect.)
		If < 0 then @TestAssetID is a child and the value is the
			levels it is below the @AssetID. (1 = child, 2 = grandchild, 3 = great grandchild ect.)
--------------------------------------------------------------------------------------------------------
    Change History
	02/02/2011	EdW	Created based on IsRelated
	04/04/2016   MM Changes for GUIDs
	08/19/2020   MM Prevent lockup if a circular reference is found (see IsRelated for explanations)
********************************************************************************************************/
CREATE FUNCTION [dbo].[IsAssetRelated](
	@AssetID [UNIQUEIDENTIFIER],
	@TestAssetID [UNIQUEIDENTIFIER],
	@ActiveOnly BIT
	)
RETURNS INT AS
BEGIN

	DECLARE @ParentList AS NVARCHAR(MAX)
	SET @ParentList = '' ''

	DECLARE @CurrentTestAssetID AS [UNIQUEIDENTIFIER], @OrigAssetID AS [UNIQUEIDENTIFIER], @Count AS INT, @Val AS BIT, @Deleted AS BIT, @Active AS BIT
	SET @OrigAssetID = @AssetID
	SET @Val=0
	SET @Count=0
	WHILE COALESCE(@AssetID, ''4CA22A04-0079-4033-84A5-E5968C7F3F17'') <> ''4CA22A04-0079-4033-84A5-E5968C7F3F17''		-- new record GUID
	BEGIN
	--	Check for a parent relationship
		SET @Count= @Count+1
		SELECT @CurrentTestAssetID=ISNULL(Assets.nParentUID,''4CA22A04-0079-4033-84A5-E5968C7F3F17''), @Deleted = Assets.lDeleted, @Active = Assets.lActive FROM Assets WHERE Assets.nAssetUID=@AssetID
		IF @Deleted <> 0 BREAK

		IF @Active = 0 AND @ActiveOnly <> 0 BREAK

		IF @CurrentTestAssetID=@TestAssetID BEGIN SET @Val=1 BREAK END ELSE BEGIN SET @AssetID=@CurrentTestAssetID END

		IF ( CHARINDEX( '' '' + CAST(@AssetID as NVARCHAR(MAX)) + '' '', @ParentList ) > 0 )
		BEGIN
			BREAK
		END
		SET @ParentList=@ParentList + N'' '' + CAST(@AssetID AS NVARCHAR(MAX))
	END

	SET @ParentList = '' ''
	IF @Val = 0
	BEGIN
	--	We don''t have a parent relationship yet, reverse things to check for child relationships
		SET @Count = 0
		SET @AssetID = @TestAssetID
		SET @TestAssetID = @OrigAssetID
		WHILE COALESCE(@AssetID, ''4CA22A04-0079-4033-84A5-E5968C7F3F17'') <> ''4CA22A04-0079-4033-84A5-E5968C7F3F17''		-- new record GUID
		BEGIN
			SET @Count= @Count-1
			SELECT @CurrentTestAssetID=ISNULL(Assets.nParentUID,''4CA22A04-0079-4033-84A5-E5968C7F3F17''), @Deleted = Assets.lDeleted, @Active = Assets.lActive FROM Assets WHERE Assets.nAssetUID=@AssetID
			IF @Deleted <> 0 BREAK

			IF @Active = 0 AND @ActiveOnly <> 0 BREAK

			IF @CurrentTestAssetID=@TestAssetID BEGIN SET @Val=1 BREAK END ELSE BEGIN SET @AssetID=@CurrentTestAssetID END


			IF ( CHARINDEX( '' '' + CAST(@AssetID AS NVARCHAR(MAX)) + '' '', @ParentList ) > 0 )
			BEGIN
				BREAK
			END
			SET @ParentList=@ParentList + N'' '' + CAST(@AssetID AS NVARCHAR(MAX))
		END
	END

	IF @Val = 0
		SET @Count = 0

	RETURN @Count
END;
'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-- MTM-1821
	IF NOT EXISTS(SELECT * FROM [dbo].[Units] WHERE cUnitSymbol = N'°C' AND nCode = 176)
	BEGIN
		IF EXISTS(SELECT * FROM [dbo].[Units] WHERE cUnitSymbol = N'°C' AND nCode = 248)
		BEGIN
			UPDATE [dbo].[Units] SET nCode = 176 WHERE  cUnitSymbol = N'°C' AND nCode = 248

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Units] WHERE cUnitSymbol = N'°F' AND nCode = 176)
	BEGIN
		IF EXISTS(SELECT * FROM [dbo].[Units] WHERE cUnitSymbol = N'°F' AND nCode = 248)
		BEGIN
			UPDATE [dbo].[Units] SET nCode = 176 WHERE  cUnitSymbol = N'°F' AND nCode = 248

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Units] WHERE cUnitSymbol = N'°R' AND nCode = 176)
	BEGIN
		IF EXISTS(SELECT * FROM [dbo].[Units] WHERE cUnitSymbol = N'°R' AND nCode = 248)
		BEGIN
			UPDATE [dbo].[Units] SET nCode = 176 WHERE  cUnitSymbol = N'°R' AND nCode = 248

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Units] WHERE cUnitSymbol = N'°Ré' AND nCode = 176)
	BEGIN
		IF EXISTS(SELECT * FROM [dbo].[Units] WHERE cUnitSymbol = N'°Ré' AND nCode = 248)
		BEGIN
			UPDATE [dbo].[Units] SET nCode = 176 WHERE  cUnitSymbol = N'°Ré' AND nCode = 248

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Units] WHERE cUnitSymbol = N'°Ro' AND nCode = 176)
	BEGIN
		IF EXISTS(SELECT * FROM [dbo].[Units] WHERE cUnitSymbol = N'°Ro' AND nCode = 248)
		BEGIN
			UPDATE [dbo].[Units] SET nCode = 176 WHERE  cUnitSymbol = N'°Ro' AND nCode = 248

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '6E4C8789-5250-4A19-82DE-28200A0213B1' )
	BEGIN
		PRINT 'Adding translation entry: 6E4C8789-5250-4A19-82DE-28200A0213B1'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('6E4C8789-5250-4A19-82DE-28200A0213B1',3211,N'EN',N'UPDATE_ROW_FORMULA',N'Update Formula',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','20200901 00:41:46',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'E08432FA-CAF2-4430-93D8-0170F7391999' )
	BEGIN
		PRINT 'Adding translation entry: E08432FA-CAF2-4430-93D8-0170F7391999'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('E08432FA-CAF2-4430-93D8-0170F7391999',3211,N'DE',N'UPDATE_ROW_FORMULA',N'#DE# Update Formula',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','20200901 00:41:46',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '013159E8-0446-430E-8C76-6F37DF7EFBC0' )
	BEGIN
		PRINT 'Adding translation entry: 013159E8-0446-430E-8C76-6F37DF7EFBC0'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('013159E8-0446-430E-8C76-6F37DF7EFBC0',3211,N'RU',N'UPDATE_ROW_FORMULA',N'#RU# Update Formula',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','20200901 00:41:46',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'DC2A6DAA-CCB2-4576-86C8-6E0665C90ACD' )
	BEGIN
		PRINT 'Adding translation entry: DC2A6DAA-CCB2-4576-86C8-6E0665C90ACD'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('DC2A6DAA-CCB2-4576-86C8-6E0665C90ACD',3211,N'PT',N'UPDATE_ROW_FORMULA',N'#PT# Update Formula',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','20200901 00:41:46',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'A2E21909-BE56-4053-B026-5BB6837135E9' )
	BEGIN
		PRINT 'Adding translation entry: A2E21909-BE56-4053-B026-5BB6837135E9'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('A2E21909-BE56-4053-B026-5BB6837135E9',3211,N'ZH',N'UPDATE_ROW_FORMULA',N'#ZH# Update Formula',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','20200901 00:41:46',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'D8FDEA68-8CD7-493B-A1A0-F24C246907C1' )
	BEGIN
		PRINT 'Adding translation entry: D8FDEA68-8CD7-493B-A1A0-F24C246907C1'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('D8FDEA68-8CD7-493B-A1A0-F24C246907C1',3211,N'JA',N'UPDATE_ROW_FORMULA',N'#JA# Update Formula',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','20200901 00:41:46',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '6D148548-BFF8-4578-A900-106F66521CA4' )
	BEGIN
		PRINT 'Adding translation entry: 6D148548-BFF8-4578-A900-106F66521CA4'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('6D148548-BFF8-4578-A900-106F66521CA4',3211,N'FR',N'UPDATE_ROW_FORMULA',N'#FR# Update Formula',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','20200901 00:41:46',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '096A2B8D-1A3D-42E2-8489-901AB459EFEC' )
	BEGIN
		PRINT 'Adding translation entry: 096A2B8D-1A3D-42E2-8489-901AB459EFEC'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('096A2B8D-1A3D-42E2-8489-901AB459EFEC',3211,N'ES',N'UPDATE_ROW_FORMULA',N'#ES# Update Formula',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','20200901 00:41:46',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '436DEE89-FAA2-4A09-B44E-93CC9DAB35AF' )
	BEGIN
		PRINT 'Adding translation entry: 436DEE89-FAA2-4A09-B44E-93CC9DAB35AF'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('436DEE89-FAA2-4A09-B44E-93CC9DAB35AF',3211,N'IT',N'UPDATE_ROW_FORMULA',N'#IT# Update Formula',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','20200901 00:41:46',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'C289D5F1-22AE-415B-ACD7-8B19403DD302' )
	BEGIN
		PRINT 'Adding translation entry: C289D5F1-22AE-415B-ACD7-8B19403DD302'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('C289D5F1-22AE-415B-ACD7-8B19403DD302',3212,N'EN',N'UPDATE_ROW_FORMULA_TRANSDUCER',N'Update Formula (Transducer)',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','20200901 00:41:46',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'AD22BBDB-0139-4362-B2B1-C178C5BFABE4' )
	BEGIN
		PRINT 'Adding translation entry: AD22BBDB-0139-4362-B2B1-C178C5BFABE4'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('AD22BBDB-0139-4362-B2B1-C178C5BFABE4',3212,N'DE',N'UPDATE_ROW_FORMULA_TRANSDUCER',N'#DE# Update Formula (Transducer)',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','20200901 00:41:46',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '1609F19F-A5ED-4515-AE0A-D9C7F7C5A106' )
	BEGIN
		PRINT 'Adding translation entry: 1609F19F-A5ED-4515-AE0A-D9C7F7C5A106'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('1609F19F-A5ED-4515-AE0A-D9C7F7C5A106',3212,N'RU',N'UPDATE_ROW_FORMULA_TRANSDUCER',N'#RU# Update Formula (Transducer)',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','20200901 00:41:46',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '4B128B27-32B7-41FA-88CC-9FBBF62EAA84' )
	BEGIN
		PRINT 'Adding translation entry: 4B128B27-32B7-41FA-88CC-9FBBF62EAA84'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('4B128B27-32B7-41FA-88CC-9FBBF62EAA84',3212,N'PT',N'UPDATE_ROW_FORMULA_TRANSDUCER',N'#PT# Update Formula (Transducer)',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','20200901 00:41:46',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '642E5588-CB96-4BF7-A244-250D21EE905A' )
	BEGIN
		PRINT 'Adding translation entry: 642E5588-CB96-4BF7-A244-250D21EE905A'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('642E5588-CB96-4BF7-A244-250D21EE905A',3212,N'ZH',N'UPDATE_ROW_FORMULA_TRANSDUCER',N'#ZH# Update Formula (Transducer)',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','20200901 00:41:46',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '0B2D4C23-A932-4364-B30E-D9EB291E8AC1' )
	BEGIN
		PRINT 'Adding translation entry: 0B2D4C23-A932-4364-B30E-D9EB291E8AC1'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('0B2D4C23-A932-4364-B30E-D9EB291E8AC1',3212,N'JA',N'UPDATE_ROW_FORMULA_TRANSDUCER',N'#JA# Update Formula (Transducer)',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','20200901 00:41:46',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'DB27FDC9-A508-4D4C-AA8D-E1565B5E5DB7' )
	BEGIN
		PRINT 'Adding translation entry: DB27FDC9-A508-4D4C-AA8D-E1565B5E5DB7'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('DB27FDC9-A508-4D4C-AA8D-E1565B5E5DB7',3212,N'FR',N'UPDATE_ROW_FORMULA_TRANSDUCER',N'#FR# Update Formula (Transducer)',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','20200901 00:41:46',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'E2CEED2D-CF76-4D94-BABE-0490F1A22A23' )
	BEGIN
		PRINT 'Adding translation entry: E2CEED2D-CF76-4D94-BABE-0490F1A22A23'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('E2CEED2D-CF76-4D94-BABE-0490F1A22A23',3212,N'ES',N'UPDATE_ROW_FORMULA_TRANSDUCER',N'#ES# Update Formula (Transducer)',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','20200901 00:41:46',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'D39B09BC-9393-40B8-98C6-175D75C52164' )
	BEGIN
		PRINT 'Adding translation entry: D39B09BC-9393-40B8-98C6-175D75C52164'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('D39B09BC-9393-40B8-98C6-175D75C52164',3212,N'IT',N'UPDATE_ROW_FORMULA_TRANSDUCER',N'#IT# Update Formula (Transducer)',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200901 00:41:46','20200901 00:41:46',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 3211 AND [cLocale] = ''DE'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''Formel Ändern'' _COLL_ AND [cKey] = N''UPDATE_ROW_FORMULA'')
	BEGIN
		PRINT ''Updating translation entry: 3211 - DE''
		UPDATE
			[dbo].[Translations] 
		SET
			[cKey] = N''UPDATE_ROW_FORMULA'',
			[mValue] = N''Formel Ändern'',
			[lActive] = -1,
			[tUpdateTime] = ''20200901 00:41:46'',
			[tMobileTime] = ''20200901 00:41:46''
		WHERE
			[nLineNumber] = 3211 AND [cLocale] = ''DE'' 
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql 

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 3212 AND [cLocale] = ''DE'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''Formel Ändern (Messwandler)'' _COLL_ AND [cKey] = N''UPDATE_ROW_FORMULA_TRANSDUCER'')
	BEGIN
		PRINT ''Updating translation entry: 3212 - DE''
		UPDATE
			[dbo].[Translations] 
		SET
			[cKey] = N''UPDATE_ROW_FORMULA_TRANSDUCER'',
			[mValue] = N''Formel Ändern (Messwandler)'',
			[lActive] = -1,
			[tUpdateTime] = ''20200901 00:41:46'',
			[tMobileTime] = ''20200901 00:41:46''
		WHERE
			[nLineNumber] = 3212 AND [cLocale] = ''DE'' 
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql 

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 3203 AND [cLocale] = ''DE'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''Einrichtungs-Rückrufbericht'' _COLL_ AND [cKey] = N''FACILITY_RECALL_REPORT'')
	BEGIN
		PRINT ''Updating translation entry: 3203 - DE''
		UPDATE
			[dbo].[Translations] 
		SET
			[cKey] = N''FACILITY_RECALL_REPORT'',
			[mValue] = N''Einrichtungs-Rückrufbericht'',
			[lActive] = -1,
			[tUpdateTime] = ''20200903 23:08:13'',
			[tMobileTime] = ''20200903 23:08:13''
		WHERE
			[nLineNumber] = 3203 AND [cLocale] = ''DE'' 
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql 

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 3204 AND [cLocale] = ''DE'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''Einrichtungs-Rückrufbericht für Manager'' _COLL_ AND [cKey] = N''FACILITY_RECALL_REPORT_FOR_MANAGER'')
	BEGIN
		PRINT ''Updating translation entry: 3204 - DE''
		UPDATE
			[dbo].[Translations] 
		SET
			[cKey] = N''FACILITY_RECALL_REPORT_FOR_MANAGER'',
			[mValue] = N''Einrichtungs-Rückrufbericht für Manager'',
			[lActive] = -1,
			[tUpdateTime] = ''20200903 23:08:13'',
			[tMobileTime] = ''20200903 23:08:13''
		WHERE
			[nLineNumber] = 3204 AND [cLocale] = ''DE'' 
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql 

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 3205 AND [cLocale] = ''DE'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''Überfällige Einrichtungen Bericht'' _COLL_ AND [cKey] = N''FACILITY_DELINQUENT_REPORT'')
	BEGIN
		PRINT ''Updating translation entry: 3205 - DE''
		UPDATE
			[dbo].[Translations] 
		SET
			[cKey] = N''FACILITY_DELINQUENT_REPORT'',
			[mValue] = N''Überfällige Einrichtungen Bericht'',
			[lActive] = -1,
			[tUpdateTime] = ''20200903 23:08:13'',
			[tMobileTime] = ''20200903 23:08:13''
		WHERE
			[nLineNumber] = 3205 AND [cLocale] = ''DE'' 
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql 

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 3206 AND [cLocale] = ''DE'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''Tool-Zuweisungs-Rückrufbericht'' _COLL_ AND [cKey] = N''TOOL_ASSIGNMENT_RECALL'')
	BEGIN
		PRINT ''Updating translation entry: 3206 - DE''
		UPDATE
			[dbo].[Translations] 
		SET
			[cKey] = N''TOOL_ASSIGNMENT_RECALL'',
			[mValue] = N''Tool-Zuweisungs-Rückrufbericht'',
			[lActive] = -1,
			[tUpdateTime] = ''20200903 23:08:13'',
			[tMobileTime] = ''20200903 23:08:13''
		WHERE
			[nLineNumber] = 3206 AND [cLocale] = ''DE'' 
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql 

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 3207 AND [cLocale] = ''DE'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''Tool-Zuweisungs-Rückrufbericht für Manager'' _COLL_ AND [cKey] = N''MANAGER_TOOL_ASSIGNMENT_RECALL'')
	BEGIN
		PRINT ''Updating translation entry: 3207 - DE''
		UPDATE
			[dbo].[Translations] 
		SET
			[cKey] = N''MANAGER_TOOL_ASSIGNMENT_RECALL'',
			[mValue] = N''Tool-Zuweisungs-Rückrufbericht für Manager'',
			[lActive] = -1,
			[tUpdateTime] = ''20200903 23:08:13'',
			[tMobileTime] = ''20200903 23:08:13''
		WHERE
			[nLineNumber] = 3207 AND [cLocale] = ''DE'' 
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql 

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 3209 AND [cLocale] = ''DE'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''Rückrufbericht für {0}'' _COLL_ AND [cKey] = N''RECALL_REPORT_FOR'')
	BEGIN
		PRINT ''Updating translation entry: 3209 - DE''
		UPDATE
			[dbo].[Translations] 
		SET
			[cKey] = N''RECALL_REPORT_FOR'',
			[mValue] = N''Rückrufbericht für {0}'',
			[lActive] = -1,
			[tUpdateTime] = ''20200903 23:08:13'',
			[tMobileTime] = ''20200903 23:08:13''
		WHERE
			[nLineNumber] = 3209 AND [cLocale] = ''DE'' 
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql 

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 3210 AND [cLocale] = ''DE'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''Einrichtungs-Rückrufbericht für {0}'' _COLL_ AND [cKey] = N''FACILITY_RECALL_REPORT_FOR'')
	BEGIN
		PRINT ''Updating translation entry: 3210 - DE''
		UPDATE
			[dbo].[Translations] 
		SET
			[cKey] = N''FACILITY_RECALL_REPORT_FOR'',
			[mValue] = N''Einrichtungs-Rückrufbericht für {0}'',
			[lActive] = -1,
			[tUpdateTime] = ''20200903 23:08:13'',
			[tMobileTime] = ''20200903 23:08:13''
		WHERE
			[nLineNumber] = 3210 AND [cLocale] = ''DE'' 
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql 

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END


	-- MTM-1486
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '082179D8-09AE-4511-840C-A82FED3E3745' )
	BEGIN
		PRINT 'Adding translation entry: 082179D8-09AE-4511-840C-A82FED3E3745'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('082179D8-09AE-4511-840C-A82FED3E3745',3213,N'EN',N'LOADING_TEMPLATE',N'Loading Template',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200903 22:49:54','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200903 22:49:54','20200903 22:49:54',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '3BF22276-837F-4196-B39B-C869A8E45B0A' )
	BEGIN
		PRINT 'Adding translation entry: 3BF22276-837F-4196-B39B-C869A8E45B0A'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('3BF22276-837F-4196-B39B-C869A8E45B0A',3213,N'DE',N'LOADING_TEMPLATE',N'Vorlage wird geladen',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200903 22:49:54','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200903 22:49:54','20200903 22:49:54',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'EB0B238B-1715-464A-B20B-067CF3C16540' )
	BEGIN
		PRINT 'Adding translation entry: EB0B238B-1715-464A-B20B-067CF3C16540'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('EB0B238B-1715-464A-B20B-067CF3C16540',3213,N'RU',N'LOADING_TEMPLATE',N'#RU# Loading Template',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200903 22:49:54','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200903 22:49:54','20200903 22:49:54',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '6725C1F5-12DD-445F-B448-8FF0291F56A3' )
	BEGIN
		PRINT 'Adding translation entry: 6725C1F5-12DD-445F-B448-8FF0291F56A3'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('6725C1F5-12DD-445F-B448-8FF0291F56A3',3213,N'PT',N'LOADING_TEMPLATE',N'#PT# Loading Template',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200903 22:49:54','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200903 22:49:54','20200903 22:49:54',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '160B661B-3486-4619-95C8-BACD8444ABA0' )
	BEGIN
		PRINT 'Adding translation entry: 160B661B-3486-4619-95C8-BACD8444ABA0'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('160B661B-3486-4619-95C8-BACD8444ABA0',3213,N'ZH',N'LOADING_TEMPLATE',N'#ZH# Loading Template',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200903 22:49:54','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200903 22:49:54','20200903 22:49:54',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'BFF0B23E-B008-449C-81CA-529EE33C2BA0' )
	BEGIN
		PRINT 'Adding translation entry: BFF0B23E-B008-449C-81CA-529EE33C2BA0'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('BFF0B23E-B008-449C-81CA-529EE33C2BA0',3213,N'JA',N'LOADING_TEMPLATE',N'#JA# Loading Template',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200903 22:49:54','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200903 22:49:54','20200903 22:49:54',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'A9118F10-2D6E-4909-97DE-652184C3DE62' )
	BEGIN
		PRINT 'Adding translation entry: A9118F10-2D6E-4909-97DE-652184C3DE62'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('A9118F10-2D6E-4909-97DE-652184C3DE62',3213,N'FR',N'LOADING_TEMPLATE',N'#FR# Loading Template',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200903 22:49:54','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200903 22:49:54','20200903 22:49:54',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '7E72B5B2-31B3-4DC6-992B-39EC4F0BC1C9' )
	BEGIN
		PRINT 'Adding translation entry: 7E72B5B2-31B3-4DC6-992B-39EC4F0BC1C9'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('7E72B5B2-31B3-4DC6-992B-39EC4F0BC1C9',3213,N'ES',N'LOADING_TEMPLATE',N'#ES# Loading Template',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200903 22:49:54','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200903 22:49:54','20200903 22:49:54',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '10784B7A-1BDB-4E6B-B4A0-D0C13DD530AF' )
	BEGIN
		PRINT 'Adding translation entry: 10784B7A-1BDB-4E6B-B4A0-D0C13DD530AF'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('10784B7A-1BDB-4E6B-B4A0-D0C13DD530AF',3213,N'IT',N'LOADING_TEMPLATE',N'#IT# Loading Template',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200903 22:49:54','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200903 22:49:54','20200903 22:49:54',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-- MTM-1540
	IF NOT EXISTS(SELECT * FROM syscolumns sc JOIN sysobjects so ON sc.id = so.id WHERE sc.name = 'nAttTemplateUID' AND so.name = 'CallSheetResults')
	BEGIN

		IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE AuditColumnID = 'C5544A07-EB7F-4E77-80E5-EBEA1A6D5B48')
		BEGIN
			SET IDENTITY_INSERT [dbo].[AuditColumns] ON
			INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID]) VALUES ('C5544A07-EB7F-4E77-80E5-EBEA1A6D5B48', 63, 3010, N'nAttTemplateUID', 1, 0, 0, 0, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200904 00:17:34.230', 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20200904 00:17:34.230', '20200904 00:17:34.230', NULL, NULL)
			SET IDENTITY_INSERT [dbo].[AuditColumns] OFF
		END
	
		PRINT N'Dropping extended properties'

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', NULL, NULL))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', NULL, NULL
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'cDataOrigin'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'cDataOrigin'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'cDescription'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'cDescription'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'cStatus'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'cStatus'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'cWorkstationName'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'cWorkstationName'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'lActive'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'lActive'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'lAdded'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'lAdded'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'lApproved'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'lApproved'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'lDeleted'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'lDeleted'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nAddFacilityUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nAddFacilityUID'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nAddUserUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nAddUserUID'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nCallSheetResultOrdinal'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nCallSheetResultOrdinal'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nCallSheetResultUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nCallSheetResultUID'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nCallSheetUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nCallSheetUID'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nImportUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nImportUID'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nRunAtFacilityUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nRunAtFacilityUID'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nTechnicianUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nTechnicianUID'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nUpdateFacilityUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nUpdateFacilityUID'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nUpdateUserUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nUpdateUserUID'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'tAddTime'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'tAddTime'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'tMobileTime'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'tMobileTime'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'tSystemUpdateTime'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'tSystemUpdateTime'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'tUpdateTime'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'tUpdateTime'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping foreign keys from [dbo].[CallSheetResults]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetResults_CallSheets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetResults]', 'U'))
		ALTER TABLE [dbo].[CallSheetResults] DROP CONSTRAINT [FK_CallSheetResults_CallSheets]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetResults_Facilities]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetResults]', 'U'))
		ALTER TABLE [dbo].[CallSheetResults] DROP CONSTRAINT [FK_CallSheetResults_Facilities]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetResults_Procedures]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetResults]', 'U'))
		ALTER TABLE [dbo].[CallSheetResults] DROP CONSTRAINT [FK_CallSheetResults_Procedures]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetResults_Users]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetResults]', 'U'))
		ALTER TABLE [dbo].[CallSheetResults] DROP CONSTRAINT [FK_CallSheetResults_Users]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping foreign keys from [dbo].[CallSheetResultEx]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetResultEx_CallSheetResults]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetResultEx]', 'U'))
		ALTER TABLE [dbo].[CallSheetResultEx] DROP CONSTRAINT [FK_CallSheetResultEx_CallSheetResults]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping foreign keys from [dbo].[Points]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Points_CallSheetResults]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Points]', 'U'))
		ALTER TABLE [dbo].[Points] DROP CONSTRAINT [FK_Points_CallSheetResults]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheetResults]'

		IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PK_CallSheetResults]', 'PK') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetResults]', 'U'))
		ALTER TABLE [dbo].[CallSheetResults] DROP CONSTRAINT [PK_CallSheetResults]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheetResults]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lRun' AND object_id = OBJECT_ID(N'[dbo].[CallSheetResults]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheetResults_lRun]', 'D'))
		ALTER TABLE [dbo].[CallSheetResults] DROP CONSTRAINT [DF_CallSheetResults_lRun]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheetResults]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lActive' AND object_id = OBJECT_ID(N'[dbo].[CallSheetResults]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheetResults_lActive]', 'D'))
		ALTER TABLE [dbo].[CallSheetResults] DROP CONSTRAINT [DF_CallSheetResults_lActive]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheetResults]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lDeleted' AND object_id = OBJECT_ID(N'[dbo].[CallSheetResults]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheetResults_lDeleted]', 'D'))
		ALTER TABLE [dbo].[CallSheetResults] DROP CONSTRAINT [DF_CallSheetResults_lDeleted]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheetResults]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lApproved' AND object_id = OBJECT_ID(N'[dbo].[CallSheetResults]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheetResults_lApproved]', 'D'))
		ALTER TABLE [dbo].[CallSheetResults] DROP CONSTRAINT [DF_CallSheetResults_lApproved]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheetResults]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lAdded' AND object_id = OBJECT_ID(N'[dbo].[CallSheetResults]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheetResults_lAdded]', 'D'))
		ALTER TABLE [dbo].[CallSheetResults] DROP CONSTRAINT [DF_CallSheetResults_lAdded]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheetResults]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nAddFacilityUID' AND object_id = OBJECT_ID(N'[dbo].[CallSheetResults]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheetResults_nAddFacilityUID]', 'D'))
		ALTER TABLE [dbo].[CallSheetResults] DROP CONSTRAINT [DF_CallSheetResults_nAddFacilityUID]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheetResults]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nAddUserUID' AND object_id = OBJECT_ID(N'[dbo].[CallSheetResults]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheetResults_nAddUserUID]', 'D'))
		ALTER TABLE [dbo].[CallSheetResults] DROP CONSTRAINT [DF_CallSheetResults_nAddUserUID]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheetResults]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'tAddTime' AND object_id = OBJECT_ID(N'[dbo].[CallSheetResults]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheetResults_tAddTime]', 'D'))
		ALTER TABLE [dbo].[CallSheetResults] DROP CONSTRAINT [DF_CallSheetResults_tAddTime]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheetResults]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nUpdateFacilityUID' AND object_id = OBJECT_ID(N'[dbo].[CallSheetResults]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheetResults_nUpdateFacilityUID]', 'D'))
		ALTER TABLE [dbo].[CallSheetResults] DROP CONSTRAINT [DF_CallSheetResults_nUpdateFacilityUID]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheetResults]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nUpdateUserUID' AND object_id = OBJECT_ID(N'[dbo].[CallSheetResults]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheetResults_nUpdateUserUID]', 'D'))
		ALTER TABLE [dbo].[CallSheetResults] DROP CONSTRAINT [DF_CallSheetResults_nUpdateUserUID]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheetResults]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'tUpdateTime' AND object_id = OBJECT_ID(N'[dbo].[CallSheetResults]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheetResults_tUpdateTime]', 'D'))
		ALTER TABLE [dbo].[CallSheetResults] DROP CONSTRAINT [DF_CallSheetResults_tUpdateTime]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheetResults]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'tMobileTime' AND object_id = OBJECT_ID(N'[dbo].[CallSheetResults]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheetResults_tMobileTime]', 'D'))
		ALTER TABLE [dbo].[CallSheetResults] DROP CONSTRAINT [DF_CallSheetResults_tMobileTime]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping index [IDX_CallSheetResults_tAddTime] from [dbo].[CallSheetResults]'

		IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_CallSheetResults_tAddTime' AND object_id = OBJECT_ID(N'[dbo].[CallSheetResults]'))
		DROP INDEX [IDX_CallSheetResults_tAddTime] ON [dbo].[CallSheetResults]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping trigger [dbo].[tr_kr_audit_CallSheetResults_Del] from [dbo].[CallSheetResults]'

		IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheetResults_Del]', 'TR') IS NOT NULL
		DROP TRIGGER [dbo].[tr_kr_audit_CallSheetResults_Del]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping trigger [dbo].[tr_kr_audit_CallSheetResults_Ins] from [dbo].[CallSheetResults]'

		IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheetResults_Ins]', 'TR') IS NOT NULL
		DROP TRIGGER [dbo].[tr_kr_audit_CallSheetResults_Ins]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping trigger [dbo].[tr_kr_audit_CallSheetResults_Upd] from [dbo].[CallSheetResults]'

		IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheetResults_Upd]', 'TR') IS NOT NULL
		DROP TRIGGER [dbo].[tr_kr_audit_CallSheetResults_Upd]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Rebuilding [dbo].[CallSheetResults]'

		SET QUOTED_IDENTIFIER ON

		SET ANSI_NULLS ON

		CREATE TABLE [dbo].[RG_Recovery_1_CallSheetResults]
		(
		[nCallSheetResultUID] [uniqueidentifier] NOT NULL ROWGUIDCOL,
		[nCallSheetUID] [uniqueidentifier] NOT NULL,
		[nProcedureUID] [uniqueidentifier] NULL,
		[nTechnicianUID] [uniqueidentifier] NULL,
		[nRunAtFacilityUID] [uniqueidentifier] NULL,
		[nAttTemplateUID] [uniqueidentifier] NULL,
		[nCallSheetResultOrdinal] [numeric] (18, 0) NOT NULL,
		[cWorkstationName] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cDescription] [nvarchar] (300) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cStatus] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cDataOrigin] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cCallSheetResultType] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[tStartTime] [datetime] NULL,
		[tEndTime] [datetime] NULL,
		[mNotes] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[lRun] [int] NOT NULL CONSTRAINT [DF_CallSheetResults_lRun] DEFAULT ((0)),
		[lActive] [int] NOT NULL CONSTRAINT [DF_CallSheetResults_lActive] DEFAULT ((-1)),
		[lDeleted] [int] NOT NULL CONSTRAINT [DF_CallSheetResults_lDeleted] DEFAULT ((0)),
		[lApproved] [int] NOT NULL CONSTRAINT [DF_CallSheetResults_lApproved] DEFAULT ((0)),
		[lAdded] [int] NOT NULL CONSTRAINT [DF_CallSheetResults_lAdded] DEFAULT ((-1)),
		[nAddFacilityUID] [uniqueidentifier] NOT NULL CONSTRAINT [DF_CallSheetResults_nAddFacilityUID] DEFAULT ('DBA97ADF-F868-459D-8343-DE1DF0FFB398'),
		[nAddUserUID] [uniqueidentifier] NOT NULL CONSTRAINT [DF_CallSheetResults_nAddUserUID] DEFAULT ('915F9722-3175-4E4D-A571-4A478E8E5172'),
		[tAddTime] [datetime] NOT NULL CONSTRAINT [DF_CallSheetResults_tAddTime] DEFAULT (getutcdate()),
		[nUpdateFacilityUID] [uniqueidentifier] NOT NULL CONSTRAINT [DF_CallSheetResults_nUpdateFacilityUID] DEFAULT ('DBA97ADF-F868-459D-8343-DE1DF0FFB398'),
		[nUpdateUserUID] [uniqueidentifier] NOT NULL CONSTRAINT [DF_CallSheetResults_nUpdateUserUID] DEFAULT ('915F9722-3175-4E4D-A571-4A478E8E5172'),
		[tUpdateTime] [datetime] NOT NULL CONSTRAINT [DF_CallSheetResults_tUpdateTime] DEFAULT (getutcdate()),
		[tMobileTime] [datetime] NOT NULL CONSTRAINT [DF_CallSheetResults_tMobileTime] DEFAULT (getutcdate()),
		[tSystemUpdateTime] [datetime] NULL,
		[nImportUID] [uniqueidentifier] NULL,
		CONSTRAINT [RG_Recovery_7d8f_PK_CallSheetResults] PRIMARY KEY NONCLUSTERED  ([nCallSheetResultUID])
		)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		INSERT INTO [dbo].[RG_Recovery_1_CallSheetResults]([nCallSheetResultUID], [nCallSheetUID], [nProcedureUID], [nTechnicianUID], [nRunAtFacilityUID], [nCallSheetResultOrdinal], [cWorkstationName], [cDescription], [cStatus], [cDataOrigin], [cCallSheetResultType], [tStartTime], [tEndTime], [mNotes], [lRun], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID]) SELECT [nCallSheetResultUID], [nCallSheetUID], [nProcedureUID], [nTechnicianUID], [nRunAtFacilityUID], [nCallSheetResultOrdinal], [cWorkstationName], [cDescription], [cStatus], [cDataOrigin], [cCallSheetResultType], [tStartTime], [tEndTime], [mNotes], [lRun], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID] FROM [dbo].[CallSheetResults]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		DROP TABLE [dbo].[CallSheetResults]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF (OBJECT_ID(N'[dbo].[RG_Recovery_1_CallSheetResults]', 'U') IS NOT NULL) AND (OBJECT_ID(N'[dbo].[CallSheetResults]', 'U') IS NULL)
		EXEC sp_rename N'[dbo].[RG_Recovery_1_CallSheetResults]', N'CallSheetResults', N'OBJECT'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		EXEC sp_rename N'[dbo].[CallSheetResults].[RG_Recovery_7d8f_PK_CallSheetResults]', N'PK_CallSheetResults', N'INDEX'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Creating index [IDX_CallSheetResults_tAddTime] on [dbo].[CallSheetResults]'

		IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_CallSheetResults_tAddTime' AND object_id = OBJECT_ID(N'[dbo].[CallSheetResults]'))
		CREATE CLUSTERED INDEX [IDX_CallSheetResults_tAddTime] ON [dbo].[CallSheetResults] ([tAddTime])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Creating trigger [dbo].[tr_kr_audit_CallSheetResults_Del] on [dbo].[CallSheetResults]'

		IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheetResults_Del]', 'TR') IS NULL
		EXEC sp_executesql N'CREATE TRIGGER [dbo].[tr_kr_audit_CallSheetResults_Del] ON [dbo].[CallSheetResults] FOR DELETE NOT FOR REPLICATION AS
		BEGIN

		-- OmniAudit 1.14.0.495
		-- Copyright © 2001-2011 Krell Software, Inc.
		-- www.krell-software.com
		-- 
		-- Generated by Fluke Calibration on June 23, 2016 11:29 AM

		SET NOCOUNT ON

		DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
		SELECT @RowsAffected = COUNT(*) FROM DELETED


		IF( @RowsAffected > 0 )
		BEGIN
		SELECT @AuditedUser = NULL

		EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
		IF( @ValidRun <> 0 )
		RETURN

		-- Populate audit detail records...
		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2085,
		0,
		CONVERT( NVARCHAR(max), NULLIF([cCallSheetResultType], '''') )
		FROM
		DELETED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2086,
		0,
		CONVERT( NVARCHAR(max), NULLIF([cDataOrigin], '''') )
		FROM
		DELETED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2087,
		0,
		CONVERT( NVARCHAR(max), NULLIF([cDescription], '''') )
		FROM
		DELETED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2088,
		0,
		CONVERT( NVARCHAR(max), NULLIF([cStatus], '''') )
		FROM
		DELETED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2089,
		0,
		CONVERT( NVARCHAR(max), NULLIF([cWorkstationName], '''') )
		FROM
		DELETED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2090,
		0,
		CONVERT(NVARCHAR, [lActive])
		FROM
		DELETED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2091,
		0,
		CONVERT(NVARCHAR, [lAdded])
		FROM
		DELETED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2092,
		0,
		CONVERT(NVARCHAR, [lApproved])
		FROM
		DELETED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2093,
		0,
		CONVERT(NVARCHAR, [lDeleted])
		FROM
		DELETED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2094,
		0,
		CONVERT(NVARCHAR, [lRun])
		FROM
		DELETED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2095,
		0,
		CONVERT( NVARCHAR(max), NULLIF([mNotes], '''') )
		FROM
		DELETED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2096,
		0,
		CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
		FROM
		DELETED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2097,
		0,
		CONVERT(NVARCHAR( 36 ), [nAddUserUID])
		FROM
		DELETED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2098,
		0,
		CONVERT( NVARCHAR( 41 ), [nCallSheetResultOrdinal], 2 )
		FROM
		DELETED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2099,
		0,
		CONVERT(NVARCHAR( 36 ), [nCallSheetResultUID])
		FROM
		DELETED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2100,
		0,
		CONVERT(NVARCHAR( 36 ), [nCallSheetUID])
		FROM
		DELETED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2101,
		0,
		CONVERT(NVARCHAR( 36 ), [nImportUID])
		FROM
		DELETED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2102,
		0,
		CONVERT(NVARCHAR( 36 ), [nProcedureUID])
		FROM
		DELETED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2103,
		0,
		CONVERT(NVARCHAR( 36 ), [nRunAtFacilityUID])
		FROM
		DELETED
		
		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		3010,
		0,
		CONVERT(NVARCHAR( 36 ), [nAttTemplateUID])
		FROM
		DELETED		

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2104,
		0,
		CONVERT(NVARCHAR( 36 ), [nTechnicianUID])
		FROM
		DELETED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2105,
		0,
		CONVERT(NVARCHAR( 36 ), [nUpdateFacilityUID])
		FROM
		DELETED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2106,
		0,
		CONVERT(NVARCHAR( 36 ), [nUpdateUserUID])
		FROM
		DELETED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2107,
		0,
		CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
		FROM
		DELETED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2108,
		0,
		CONVERT( NVARCHAR( 34 ), [tEndTime], 121 )
		FROM
		DELETED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2109,
		0,
		CONVERT( NVARCHAR( 34 ), [tMobileTime], 121 )
		FROM
		DELETED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2110,
		0,
		CONVERT( NVARCHAR( 34 ), [tStartTime], 121 )
		FROM
		DELETED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2111,
		0,
		CONVERT( NVARCHAR( 34 ), [tSystemUpdateTime], 121 )
		FROM
		DELETED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2112,
		0,
		CONVERT( NVARCHAR( 34 ), [tUpdateTime], 121 )
		FROM
		DELETED

		EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 63, @RowsAffected, ''D'', @AuditedUser
		END  -- IF( @RowsAffected > 0 )
		END
		'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_CallSheetResults_Del]', 'last', 'delete', null

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Creating trigger [dbo].[tr_kr_audit_CallSheetResults_Ins] on [dbo].[CallSheetResults]'

		IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheetResults_Ins]', 'TR') IS NULL
		EXEC sp_executesql N'CREATE TRIGGER [dbo].[tr_kr_audit_CallSheetResults_Ins] ON [dbo].[CallSheetResults] FOR INSERT NOT FOR REPLICATION AS
		BEGIN

		-- OmniAudit 1.14.0.495
		-- Copyright © 2001-2011 Krell Software, Inc.
		-- www.krell-software.com
		-- 
		-- Generated by Fluke Calibration on June 23, 2016 11:29 AM

		SET NOCOUNT ON

		DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
		SELECT @RowsAffected = COUNT(*) FROM INSERTED


		IF( @RowsAffected > 0 )
		BEGIN
		SELECT @AuditedUser = NULL

		EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
		IF( @ValidRun <> 0 )
		RETURN

		-- Populate audit detail records...
		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2085,
		0,
		CONVERT( NVARCHAR(max), NULLIF([cCallSheetResultType], '''') )
		FROM
		INSERTED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2086,
		0,
		CONVERT( NVARCHAR(max), NULLIF([cDataOrigin], '''') )
		FROM
		INSERTED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2087,
		0,
		CONVERT( NVARCHAR(max), NULLIF([cDescription], '''') )
		FROM
		INSERTED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2088,
		0,
		CONVERT( NVARCHAR(max), NULLIF([cStatus], '''') )
		FROM
		INSERTED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2089,
		0,
		CONVERT( NVARCHAR(max), NULLIF([cWorkstationName], '''') )
		FROM
		INSERTED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2090,
		0,
		CONVERT(NVARCHAR, [lActive])
		FROM
		INSERTED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2091,
		0,
		CONVERT(NVARCHAR, [lAdded])
		FROM
		INSERTED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2092,
		0,
		CONVERT(NVARCHAR, [lApproved])
		FROM
		INSERTED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2093,
		0,
		CONVERT(NVARCHAR, [lDeleted])
		FROM
		INSERTED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2094,
		0,
		CONVERT(NVARCHAR, [lRun])
		FROM
		INSERTED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2095,
		0,
		CONVERT( NVARCHAR(max), NULLIF([mNotes], '''') )
		FROM
		INSERTED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2096,
		0,
		CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
		FROM
		INSERTED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2097,
		0,
		CONVERT(NVARCHAR( 36 ), [nAddUserUID])
		FROM
		INSERTED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2098,
		0,
		CONVERT( NVARCHAR( 41 ), [nCallSheetResultOrdinal], 2 )
		FROM
		INSERTED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2099,
		0,
		CONVERT(NVARCHAR( 36 ), [nCallSheetResultUID])
		FROM
		INSERTED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2100,
		0,
		CONVERT(NVARCHAR( 36 ), [nCallSheetUID])
		FROM
		INSERTED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2102,
		0,
		CONVERT(NVARCHAR( 36 ), [nProcedureUID])
		FROM
		INSERTED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2103,
		0,
		CONVERT(NVARCHAR( 36 ), [nRunAtFacilityUID])
		FROM
		INSERTED
		
		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		3010,
		0,
		CONVERT(NVARCHAR( 36 ), [nAttTemplateUID])
		FROM
		INSERTED		

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2104,
		0,
		CONVERT(NVARCHAR( 36 ), [nTechnicianUID])
		FROM
		INSERTED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2107,
		0,
		CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
		FROM
		INSERTED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2108,
		0,
		CONVERT( NVARCHAR( 34 ), [tEndTime], 121 )
		FROM
		INSERTED

		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultUID]),
		2110,
		0,
		CONVERT( NVARCHAR( 34 ), [tStartTime], 121 )
		FROM
		  INSERTED

			DECLARE @nAddUserUID [uniqueidentifier],
					@nAddFacilityUID [uniqueidentifier]
			SELECT
				@nAddUserUID = nAddUserUID ,
				@nAddFacilityUID = nAddFacilityUID
			FROM
				INSERTED

		EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 63, @RowsAffected, ''I'', @AuditedUser, @nAddUserUID, @nAddFacilityUID, NULL, NULL
		END  -- IF( @RowsAffected > 0 )
		END
		'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_CallSheetResults_Ins]', 'last', 'insert', null

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Creating trigger [dbo].[tr_kr_audit_CallSheetResults_Upd] on [dbo].[CallSheetResults]'

		IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheetResults_Upd]', 'TR') IS NULL
		EXEC sp_executesql N'CREATE TRIGGER [dbo].[tr_kr_audit_CallSheetResults_Upd] ON [dbo].[CallSheetResults] FOR UPDATE NOT FOR REPLICATION AS
		BEGIN

		-- OmniAudit 1.14.0.495
		-- Copyright © 2001-2011 Krell Software, Inc.
		-- www.krell-software.com
		-- 
		-- Generated by Fluke Calibration on June 23, 2016 11:29 AM

		SET NOCOUNT ON

		DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier, @ChangeCount INT, @CaptureCount INT
		SELECT @RowsAffected = COUNT(*) FROM INSERTED


		IF( @RowsAffected > 0 )
		BEGIN
		SELECT @AuditedUser = NULL

		EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
		IF( @ValidRun <> 0 )
		RETURN

		SELECT @CaptureCount = 0

		-- Test for a key update...
		SELECT @ChangeCount = COUNT(*)
		FROM
		INSERTED i
		FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultUID] = i.[nCallSheetResultUID] )

		-- Populate audit detail records...
		IF( UPDATE( [cCallSheetResultType] ) )
		BEGIN
		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultUID], d.[nCallSheetResultUID] )),
		2085,
		0,
		CONVERT( NVARCHAR(max), NULLIF(d.[cCallSheetResultType], '''') ),
		CONVERT( NVARCHAR(max), NULLIF(i.[cCallSheetResultType], '''') )
		FROM
		INSERTED i
		FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultUID] = i.[nCallSheetResultUID] )
		WHERE
		  ( NULLIF(d.[cCallSheetResultType], '''') <> NULLIF(i.[cCallSheetResultType], '''') ) OR
		( NULLIF(d.[cCallSheetResultType], '''') IS NULL AND NULLIF(i.[cCallSheetResultType], '''') IS NOT NULL ) OR
		( NULLIF(i.[cCallSheetResultType], '''') IS NULL AND NULLIF(d.[cCallSheetResultType], '''') IS NOT NULL )

		SELECT @CaptureCount = @CaptureCount + @@RowCount
		END

		IF( UPDATE( [cDataOrigin] ) )
		BEGIN
		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultUID], d.[nCallSheetResultUID] )),
		2086,
		0,
		CONVERT( NVARCHAR(max), NULLIF(d.[cDataOrigin], '''') ),
		CONVERT( NVARCHAR(max), NULLIF(i.[cDataOrigin], '''') )
		FROM
		INSERTED i
		FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultUID] = i.[nCallSheetResultUID] )
		WHERE
		  ( NULLIF(d.[cDataOrigin], '''') <> NULLIF(i.[cDataOrigin], '''') ) OR
		( NULLIF(d.[cDataOrigin], '''') IS NULL AND NULLIF(i.[cDataOrigin], '''') IS NOT NULL ) OR
		( NULLIF(i.[cDataOrigin], '''') IS NULL AND NULLIF(d.[cDataOrigin], '''') IS NOT NULL )

		SELECT @CaptureCount = @CaptureCount + @@RowCount
		END

		IF( UPDATE( [cDescription] ) )
		BEGIN
		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultUID], d.[nCallSheetResultUID] )),
		2087,
		0,
		CONVERT( NVARCHAR(max), NULLIF(d.[cDescription], '''') ),
		CONVERT( NVARCHAR(max), NULLIF(i.[cDescription], '''') )
		FROM
		INSERTED i
		FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultUID] = i.[nCallSheetResultUID] )
		WHERE
		  ( NULLIF(d.[cDescription], '''') <> NULLIF(i.[cDescription], '''') ) OR
		( NULLIF(d.[cDescription], '''') IS NULL AND NULLIF(i.[cDescription], '''') IS NOT NULL ) OR
		( NULLIF(i.[cDescription], '''') IS NULL AND NULLIF(d.[cDescription], '''') IS NOT NULL )

		SELECT @CaptureCount = @CaptureCount + @@RowCount
		END

		IF( UPDATE( [cStatus] ) )
		BEGIN
		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultUID], d.[nCallSheetResultUID] )),
		2088,
		0,
		CONVERT( NVARCHAR(max), NULLIF(d.[cStatus], '''') ),
		CONVERT( NVARCHAR(max), NULLIF(i.[cStatus], '''') )
		FROM
		INSERTED i
		FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultUID] = i.[nCallSheetResultUID] )
		WHERE
		  ( NULLIF(d.[cStatus], '''') <> NULLIF(i.[cStatus], '''') ) OR
		( NULLIF(d.[cStatus], '''') IS NULL AND NULLIF(i.[cStatus], '''') IS NOT NULL ) OR
		( NULLIF(i.[cStatus], '''') IS NULL AND NULLIF(d.[cStatus], '''') IS NOT NULL )

		SELECT @CaptureCount = @CaptureCount + @@RowCount
		END

		IF( UPDATE( [cWorkstationName] ) )
		BEGIN
		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultUID], d.[nCallSheetResultUID] )),
		2089,
		0,
		CONVERT( NVARCHAR(max), NULLIF(d.[cWorkstationName], '''') ),
		CONVERT( NVARCHAR(max), NULLIF(i.[cWorkstationName], '''') )
		FROM
		INSERTED i
		FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultUID] = i.[nCallSheetResultUID] )
		WHERE
		  ( NULLIF(d.[cWorkstationName], '''') <> NULLIF(i.[cWorkstationName], '''') ) OR
		( NULLIF(d.[cWorkstationName], '''') IS NULL AND NULLIF(i.[cWorkstationName], '''') IS NOT NULL ) OR
		( NULLIF(i.[cWorkstationName], '''') IS NULL AND NULLIF(d.[cWorkstationName], '''') IS NOT NULL )

		SELECT @CaptureCount = @CaptureCount + @@RowCount
		END

		IF( UPDATE( [lActive] ) )
		BEGIN
		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultUID], d.[nCallSheetResultUID] )),
		2090,
		0,
		CONVERT(NVARCHAR, d.[lActive]),
		CONVERT(NVARCHAR, i.[lActive])
		FROM
		INSERTED i
		FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultUID] = i.[nCallSheetResultUID] )
		WHERE
		  ( d.[lActive] <> i.[lActive] ) OR
		( d.[lActive] IS NULL AND i.[lActive] IS NOT NULL ) OR
		( i.[lActive] IS NULL AND d.[lActive] IS NOT NULL )

		SELECT @CaptureCount = @CaptureCount + @@RowCount
		END

		IF( UPDATE( [lAdded] ) )
		BEGIN
		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultUID], d.[nCallSheetResultUID] )),
		2091,
		0,
		CONVERT(NVARCHAR, d.[lAdded]),
		CONVERT(NVARCHAR, i.[lAdded])
		FROM
		INSERTED i
		FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultUID] = i.[nCallSheetResultUID] )
		WHERE
		  ( d.[lAdded] <> i.[lAdded] ) OR
		( d.[lAdded] IS NULL AND i.[lAdded] IS NOT NULL ) OR
		( i.[lAdded] IS NULL AND d.[lAdded] IS NOT NULL )

		SELECT @CaptureCount = @CaptureCount + @@RowCount
		END

		IF( UPDATE( [lApproved] ) )
		BEGIN
		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultUID], d.[nCallSheetResultUID] )),
		2092,
		0,
		CONVERT(NVARCHAR, d.[lApproved]),
		CONVERT(NVARCHAR, i.[lApproved])
		FROM
		INSERTED i
		FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultUID] = i.[nCallSheetResultUID] )
		WHERE
		  ( d.[lApproved] <> i.[lApproved] ) OR
		( d.[lApproved] IS NULL AND i.[lApproved] IS NOT NULL ) OR
		( i.[lApproved] IS NULL AND d.[lApproved] IS NOT NULL )

		SELECT @CaptureCount = @CaptureCount + @@RowCount
		END

		IF( UPDATE( [lDeleted] ) )
		BEGIN
		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultUID], d.[nCallSheetResultUID] )),
		2093,
		0,
		CONVERT(NVARCHAR, d.[lDeleted]),
		CONVERT(NVARCHAR, i.[lDeleted])
		FROM
		INSERTED i
		FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultUID] = i.[nCallSheetResultUID] )
		WHERE
		  ( d.[lDeleted] <> i.[lDeleted] ) OR
		( d.[lDeleted] IS NULL AND i.[lDeleted] IS NOT NULL ) OR
		( i.[lDeleted] IS NULL AND d.[lDeleted] IS NOT NULL )

		SELECT @CaptureCount = @CaptureCount + @@RowCount
		END

		IF( UPDATE( [lRun] ) )
		BEGIN
		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultUID], d.[nCallSheetResultUID] )),
		2094,
		0,
		CONVERT(NVARCHAR, d.[lRun]),
		CONVERT(NVARCHAR, i.[lRun])
		FROM
		INSERTED i
		FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultUID] = i.[nCallSheetResultUID] )
		WHERE
		  ( d.[lRun] <> i.[lRun] ) OR
		( d.[lRun] IS NULL AND i.[lRun] IS NOT NULL ) OR
		( i.[lRun] IS NULL AND d.[lRun] IS NOT NULL )

		SELECT @CaptureCount = @CaptureCount + @@RowCount
		END

		IF( UPDATE( [mNotes] ) )
		BEGIN
		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultUID], d.[nCallSheetResultUID] )),
		2095,
		0,
		CONVERT( NVARCHAR(max), NULLIF(d.[mNotes], '''') ),
		CONVERT( NVARCHAR(max), NULLIF(i.[mNotes], '''') )
		FROM
		INSERTED i
		FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultUID] = i.[nCallSheetResultUID] )
		WHERE
		  ( NULLIF(d.[mNotes], '''') <> NULLIF(i.[mNotes], '''') ) OR
		( NULLIF(d.[mNotes], '''') IS NULL AND NULLIF(i.[mNotes], '''') IS NOT NULL ) OR
		( NULLIF(i.[mNotes], '''') IS NULL AND NULLIF(d.[mNotes], '''') IS NOT NULL )

		SELECT @CaptureCount = @CaptureCount + @@RowCount
		END

		IF( UPDATE( [nAddFacilityUID] ) )
		BEGIN
		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultUID], d.[nCallSheetResultUID] )),
		2096,
		0,
		CONVERT(NVARCHAR( 36 ), d.[nAddFacilityUID]),
		CONVERT(NVARCHAR( 36 ), i.[nAddFacilityUID])
		FROM
		INSERTED i
		FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultUID] = i.[nCallSheetResultUID] )
		WHERE
		  ( d.[nAddFacilityUID] <> i.[nAddFacilityUID] ) OR
		( d.[nAddFacilityUID] IS NULL AND i.[nAddFacilityUID] IS NOT NULL ) OR
		( i.[nAddFacilityUID] IS NULL AND d.[nAddFacilityUID] IS NOT NULL )

		SELECT @CaptureCount = @CaptureCount + @@RowCount
		END

		IF( UPDATE( [nAddUserUID] ) )
		BEGIN
		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultUID], d.[nCallSheetResultUID] )),
		2097,
		0,
		CONVERT(NVARCHAR( 36 ), d.[nAddUserUID]),
		CONVERT(NVARCHAR( 36 ), i.[nAddUserUID])
		FROM
		INSERTED i
		FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultUID] = i.[nCallSheetResultUID] )
		WHERE
		  ( d.[nAddUserUID] <> i.[nAddUserUID] ) OR
		( d.[nAddUserUID] IS NULL AND i.[nAddUserUID] IS NOT NULL ) OR
		( i.[nAddUserUID] IS NULL AND d.[nAddUserUID] IS NOT NULL )

		SELECT @CaptureCount = @CaptureCount + @@RowCount
		END

		IF( UPDATE( [nCallSheetResultOrdinal] ) )
		BEGIN
		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultUID], d.[nCallSheetResultUID] )),
		2098,
		0,
		CONVERT( NVARCHAR( 41 ), d.[nCallSheetResultOrdinal], 2 ),
		CONVERT( NVARCHAR( 41 ), i.[nCallSheetResultOrdinal], 2 )
		FROM
		INSERTED i
		FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultUID] = i.[nCallSheetResultUID] )
		WHERE
		  ( d.[nCallSheetResultOrdinal] <> i.[nCallSheetResultOrdinal] ) OR
		( d.[nCallSheetResultOrdinal] IS NULL AND i.[nCallSheetResultOrdinal] IS NOT NULL ) OR
		( i.[nCallSheetResultOrdinal] IS NULL AND d.[nCallSheetResultOrdinal] IS NOT NULL )

		SELECT @CaptureCount = @CaptureCount + @@RowCount
		END

		IF( UPDATE( [nCallSheetResultUID] ) )
		BEGIN
		-- Audit key column updates...
		IF( @ChangeCount > @RowsAffected )
		BEGIN
		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
		SELECT
		  @AuditID,
		  ''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultUID], d.[nCallSheetResultUID] )),
		  2099,
		  0,
		  CONVERT(NVARCHAR( 36 ), d.[nCallSheetResultUID]),
		  CONVERT(NVARCHAR( 36 ), i.[nCallSheetResultUID])
		FROM
		  INSERTED i
		  FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultUID] = i.[nCallSheetResultUID] )
		WHERE
		  ( d.[nCallSheetResultUID] <> i.[nCallSheetResultUID] ) OR
		  ( d.[nCallSheetResultUID] IS NULL AND i.[nCallSheetResultUID] IS NOT NULL ) OR
		  ( i.[nCallSheetResultUID] IS NULL AND d.[nCallSheetResultUID] IS NOT NULL )
		SELECT @CaptureCount = @CaptureCount + @@RowCount
		END
		END

		IF( UPDATE( [nCallSheetUID] ) )
		BEGIN
		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultUID], d.[nCallSheetResultUID] )),
		2100,
		0,
		CONVERT(NVARCHAR( 36 ), d.[nCallSheetUID]),
		CONVERT(NVARCHAR( 36 ), i.[nCallSheetUID])
		FROM
		INSERTED i
		FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultUID] = i.[nCallSheetResultUID] )
		WHERE
		  ( d.[nCallSheetUID] <> i.[nCallSheetUID] ) OR
		( d.[nCallSheetUID] IS NULL AND i.[nCallSheetUID] IS NOT NULL ) OR
		( i.[nCallSheetUID] IS NULL AND d.[nCallSheetUID] IS NOT NULL )

		SELECT @CaptureCount = @CaptureCount + @@RowCount
		END

		IF( UPDATE( [nProcedureUID] ) )
		BEGIN
		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultUID], d.[nCallSheetResultUID] )),
		2102,
		0,
		CONVERT(NVARCHAR( 36 ), d.[nProcedureUID]),
		CONVERT(NVARCHAR( 36 ), i.[nProcedureUID])
		FROM
		INSERTED i
		FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultUID] = i.[nCallSheetResultUID] )
		WHERE
		  ( d.[nProcedureUID] <> i.[nProcedureUID] ) OR
		( d.[nProcedureUID] IS NULL AND i.[nProcedureUID] IS NOT NULL ) OR
		( i.[nProcedureUID] IS NULL AND d.[nProcedureUID] IS NOT NULL )

		SELECT @CaptureCount = @CaptureCount + @@RowCount
		END

		IF( UPDATE( [nRunAtFacilityUID] ) )
		BEGIN
		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultUID], d.[nCallSheetResultUID] )),
		2103,
		0,
		CONVERT(NVARCHAR( 36 ), d.[nRunAtFacilityUID]),
		CONVERT(NVARCHAR( 36 ), i.[nRunAtFacilityUID])
		FROM
		INSERTED i
		FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultUID] = i.[nCallSheetResultUID] )
		WHERE
		  ( d.[nRunAtFacilityUID] <> i.[nRunAtFacilityUID] ) OR
		( d.[nRunAtFacilityUID] IS NULL AND i.[nRunAtFacilityUID] IS NOT NULL ) OR
		( i.[nRunAtFacilityUID] IS NULL AND d.[nRunAtFacilityUID] IS NOT NULL )

		SELECT @CaptureCount = @CaptureCount + @@RowCount
		END
		
		IF( UPDATE( [nAttTemplateUID] ) )
		BEGIN
		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultUID], d.[nCallSheetResultUID] )),
		3010,
		0,
		CONVERT(NVARCHAR( 36 ), d.[nAttTemplateUID]),
		CONVERT(NVARCHAR( 36 ), i.[nAttTemplateUID])
		FROM
		INSERTED i
		FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultUID] = i.[nCallSheetResultUID] )
		WHERE
		  ( d.[nAttTemplateUID] <> i.[nAttTemplateUID] ) OR
		( d.[nAttTemplateUID] IS NULL AND i.[nAttTemplateUID] IS NOT NULL ) OR
		( i.[nAttTemplateUID] IS NULL AND d.[nAttTemplateUID] IS NOT NULL )

		SELECT @CaptureCount = @CaptureCount + @@RowCount
		END		

		IF( UPDATE( [nTechnicianUID] ) )
		BEGIN
		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultUID], d.[nCallSheetResultUID] )),
		2104,
		0,
		CONVERT(NVARCHAR( 36 ), d.[nTechnicianUID]),
		CONVERT(NVARCHAR( 36 ), i.[nTechnicianUID])
		FROM
		INSERTED i
		FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultUID] = i.[nCallSheetResultUID] )
		WHERE
		  ( d.[nTechnicianUID] <> i.[nTechnicianUID] ) OR
		( d.[nTechnicianUID] IS NULL AND i.[nTechnicianUID] IS NOT NULL ) OR
		( i.[nTechnicianUID] IS NULL AND d.[nTechnicianUID] IS NOT NULL )

		SELECT @CaptureCount = @CaptureCount + @@RowCount
		END

		IF( UPDATE( [tAddTime] ) )
		BEGIN
		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultUID], d.[nCallSheetResultUID] )),
		2107,
		0,
		CONVERT( NVARCHAR( 34 ), d.[tAddTime], 121 ),
		CONVERT( NVARCHAR( 34 ), i.[tAddTime], 121 )
		FROM
		INSERTED i
		FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultUID] = i.[nCallSheetResultUID] )
		WHERE
		  ( d.[tAddTime] <> i.[tAddTime] ) OR
		( d.[tAddTime] IS NULL AND i.[tAddTime] IS NOT NULL ) OR
		( i.[tAddTime] IS NULL AND d.[tAddTime] IS NOT NULL )

		SELECT @CaptureCount = @CaptureCount + @@RowCount
		END

		IF( UPDATE( [tEndTime] ) )
		BEGIN
		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultUID], d.[nCallSheetResultUID] )),
		2108,
		0,
		CONVERT( NVARCHAR( 34 ), d.[tEndTime], 121 ),
		CONVERT( NVARCHAR( 34 ), i.[tEndTime], 121 )
		FROM
		INSERTED i
		FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultUID] = i.[nCallSheetResultUID] )
		WHERE
		  ( d.[tEndTime] <> i.[tEndTime] ) OR
		( d.[tEndTime] IS NULL AND i.[tEndTime] IS NOT NULL ) OR
		( i.[tEndTime] IS NULL AND d.[tEndTime] IS NOT NULL )

		SELECT @CaptureCount = @CaptureCount + @@RowCount
		END

		IF( UPDATE( [tStartTime] ) )
		BEGIN
		INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
		SELECT
		@AuditID,
		''nCallSheetResultUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultUID], d.[nCallSheetResultUID] )),
		2110,
		0,
		CONVERT( NVARCHAR( 34 ), d.[tStartTime], 121 ),
		CONVERT( NVARCHAR( 34 ), i.[tStartTime], 121 )
		FROM
		INSERTED i
		FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultUID] = i.[nCallSheetResultUID] )
		WHERE
		  ( d.[tStartTime] <> i.[tStartTime] ) OR
		( d.[tStartTime] IS NULL AND i.[tStartTime] IS NOT NULL ) OR
		( i.[tStartTime] IS NULL AND d.[tStartTime] IS NOT NULL )

		SELECT @CaptureCount = @CaptureCount + @@RowCount
		END


		IF( @CaptureCount > 0 )
		BEGIN

			DECLARE @nUpdateUserUID [uniqueidentifier],
					@nUpdateFacilityUID [uniqueidentifier]
			SELECT
				@nUpdateUserUID = nUpdateUserUID,
				@nUpdateFacilityUID = nUpdateFacilityUID
			FROM
				INSERTED

		    EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 63, @RowsAffected, ''U'', @AuditedUser, NULL, NULL, @nUpdateUserUID, @nUpdateFacilityUID
		END
		END  -- IF( @RowsAffected > 0 )
		END
		'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_CallSheetResults_Upd]', 'last', 'update', null

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Adding foreign keys to [dbo].[CallSheetResults]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetResults_CallSheets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetResults]', 'U'))
		ALTER TABLE [dbo].[CallSheetResults] ADD CONSTRAINT [FK_CallSheetResults_CallSheets] FOREIGN KEY ([nCallSheetUID]) REFERENCES [dbo].[CallSheets] ([nCallSheetUID])

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetResults_Facilities]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetResults]', 'U'))
		ALTER TABLE [dbo].[CallSheetResults] ADD CONSTRAINT [FK_CallSheetResults_Facilities] FOREIGN KEY ([nRunAtFacilityUID]) REFERENCES [dbo].[Facilities] ([nFacilityUID])

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetResults_Files]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetResults]', 'U'))
		ALTER TABLE [dbo].[CallSheetResults] ADD CONSTRAINT [FK_CallSheetResults_Files] FOREIGN KEY ([nAttTemplateUID]) REFERENCES [dbo].[Files] ([nFileUID])

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetResults_Procedures]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetResults]', 'U'))
		ALTER TABLE [dbo].[CallSheetResults] ADD CONSTRAINT [FK_CallSheetResults_Procedures] FOREIGN KEY ([nProcedureUID]) REFERENCES [dbo].[Procedures] ([nProcedureUID])

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetResults_Users]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetResults]', 'U'))
		ALTER TABLE [dbo].[CallSheetResults] ADD CONSTRAINT [FK_CallSheetResults_Users] FOREIGN KEY ([nTechnicianUID]) REFERENCES [dbo].[Users] ([nUserUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Adding foreign keys to [dbo].[CallSheetResultEx]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetResultEx_CallSheetResults]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetResultEx]', 'U'))
		ALTER TABLE [dbo].[CallSheetResultEx] ADD CONSTRAINT [FK_CallSheetResultEx_CallSheetResults] FOREIGN KEY ([nCallSheetResultUID]) REFERENCES [dbo].[CallSheetResults] ([nCallSheetResultUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Adding foreign keys to [dbo].[Points]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Points_CallSheetResults]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Points]', 'U'))
		ALTER TABLE [dbo].[Points] ADD CONSTRAINT [FK_Points_CallSheetResults] FOREIGN KEY ([nCallSheetResultUID]) REFERENCES [dbo].[CallSheetResults] ([nCallSheetResultUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Creating extended properties'


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', NULL, NULL))
		EXEC sp_addextendedproperty N'MS_Description', N'One-to-many link between CallSheets and Points', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', NULL, NULL
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'cDataOrigin'))
		EXEC sp_addextendedproperty N'MS_Description', N'Originating system where the data came from', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'cDataOrigin'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'cDescription'))
		EXEC sp_addextendedproperty N'MS_Description', N'Description for this call sheet result', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'cDescription'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'cStatus'))
		EXEC sp_addextendedproperty N'MS_Description', N'Status for this call sheet result', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'cStatus'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'cWorkstationName'))
		EXEC sp_addextendedproperty N'MS_Description', N'Workstation the instrument was calibrated at', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'cWorkstationName'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'lActive'))
		EXEC sp_addextendedproperty N'MS_Description', N'0=inactive; -1 or 1=active', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'lActive'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'lAdded'))
		EXEC sp_addextendedproperty N'MS_Description', N'0=not added; -1 or 1=added', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'lAdded'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'lApproved'))
		EXEC sp_addextendedproperty N'MS_Description', N'0=not approved; -1 or 1=approved', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'lApproved'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'lDeleted'))
		EXEC sp_addextendedproperty N'MS_Description', N'0=not deleted; -1 or 1=deleted', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'lDeleted'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nAddFacilityUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'UID of the server that added the record', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nAddFacilityUID'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nAddUserUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'UID of the user that added the record', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nAddUserUID'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nCallSheetResultOrdinal'))
		EXEC sp_addextendedproperty N'MS_Description', N'Sequential number for this call sheet result', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nCallSheetResultOrdinal'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nCallSheetResultUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Unique identifier for the call sheet result used only by the system', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nCallSheetResultUID'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nCallSheetUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates the call sheet this result is from', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nCallSheetUID'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nImportUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'If imported, contains UID of the import record', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nImportUID'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nRunAtFacilityUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates the facility where the calibration is performed', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nRunAtFacilityUID'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nAttTemplateUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates the PXE / template file used when running the calibration', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nAttTemplateUID'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nTechnicianUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates the technician performing the calibration', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nTechnicianUID'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nUpdateFacilityUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'UID of the server that last updated the record', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nUpdateFacilityUID'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nUpdateUserUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'UID of the last user to update the record', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'nUpdateUserUID'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'tAddTime'))
		EXEC sp_addextendedproperty N'MS_Description', N'Time the record was added', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'tAddTime'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'tMobileTime'))
		EXEC sp_addextendedproperty N'MS_Description', N'Time the record was last updated for Mobile mode', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'tMobileTime'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'tSystemUpdateTime'))
		EXEC sp_addextendedproperty N'MS_Description', N'Time the record was last updated for the Warehouse', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'tSystemUpdateTime'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'tUpdateTime'))
		EXEC sp_addextendedproperty N'MS_Description', N'Time the record was last updated', 'SCHEMA', N'dbo', 'TABLE', N'CallSheetResults', 'COLUMN', N'tUpdateTime'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	PRINT N'Refreshing [dbo].[vw_METCAL_DataPoints]'

	IF OBJECT_ID(N'[dbo].[vw_METCAL_DataPoints]', 'V') IS NOT NULL
	EXEC sp_refreshview N'[dbo].[vw_METCAL_DataPoints]'

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	PRINT N'Refreshing [dbo].[vw_CallSheetReadings]'

	IF OBJECT_ID(N'[dbo].[vw_CallSheetReadings]', 'V') IS NOT NULL
	EXEC sp_refreshview N'[dbo].[vw_CallSheetReadings]'

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	PRINT N'Refreshing [dbo].[vw_CallSheetsWithAttCheck]'

	IF OBJECT_ID(N'[dbo].[vw_CallSheetsWithAttCheck]', 'V') IS NOT NULL
	EXEC sp_refreshview N'[dbo].[vw_CallSheetsWithAttCheck]'

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	IF EXISTS( SELECT * FROM sysobjects WHERE type='V' AND name='vw_METCAL_DataPoints' )
	BEGIN
		PRINT N'Dropping [dbo].[vw_METCAL_DataPoints]'

		DROP VIEW [dbo].[vw_METCAL_DataPoints]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[vw_METCAL_DataPoints]', 'V') IS NULL
	BEGIN
	PRINT N'Creating [dbo].[vw_METCAL_DataPoints]'

		EXEC sp_executesql N'

	/****************************************************************
		vw_METCAL_DataPoints
		(C) 2013-20 Fluke Calibration
	-----------------------------------------------------------------
		CHANGE HISTORY
		02/12/2013	EdW		Initial development
		07/24/2013  MM      Handle exponential formats
		08/22/2013  MM      Add more fields from CallSheetResults
		08/22/2013  MM      Add procedure used for work order results
		07/18/2019  WJS     Added nPointUID
		09/03/2020  MM      Added nAttTemplateUID
	*****************************************************************/
	CREATE VIEW [dbo].[vw_METCAL_DataPoints]
	AS
	SELECT
	csr.nCallSheetUID
	,csr.nCallSheetResultUID
	,csr.nProcedureUID
	,csr.nTechnicianUID
	,csr.nRunAtFacilityUID
	,csr.nAttTemplateUID
	,csr.nCallSheetResultOrdinal
	,ISNULL(csr.cWorkstationName,'''') AS [cWorkstationName]
	,ISNULL(csr.cDescription,'''') AS[cDescription]
	,ISNULL(csr.cStatus,'''') AS [cStatus]
	,ISNULL(csr.cDataOrigin,'''') AS [cDataOrigin]
	,ISNULL(csr.cCallSheetResultType,'''') AS [cCallSheetResultType]
	,csr.tStartTime
	,csr.tEndTime
	,ISNULL(prcsr.cProcedureName,''No Procedure'') AS [Procedure]
	,ISNULL(p.nPointOrdinal, 0) AS [row_num]
	,ISNULL(p.cPointDescription, '''') AS [test_desc]
	,ISNULL(p.cPointPassFailStatus, '''') AS [PointPassFail]
	,ISNULL([dbo].[udf_get_formattedValue](pen.nField010, pen.nField010FormatUID),'''') AS [fixq]
	,upen010.cUnitSymbol AS [Fixq_u]
	,ISNULL([dbo].[udf_get_formattedValue](pen.nField029, pen.nField029FormatUID),'''') AS [varq]
	,upen029.cUnitSymbol AS [varq_u]
	,ISNULL([dbo].[udf_get_formattedValue](pun.nLowerLimit, pun.nLowerLimitFormatUID),'''') AS [lower_limit]
	,upun1.cUnitSymbol AS [lower_limit_u]
	,ISNULL([dbo].[udf_get_formattedValue](pun.nUpperLimit, pun.nUpperLimitFormatUID),'''') AS [upper_limit]
	,upun2.cUnitSymbol AS [upper_limit_u]
	,ISNULL([dbo].[udf_get_formattedValue](pun.nUncertaintyExpanded, pun.nUncertaintyExpandedFormatUID),'''') AS [exp_uncert]
	,upun3.cUnitSymbol AS [exp_uncert_u]
	,ISNULL([dbo].[udf_get_formattedValue](pun.nUncertaintyStandard, pun.nUncertaintyStandardFormatUID),'''') AS [std_uncert]
	,upun4.cUnitSymbol AS [std_uncert_u]
	,ISNULL(CONVERT(VARCHAR,pun.nCoverageFactor),'''') AS [cov_fac]
	,ISNULL(p.cCondition, '''') AS [condition]
	,ISNULL(p.cRemarks, '''') AS [remark]
	,ISNULL([dbo].[udf_get_formattedValue](p.nCardinalPoint, p.nCardinalPointFormatUID),'''') AS [cpt]
	,up3.cUnitSymbol AS [cpt_u]
	,ISNULL(CONVERT(VARCHAR,p.lUUTIsFixed),'''') AS [fix_flag]
	,ISNULL([dbo].[udf_get_formattedValue](pen.nField015, pen.nField015FormatUID),'''') AS [nominal]
	,upen015.cUnitSymbol AS [nominal_u]
	,ISNULL([dbo].[udf_get_formattedValue](pun.nModifier1, pun.nModifier1FormatUID),'''') AS [mod1]
	,upun5.cUnitSymbol AS [mod1_u]
	,ISNULL([dbo].[udf_get_formattedValue](p.nReference, p.nReferenceFormatUID),'''') AS [sys_actual]
	,up2.cUnitSymbol AS [sys_actual_u]
	,ISNULL(CONVERT(VARCHAR,pel.lField001),'''') AS [corr_flag]
	,ISNULL([dbo].[udf_get_formattedValue](pen.nField027, pen.nField027FormatUID),'''') AS [uut_ind]
	,upen027.cUnitSymbol AS [uut_ind_u]
	,ISNULL([dbo].[udf_get_formattedValue](pen.nField008, pen.nField008FormatUID),'''') AS [expv]
	,upen008.cUnitSymbol AS [expv_u]
	,ISNULL([dbo].[udf_get_formattedValue](p.nUUT, p.nUUTFormatUID),'''') AS [measurement]
	,up1.cUnitSymbol AS [measurement_u]
	,ISNULL(CONVERT(VARCHAR,pel.lField001),'''') AS [meas_flag]
	,ISNULL([dbo].[udf_get_formattedValue](pen.nField006, pen.nField006FormatUID),'''') AS [dev]
	,upen006.cUnitSymbol AS [dev_u]
	,ISNULL([dbo].[udf_get_formattedValue](tol.nError, tol.nErrorFormatUID),'''') AS [error]
	,utol1.cUnitSymbol AS [error_u]
	,ISNULL(CONVERT(VARCHAR,tol.nReadingErrorPercent),'''') AS [rel_err]
	,'''' AS [rel_err_u]
	,ISNULL([dbo].[udf_get_formattedValue](p.nCorrection, p.nCorrectionFormatUID),'''') AS [corr]
	,up4.cUnitSymbol AS [corr_u]
	,ISNULL([dbo].[udf_get_formattedValue](pen.nField004, pen.nField004FormatUID),'''') AS [corr_unc]
	,upen004.cUnitSymbol AS [corr_unc_u]
	,ISNULL([dbo].[udf_get_formattedValue](tol.nReferenceTolerance, tol.nReferenceToleranceFormatUID),'''') AS [tol_ref]
	, utol2.cUnitSymbol AS [tol_ref_u]
	,ISNULL([dbo].[udf_get_formattedValue](tol.nToleranceNegative, tol.nToleranceNegativeFormatUID),'''') AS [tol_neg]
	,utol5.cUnitSymbol AS [tol_neg_u]
	,ISNULL([dbo].[udf_get_formattedValue](tol.nTolerancePositive, tol.nTolerancePositiveFormatUID),'''') AS [tol_pos]
	,utol6.cUnitSymbol AS [tol_pos_u]
	,ISNULL([dbo].[udf_get_formattedValue](tol.nTolerance, tol.nToleranceUnitUID),'''') AS [tol]
	,utol3.cUnitSymbol AS [tol_u]
	,ISNULL(pes.cField011,'''') AS [tur]
	,ISNULL(CONVERT(VARCHAR,tol.nToleranceErrorPercent),'''') AS [tol_err]
	,'''' AS [tol_err_u]
	,ISNULL(pun.cUncertaintyMethod,'''') AS [uncert_method]
	,ISNULL(CONVERT(VARCHAR,stat.nNumberOfSamplesDiscarded),'''') AS [nthrow]
	,ISNULL(CONVERT(VARCHAR,stat.nNumberOfSamplesUUT),'''') AS [num_meas]
	,ISNULL([dbo].[udf_get_formattedValue](stat.nUUTStandardDeviation, stat.nUUTStandardDeviationFormatUID),'''') AS [sdev]
	,ustat11.cUnitSymbol AS [sdev_u]
	,ISNULL([dbo].[udf_get_formattedValue](pun.nS1, pun.nS1FormatUID),'''') AS [s1]
	,upun16.cUnitSymbol AS [s1_u]
	,ISNULL([dbo].[udf_get_formattedValue](pun.nS2, pun.nS2FormatUID),'''') AS [s2]
	,upun17.cUnitSymbol AS [s2_u]
	,ISNULL([dbo].[udf_get_formattedValue](pun.nUncertaintyDominant, pun.nUncertaintyDominantFormatUID),'''') AS [dom_uncert]
	,upun20.cUnitSymbol AS [dom_uncert_u]
	,ISNULL(pes.cField009,'''') AS [test_step]
	,ISNULL(p.cFunctionSelectCode,'''') AS [fsc]
	,ISNULL(p.cPointLabel,'''') AS [result_type]
	,ISNULL(CONVERT(VARCHAR,p.lAccredited),'''') AS [accred]
	,ISNULL(pun.cGuardBandMethod,'''') AS [guardband_meth]
	,ISNULL([dbo].[udf_get_formattedValue](pun.nGuardBandLower, pun.nGuardBandLowerFormatUID),'''') AS [guardband_ll]
	,upun18.cUnitSymbol AS [guardband_ll_u]
	,ISNULL([dbo].[udf_get_formattedValue](pun.nGuardBandUpper, pun.nGuardBandUpperFormatUID),'''') AS [guardband_ul]
	,upun19.cUnitSymbol AS [guardband_ul_u]
	,ISNULL([dbo].[udf_get_formattedValue](p.nSystemAccuracy, p.nSystemAccuracyFormatUID),'''') AS [sys_acc]
	,up6.cUnitSymbol AS [sys_acc_u]
	,ISNULL(CONVERT(VARCHAR,pun.nSystemCoverageFactor),'''') AS [sys_cov_fac]
	,ISNULL([dbo].[udf_get_formattedValue](p.nUUTRange, p.nUUTRangeFormatUID),'''') AS [uut_range]
	,up5.cUnitSymbol AS [uut_range_u]
	,p.tAddTime AS [created]
	,p.tUpdateTime AS [editlogtime]
	,ISNULL(pes.cField010,'''') AS [test_step2]
	,p.nPointUID AS [nPointUID]
	FROM
	[dbo].[CallSheetResults] csr
	INNER JOIN [dbo].[Points] p ON p.nCallSheetResultUID = csr.nCallSheetResultUID
	LEFT JOIN [dbo].[procedures] prcsr ON csr.nProcedureUID = prcsr.nProcedureUID
	LEFT JOIN [dbo].[Units] up1 ON up1.nUnitUID = p.nUUTUnitUID
	LEFT JOIN [dbo].[Units] up2 ON up2.nUnitUID = p.nReferenceUnitUID
	LEFT JOIN [dbo].[Units] up3 ON up3.nUnitUID = p.nCardinalPointUnitUID
	LEFT JOIN [dbo].[Units] up4 ON up4.nUnitUID = p.nCorrectionUnitUID
	LEFT JOIN [dbo].[Units] up5 ON up5.nUnitUID = p.nUUTRangeUnitUID
	LEFT JOIN [dbo].[Units] up6 ON up6.nUnitUID = p.nSystemAccuracyUnitUID
	LEFT JOIN [dbo].[PointExNumerics] pen ON pen.nPointUID = p.nPointUID
	LEFT JOIN [dbo].[Units] upen010 ON upen010.nUnitUID = pen.nField010UnitUID
	LEFT JOIN [dbo].[Units] upen029 ON upen029.nUnitUID = pen.nField029UnitUID
	LEFT JOIN [dbo].[Units] upen015 ON upen015.nUnitUID = pen.nField015UnitUID
	LEFT JOIN [dbo].[Units] upen027 ON upen027.nUnitUID = pen.nField027UnitUID
	LEFT JOIN [dbo].[Units] upen008 ON upen008.nUnitUID = pen.nField008UnitUID
	LEFT JOIN [dbo].[Units] upen006 ON upen006.nUnitUID = pen.nField006UnitUID
	LEFT JOIN [dbo].[Units] upen004 ON upen004.nUnitUID = pen.nField004UnitUID
	LEFT JOIN [dbo].[PointUncertainties] pun ON pun.nPointUID = p.nPointUID
	LEFT JOIN [dbo].[Units] upun1 ON upun1.nUnitUID = pun.nLowerLimitUnitUID
	LEFT JOIN [dbo].[Units] upun2 ON upun2.nUnitUID = pun.nUpperLimitUnitUID
	LEFT JOIN [dbo].[Units] upun3 ON upun3.nUnitUID = pun.nUncertaintyExpandedUnitUID
	LEFT JOIN [dbo].[Units] upun4 ON upun4.nUnitUID = pun.nUncertaintyStandardUnitUID
	LEFT JOIN [dbo].[Units] upun5 ON upun5.nUnitUID = pun.nModifier1UnitUID
	LEFT JOIN [dbo].[Units] upun16 ON upun16.nUnitUID = pun.nS1UnitUID
	LEFT JOIN [dbo].[Units] upun17 ON upun17.nUnitUID = pun.nS2UnitUID
	LEFT JOIN [dbo].[Units] upun18 ON upun18.nUnitUID = pun.nGuardBandLowerUnitUID
	LEFT JOIN [dbo].[Units] upun19 ON upun19.nUnitUID = pun.nGuardBandUpperUnitUID
	LEFT JOIN [dbo].[Units] upun20 ON upun20.nUnitUID = pun.nUncertaintyDominantUnitUID
	LEFT JOIN [dbo].[PointExLogicals] pel ON pel.nPointUID = p.nPointUID
	LEFT JOIN [dbo].[PointTolerances] tol ON tol.nPointUID = p.nPointUID
	LEFT JOIN [dbo].[Units] utol1 ON utol1.nUnitUID = tol.nErrorUnitUID
	LEFT JOIN [dbo].[Units] utol2 ON utol2.nUnitUID = tol.nReferenceToleranceUnitUID
	LEFT JOIN [dbo].[Units] utol3 ON utol3.nUnitUID = tol.nToleranceFormatUID
	LEFT JOIN [dbo].[Units] utol5 ON utol5.nUnitUID = tol.nToleranceNegativeUnitUID
	LEFT JOIN [dbo].[Units] utol6 ON utol6.nUnitUID = tol.nTolerancePositiveUnitUID
	LEFT JOIN [dbo].[PointExStrings] pes ON pes.nPointUID = p.nPointUID
	LEFT JOIN [dbo].[PointStatistics] stat ON stat.nPointUID = p.nPointUID
	LEFT JOIN [dbo].[Units] ustat11 ON ustat11.nUnitUID = stat.nUUTStandardDeviationUnitUID
	WHERE
		p.lDeleted = 0
	AND
		p.lActive <> 0
	'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[spl_CallSheetResults_RETRIEVE]', 'P') IS NOT NULL
		BEGIN
			PRINT N'Dropping [dbo].[spl_CallSheetResults_RETRIEVE]'
			DROP PROCEDURE [dbo].[spl_CallSheetResults_RETRIEVE]

		    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
		
		    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

	IF OBJECT_ID(N'[dbo].[spl_CallSheetResults_RETRIEVE]', 'P') IS NULL
		BEGIN
			PRINT N'Creating [dbo].[spl_CallSheetResults_RETRIEVE]'

			EXEC sp_executesql N'		
	/****************************************************************
		spl_CallSheetResults_RETRIEVE
		Retrieves a single record by ID from the CallSheetResults table
		(c) 2011-2020 Fluke Calibration
	-----------------------------------------------------------------
		Automatically generated on 9/4/2020 (R)
	*****************************************************************/
		
	CREATE PROCEDURE [dbo].[spl_CallSheetResults_RETRIEVE]
		
	@nCallSheetResultUID uniqueidentifier


	AS
	BEGIN

		SELECT
	[nCallSheetResultUID]
			,[nCallSheetUID]
			,[nProcedureUID]
			,[nTechnicianUID]
			,[nRunAtFacilityUID]
			,[nAttTemplateUID]
			,[nCallSheetResultOrdinal]
			,[cWorkstationName]
			,[cDescription]
			,[cStatus]
			,[cDataOrigin]
			,[cCallSheetResultType]
			,[tStartTime]
			,[tEndTime]
			,[mNotes]
			,[lRun]
			,[lActive]
			,[lDeleted]
			,[lApproved]
			,[lAdded]
			,[nAddFacilityUID]
			,[nAddUserUID]
			,[tAddTime]
			,[nUpdateFacilityUID]
			,[nUpdateUserUID]
			,[tUpdateTime]
			,[tMobileTime]
			,[tSystemUpdateTime]
			,[nImportUID]

		FROM
			[dbo].[CallSheetResults]
		WHERE
	[nCallSheetResultUID] = @nCallSheetResultUID

		
		RETURN
			
	END
	'
		    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
		
		    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END
		
	IF OBJECT_ID(N'[dbo].[spl_CallSheetResults_LIST]', 'P') IS NOT NULL
		BEGIN
			PRINT N'Dropping [dbo].[spl_CallSheetResults_LIST]'
			DROP PROCEDURE [dbo].[spl_CallSheetResults_LIST]

		    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
		
		    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

	IF OBJECT_ID(N'[dbo].[spl_CallSheetResults_LIST]', 'P') IS NULL
		BEGIN
			PRINT N'Creating [dbo].[spl_CallSheetResults_LIST]'

			EXEC sp_executesql N'		
	/****************************************************************
		spl_CallSheetResults_LIST
		Retrieves all records from the CallSheetResults table
		Optionally includes inactive records
		(c) 2011-2020 Fluke Calibration
	-----------------------------------------------------------------
		Automatically generated on 9/4/2020 (L)
	*****************************************************************/
		
	CREATE PROCEDURE [dbo].[spl_CallSheetResults_LIST]
		
	@includeInactive	INT	= 0

	AS
	BEGIN

		SELECT
	[nCallSheetResultUID]
			,[nCallSheetUID]
			,[nProcedureUID]
			,[nTechnicianUID]
			,[nRunAtFacilityUID]
			,[nAttTemplateUID]
			,[nCallSheetResultOrdinal]
			,[cWorkstationName]
			,[cDescription]
			,[cStatus]
			,[cDataOrigin]
			,[cCallSheetResultType]
			,[tStartTime]
			,[tEndTime]
			,[mNotes]
			,[lRun]
			,[lActive]
			,[lDeleted]
			,[lApproved]
			,[lAdded]
			,[nAddFacilityUID]
			,[nAddUserUID]
			,[tAddTime]
			,[nUpdateFacilityUID]
			,[nUpdateUserUID]
			,[tUpdateTime]
			,[tMobileTime]
			,[tSystemUpdateTime]
			,[nImportUID]

		FROM
			[dbo].[CallSheetResults]
		WHERE
			ABS(lActive) + @includeInactive > 0
			AND
			lDeleted = 0
		
		RETURN
			
	END
	'
		    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
		
		    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

	IF OBJECT_ID(N'[dbo].[spl_CallSheetResults_INSERT]', 'P') IS NOT NULL
		BEGIN
			PRINT N'Dropping [dbo].[spl_CallSheetResults_INSERT]'
			DROP PROCEDURE [dbo].[spl_CallSheetResults_INSERT]

		    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
		
		    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

	IF OBJECT_ID(N'[dbo].[spl_CallSheetResults_INSERT]', 'P') IS NULL
		BEGIN
			PRINT N'Creating [dbo].[spl_CallSheetResults_INSERT]'
			
			EXEC sp_executesql N'	
	/****************************************************************
		spl_CallSheetResults_INSERT
		Inserts a new record into the CallSheetResults table
		(c) 2011-2020 Fluke Calibration
	-----------------------------------------------------------------
		Automatically generated on 9/4/2020 (I)
	*****************************************************************/
		
	CREATE PROCEDURE [dbo].[spl_CallSheetResults_INSERT]
		
	@nCallSheetUID uniqueidentifier 
		,@nProcedureUID uniqueidentifier  = NULL 
		,@nTechnicianUID uniqueidentifier  = NULL 
		,@nRunAtFacilityUID uniqueidentifier  = NULL 
		,@nAttTemplateUID uniqueidentifier  = NULL 
		,@nCallSheetResultOrdinal numeric(18, 0) 
		,@cWorkstationName nvarchar(50)  = NULL 
		,@cDescription nvarchar(300)  = NULL 
		,@cStatus nvarchar(50)  = NULL 
		,@cDataOrigin nvarchar(50)  = NULL 
		,@cCallSheetResultType nvarchar(50)  = NULL 
		,@tStartTime datetime  = NULL 
		,@tEndTime datetime  = NULL 
		,@mNotes nvarchar(max)  = NULL 
		,@lRun int  = 0 
		,@lActive int  = -1 
		,@lDeleted int  = 0 
		,@lApproved int  = 0 
		,@lAdded int  = -1 
		,@nAddFacilityUID uniqueidentifier  = ''DBA97ADF-F868-459D-8343-DE1DF0FFB398'' 
		,@nAddUserUID uniqueidentifier  = ''915F9722-3175-4E4D-A571-4A478E8E5172'' 
		,@nImportUID uniqueidentifier  = NULL 

		,@nCallSheetResultUID [uniqueidentifier] = NULL OUTPUT

	AS
	BEGIN

		DECLARE @ID [uniqueidentifier] = NEWID()

		INSERT INTO [dbo].[CallSheetResults] (
			[nCallSheetResultUID]
	,[nCallSheetUID]
			,[nProcedureUID]
			,[nTechnicianUID]
			,[nRunAtFacilityUID]
			,[nAttTemplateUID]
			,[nCallSheetResultOrdinal]
			,[cWorkstationName]
			,[cDescription]
			,[cStatus]
			,[cDataOrigin]
			,[cCallSheetResultType]
			,[tStartTime]
			,[tEndTime]
			,[mNotes]
			,[lRun]
			,[lActive]
			,[lDeleted]
			,[lApproved]
			,[lAdded]
			,[nAddFacilityUID]
			,[nAddUserUID]
			,[nImportUID]

			,[tAddTime]
			,[nUpdateUserUID]
			,[nUpdateFacilityUID]
			,[tUpdateTime]
			,[tMobileTime]
		)
		VALUES (
			@ID
	,@nCallSheetUID
			,@nProcedureUID
			,@nTechnicianUID
			,@nRunAtFacilityUID
			,@nAttTemplateUID
			,@nCallSheetResultOrdinal
			,@cWorkstationName
			,@cDescription
			,@cStatus
			,@cDataOrigin
			,@cCallSheetResultType
			,@tStartTime
			,@tEndTime
			,@mNotes
			,@lRun
			,@lActive
			,@lDeleted
			,@lApproved
			,@lAdded
			,@nAddFacilityUID
			,@nAddUserUID
			,@nImportUID

			,GetUTCDate()
			,@nAddUserUID
			,@nAddFacilityUID
			,GetUTCDate()
			,GetUTCDate()
		)

		-- Return the new GUID for the UID of this record to the caller
		SET @nCallSheetResultUID = @ID

		-- Avoids warning in VS2010
		RETURN 1
			
	END
	'
		    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
		
		    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END
		
	IF OBJECT_ID(N'[dbo].[spl_CallSheetResults_DELETE]', 'P') IS NOT NULL
		BEGIN
			PRINT N'Dropping [dbo].[spl_CallSheetResults_DELETE]'
			DROP PROCEDURE [dbo].[spl_CallSheetResults_DELETE]

		    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
		
		    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

	IF OBJECT_ID(N'[dbo].[spl_CallSheetResults_DELETE]', 'P') IS NULL
		BEGIN
			PRINT N'Creating [dbo].[spl_CallSheetResults_DELETE]'

			EXEC sp_executesql N'	
	/****************************************************************
		spl_CallSheetResults_DELETE
		Deletes a single record by ID from the CallSheetResults table
		(c) 2011-2020 Fluke Calibration
	-----------------------------------------------------------------
		Automatically generated on 9/4/2020 (D)
	*****************************************************************/

	CREATE PROCEDURE [dbo].[spl_CallSheetResults_DELETE]

		@nCallSheetResultUID uniqueidentifier,
		@nUpdateUserUID 		[uniqueidentifier],
		@nUpdateFacilityUID		[uniqueidentifier],
		@retMsg					tinyint OUTPUT
		
	AS
	BEGIN

		DECLARE @recordID nvarchar(50)
		DECLARE @userID nvarchar(50)
		DECLARE @facilityUID nvarchar(50)
		DECLARE @now nvarchar(50)

		SELECT
			@recordID = CONVERT( nvarchar(50), @nCallSheetResultUID ),
			@now = CONVERT( nvarchar(50), GetUTCDate() ),
			@userID = CONVERT( nvarchar(50), @nUpdateUserUID ),
			@facilityUID = CONVERT( nvarchar(50), @nUpdateFacilityUID ) 

		EXEC sp_CheckAndDelete
			1,							-- MarkDeleted
			''CallSheetResults'',		-- TableName
			@recordID,					-- PrimaryKeyValue
			1,							-- IsPrimaryKeyString
			''CallSheetResultEx Points PointStatistics PointTolerances '',	-- TableExceptions
			1,							-- ExceptDeletions
			@facilityUID,				-- FacilityUID
			@userID,					-- UpdateUserUID
			@now,						-- UpdateTime
			@retMsg OUTPUT
		
		RETURN @retMsg
			
	END
	'
		    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
		
		    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END



	IF OBJECT_ID(N'[dbo].[spl_CallSheetResults_UPDATE]', 'P') IS NOT NULL
		BEGIN
			PRINT N'Dropping [dbo].[spl_CallSheetResults_UPDATE]'
			DROP PROCEDURE [dbo].[spl_CallSheetResults_UPDATE]

		    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
		
		    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

	IF OBJECT_ID(N'[dbo].[spl_CallSheetResults_UPDATE]', 'P') IS NULL
		BEGIN
			PRINT N'Creating [dbo].[spl_CallSheetResults_UPDATE]'

			EXEC sp_executesql N'		
	/****************************************************************
		spl_CallSheetResults_UPDATE
		Updates a single record by ID in the CallSheetResults table
		(c) 2011-2020 Fluke Calibration
	-----------------------------------------------------------------
		Automatically generated on 9/4/2020 (U)
	*****************************************************************/
		
	CREATE PROCEDURE [dbo].[spl_CallSheetResults_UPDATE]
		
	@nCallSheetResultUID uniqueidentifier
		,@nCallSheetUID uniqueidentifier
		,@nProcedureUID uniqueidentifier
		,@nTechnicianUID uniqueidentifier
		,@nRunAtFacilityUID uniqueidentifier
		,@nAttTemplateUID uniqueidentifier
		,@nCallSheetResultOrdinal numeric(18, 0)
		,@cWorkstationName nvarchar(50)
		,@cDescription nvarchar(300)
		,@cStatus nvarchar(50)
		,@cDataOrigin nvarchar(50)
		,@cCallSheetResultType nvarchar(50)
		,@tStartTime datetime
		,@tEndTime datetime
		,@mNotes nvarchar(max)
		,@lRun int
		,@lActive int
		,@lDeleted int
		,@lApproved int
		,@lAdded int
		,@nUpdateFacilityUID uniqueidentifier
		,@nUpdateUserUID uniqueidentifier
		,@nImportUID uniqueidentifier


	AS
	BEGIN
		DECLARE @DateNow datetime = GetUTCDate();

		UPDATE [dbo].[CallSheetResults]
		SET
	[nCallSheetUID] = @nCallSheetUID
			,[nProcedureUID] = @nProcedureUID
			,[nTechnicianUID] = @nTechnicianUID
			,[nRunAtFacilityUID] = @nRunAtFacilityUID
			,[nAttTemplateUID] = @nAttTemplateUID
			,[nCallSheetResultOrdinal] = @nCallSheetResultOrdinal
			,[cWorkstationName] = @cWorkstationName
			,[cDescription] = @cDescription
			,[cStatus] = @cStatus
			,[cDataOrigin] = @cDataOrigin
			,[cCallSheetResultType] = @cCallSheetResultType
			,[tStartTime] = @tStartTime
			,[tEndTime] = @tEndTime
			,[mNotes] = @mNotes
			,[lRun] = @lRun
			,[lActive] = @lActive
			,[lDeleted] = @lDeleted
			,[lApproved] = @lApproved
			,[lAdded] = @lAdded
			,[nUpdateFacilityUID] = @nUpdateFacilityUID
			,[nUpdateUserUID] = @nUpdateUserUID
			,[nImportUID] = @nImportUID

			,[tUpdateTime] = @DateNow
			,[tMobileTime] = @DateNow
		WHERE
	[nCallSheetResultUID] = @nCallSheetResultUID

		
		RETURN
			
	END
	'
		    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
		
		    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '6F5C86AA-F716-4ACF-BA69-86D640E0EB9A' )
	BEGIN
		PRINT 'Adding translation entry: 6F5C86AA-F716-4ACF-BA69-86D640E0EB9A'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('6F5C86AA-F716-4ACF-BA69-86D640E0EB9A',3214,N'EN',N'CALCULATE_SLOPE',N'Calculate Slope and Offset',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','20200915 05:36:49',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '6AFE6BB7-D4F0-406E-8FA4-9035FD9DBA36' )
	BEGIN
		PRINT 'Adding translation entry: 6AFE6BB7-D4F0-406E-8FA4-9035FD9DBA36'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('6AFE6BB7-D4F0-406E-8FA4-9035FD9DBA36',3214,N'DE',N'CALCULATE_SLOPE',N'#DE# Calculate Slope and Offset',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','20200915 05:36:49',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '7644FACD-40B3-491D-8E4C-112012D26D61' )
	BEGIN
		PRINT 'Adding translation entry: 7644FACD-40B3-491D-8E4C-112012D26D61'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('7644FACD-40B3-491D-8E4C-112012D26D61',3214,N'RU',N'CALCULATE_SLOPE',N'#RU# Calculate Slope and Offset',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','20200915 05:36:49',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'D969AABD-003B-48FA-8558-7B105D714AA7' )
	BEGIN
		PRINT 'Adding translation entry: D969AABD-003B-48FA-8558-7B105D714AA7'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('D969AABD-003B-48FA-8558-7B105D714AA7',3214,N'PT',N'CALCULATE_SLOPE',N'#PT# Calculate Slope and Offset',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','20200915 05:36:49',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'AAF320FD-4571-4E8D-B050-AC2CB92F57B2' )
	BEGIN
		PRINT 'Adding translation entry: AAF320FD-4571-4E8D-B050-AC2CB92F57B2'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('AAF320FD-4571-4E8D-B050-AC2CB92F57B2',3214,N'ZH',N'CALCULATE_SLOPE',N'#ZH# Calculate Slope and Offset',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','20200915 05:36:49',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'E6777E9F-A0A8-450F-9D34-0B52586BB74A' )
	BEGIN
		PRINT 'Adding translation entry: E6777E9F-A0A8-450F-9D34-0B52586BB74A'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('E6777E9F-A0A8-450F-9D34-0B52586BB74A',3214,N'JA',N'CALCULATE_SLOPE',N'#JA# Calculate Slope and Offset',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','20200915 05:36:49',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'FA190781-DAFD-4BBF-A939-E70FD06B2EAA' )
	BEGIN
		PRINT 'Adding translation entry: FA190781-DAFD-4BBF-A939-E70FD06B2EAA'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('FA190781-DAFD-4BBF-A939-E70FD06B2EAA',3214,N'FR',N'CALCULATE_SLOPE',N'#FR# Calculate Slope and Offset',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','20200915 05:36:49',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '6E5B09C2-79D8-4736-911D-1690D09AD73E' )
	BEGIN
		PRINT 'Adding translation entry: 6E5B09C2-79D8-4736-911D-1690D09AD73E'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('6E5B09C2-79D8-4736-911D-1690D09AD73E',3214,N'ES',N'CALCULATE_SLOPE',N'#ES# Calculate Slope and Offset',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','20200915 05:36:49',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'B456A5D0-E8EF-4606-8574-E000902EF1CA' )
	BEGIN
		PRINT 'Adding translation entry: B456A5D0-E8EF-4606-8574-E000902EF1CA'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('B456A5D0-E8EF-4606-8574-E000902EF1CA',3214,N'IT',N'CALCULATE_SLOPE',N'#IT# Calculate Slope and Offset',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','20200915 05:36:49',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '4029712A-709D-4975-93F1-BC7C6FB598B7' )
	BEGIN
		PRINT 'Adding translation entry: 4029712A-709D-4975-93F1-BC7C6FB598B7'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('4029712A-709D-4975-93F1-BC7C6FB598B7',3215,N'EN',N'DELETE_ROW_FORMULA_TRANSDUCER',N'Delete Formula (Transducer)',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','20200915 05:36:49',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '64AEFC06-EAC4-4F20-B355-93FF7356BDA9' )
	BEGIN
		PRINT 'Adding translation entry: 64AEFC06-EAC4-4F20-B355-93FF7356BDA9'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('64AEFC06-EAC4-4F20-B355-93FF7356BDA9',3215,N'DE',N'DELETE_ROW_FORMULA_TRANSDUCER',N'#DE# Delete Formula (Transducer)',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','20200915 05:36:49',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '32E1BD57-1639-46CE-90F4-4F7989D91A21' )
	BEGIN
		PRINT 'Adding translation entry: 32E1BD57-1639-46CE-90F4-4F7989D91A21'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('32E1BD57-1639-46CE-90F4-4F7989D91A21',3215,N'RU',N'DELETE_ROW_FORMULA_TRANSDUCER',N'#RU# Delete Formula (Transducer)',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','20200915 05:36:49',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '202F1534-9825-4648-9176-B54B475B8814' )
	BEGIN
		PRINT 'Adding translation entry: 202F1534-9825-4648-9176-B54B475B8814'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('202F1534-9825-4648-9176-B54B475B8814',3215,N'PT',N'DELETE_ROW_FORMULA_TRANSDUCER',N'#PT# Delete Formula (Transducer)',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','20200915 05:36:49',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '6A8455D3-574E-4109-9F17-74A98F145AFA' )
	BEGIN
		PRINT 'Adding translation entry: 6A8455D3-574E-4109-9F17-74A98F145AFA'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('6A8455D3-574E-4109-9F17-74A98F145AFA',3215,N'ZH',N'DELETE_ROW_FORMULA_TRANSDUCER',N'#ZH# Delete Formula (Transducer)',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','20200915 05:36:49',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '8073471D-FFFE-4ACE-AD93-D78EF1C3AC3F' )
	BEGIN
		PRINT 'Adding translation entry: 8073471D-FFFE-4ACE-AD93-D78EF1C3AC3F'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('8073471D-FFFE-4ACE-AD93-D78EF1C3AC3F',3215,N'JA',N'DELETE_ROW_FORMULA_TRANSDUCER',N'#JA# Delete Formula (Transducer)',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','20200915 05:36:49',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '392E6F7C-ED0B-436A-B178-819C52EB7500' )
	BEGIN
		PRINT 'Adding translation entry: 392E6F7C-ED0B-436A-B178-819C52EB7500'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('392E6F7C-ED0B-436A-B178-819C52EB7500',3215,N'FR',N'DELETE_ROW_FORMULA_TRANSDUCER',N'#FR# Delete Formula (Transducer)',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','20200915 05:36:49',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '8E6C8FCA-9692-4F0F-B29B-9AD4C1E87E2D' )
	BEGIN
		PRINT 'Adding translation entry: 8E6C8FCA-9692-4F0F-B29B-9AD4C1E87E2D'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('8E6C8FCA-9692-4F0F-B29B-9AD4C1E87E2D',3215,N'ES',N'DELETE_ROW_FORMULA_TRANSDUCER',N'#ES# Delete Formula (Transducer)',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','20200915 05:36:49',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '8AD2DA56-7BB5-4429-B721-ABEDBE1CA48A' )
	BEGIN
		PRINT 'Adding translation entry: 8AD2DA56-7BB5-4429-B721-ABEDBE1CA48A'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('8AD2DA56-7BB5-4429-B721-ABEDBE1CA48A',3215,N'IT',N'DELETE_ROW_FORMULA_TRANSDUCER',N'#IT# Delete Formula (Transducer)',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','20200915 05:36:49',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '57E54AAC-24DE-46C1-8D79-ECA6D613BC6C' )
	BEGIN
		PRINT 'Adding translation entry: 57E54AAC-24DE-46C1-8D79-ECA6D613BC6C'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('57E54AAC-24DE-46C1-8D79-ECA6D613BC6C',3216,N'EN',N'DELETE_ROW_FORMULA',N'Delete Formula',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','20200915 05:36:49',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'C4C9E28D-0F33-4D4E-BE71-5435698F4054' )
	BEGIN
		PRINT 'Adding translation entry: C4C9E28D-0F33-4D4E-BE71-5435698F4054'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('C4C9E28D-0F33-4D4E-BE71-5435698F4054',3216,N'DE',N'DELETE_ROW_FORMULA',N'#DE# Delete Formula',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','20200915 05:36:49',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '83A6DF84-5D4E-4419-957A-9BCC4EA1B2C4' )
	BEGIN
		PRINT 'Adding translation entry: 83A6DF84-5D4E-4419-957A-9BCC4EA1B2C4'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('83A6DF84-5D4E-4419-957A-9BCC4EA1B2C4',3216,N'RU',N'DELETE_ROW_FORMULA',N'#RU# Delete Formula',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','20200915 05:36:49',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '40706185-191A-4E1D-99D5-1B7EB6752931' )
	BEGIN
		PRINT 'Adding translation entry: 40706185-191A-4E1D-99D5-1B7EB6752931'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('40706185-191A-4E1D-99D5-1B7EB6752931',3216,N'PT',N'DELETE_ROW_FORMULA',N'#PT# Delete Formula',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','20200915 05:36:49',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '238F7069-6B03-47E6-BA77-70C3FD4208F0' )
	BEGIN
		PRINT 'Adding translation entry: 238F7069-6B03-47E6-BA77-70C3FD4208F0'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('238F7069-6B03-47E6-BA77-70C3FD4208F0',3216,N'ZH',N'DELETE_ROW_FORMULA',N'#ZH# Delete Formula',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','20200915 05:36:49',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '2C34BB75-1399-4BF2-9024-8441533A8A1B' )
	BEGIN
		PRINT 'Adding translation entry: 2C34BB75-1399-4BF2-9024-8441533A8A1B'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('2C34BB75-1399-4BF2-9024-8441533A8A1B',3216,N'JA',N'DELETE_ROW_FORMULA',N'#JA# Delete Formula',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','20200915 05:36:49',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = 'C399D2F6-D578-47CF-8684-49AAEDD72E5D' )
	BEGIN
		PRINT 'Adding translation entry: C399D2F6-D578-47CF-8684-49AAEDD72E5D'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('C399D2F6-D578-47CF-8684-49AAEDD72E5D',3216,N'FR',N'DELETE_ROW_FORMULA',N'#FR# Delete Formula',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','20200915 05:36:49',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '35F1965D-B738-4984-BDD7-455C6FCF0404' )
	BEGIN
		PRINT 'Adding translation entry: 35F1965D-B738-4984-BDD7-455C6FCF0404'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('35F1965D-B738-4984-BDD7-455C6FCF0404',3216,N'ES',N'DELETE_ROW_FORMULA',N'#ES# Delete Formula',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','20200915 05:36:49',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '095DE68F-6CC9-4939-BFE3-484B8F6EF074' )
	BEGIN
		PRINT 'Adding translation entry: 095DE68F-6CC9-4939-BFE3-484B8F6EF074'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('095DE68F-6CC9-4939-BFE3-484B8F6EF074',3216,N'IT',N'DELETE_ROW_FORMULA',N'#IT# Delete Formula',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200915 05:36:49','20200915 05:36:49',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 3214 AND [cLocale] = ''DE'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''Steigung und Versatz ermitteln'' _COLL_ AND [cKey] = N''CALCULATE_SLOPE'')
	BEGIN
		PRINT ''Updating translation entry: 3214 - DE''
		UPDATE
			[dbo].[Translations] 
		SET
			[cKey] = N''CALCULATE_SLOPE'',
			[mValue] = N''Steigung und Versatz ermitteln'',
			[lActive] = -1,
			[tUpdateTime] = ''20200915 05:36:49'',
			[tMobileTime] = ''20200915 05:36:49''
		WHERE
			[nLineNumber] = 3214 AND [cLocale] = ''DE'' 
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql 

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 3215 AND [cLocale] = ''DE'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''Formel Löschen (Messwandler)'' _COLL_ AND [cKey] = N''DELETE_ROW_FORMULA_TRANSDUCER'')
	BEGIN
		PRINT ''Updating translation entry: 3215 - DE''
		UPDATE
			[dbo].[Translations] 
		SET
			[cKey] = N''DELETE_ROW_FORMULA_TRANSDUCER'',
			[mValue] = N''Formel Löschen (Messwandler)'',
			[lActive] = -1,
			[tUpdateTime] = ''20200915 05:36:49'',
			[tMobileTime] = ''20200915 05:36:49''
		WHERE
			[nLineNumber] = 3215 AND [cLocale] = ''DE'' 
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql 

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	SELECT @sql = N'
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nLineNumber] = 3216 AND [cLocale] = ''DE'' AND CONVERT(NVARCHAR(MAX), [mValue]) = N''Formel Löschen'' _COLL_ AND [cKey] = N''DELETE_ROW_FORMULA'')
	BEGIN
		PRINT ''Updating translation entry: 3216 - DE''
		UPDATE
			[dbo].[Translations] 
		SET
			[cKey] = N''DELETE_ROW_FORMULA'',
			[mValue] = N''Formel Löschen'',
			[lActive] = -1,
			[tUpdateTime] = ''20200915 05:36:49'',
			[tMobileTime] = ''20200915 05:36:49''
		WHERE
			[nLineNumber] = 3216 AND [cLocale] = ''DE'' 
	END'
	SELECT @sql = REPLACE(@sql, '_COLL_', 'COLLATE ' + @coll_cs)
	BEGIN
		EXEC sp_executesql @sql 

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END


	-- MTM-961
    IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'FC2B07EA-B992-4201-A9C5-E5BAF9B06715')
	BEGIN
	    PRINT N'Adding Context Element for lAllowActual'
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('FC2B07EA-B992-4201-A9C5-E5BAF9B06715','88B34031-1EA5-4A37-836C-101B53F7A185',N'Field',N'lAllowActual',N'Allow Nominal Value Adjustment',200,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200917 16:37:02','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200917 16:37:02','20200917 16:37:02')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	
	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'AB1610F7-F6F8-4CA7-B430-BE4A463D9449')
	BEGIN
	    PRINT N'Adding Context Element Link for lAllowActual'
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('AB1610F7-F6F8-4CA7-B430-BE4A463D9449','8CAC4C68-D6AE-47E8-94F0-AA96556A1D92','FC2B07EA-B992-4201-A9C5-E5BAF9B06715',N'AND',1,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200917 16:37:02','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200917 16:37:02','20200917 16:37:02')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-- MTM-2257
	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '9D7F91A2-304A-4B35-97CA-97D05C24683D' )
	BEGIN
		PRINT 'Adding translation entry: 9D7F91A2-304A-4B35-97CA-97D05C24683D'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('9D7F91A2-304A-4B35-97CA-97D05C24683D',3217,N'EN',N'NOT_A_GUID',N'Value was not recognized as a GUID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200919 02:54:10','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200919 02:54:10','20200919 02:54:10',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '1A7815C8-2B3C-42A4-92FC-15FF0B3D03D8' )
	BEGIN
		PRINT 'Adding translation entry: 1A7815C8-2B3C-42A4-92FC-15FF0B3D03D8'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('1A7815C8-2B3C-42A4-92FC-15FF0B3D03D8',3217,N'DE',N'NOT_A_GUID',N'#DE# Value was not recognized as a GUID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200919 02:54:10','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200919 02:54:10','20200919 02:54:10',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '8AAB8A72-97EB-4224-9787-AC9739322C95' )
	BEGIN
		PRINT 'Adding translation entry: 8AAB8A72-97EB-4224-9787-AC9739322C95'
		INSERT INTO [dbo].[Translations] ([nTranslationUID],[nLineNumber],[cLocale],[cKey],[mValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('8AAB8A72-97EB-4224-9787-AC9739322C95',3217,N'RU',N'NOT_A_GUID',N'#RU# Value was not recognized as a GUID',-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200919 02:54:10','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20200919 02:54:10','20200919 02:54:10',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[Translations] WHERE [nTranslationUID] = '89ADD7E6-AF56-443A-9DDA-B8BC7C02ABBF'